/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;

public class MissingCallableBodyFixer
extends OCFixer {
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        OCClassDeclaration containingClass;
        if (editor == null) {
            MissingCallableBodyFixer.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            MissingCallableBodyFixer.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            MissingCallableBodyFixer.$$$reportNull$$$0(2);
        }
        if (!(psiElement instanceof OCFunctionDefinition) && !(psiElement instanceof OCMethod)) {
            return;
        }
        if (psiElement instanceof OCMethod && ((containingClass = ((OCMethod)psiElement).getContainingClass()) instanceof OCInterface || containingClass instanceof OCProtocol)) {
            return;
        }
        OCCallable fun = (OCCallable)psiElement;
        OCBlockStatement body = fun.getBody();
        Document doc = editor.getDocument();
        if (body != null) {
            MissingCallableBodyFixer.fixBlockIfNeed(editor, body, false);
            return;
        }
        int endOffset = OCChangeUtil.getRangeWithMacros(fun).getEndOffset();
        if (StringUtil.endsWithChar((CharSequence)fun.getText(), (char)';')) {
            doc.deleteString(endOffset - 1, endOffset);
            --endOffset;
        }
        doc.insertString(endOffset, (CharSequence)"{\n}");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/editor/smartEnter/MissingCallableBodyFixer";
        objectArray[2] = "apply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

