/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingIfBranchesFixer
extends OCFixer {
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        OCStatement thenBranch;
        if (editor == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(2);
        }
        if (!(psiElement instanceof OCIfStatement)) {
            return;
        }
        OCIfStatement ifStatement = (OCIfStatement)psiElement;
        Document doc = editor.getDocument();
        ASTNode elseKeyword = ifStatement.getElseKeyword();
        if (elseKeyword != null) {
            MissingIfBranchesFixer.handleBranch(doc, ifStatement, true, elseKeyword.getPsi(), ifStatement.getElseBranch());
        }
        if (MissingIfBranchesFixer.fixBlockIfNeed(editor, thenBranch = ifStatement.getThenBranch(), false)) {
            return;
        }
        if (thenBranch != null && MissingIfBranchesFixer.startLine(doc, thenBranch) == MissingIfBranchesFixer.startLine(doc, ifStatement) && !MissingIfBranchesFixer.hasEmptyStatement(ifStatement.getCondition())) {
            return;
        }
        ASTNode rParenth = ifStatement.getRParenth();
        if (rParenth == null) {
            return;
        }
        MissingIfBranchesFixer.handleBranch(doc, ifStatement, false, rParenth.getPsi(), ifStatement.getThenBranch());
    }

    private static void handleBranch(@NotNull Document doc, @NotNull OCIfStatement ifStatement, boolean isElse, @NotNull PsiElement beforeBranch, @Nullable OCStatement branch) {
        if (doc == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(3);
        }
        if (ifStatement == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(4);
        }
        if (beforeBranch == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(5);
        }
        if (branch instanceof OCBlockStatement || isElse && branch instanceof OCIfStatement) {
            return;
        }
        boolean transformingOneLiner = branch != null && (MissingIfBranchesFixer.startLine(doc, beforeBranch) == MissingIfBranchesFixer.startLine(doc, branch) || MissingIfBranchesFixer.indent(doc, ifStatement) < MissingIfBranchesFixer.indent(doc, branch));
        int endOffset = OCChangeUtil.getRangeWithMacros(beforeBranch).getEndOffset();
        if (!transformingOneLiner) {
            doc.insertString(endOffset, (CharSequence)"{}");
        } else {
            doc.insertString(endOffset, (CharSequence)"{");
            doc.insertString(OCChangeUtil.getRangeWithMacros(branch).getEndOffset() + 1, (CharSequence)"}");
        }
    }

    private static int indent(Document doc, @NotNull PsiElement psiElement) {
        if (psiElement == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(6);
        }
        int offset = OCChangeUtil.getRangeWithMacros(psiElement).getStartOffset();
        return offset - doc.getLineStartOffset(doc.getLineNumber(offset));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeBranch";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/smartEnter/MissingIfBranchesFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBranch";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "indent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

