/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.editor.surround.OCSurrounder;
import com.jetbrains.cidr.lang.psi.OCStatement;
import org.jetbrains.annotations.NotNull;

public class OCStructureUnawareBraceSurrounder
extends OCSurrounder {
    public String getTemplateDescription() {
        return "{ }";
    }

    @Override
    public boolean isApplicable(PsiElement @NotNull [] elements) {
        if (elements == null) {
            OCStructureUnawareBraceSurrounder.$$$reportNull$$$0(0);
        }
        if (!super.isApplicable(elements)) {
            return false;
        }
        if (elements.length != 2) {
            return false;
        }
        OCStatement firstStmt = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)elements[0], OCStatement.class);
        OCStatement lastStmt = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)elements[1], OCStatement.class);
        return firstStmt == null || lastStmt == null || firstStmt.getParent() != lastStmt.getParent();
    }

    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, PsiElement @NotNull [] elements) throws IncorrectOperationException {
        if (project == null) {
            OCStructureUnawareBraceSurrounder.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            OCStructureUnawareBraceSurrounder.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            OCStructureUnawareBraceSurrounder.$$$reportNull$$$0(3);
        }
        int startOffset = elements[0].getTextRange().getStartOffset();
        int endOffset = elements[elements.length - 1].getTextRange().getEndOffset();
        Document doc = editor.getDocument();
        CharSequence chars = doc.getCharsSequence();
        startOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(startOffset - 1), (String)" \t") + 1;
        doc.insertString(endOffset, (CharSequence)"\n}");
        doc.insertString(startOffset, (CharSequence)"{\n");
        CodeStyleManager styler = CodeStyleManager.getInstance((Project)project);
        PsiFile file = elements[0].getContainingFile();
        styler.reformatText(file, startOffset, startOffset + 1);
        styler.reformatText(file, endOffset - 1, endOffset);
        styler.adjustLineIndent(file, TextRange.from((int)startOffset, (int)endOffset));
        int caretOffset = startOffset + "{".length();
        return TextRange.create((int)caretOffset, (int)caretOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/surround/OCStructureUnawareBraceSurrounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

