/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.formatting.OCIndentChanger;
import com.jetbrains.cidr.lang.formatting.OCSimpleBlock;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFormatterUtil {
    public static final TokenSet FORMAT_DIRECTIVES = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.DIRECTIVES, OCElementTypes.DIRECTIVES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.HASH})});
    public static final TokenSet FORMAT_CONTENTS = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.DIRECTIVE_CONTENT, OCTokenTypes.PRAGMA_DIRECTIVE_CONTENT, OCTokenTypes.INCLUDE_DIRECTIVE_CONTENT});
    public static final TokenSet FORMAT_DIRECTIVES_AND_NON_COMPILED = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.DIRECTIVES, OCElementTypes.DIRECTIVES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.HASH, OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT})});
    public static final TokenSet FORMAT_PROBLEM_LEAFS_IN_NONCOMPILED = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.RAW_STRING_LITERALS, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.BLOCK_COMMENT})});
    public static final TokenSet FORMAT_DIRECTIVES_INCREASE_INDENT = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.IF_DIRECTIVES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.ELSE_DIRECTIVE, OCTokenTypes.ELIF_DIRECTIVE})});
    private static final TokenSet CLASS_CHILDREN = TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.FUNCTION_DEFINITION, OCElementTypes.FUNCTION_DECLARATION});
    private static final TokenSet CLASS_DECL_HEADER_PARTS = TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.INSTANCE_VARIABLES_LIST, OCElementTypes.SUPER_CLASS_REF, OCElementTypes.PROTOCOL_LIST, OCElementTypes.GENERIC_PARAMETERS_LIST, OCElementTypes.CATEGORY_NAME});
    private static final TokenSet CLASS_DECL_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.PROTOCOL_KEYWORD, OCTokenTypes.INTERFACE_KEYWORD, OCTokenTypes.IMPLEMENTATION_KEYWORD});
    public static final TokenSet SPACES_COMMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITESPACES, OCTokenTypes.COMMENTS});
    public static final TokenSet MACRO_SPACES_COMMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.MACRO_CALL}), SPACES_COMMENTS});

    @Contract(value="null, _->false")
    public static boolean isOrFollows(ASTNode node, IElementType expectedType) {
        while (node != null) {
            if (node.getElementType() == expectedType) {
                return true;
            }
            node = node.getTreePrev();
        }
        return false;
    }

    public static boolean isNotEmptyAndOneOf(ASTNode node, PsiElement ... candidates) {
        return OCElementUtil.getElementType(node) != OCElementTypes.EMPTY_STATEMENT && OCElementUtil.isOneOf(node, candidates);
    }

    @Contract(value="null->false")
    public static boolean isAnyLBrace(IElementType tokenType) {
        return tokenType == OCTokenTypes.LBRACE || tokenType == OCTokenTypes.LBRACKET || tokenType == OCTokenTypes.LPAR;
    }

    @Contract(value="null->false")
    public static boolean isAnyRBrace(IElementType tokenType) {
        return tokenType == OCTokenTypes.RBRACE || tokenType == OCTokenTypes.RBRACKET || tokenType == OCTokenTypes.RPAR;
    }

    @Contract(value="null->false")
    public static boolean isBlock(IElementType type) {
        return OCElementTypes.BLOCK_STATEMENTS.contains(type);
    }

    @Contract(value="null->false")
    public static boolean isInsideAnyBraces(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        int counter = 0;
        while ((node = node.getTreePrev()) != null) {
            if (OCFormatterUtil.isAnyLBrace(node.getElementType())) {
                ++counter;
                continue;
            }
            if (!OCFormatterUtil.isAnyRBrace(node.getElementType())) continue;
            --counter;
        }
        return counter > 0;
    }

    @Contract(value="null->false")
    public static boolean isKeyword(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        IElementType elementType = OCElementUtil.getElementType(node);
        return OCTokenTypes.KEYWORDS.contains(elementType);
    }

    @Contract(value="null->false")
    public static boolean isClassHeader(@Nullable ASTNode node) {
        while (node != null && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(node.getElementType())) {
            node = node.getTreeNext();
        }
        if (node == null) {
            return false;
        }
        IElementType et = node.getElementType();
        if (et == OCElementTypes.OBJC_KEYWORD) {
            ASTNode lc = node.getLastChildNode();
            return CLASS_DECL_KEYWORDS.contains(OCElementUtil.getElementType(lc)) && OCElementTypes.CLASSES.contains(OCElementUtil.getElementType(node.getTreeParent()));
        }
        if (et == OCTokenTypes.IDENTIFIER) {
            return OCElementTypes.CLASSES.contains(OCElementUtil.getElementType(node.getTreeParent()));
        }
        return CLASS_DECL_HEADER_PARTS.contains(et);
    }

    public static boolean isClassMember(ASTNode node) {
        return !OCFormatterUtil.isClassHeader(node) && OCTokenTypes.END_KEYWORD != OCElementUtil.getObjCKeywordElementType(node);
    }

    public static boolean isMessageArgumentValue(@NotNull ASTNode node) {
        if (node == null) {
            OCFormatterUtil.$$$reportNull$$$0(0);
        }
        return OCElementUtil.getElementType(node.getTreeParent()) == OCElementTypes.MESSAGE_ARGUMENT && node.getElementType() != OCElementTypes.ARGUMENT_SELECTOR;
    }

    @Contract(value="null -> false")
    public static boolean isVarArgArgument(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        if (node.getElementType() != OCElementTypes.MESSAGE_ARGUMENT) {
            return false;
        }
        ASTNode selector = node.findChildByType((IElementType)OCElementTypes.ARGUMENT_SELECTOR);
        return selector == null || StringUtil.isEmptyOrSpaces((String)selector.getText());
    }

    @Contract(value="null -> false")
    public static boolean isFollowedByVarArg(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        if (node.getElementType() != OCElementTypes.MESSAGE_ARGUMENT) {
            return false;
        }
        while ((node = FormatterUtil.getNextNonWhitespaceSibling((ASTNode)node)) != null) {
            if (!OCFormatterUtil.isVarArgArgument(node)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isProtocolListOrReference(IElementType type) {
        return type == OCElementTypes.PROTOCOL_LIST || type == OCElementTypes.REFERENCE_ELEMENT;
    }

    public static boolean isDeclarationOrDefinition(IElementType type) {
        return type == OCElementTypes.DECLARATION_STATEMENT || type == OCElementTypes.DECLARATION || type == OCElementTypes.FUNCTION_DECLARATION || type == OCElementTypes.METHOD || type == OCElementTypes.PROPERTY || type == OCElementTypes.FUNCTION_DEFINITION || type == OCElementTypes.CLASS_PREDEF_LIST || OCElementTypes.CLASSES.contains(type);
    }

    public static boolean isVariablesListOrStructure(IElementType type) {
        return type == OCElementTypes.INSTANCE_VARIABLES_LIST || OCFormatterUtil.isStructure(type);
    }

    public static boolean isCollectionOrStructureInitializer(@Nullable IElementType type) {
        return type == OCElementTypes.COMPOUND_INITIALIZER || OCElementTypes.NS_COLLECTION_LITERALS.contains(type);
    }

    public static boolean isStructure(IElementType type) {
        return OCElementTypes.STRUCTURE_TYPES.contains(type);
    }

    @Contract(pure=true)
    public static boolean isGlobalDeclarationScope(IElementType type) {
        return OCFormatterUtil.isNamespace(type) || type == OCTokenTypes.OC_FILE;
    }

    @Contract(pure=true)
    public static boolean isNamespace(IElementType type) {
        return type == OCElementTypes.CPP_NAMESPACE;
    }

    public static boolean isStructureOrNamespace(IElementType type) {
        return OCFormatterUtil.isStructure(type) || OCFormatterUtil.isNamespace(type);
    }

    @Contract(value="null->null")
    public static ASTNode getNextNonWhitespaceOrCommentSibling(@Nullable ASTNode node) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node == null ? null : node.getTreeNext();
        while (prevNode != null && OCFormatterUtil.isInessential(prevNode)) {
            prevNode = prevNode.getTreeNext();
        }
        return prevNode;
    }

    @Contract(value="null->null")
    public static ASTNode getPreviousNonWhitespaceOrCommentSibling(@Nullable ASTNode node) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node == null ? null : node.getTreePrev();
        while (prevNode != null && OCFormatterUtil.isInessential(prevNode)) {
            prevNode = prevNode.getTreePrev();
        }
        return prevNode;
    }

    @Contract(value="null->true")
    public static boolean isInessential(@Nullable ASTNode node) {
        return node == null || FormatterUtil.isWhitespaceOrEmpty((ASTNode)node) || OCTokenTypes.COMMENTS.contains(node.getElementType());
    }

    public static boolean isOCVisibilityKeywordOrCPPVisibilityColon(@Nullable ASTNode node) {
        return OCElementUtil.isOCVisibilityKeyword(node) || OCElementUtil.getElementType(node) == OCTokenTypes.COLON && OCElementUtil.isCPPVisibilityKeyword(OCFormatterUtil.getPreviousNonWhitespaceOrCommentSibling(node));
    }

    @Contract(pure=true)
    public static boolean isForOrForEachStatement(IElementType type) {
        return type == OCElementTypes.FOR_STATEMENT || type == OCElementTypes.FOREACH_STATEMENT;
    }

    @Contract(pure=true)
    public static boolean isLoopStatement(IElementType type) {
        return OCFormatterUtil.isForOrForEachStatement(type) || type == OCElementTypes.WHILE_STATEMENT || type == OCElementTypes.DO_WHILE_STATEMENT;
    }

    @Contract(pure=true)
    public static boolean isControlStatement(IElementType type) {
        return type == OCElementTypes.RETURN_STATEMENT || type == OCElementTypes.IF_STATEMENT || OCFormatterUtil.isLoopStatement(type) || type == OCElementTypes.SWITCH_STATEMENT || type == OCElementTypes.CASE_STATEMENT || type == OCElementTypes.TRY_STATEMENT || type == OCElementTypes.SYNCHRONIZED_STATEMENT || type == OCElementTypes.AUTO_RELEASE_POOL_STATEMENT;
    }

    public static boolean isControlStatementOrSection(IElementType type) {
        return OCFormatterUtil.isControlStatement(type) || OCFormatterUtil.isControlSection(type);
    }

    @Contract(pure=true)
    public static boolean isControlSection(IElementType type) {
        return type == OCElementTypes.CATCH_SECTION || type == OCElementTypes.FINALLY_SECTION;
    }

    public static boolean isInsideDirective(@Nullable ASTNode node) {
        for (ASTNode each = node; each != null; each = each.getTreeParent()) {
            if (!OCFormatterUtil.isDirective(each)) continue;
            return true;
        }
        IElementType type = OCElementUtil.getElementType(node);
        return OCTokenTypes.DIRECTIVES.contains(type) || FORMAT_CONTENTS.contains(type);
    }

    @Contract(value="null -> false")
    public static boolean isDirective(@Nullable ASTNode child) {
        return child != null && FORMAT_DIRECTIVES.contains(child.getElementType());
    }

    @Nullable
    public static <T> T processBraced(@Nullable ASTNode parent, @Nullable IElementType childType, boolean strictStart, @NotNull LeftBracesProcessor<T> processor) {
        if (processor == null) {
            OCFormatterUtil.$$$reportNull$$$0(1);
        }
        IElementType parentType = OCElementUtil.getElementType(parent);
        if (childType == OCElementTypes.INSTANCE_VARIABLES_LIST) {
            return processor.processInterfaceOrStructure();
        }
        if (strictStart && OCFormatterUtil.isVariablesListOrStructure(parentType) && childType == OCTokenTypes.LBRACE || !strictStart && OCFormatterUtil.isVariablesListOrStructure(childType)) {
            return processor.processInterfaceOrStructure();
        }
        if (strictStart && OCFormatterUtil.isNamespace(parentType) && childType == OCTokenTypes.LBRACE || !strictStart && OCFormatterUtil.isNamespace(childType)) {
            return processor.processNamespace();
        }
        if (childType == OCElementTypes.CPP_REQUIRES_CLAUSE) {
            return processor.processRequiresClause();
        }
        if (OCFormatterUtil.isBlock(childType)) {
            if (parentType == OCElementTypes.METHOD) {
                return processor.processMethod();
            }
            if (parentType == OCElementTypes.FUNCTION_DEFINITION) {
                return processor.processFunction();
            }
            if (parentType == OCElementTypes.BLOCK_EXPRESSION || parentType == OCElementTypes.CPP_LAMBDA_EXPRESSION) {
                return processor.processBlock();
            }
            if (parentType == OCElementTypes.IF_STATEMENT) {
                return processor.processIfStatement();
            }
            if (OCFormatterUtil.isForOrForEachStatement(parentType)) {
                return processor.processForOrForEachStatement();
            }
            if (parentType == OCElementTypes.WHILE_STATEMENT) {
                return processor.processWhileStatement();
            }
            if (parentType == OCElementTypes.DO_WHILE_STATEMENT) {
                return processor.processDoWhileStatement();
            }
            if (parentType == OCElementTypes.SWITCH_STATEMENT) {
                return processor.processSwitchStatement();
            }
            if (parentType == OCElementTypes.CASE_STATEMENT) {
                return processor.processSwitchStatement();
            }
            if (parentType == OCElementTypes.TRY_STATEMENT) {
                return processor.processTryStatement();
            }
            if (parentType == OCElementTypes.CATCH_SECTION) {
                return processor.processCatchStatement();
            }
            if (parentType == OCElementTypes.FINALLY_SECTION) {
                return processor.processFinallyStatement();
            }
            if (parentType == OCElementTypes.SYNCHRONIZED_STATEMENT) {
                return processor.processSynchronizedStatement();
            }
            if (parentType == OCElementTypes.AUTO_RELEASE_POOL_STATEMENT) {
                return processor.processAutoreleasePoolStatement();
            }
        }
        return null;
    }

    static boolean isObjCKeywordWithDog(IElementType elementType, ASTNode node, OCElementType requiredType) {
        return elementType == OCElementTypes.OBJC_KEYWORD && OCElementUtil.getObjCKeywordElementType(node) == requiredType;
    }

    public static boolean isCPPClassDeclaration(@Nullable ASTNode node) {
        if (OCElementUtil.getElementType(node) != OCElementTypes.DECLARATION) {
            return false;
        }
        ASTNode typeElement = node.findChildByType((IElementType)OCElementTypes.TYPE_ELEMENT);
        return typeElement != null && OCFormatterUtil.isCPPClass(typeElement.getFirstChildNode());
    }

    public static boolean isCPPClass(@Nullable ASTNode node) {
        return OCFormatterUtil.isClassStructUnion(node) && (node.getFirstChildNode().getElementType() == OCTokenTypes.CLASS_KEYWORD || node.findChildByType(CLASS_CHILDREN) != null);
    }

    public static boolean isClassStructUnion(@Nullable ASTNode node) {
        return OCElementUtil.getElementType(node) == OCElementTypes.STRUCT || OCElementUtil.getElementType(node) == OCElementTypes.UNION;
    }

    @Nullable
    public static ASTNode nextLeafInOwner(@NotNull ASTNode current, @NotNull ASTNode owner) {
        if (current == null) {
            OCFormatterUtil.$$$reportNull$$$0(2);
        }
        if (owner == null) {
            OCFormatterUtil.$$$reportNull$$$0(3);
        }
        for (ASTNode nextSibling = current.getTreeNext(); nextSibling != null; nextSibling = nextSibling.getTreeNext()) {
            ASTNode first = OCFormatterUtil.firstLeaf(nextSibling);
            if (first == null) continue;
            return first;
        }
        ASTNode parent = current.getTreeParent();
        if (parent == owner || parent instanceof OCFile || parent == null) {
            return null;
        }
        return OCFormatterUtil.nextLeafInOwner(parent, owner);
    }

    @Nullable
    public static ASTNode prevLeafInOwner(@NotNull ASTNode current, @NotNull ASTNode owner) {
        if (current == null) {
            OCFormatterUtil.$$$reportNull$$$0(4);
        }
        if (owner == null) {
            OCFormatterUtil.$$$reportNull$$$0(5);
        }
        for (ASTNode prevSibling = current.getTreePrev(); prevSibling != null; prevSibling = prevSibling.getTreePrev()) {
            ASTNode last = OCFormatterUtil.lastLeaf(prevSibling);
            if (last == null) continue;
            return last;
        }
        ASTNode parent = current.getTreeParent();
        if (parent == owner || parent instanceof OCFile || parent == null) {
            return null;
        }
        return OCFormatterUtil.prevLeafInOwner(parent, owner);
    }

    @Nullable
    public static ASTNode lastLeaf(@NotNull ASTNode element) {
        if (element == null) {
            OCFormatterUtil.$$$reportNull$$$0(6);
        }
        return TreeUtil.findLastLeaf((ASTNode)element);
    }

    @Nullable
    public static ASTNode firstLeaf(@NotNull ASTNode element) {
        if (element == null) {
            OCFormatterUtil.$$$reportNull$$$0(7);
        }
        return TreeUtil.findFirstLeaf((ASTNode)element);
    }

    @Contract(value="null, _ -> false")
    public static boolean isAncestorOrSelf(@Nullable ASTNode ancestor, @NotNull ASTNode element) {
        if (element == null) {
            OCFormatterUtil.$$$reportNull$$$0(8);
        }
        if (ancestor == null) {
            return false;
        }
        if (ancestor == element) {
            return true;
        }
        ASTNode parent = element.getTreeParent();
        while (parent != null) {
            if (parent == ancestor) {
                return true;
            }
            parent = parent.getTreeParent();
        }
        return false;
    }

    @NotNull
    static ASTNode getBestCommonOwner(@NotNull ASTNode defaultOwner, @NotNull ASTNode node1, @NotNull ASTNode node2) {
        if (defaultOwner == null) {
            OCFormatterUtil.$$$reportNull$$$0(9);
        }
        if (node1 == null) {
            OCFormatterUtil.$$$reportNull$$$0(10);
        }
        if (node2 == null) {
            OCFormatterUtil.$$$reportNull$$$0(11);
        }
        PsiElement p1 = node1.getPsi();
        PsiElement p2 = node2.getPsi();
        if (p1 != null && p2 != null) {
            PsiElement owner = PsiTreeUtil.findCommonParent((PsiElement)p1, (PsiElement)p2);
            if (owner instanceof LeafElement) {
                owner = owner.getParent();
            }
            if (owner != null && owner.getNode() != null) {
                ASTNode aSTNode = owner.getNode();
                if (aSTNode == null) {
                    OCFormatterUtil.$$$reportNull$$$0(12);
                }
                return aSTNode;
            }
        }
        ASTNode aSTNode = defaultOwner;
        if (aSTNode == null) {
            OCFormatterUtil.$$$reportNull$$$0(13);
        }
        return aSTNode;
    }

    public static boolean isInBlockEnclosed(@Nullable ASTNode child, @NotNull ASTNode parent) {
        if (parent == null) {
            OCFormatterUtil.$$$reportNull$$$0(14);
        }
        boolean isInlineEnclosed = false;
        boolean afterLBrace = false;
        for (ASTNode node = parent.getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType type = node.getElementType();
            boolean whitespace = OCElementUtil.isWhitespace(node.getPsi());
            if (child != null && child == node || child == null && !whitespace && type != OCTokenTypes.LBRACE && type != OCTokenTypes.RBRACE) {
                isInlineEnclosed = true;
                continue;
            }
            if (type == OCTokenTypes.LBRACE) {
                afterLBrace = true;
                continue;
            }
            if (!afterLBrace || (isInlineEnclosed || !node.textContains('\n')) && (type == OCTokenTypes.RBRACE || whitespace)) continue;
            return false;
        }
        return isInlineEnclosed || child == null;
    }

    @Contract(value="null -> false")
    public static boolean isDirectlyInsideSwitch(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        ASTNode parent = node.getTreeParent();
        IElementType parentType = OCElementUtil.getElementType(parent);
        if (OCElementTypes.BLOCK_STATEMENTS.contains(parentType)) {
            parentType = OCElementUtil.getElementType(parent.getTreeParent());
        }
        return parentType == OCElementTypes.SWITCH_STATEMENT;
    }

    public static LABEL_TYPE getLabelType(@Nullable ASTNode node) {
        LABEL_TYPE ret = LABEL_TYPE.OTHER;
        while (node != null) {
            IElementType nodeType = node.getElementType();
            if (nodeType == OCElementTypes.LABELED_STATEMENT) {
                ret = LABEL_TYPE.LABEL_LIKE;
            } else {
                if (nodeType != OCElementTypes.CASE_STATEMENT) break;
                ret = LABEL_TYPE.CASE_LIKE;
            }
            if (OCFormatterUtil.isDirectlyInsideSwitch(node)) {
                return LABEL_TYPE.CASE_LIKE;
            }
            node = node.getTreeParent();
        }
        return ret;
    }

    private static ASTNode getPrev(@Nullable ASTNode node) {
        IElementType prevType;
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node == null ? null : node.getTreePrev();
        while (prevNode != null && MACRO_SPACES_COMMENTS.contains(prevType = prevNode.getElementType())) {
            prevNode = prevNode.getTreePrev();
        }
        return prevNode;
    }

    @Contract(value="null,_->false")
    public static boolean isPrecededBy(@Nullable ASTNode node, @NotNull IElementType expectedType) {
        if (expectedType == null) {
            OCFormatterUtil.$$$reportNull$$$0(15);
        }
        return OCElementUtil.getElementType(OCFormatterUtil.getPrev(node)) == expectedType;
    }

    @Contract(value="null,_->false")
    public static boolean isPrecededBy(@Nullable ASTNode node, @NotNull TokenSet expectedTypes) {
        if (expectedTypes == null) {
            OCFormatterUtil.$$$reportNull$$$0(16);
        }
        return expectedTypes.contains(OCElementUtil.getElementType(OCFormatterUtil.getPrev(node)));
    }

    public static boolean isFirstEssentialChild(@NotNull ASTNode child) {
        IElementType nextType;
        ASTNode nextNode;
        ASTNode parent;
        if (child == null) {
            OCFormatterUtil.$$$reportNull$$$0(17);
        }
        if ((parent = child.getTreeParent()) == null) {
            return true;
        }
        for (nextNode = parent.getFirstChildNode(); nextNode != null && ((nextType = nextNode.getElementType()) instanceof OCPunctuatorElementType || MACRO_SPACES_COMMENTS.contains(nextType)); nextNode = nextNode.getTreeNext()) {
        }
        return nextNode == child;
    }

    public static void applyIndentCorrection(boolean useSmartIndent, List<? extends Block> collector, int wrapType, boolean keepLineBreak, Condition<? super ASTNode> isReindentedNode) {
        if (wrapType == 0 && !keepLineBreak) {
            return;
        }
        boolean needEnforceIndent = useSmartIndent;
        if (!needEnforceIndent) {
            int count = 0;
            for (Block block : collector) {
                PsiElement psi;
                ASTNode beforeFirstNode;
                ASTNode firstNode = OCSimpleBlock.extractFirstNode(block);
                if (!isReindentedNode.value((Object)firstNode) || ++count <= 1) continue;
                boolean bl = needEnforceIndent = wrapType == 2;
                if (!needEnforceIndent && ((beforeFirstNode = FormatterUtil.getPreviousLeaf((ASTNode)firstNode, (IElementType[])new IElementType[0])) == null || !(needEnforceIndent = (psi = beforeFirstNode.getPsi()) instanceof PsiWhiteSpace && psi.textContains('\n')))) continue;
                break;
            }
        }
        if (needEnforceIndent) {
            Indent indent = useSmartIndent ? Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION) : Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
            for (Block block : collector) {
                if (!(block instanceof OCIndentChanger) || !isReindentedNode.value((Object)OCSimpleBlock.extractFirstNode(block))) continue;
                ((OCIndentChanger)block).putIndent(indent);
            }
        }
    }

    @Contract(value="null -> false")
    private static boolean isNestedNamespacePart(@Nullable ASTNode node) {
        if (node != null && node.getElementType() == OCElementTypes.CPP_NAMESPACE) {
            ASTNode first = node.getFirstChildNode();
            return first != null && first.getElementType() == OCTokenTypes.COLON2X;
        }
        return false;
    }

    public static boolean isNestedInlineBlock(@NotNull OCCodeStyleSettings ocSettings, @Nullable ASTNode node) {
        if (ocSettings == null) {
            OCFormatterUtil.$$$reportNull$$$0(18);
        }
        return ocSettings.KEEP_NESTED_NAMESPACES_IN_ONE_LINE && OCElementUtil.getElementType(node) == OCElementTypes.CPP_NAMESPACE && OCElementUtil.getElementType(node.getTreeParent()) == OCElementTypes.CPP_NAMESPACE && OCFormatterUtil.isInBlockEnclosed(node, node.getTreeParent()) || OCFormatterUtil.isNestedNamespacePart(node);
    }

    @Contract(value="null -> false")
    public static boolean isSynthetic(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        return OCFormatterUtil.hasSyntheticLeaf(node, true) && OCFormatterUtil.hasSyntheticLeaf(node, false);
    }

    public static boolean hasSyntheticLeaf(@Nullable ASTNode node, boolean first) {
        LeafElement leaf = node instanceof LeafElement ? (LeafElement)node : (first ? TreeUtil.findFirstLeaf((ASTNode)node) : TreeUtil.findLastLeaf((ASTNode)node));
        return leaf instanceof PsiElement && OCElementUtil.isSynthetic((PsiElement)leaf);
    }

    public static boolean isNestedBlockOwner(@NotNull OCCodeStyleSettings ocSettings, @NotNull ASTNode owner) {
        if (ocSettings == null) {
            OCFormatterUtil.$$$reportNull$$$0(19);
        }
        if (owner == null) {
            OCFormatterUtil.$$$reportNull$$$0(20);
        }
        ASTNode child = owner.findChildByType((IElementType)OCElementTypes.CPP_NAMESPACE);
        return ocSettings.KEEP_NESTED_NAMESPACES_IN_ONE_LINE && OCElementUtil.getElementType(owner) == OCElementTypes.CPP_NAMESPACE && OCFormatterUtil.isNestedInlineBlock(ocSettings, child) || OCFormatterUtil.isNestedNamespacePart(child);
    }

    @Contract(value="null -> false")
    public static boolean isNamespaceWithKeyword(@Nullable ASTNode node) {
        return node != null && node.getElementType() == OCElementTypes.CPP_NAMESPACE && !OCFormatterUtil.isNestedNamespacePart(node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 3: 
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultOwner";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/formatting/OCFormatterUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ocSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/formatting/OCFormatterUtil";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestCommonOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMessageArgumentValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processBraced";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nextLeafInOwner";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prevLeafInOwner";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lastLeaf";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "firstLeaf";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAncestorOrSelf";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBestCommonOwner";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInBlockEnclosed";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isPrecededBy";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isFirstEssentialChild";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isNestedInlineBlock";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isNestedBlockOwner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class LeftBracesProcessor<T> {
        public T processNamespace() {
            return this.processGeneral();
        }

        public T processInterfaceOrStructure() {
            return this.processGeneral();
        }

        public T processMethod() {
            return this.processGeneral();
        }

        public T processFunction() {
            return this.processGeneral();
        }

        public T processRequiresClause() {
            return this.processGeneral();
        }

        public T processBlock() {
            return this.processFunction();
        }

        public T processIfStatement() {
            return this.processGeneral();
        }

        public T processForOrForEachStatement() {
            return this.processGeneral();
        }

        public T processWhileStatement() {
            return this.processGeneral();
        }

        public T processDoWhileStatement() {
            return this.processGeneral();
        }

        public T processSwitchStatement() {
            return this.processGeneral();
        }

        public T processTryStatement() {
            return this.processGeneral();
        }

        public T processCatchStatement() {
            return this.processGeneral();
        }

        public T processFinallyStatement() {
            return this.processGeneral();
        }

        public T processSynchronizedStatement() {
            return this.processGeneral();
        }

        public T processAutoreleasePoolStatement() {
            return this.processGeneral();
        }

        public T processGeneral() {
            return null;
        }
    }

    static enum LABEL_TYPE {
        CASE_LIKE,
        LABEL_LIKE,
        OTHER;

    }
}

