/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateComparisonOperatorsContext;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.handlers.OCCCppGenerateHandlerBase;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.refactoring.OCNamingConventionUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.util.OCFakeFunctionSymbolBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateComparisonOperatorsHandler
extends OCCCppGenerateHandlerBase<OCStructSymbol, OCDeclaratorSymbol, OCGenerateComparisonOperatorsContext> {
    private static final OCBooleanOption ADDITIONAL_EQ_OPTION = new OCBooleanOption(OCBundle.message("generate.comparison.operators.additional.eq.option", new Object[0]));
    private static final OCBooleanOption ADDITIONAL_REL_OPTION = new OCBooleanOption(OCBundle.message("generate.comparison.operators.additional.rel.option", new Object[0]));
    private static final OCBooleanOption AS_MEMBER_OPTION = new OCBooleanOption(OCBundle.message("generate.comparison.operators.as.member.option", new Object[0]));
    private static final OCBooleanOption USE_STD_TIE_OPTION = new OCBooleanOption(OCBundle.message("generate.comparison.operators.use.std.tie", new Object[0]));
    private final EnumSet<Type> myTypes;

    public OCGenerateComparisonOperatorsHandler(@NotNull EnumSet<Type> types) {
        if (types == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(0);
        }
        this.myTypes = types;
    }

    @Override
    @NotNull
    protected Collection<OCFunctionSymbol> checkExistingFunctions(@NotNull Project project, @NotNull OCCaretLocation location, @NotNull OCGenerateComparisonOperatorsContext actionContext) {
        if (project == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(1);
        }
        if (location == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(2);
        }
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(3);
        }
        ArrayList<String> operators = this.getOperatorsToGenerate(actionContext);
        OCStructType selfType = ((OCStructSymbol)actionContext.getParent()).getType();
        List<Pair<String, OCFunctionSymbol>> existing = OCResolveUtil.findExistingFunctions(project, operators, Arrays.asList(selfType, selfType), (OCSymbol)actionContext.getParent(), OCResolveContext.forSymbol((OCSymbol)actionContext.getParent(), actionContext.getProject()));
        actionContext.setExistingOperators(existing.stream().map(p -> (String)p.getFirst()).distinct().collect(Collectors.toList()));
        actionContext.setOperatorsToGenerate(operators);
        List list = ContainerUtil.map(existing, p -> (OCFunctionSymbol)p.getSecond());
        if (list == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    protected String getSomeDefinedText() {
        String string = OCBundle.message("generate.comparison.operators.usages.some.defined", new Object[0]);
        if (string == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getAllDefinedText() {
        String string = OCBundle.message("generate.comparison.operators.usages.all.defined", new Object[0]);
        if (string == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getExistingTabName() {
        String string = OCBundle.message("generate.comparison.operators.usages.existing.text", new Object[0]);
        if (string == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(7);
        }
        return string;
    }

    private @NotNull ArrayList<@NlsSafe String> getOperatorsToGenerate(@NotNull OCGenerateComparisonOperatorsContext context) {
        if (context == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(8);
        }
        ArrayList<@NlsSafe String> result = new ArrayList<String>();
        if (this.myTypes.contains((Object)Type.EQUALITY)) {
            result.add("operator==");
            if (this.getOption(context, ADDITIONAL_EQ_OPTION).booleanValue()) {
                result.add("operator!=");
            }
        }
        if (this.myTypes.contains((Object)Type.RELATIONAL)) {
            result.add("operator<");
            if (this.getOption(context, ADDITIONAL_REL_OPTION).booleanValue()) {
                result.add("operator>");
                result.add("operator<=");
                result.add("operator>=");
            }
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<OCGenerateUtil.Replacement> getReplacements(@NotNull OCCaretLocation location, @NotNull OCGenerateComparisonOperatorsContext actionContext, @NotNull List<OCDeclaratorSymbol> fields) {
        List<OCGenerateUtil.Replacement> replacements;
        if (location == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(10);
        }
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(11);
        }
        if (fields == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(12);
        }
        List all = actionContext.getOperatorsToGenerate();
        List ops = actionContext.isReplaceExisting() ? all : ContainerUtil.filter(all, o -> !actionContext.getExistingOperators().contains(o));
        List symbols = ContainerUtil.map((Collection)ops, s -> OCGenerateComparisonOperatorsHandler.createBinaryOperatorSymbol(location.getProject(), s, actionContext));
        List bodies = ContainerUtil.map((Collection)ops, s -> this.getOperatorBody((String)s, actionContext, fields));
        PsiElement element = ((OCStructSymbol)actionContext.getParent()).locateDefinition(location.getProject());
        if (!(element instanceof OCStruct)) {
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<OCGenerateUtil.Replacement> list = replacements = OCCppDefinitionsUtil.getNewFunctionsReplacements(location, (OCStruct)element, actionContext.getParent(), symbols, bodies, this.getInlinePolicy(actionContext));
        if (list == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    @NlsSafe
    private String getOperatorBody(@NlsSafe @NotNull String operator, @NotNull OCGenerateComparisonOperatorsContext actionContext, @NotNull List<OCDeclaratorSymbol> fields) {
        if (operator == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(15);
        }
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(16);
        }
        if (fields == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(17);
        }
        Project project = actionContext.getProject();
        String lhsNameOrThis = OCGenerateComparisonOperatorsHandler.getLhsNameOrThis(actionContext);
        String rhsName = OCGenerateComparisonOperatorsHandler.getRhsName(project);
        switch (operator) {
            case "operator==": {
                return this.getEqOperatorBody(fields, actionContext);
            }
            case "operator!=": {
                String string = String.format("{\n return !(%s == %s);\n}", rhsName, lhsNameOrThis);
                if (string == null) {
                    OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(18);
                }
                return string;
            }
            case "operator<": {
                return this.getLessOperatorBody(fields, actionContext);
            }
            case "operator>": {
                String string = String.format("{\n return %s < %s;\n}", rhsName, lhsNameOrThis);
                if (string == null) {
                    OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(19);
                }
                return string;
            }
            case "operator<=": {
                String string = String.format("{\n return !(%s < %s);\n}", rhsName, lhsNameOrThis);
                if (string == null) {
                    OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(20);
                }
                return string;
            }
            case "operator>=": {
                String string = String.format("{\n return !(%s < %s);\n}", lhsNameOrThis, rhsName);
                if (string == null) {
                    OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(21);
                }
                return string;
            }
        }
        throw new IllegalArgumentException(operator + " should be a comparison operator");
    }

    @NotNull
    private static OCFunctionSymbol createBinaryOperatorSymbol(@NotNull Project project, @NotNull String name, @NotNull OCGenerateComparisonOperatorsContext actionContext) {
        if (project == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(22);
        }
        if (name == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(23);
        }
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(24);
        }
        boolean isMember = OCGenerateComparisonOperatorsHandler.shouldBeMember(actionContext);
        OCCppReferenceType selfCref = OCCppReferenceType.to(((OCStructSymbol)actionContext.getParent()).getType().cloneWithConstModifier(project));
        OCFakeFunctionSymbolBuilder builder2 = new OCFakeFunctionSymbolBuilder(name).setReturnType(OCIntType.BOOL_NATIVE).setContainer((OCSymbolWithQualifiedName)actionContext.getParent()).setVisibility(OCVisibility.PUBLIC).setIsConst(isMember).setIsFriend(!isMember).setIsOperator(true);
        if (!isMember) {
            builder2.addParam(selfCref, OCGenerateComparisonOperatorsHandler.getLhsName(project));
        }
        builder2.addParam(selfCref, OCGenerateComparisonOperatorsHandler.getRhsName(project));
        OCFunctionSymbol oCFunctionSymbol = builder2.get();
        if (oCFunctionSymbol == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(25);
        }
        return oCFunctionSymbol;
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    private static String getRhsName(@NotNull Project project) {
        if (project == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(26);
        }
        String string = OCNamingConventionUtil.applyNamingConvention("rhs", OCSymbolKind.PARAMETER, project);
        if (string == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    private static String getLhsName(@NotNull Project project) {
        if (project == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(28);
        }
        String string = OCNamingConventionUtil.applyNamingConvention("lhs", OCSymbolKind.PARAMETER, project);
        if (string == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String getLhsNameOrThis(@NotNull OCGenerateComparisonOperatorsContext actionContext) {
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(30);
        }
        return OCGenerateComparisonOperatorsHandler.shouldBeMember(actionContext) ? "*this" : OCGenerateComparisonOperatorsHandler.getLhsName(actionContext.getProject());
    }

    public static boolean shouldBeMember(@NotNull OCGenerateComparisonOperatorsContext actionContext) {
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(31);
        }
        return actionContext.getOptionValues() != null && OCGenerateComparisonOperatorsHandler.getOption(actionContext.getOptionValues(), AS_MEMBER_OPTION) != false;
    }

    private static void fillLeftsAndRights(@NotNull List<OCDeclaratorSymbol> fields, @NotNull OCGenerateComparisonOperatorsContext actionContext, @NotNull List<@NlsSafe String> lefts, @NotNull List<@NlsSafe String> rights) {
        if (fields == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(32);
        }
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(33);
        }
        if (lefts == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(34);
        }
        if (rights == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(35);
        }
        Project project = actionContext.getProject();
        OCResolveContext context = OCResolveContext.forSymbol((OCSymbol)actionContext.getParent(), project);
        ((OCStructSymbol)actionContext.getParent()).processBaseClasses(context, (symbol, visibility) -> {
            String name = symbol.getType().getBestNameInContext(context);
            lefts.add(String.format("static_cast<const %s &>(%s)", name, OCGenerateComparisonOperatorsHandler.getLhsNameOrThis(actionContext)));
            rights.add(String.format("static_cast<const %s &>(%s)", name, OCGenerateComparisonOperatorsHandler.getRhsName(project)));
            return true;
        });
        for (OCDeclaratorSymbol field : fields) {
            lefts.add((String)(OCGenerateComparisonOperatorsHandler.shouldBeMember(actionContext) ? "" : OCGenerateComparisonOperatorsHandler.getLhsName(project) + ".") + field.getName());
            rights.add(OCGenerateComparisonOperatorsHandler.getRhsName(project) + "." + field.getName());
        }
    }

    @NotNull
    @NlsSafe
    private String getEqOperatorBody(@NotNull List<OCDeclaratorSymbol> fields, @NotNull OCGenerateComparisonOperatorsContext actionContext) {
        if (fields == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(36);
        }
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(37);
        }
        ArrayList<String> lefts = new ArrayList<String>();
        ArrayList<String> rights = new ArrayList<String>();
        OCGenerateComparisonOperatorsHandler.fillLeftsAndRights(fields, actionContext, lefts, rights);
        @NlsSafe String retVal = this.getOption(actionContext, USE_STD_TIE_OPTION) != false && lefts.size() > 1 ? String.format("std::tie(%s) == std::tie(%s)", StringUtil.join(lefts, (String)", "), StringUtil.join(rights, (String)", ")) : StringUtil.join((Iterable)ContainerUtil.zip(lefts, rights), pair -> (String)pair.first + " == " + (String)pair.second, (String)" && \n");
        String string = String.format("{\nreturn %s;\n}", retVal);
        if (string == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private String getLessOperatorBody(@NotNull List<OCDeclaratorSymbol> fields, @NotNull OCGenerateComparisonOperatorsContext actionContext) {
        if (fields == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(39);
        }
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(40);
        }
        ArrayList<String> lefts = new ArrayList<String>();
        ArrayList<String> rights = new ArrayList<String>();
        OCGenerateComparisonOperatorsHandler.fillLeftsAndRights(fields, actionContext, lefts, rights);
        if (this.getOption(actionContext, USE_STD_TIE_OPTION).booleanValue() && lefts.size() > 1) {
            String string = String.format("{\nreturn std::tie(%s) < std::tie(%s);\n}", StringUtil.join(lefts, (String)", "), StringUtil.join(rights, (String)", "));
            if (string == null) {
                OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(41);
            }
            return string;
        }
        @NlsSafe StringBuilder result = new StringBuilder("{\n");
        int idx = 0;
        for (Pair pair : ContainerUtil.zip(lefts, rights)) {
            if (idx != lefts.size() - 1) {
                result.append(String.format("if (%s < %s)\nreturn true;\nif (%s < %s)\nreturn false;\n", pair.first, pair.second, pair.second, pair.first));
            } else {
                result.append(String.format("return %s < %s;\n", pair.first, pair.second));
            }
            ++idx;
        }
        result.append("}");
        String string = result.toString();
        if (string == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(42);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getActionTitle() {
        if (this.myTypes.equals(EnumSet.of(Type.EQUALITY))) {
            String string = OCBundle.message("generate.comparison.operators.action.title.eq", new Object[0]);
            if (string == null) {
                OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(43);
            }
            return string;
        }
        if (this.myTypes.equals(EnumSet.of(Type.RELATIONAL))) {
            String string = OCBundle.message("generate.comparison.operators.action.title.rel", new Object[0]);
            if (string == null) {
                OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(44);
            }
            return string;
        }
        String string = OCBundle.message("generate.comparison.operators.action.title", new Object[0]);
        if (string == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(45);
        }
        return string;
    }

    @Override
    protected String getMembersChooserTitle() {
        return OCBundle.message("generate.comparison.operators.member.chooser.title", new Object[0]);
    }

    @Override
    @NotNull
    protected OCGenerateComparisonOperatorsContext evaluateActionContext(OCStructSymbol parent, @NotNull PsiElement context) {
        if (context == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(46);
        }
        return new OCGenerateComparisonOperatorsContext(parent, context);
    }

    @Override
    @NotNull
    protected Collection<OCDeclaratorSymbol> getSelectedCandidates(@NotNull OCGenerateComparisonOperatorsContext actionContext, @Nullable Editor editor, @NotNull PsiFile file, @NotNull List<OCDeclaratorSymbol> candidates) {
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(47);
        }
        if (file == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(48);
        }
        if (candidates == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(49);
        }
        List<OCDeclaratorSymbol> list = candidates;
        if (list == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(50);
        }
        return list;
    }

    @Override
    protected void saveOptions(PsiFile file, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        if (settings == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(51);
        }
        if (optionValues.containsKey(AS_MEMBER_OPTION)) {
            settings.GENERATE_OPERATORS_AS_MEMBERS = OCGenerateComparisonOperatorsHandler.getOption(optionValues, AS_MEMBER_OPTION);
        }
        if (optionValues.containsKey(USE_STD_TIE_OPTION)) {
            settings.GENERATE_COMPARISON_OPERATORS_USE_STD_TIE = OCGenerateComparisonOperatorsHandler.getOption(optionValues, USE_STD_TIE_OPTION);
        }
    }

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCGenerateComparisonOperatorsContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(52);
        }
        if (options == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(53);
        }
        if (this.myTypes.contains((Object)Type.EQUALITY)) {
            options.add((Pair<OCOption, Object>)new Pair((Object)ADDITIONAL_EQ_OPTION, (Object)(settings == null || settings.GENERATE_ADDITIONAL_EQ_OPERATORS ? 1 : 0)));
        }
        if (this.myTypes.contains((Object)Type.RELATIONAL)) {
            options.add((Pair<OCOption, Object>)new Pair((Object)ADDITIONAL_REL_OPTION, (Object)(settings == null || settings.GENERATE_ADDITIONAL_REL_OPERATORS ? 1 : 0)));
        }
        options.add((Pair<OCOption, Object>)new Pair((Object)AS_MEMBER_OPTION, (Object)(settings == null || settings.GENERATE_OPERATORS_AS_MEMBERS ? 1 : 0)));
        options.add((Pair<OCOption, Object>)new Pair((Object)USE_STD_TIE_OPTION, (Object)(settings != null && settings.GENERATE_COMPARISON_OPERATORS_USE_STD_TIE ? 1 : 0)));
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 29: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 29: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 22: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: 
            case 11: 
            case 16: 
            case 24: 
            case 30: 
            case 31: 
            case 33: 
            case 37: 
            case 40: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 29: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateComparisonOperatorsHandler";
                break;
            }
            case 8: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 17: 
            case 32: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lefts";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rights";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateComparisonOperatorsHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "checkExistingFunctions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSomeDefinedText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDefinedText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingTabName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperatorsToGenerate";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacements";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperatorBody";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryOperatorSymbol";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRhsName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLhsName";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqOperatorBody";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getLessOperatorBody";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkExistingFunctions";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 29: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 50: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOperatorsToGenerate";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getReplacements";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOperatorBody";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryOperatorSymbol";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getRhsName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getLhsName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLhsNameOrThis";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeMember";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "fillLeftsAndRights";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getEqOperatorBody";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getLessOperatorBody";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedCandidates";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "saveOptions";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "loadOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 29: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Type {
        EQUALITY,
        RELATIONAL;

    }
}

