/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCObjCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateInitWithHandler
extends OCObjCClassTextActionHandlerBase<OCInstanceVariableSymbol, OCGenerateMethodActionContext> {
    private static final OCBooleanOption RETAIN_OBJECTS = new OCBooleanOption(OCGenerateBundle.message("generate.initwith.handler.retain.objects", new Object[0]));
    private static final OCBooleanOption USE_SETTERS = new OCBooleanOption(OCGenerateBundle.message("generate.initwith.handler.use.setters", new Object[0]));
    private static final OCBooleanOption GENERATE_CLASS_CONSTRUCTOR = new OCBooleanOption(OCGenerateBundle.message("generate.initwith.handler.generate.class.constructor", new Object[0]));

    @Override
    @NotNull
    @NlsContexts.Command
    protected String getActionTitle() {
        @NlsSafe String initWithMethod = "-initWith";
        String string = OCGenerateBundle.message("generate.initwith.handler.action.title", "-initWith");
        if (string == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NlsContexts.DialogTitle
    protected String getMembersChooserTitle() {
        return OCGenerateBundle.message("generate.initwith.handler.members.chooser.title", new Object[0]);
    }

    protected boolean defaultRetainObjects(@Nullable OCCodeStyleSettings settings) {
        return settings == null || settings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR;
    }

    protected boolean defaultUseSetters(@Nullable OCCodeStyleSettings settings) {
        return settings != null && settings.USE_SETTERS_IN_CONSTRUCTOR;
    }

    protected boolean defaultGenerateClassConstructor(@Nullable OCCodeStyleSettings settings) {
        return settings != null && settings.GENERATE_CLASS_CONSTRUCTOR;
    }

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCGenerateMethodActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        if (actionContext == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(1);
        }
        if (options == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(2);
        }
        if (OCCompilerFeaturesHelper.isArcDisabled(file)) {
            options.add((Pair<OCOption, Object>)new Pair((Object)RETAIN_OBJECTS, (Object)this.defaultRetainObjects(settings)));
        }
        options.add((Pair<OCOption, Object>)new Pair((Object)USE_SETTERS, (Object)this.defaultUseSetters(settings)));
        options.add((Pair<OCOption, Object>)new Pair((Object)GENERATE_CLASS_CONSTRUCTOR, (Object)this.defaultGenerateClassConstructor(settings)));
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    @Override
    protected void saveOptions(PsiFile file, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        if (settings == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(3);
        }
        if (OCCompilerFeaturesHelper.isArcDisabled(file)) {
            settings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR = OCGenerateInitWithHandler.getOption(optionValues, RETAIN_OBJECTS);
        }
        settings.USE_SETTERS_IN_CONSTRUCTOR = OCGenerateInitWithHandler.getOption(optionValues, USE_SETTERS);
        settings.GENERATE_CLASS_CONSTRUCTOR = OCGenerateInitWithHandler.getOption(optionValues, GENERATE_CLASS_CONSTRUCTOR);
        super.saveOptions(file, settings, optionValues);
    }

    private static boolean useInstanceType(PsiFile file) {
        return OCCompilerFeaturesHelper.supportsInstancetype(file);
    }

    @Override
    @NotNull
    protected OCGenerateMethodActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        if (element == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(4);
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        OCObjectType type = parent.getResolvedType(OCResolveContext.forPsi(element), true);
        if (type != null) {
            type.processMembers("init", OCMethodSymbol.class, finder);
        }
        return new OCGenerateMethodActionContext(parent, Collections.singletonList((OCMethodSymbol)finder.getFoundValue()), type, element);
    }

    @Override
    protected void performAction(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file, @NotNull OCGenerateMethodActionContext context, @NotNull List<OCInstanceVariableSymbol> ivars) {
        if (project == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(5);
        }
        if (file == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(6);
        }
        if (context == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(7);
        }
        if (ivars == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(8);
        }
        if (!ivars.isEmpty()) {
            OCClassSymbol classSymbol = ivars.get(0).getParent();
            StringBuilder signature2 = new StringBuilder();
            OCMethod method = OCElementFactory.methodFromSignature(OCGenerateInitWithHandler.getMethodSignature(context.getBaseMethod(), ivars, this.getOption(context, USE_SETTERS), file), (PsiElement)file, false, false);
            OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCCallable)method, classSymbol.getContainingOCFile(project));
            handler.setChangeUsages(false);
            handler.getGeneratedInfo().setMethodParent(classSymbol);
            handler.getGeneratedInfo().runOnSuccess(() -> signature2.append(handler.getNewSignature(false)));
            handler.setTitle(this.getActionTitle());
            handler.setRefactorButtonText(OCBundle.message("button.generate", new Object[0]));
            handler.invoke();
            context.setMethodSignature(signature2.length() > 0 ? signature2.toString() : null);
            context.setParameters(handler.getParameters());
        }
        super.performAction(project, editor, file, context, ivars);
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateMethodActionContext context) {
        return true;
    }

    private static String getMethodSignature(OCMethodSymbol baseMethod, List<OCInstanceVariableSymbol> ivars, boolean useSetters, @NotNull PsiFile file) {
        if (file == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(9);
        }
        @NlsSafe StringBuilder signature2 = new StringBuilder();
        signature2.append(baseMethod.isStatic() ? (char)'+' : '-');
        Project project = file.getProject();
        if (OCGenerateInitWithHandler.useInstanceType(file)) {
            signature2.append("(instancetype)");
        } else {
            signature2.append('(').append(baseMethod.getReturnType(project).getBestNameInContext((PsiElement)file)).append(')');
        }
        boolean first = true;
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCPropertySymbol property = ivar.getAssociatedProperty(project);
            if (property != null && property.isReadonly()) {
                property = property.getAssociatedPropertyInPrivateCategory(project);
            }
            if (first) {
                signature2.append("initWith").append(StringUtil.capitalize((String)OCNameSuggester.getNonCollidingName(ivar, true, project)));
            } else {
                signature2.append(' ').append(OCNameSuggester.getNonCollidingName(ivar, true, project));
            }
            first = false;
            boolean useProperty = useSetters && property != null && !property.isReadonly();
            signature2.append(":(").append(ivar.getType().getBestNameInContext((PsiElement)file)).append(')').append(OCNameSuggester.getNonCollidingName(ivar, useProperty, project));
        }
        return signature2.toString();
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCInstanceVariableSymbol> ivars, @NotNull OCGenerateMethodActionContext context) {
        if (element == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(10);
        }
        if (ivars == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(11);
        }
        if (context == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(12);
        }
        String methodSignature = context.getMethodSignature();
        if (ivars.isEmpty()) {
            if (element instanceof OCImplementation) {
                String string = OCCallableUtil.methodText(context.getBaseMethod(), null, element);
                if (string == null) {
                    OCGenerateInitWithHandler.$$$reportNull$$$0(13);
                }
                return string;
            }
            return "";
        }
        if (methodSignature != null) {
            boolean useSetters = this.getOption(context, USE_SETTERS);
            boolean retainObjects = OCCompilerFeaturesHelper.isArcDisabled(element.getContainingFile()) && this.getOption(context, RETAIN_OBJECTS) != false;
            boolean generateClassConstructor = this.getOption(context, GENERATE_CLASS_CONSTRUCTOR);
            String objectSignature = OCGenerateInitWithHandler.getObjectMethodSignature(methodSignature, true, context.getType(), OCResolveContext.forPsi(element));
            if (element instanceof OCImplementation) {
                PsiFile file = element.getContainingFile();
                String initializerText = OCGenerateInitWithHandler.getInitializerText(ivars, context.getParameters(), 0, file, useSetters, retainObjects, context.getNonReleasedIvars());
                StringBuilder result = new StringBuilder();
                result.append(OCCallableUtil.methodWithSignature(context.getBaseMethod(), methodSignature, initializerText, element));
                if (generateClassConstructor && objectSignature != null) {
                    String callText = OCGenerateInitWithHandler.getClassConstructorText((OCImplementation)element, context);
                    result.append(OCCallableUtil.methodText(objectSignature, callText, element));
                }
                String string = result.toString();
                if (string == null) {
                    OCGenerateInitWithHandler.$$$reportNull$$$0(14);
                }
                return string;
            }
            StringBuilder result = new StringBuilder();
            result.append(methodSignature).append(";\n");
            if (generateClassConstructor && objectSignature != null) {
                result.append(objectSignature).append(";\n");
            }
            String string = result.toString();
            if (string == null) {
                OCGenerateInitWithHandler.$$$reportNull$$$0(15);
            }
            return string;
        }
        return "";
    }

    @Nullable
    @NlsSafe
    public static String getObjectMethodSignature(@NlsSafe String methodSignature, boolean appendReturnType, OCObjectType type, @NotNull OCResolveContext context) {
        String prefixName;
        int pos;
        if (context == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(16);
        }
        pos = (pos = methodSignature.indexOf("initWith")) != -1 ? pos + "initWith".length() : methodSignature.indexOf(58);
        Collection<String> suggestions = OCNameSuggester.suggestForType((OCType)type, null, "", context);
        String string = prefixName = suggestions.isEmpty() ? "object" : suggestions.iterator().next();
        @NlsSafe String returnType = appendReturnType ? (OCGenerateInitWithHandler.useInstanceType(context.getFile()) ? "+(instancetype)" : "+(id)") : "";
        String objectSignature = pos != -1 ? returnType + prefixName + "With" + methodSignature.substring(pos) : null;
        return objectSignature;
    }

    private static String getClassConstructorText(OCImplementation element, OCGenerateMethodActionContext context) {
        @NlsSafe StringBuilder text = new StringBuilder("return ");
        if (OCCompilerFeaturesHelper.isArcDisabled(element.getContainingFile())) {
            text.append("[");
        }
        text.append("[[self alloc] ");
        for (OCParameterInfo param : context.getParameters()) {
            text.append(param.getSelector()).append(":").append(param.getName()).append(' ');
        }
        if (OCCompilerFeaturesHelper.isArcDisabled(element.getContainingFile())) {
            text.append("] autorelease");
        }
        text.append("];");
        return text.toString();
    }

    public static String getInitializerText(List<OCInstanceVariableSymbol> ivars, List<OCParameterInfo> parameters, int atIndex, @NotNull PsiFile implementationFile, boolean useSetters, boolean retainObjects, List<OCInstanceVariableSymbol> nonReleasedIvars) {
        if (implementationFile == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(17);
        }
        @NlsSafe StringBuilder initialization = new StringBuilder();
        OCNotReleasedIvarInspection.IvarsInfo ivarsInfo = OCNotReleasedIvarInspection.startInspection(implementationFile);
        OCResolveContext context = OCResolveContext.forPsi((PsiElement)implementationFile);
        for (OCParameterInfo parameter : parameters) {
            int index = parameter.getOldIndex() - atIndex;
            if (index < 0 || index >= ivars.size()) continue;
            OCInstanceVariableSymbol ivar = ivars.get(index);
            Project project = implementationFile.getProject();
            OCPropertySymbol property = ivar.getAssociatedProperty(project);
            OCType type = ivar.getResolvedType(context);
            if (property != null && property.isReadonly()) {
                OCPropertySymbol associatedProperty = property.getAssociatedPropertyInPrivateCategory(project);
                OCPropertySymbol oCPropertySymbol = property = associatedProperty != null ? associatedProperty : property;
            }
            if (initialization.length() > 0) {
                initialization.append("\n");
            }
            if (useSetters && property != null && !property.isReadonly()) {
                initialization.append("self.").append(property.getName()).append('=');
                initialization.append(parameter.getName()).append(";");
                continue;
            }
            if (retainObjects && type.isPointerToObjectCompatible() && OCCompilerFeaturesHelper.isArcDisabled(implementationFile)) {
                initialization.append(ivar.getName()).append('=');
                initialization.append("[").append(parameter.getName());
                if (type.isPointerToString()) {
                    initialization.append(" copy];");
                } else {
                    initialization.append(" retain];");
                }
                if (!OCCompilerFeaturesHelper.isArcDisabled(implementationFile) || ivarsInfo == null || OCNotReleasedIvarInspection.isIvarReleased(ivar, implementationFile, ivarsInfo)) continue;
                nonReleasedIvars.add(ivar);
                continue;
            }
            if (property != null && property.hasAttribute(OCPropertySymbol.PropertyAttribute.COPY)) {
                initialization.append(ivar.getName()).append('=');
                initialization.append("[").append(parameter.getName()).append(" copy];");
                continue;
            }
            initialization.append(ivar.getName()).append('=');
            initialization.append(parameter.getName()).append(";");
        }
        return initialization.toString();
    }

    @Override
    protected void performAction(@NotNull Project project, @NotNull PsiElement element, int caretPos, PsiElement at, @NotNull List<OCInstanceVariableSymbol> members, @NotNull OCGenerateMethodActionContext context) {
        if (project == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(18);
        }
        if (element == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(19);
        }
        if (members == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(20);
        }
        if (context == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(21);
        }
        super.performAction(project, element, caretPos, at, members, context);
        if (element instanceof OCImplementation && !context.getNonReleasedIvars().isEmpty()) {
            new OCReleaseVariablesIntentionAction(context.getNonReleasedIvars(), context.getProject()).invoke(project, null, element.getContainingFile());
        }
        if (element instanceof OCImplementation) {
            for (OCInstanceVariableSymbol member : members) {
                if (member.getParent().isSameCategory(context.getInterfaceSymbol())) continue;
                new OCImportSymbolFix(element, member.getParent(), false).fixBestItem(project, element.getContainingFile());
            }
        }
    }

    @Override
    protected boolean shouldSelectResult(@NotNull OCBlockStatement body) {
        if (body == null) {
            OCGenerateInitWithHandler.$$$reportNull$$$0(22);
        }
        return true;
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCInstanceVariableSymbol> ivars, OCGenerateMethodActionContext actionContext) {
        if (at == null || caretOffset < ((OCClassDeclaration)element).getMethodsStartOffset(true)) {
            return OCDeclarationKind.InitMethod.getChildrenEndOffset(element);
        }
        return ((OCClassDeclaration)element).getMethodsInsertPosition(true, at, caretOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateInitWithHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 12: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ivars";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateInitWithHandler";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadOptions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveOptions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignature";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInsertText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getObjectMethodSignature";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInitializerText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "shouldSelectResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

