/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureVIew;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCStructureViewElement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public final class OCKindSorter
implements Sorter {
    public static final Sorter INSTANCE = new OCKindSorter();

    private OCKindSorter() {
    }

    public Comparator getComparator() {
        return new Comparator<OCStructureViewElement>(){

            @Override
            public int compare(OCStructureViewElement o1, OCStructureViewElement o2) {
                return Integer.compare(this.getWeight(o1.getValue()), this.getWeight(o2.getValue()));
            }

            private int getWeight(PsiElement o) {
                if (o instanceof OCCppNamespace) {
                    return 0;
                }
                if (o instanceof OCStructLike) {
                    return 1;
                }
                if (o instanceof OCClassDeclaration) {
                    return 2;
                }
                if (o instanceof OCFunctionDefinition) {
                    OCFunctionSymbol symbol = ((OCFunctionDefinition)o).getSymbol();
                    if (symbol != null) {
                        if (symbol.isCppConstructor()) {
                            return 3;
                        }
                        if (symbol.isCppDestructor()) {
                            return 4;
                        }
                    }
                    if (o.getParent() instanceof OCClassDeclaration) {
                        return 9;
                    }
                    return 5;
                }
                if (o instanceof OCMethod) {
                    OCMethodSymbol symbol = (OCMethodSymbol)((OCMethod)o).getSymbol();
                    if (symbol != null && symbol.isConstructorMethod()) {
                        return 3;
                    }
                    return 5;
                }
                if (o instanceof OCDeclarator) {
                    OCSymbol symbol = ((OCDeclarator)o).getSymbol();
                    if (symbol != null) {
                        switch (symbol.getKind()) {
                            case CPP_CONSTRUCTOR_DECLARATION: 
                            case CPP_CONSTRUCTOR_PREDECLARATION: {
                                return 3;
                            }
                            case FUNCTION_DECLARATION: 
                            case FUNCTION_PREDECLARATION: {
                                return 5;
                            }
                            case PROPERTY: {
                                return 6;
                            }
                            case INSTANCE_VARIABLE: 
                            case STRUCT_FIELD: {
                                return 7;
                            }
                            case TYPEDEF: {
                                return 8;
                            }
                            case GLOBAL_VARIABLE: 
                            case GLOBAL_VARIABLE_PREDECLARATION: {
                                return 10;
                            }
                        }
                    }
                    return 11;
                }
                if (o instanceof OCDirective) {
                    return 12;
                }
                return Integer.MAX_VALUE;
            }
        };
    }

    public boolean isVisible() {
        return true;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(StructureViewBundle.message((String)"action.sort.by.type", (Object[])new Object[0]), "", AllIcons.ObjectBrowser.SortByType);
    }

    @NotNull
    public String getName() {
        return "KIND";
    }
}

