/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateFromIvarsActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGeneratePropertiesHandler;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseLocalConvertibleHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCPropertyInplaceIntroducer;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConvertToPropertyIntentionAction
extends OCGeneratePropertiesHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message("intentions.convert.to.property", new Object[0]);
        if (string == null) {
            OCConvertToPropertyIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCConvertToPropertyIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public OCInstanceVariableSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            OCConvertToPropertyIntentionAction.$$$reportNull$$$0(2);
        }
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        Object parent = OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class);
        OCSymbol symbol = null;
        if (parent instanceof OCReferenceElement) {
            symbol = ((OCReferenceElement)parent).resolveToSymbol();
        } else if (parent instanceof OCDeclarator) {
            symbol = ((OCDeclarator)parent).getSymbol();
        } else if (parent instanceof OCQualifiedExpression) {
            symbol = ((OCQualifiedExpression)parent).resolveToSymbol();
        }
        return symbol instanceof OCInstanceVariableSymbol ? (OCInstanceVariableSymbol)symbol : null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            OCConvertToPropertyIntentionAction.$$$reportNull$$$0(3);
        }
        return OCSearchScope.isInProjectSources(this.locateCandidate(project, editor, file), project);
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        OCInstanceVariableSymbol ivar;
        if (project == null) {
            OCConvertToPropertyIntentionAction.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            OCConvertToPropertyIntentionAction.$$$reportNull$$$0(5);
        }
        if (file == null) {
            OCConvertToPropertyIntentionAction.$$$reportNull$$$0(6);
        }
        return (ivar = this.locateCandidate(project, editor, file)) != null ? ivar.getParent().getMainInterface(project) : null;
    }

    @Override
    protected boolean replaceAllIvars() {
        return true;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCInstanceVariableSymbol> candidates) {
        return false;
    }

    @Override
    @NotNull
    protected Condition<OCInstanceVariableSymbol> getCandidatesFilter(@NotNull OCGenerateFromIvarsActionContext actionContext) {
        if (actionContext == null) {
            OCConvertToPropertyIntentionAction.$$$reportNull$$$0(7);
        }
        Condition condition = Conditions.alwaysTrue();
        if (condition == null) {
            OCConvertToPropertyIntentionAction.$$$reportNull$$$0(8);
        }
        return condition;
    }

    @Override
    protected void performAction(@NotNull Project project, Editor editor, final @NotNull PsiFile file, final @NotNull OCGenerateFromIvarsActionContext context, final @NotNull List<OCInstanceVariableSymbol> ivars) {
        OCInstanceVariableSymbol ivar;
        if (project == null) {
            OCConvertToPropertyIntentionAction.$$$reportNull$$$0(9);
        }
        if (file == null) {
            OCConvertToPropertyIntentionAction.$$$reportNull$$$0(10);
        }
        if (context == null) {
            OCConvertToPropertyIntentionAction.$$$reportNull$$$0(11);
        }
        if (ivars == null) {
            OCConvertToPropertyIntentionAction.$$$reportNull$$$0(12);
        }
        if ((ivar = this.locateCandidate(project, editor, file)) == null) {
            return;
        }
        OCPropertySymbol associatedProperty = ivar.getAssociatedProperty(project);
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        final OCElement element = (OCElement)OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class);
        final String propName = associatedProperty != null ? associatedProperty.getName() : OCNameSuggester.getNonCollidingName(ivar, true, project);
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)element);
        OCBaseLocalConvertibleHandler handler = new OCBaseLocalConvertibleHandler(OCRefactoringBundle.message("refactoring.introduce.property.name", new Object[0])){

            protected OCPropertyInplaceIntroducer createIntroducer(Project project, final Editor editor, PsiElement expression, List<PsiElement> occurrences, @NlsContexts.Command String refactoringName) {
                return new OCPropertyInplaceIntroducer(project, editor, expression, occurrences, refactoringName){

                    @Override
                    public PsiElement evaluateAnchor() {
                        return element;
                    }

                    public PsiElement[] getOccurrences() {
                        PsiElement[] psiElementArray;
                        PsiElement occurrence = pointer.getElement();
                        if (occurrence != null) {
                            PsiElement[] psiElementArray2 = new PsiElement[1];
                            psiElementArray = psiElementArray2;
                            psiElementArray2[0] = occurrence;
                        } else {
                            psiElementArray = PsiElement.EMPTY_ARRAY;
                        }
                        return psiElementArray;
                    }

                    @Override
                    protected void performIntroduce() {
                        OCConvertToPropertyIntentionAction.this.performAction(file, context, ivars, this.getInputName(), (OCPropertySymbol.PropertySemantics)((Object)this.mySemantics.compute()), this.myReadonly, this.isConvertUsages(), this.myPutToPrivateCategoryCB != null && this.myPutToPrivateCategoryCB.isSelected());
                    }

                    @Override
                    protected boolean askToGenerateSynthesize() {
                        return false;
                    }

                    @Override
                    protected boolean askToConvertUsages() {
                        if (!OCCompilerFeaturesHelper.supportsAutosynthesis(file)) {
                            return false;
                        }
                        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
                        Object parent = OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class);
                        return !(parent instanceof OCQualifiedExpression);
                    }

                    @Override
                    protected String[] suggestNames(boolean replaceAll, @Nullable OCDeclarator variable) {
                        if (!propName.equals(ivar.getName())) {
                            return new String[]{propName, ivar.getName()};
                        }
                        return new String[]{propName};
                    }
                };
            }

            @Override
            @NotNull
            protected String getFeatureID() {
                return "refactoring.convertToProperty";
            }
        };
        handler.invoke(project, editor, element, ivar.getResolvedType(OCResolveContext.forPsi((PsiElement)file)), true, false, propName, ivar.getParent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCConvertToPropertyIntentionAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ivars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCConvertToPropertyIntentionAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidatesFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "locateCandidate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCandidatesFilter";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

