/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.intentions.OCBraceToggleBaseIntentionAction;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSingleStatementWithBracesIntentionAction
extends OCBraceToggleBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(OCSingleStatementWithBracesIntentionAction.class);

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message("intentions.remove.braces.statement", this.getStatementName());
        if (string == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private OCBlockStatement getContainedBlockStatement(@NotNull OCStatement statement, @NotNull PsiElement element) {
        PsiElement expr;
        if (statement == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(2);
        }
        if (!((expr = this.getContainedExpr(statement, element)) instanceof OCBlockStatement)) {
            return null;
        }
        return (OCBlockStatement)expr;
    }

    @Override
    protected void doRun(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCStatement statement;
        if (project == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(4);
        }
        LOG.assertTrue((statement = OCSingleStatementWithBracesIntentionAction.getParentStatement(element)) != null);
        OCBlockStatement blockStatement = this.getContainedBlockStatement(statement, element);
        LOG.assertTrue(blockStatement != null);
        List<OCStatement> statements = blockStatement.getStatements();
        LOG.assertTrue(statements.size() == 1);
        PsiElement newStatement = statements.get(0);
        PsiElement prevSibling = newStatement.getPrevSibling();
        PsiElement newElement = OCSingleStatementWithBracesIntentionAction.getMacroOrElement(newStatement, prevSibling);
        CaretModel caretModel = editor.getCaretModel();
        int moveCaretBy = OCSingleStatementWithBracesIntentionAction.getCaretAdjustment(caretModel, newElement);
        PsiElement insertedElement = OCSingleStatementWithBracesIntentionAction.replaceElement(blockStatement, newElement);
        OCSingleStatementWithBracesIntentionAction.insertSemiColonIfNeeded(prevSibling, insertedElement);
        OCSingleStatementWithBracesIntentionAction.moveCaret(caretModel, moveCaretBy, insertedElement);
        OCSingleStatementWithBracesIntentionAction.reformat(project, editor.getDocument(), statement);
    }

    @Override
    protected boolean isValidElement(@NotNull OCStatement statement, @NotNull PsiElement element) {
        OCBlockStatement blockStatement;
        if (statement == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(5);
        }
        if (element == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(6);
        }
        return (blockStatement = this.getContainedBlockStatement(statement, element)) != null && OCParenthesesUtils.canStripBraces(blockStatement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCSingleStatementWithBracesIntentionAction";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCSingleStatementWithBracesIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContainedBlockStatement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

