/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class OCSwitchPropertyDotMethodIntentionAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message("intentions.switch.property.dot.method", new Object[0]);
        if (string == null) {
            OCSwitchPropertyDotMethodIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        OCExpression expression;
        if (project == null) {
            OCSwitchPropertyDotMethodIntentionAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            OCSwitchPropertyDotMethodIntentionAction.$$$reportNull$$$0(2);
        }
        if ((expression = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCSendMessageExpression.class, OCQualifiedExpression.class})) instanceof OCQualifiedExpression) {
            ReadWriteAccessDetector.Access access = new OCReadWriteAccessDetector().getExpressionAccess(expression);
            if (access == ReadWriteAccessDetector.Access.Read) {
                this.setText(OCInspectionsBundle.message("intentions.switch.to.getter.notation", new Object[0]));
            } else if (access == ReadWriteAccessDetector.Access.Write) {
                this.setText(OCInspectionsBundle.message("intentions.switch.to.setter.notation", new Object[0]));
            } else {
                return false;
            }
            OCSymbol symbol = ((OCQualifiedExpression)expression).resolveToSymbol();
            return symbol instanceof OCPropertySymbol || symbol instanceof OCMethodSymbol;
        }
        if (expression instanceof OCSendMessageExpression) {
            this.setText(OCInspectionsBundle.message("intentions.switch.to.dot.notation", new Object[0]));
            OCMethodSymbol responder = ((OCSendMessageExpression)expression).getProbableResponders().getKnownResponder();
            OCResolveContext context = OCResolveContext.forPsi(element);
            return responder != null && (responder.getGeneratedFromProperty() != null || responder.isGetter(context) || responder.isSetter(context) && OCNameSuggester.getObjCGetterFromSetter(responder.getName()) != null);
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCExpression expression;
        if (project == null) {
            OCSwitchPropertyDotMethodIntentionAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            OCSwitchPropertyDotMethodIntentionAction.$$$reportNull$$$0(4);
        }
        if ((expression = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCSendMessageExpression.class, OCQualifiedExpression.class})) instanceof OCQualifiedExpression) {
            ReadWriteAccessDetector.Access access = new OCReadWriteAccessDetector().getExpressionAccess(expression);
            OCSymbol symbol = ((OCQualifiedExpression)expression).resolveToSymbol();
            if (access == ReadWriteAccessDetector.Access.Read) {
                String getterName;
                if (symbol instanceof OCPropertySymbol) {
                    getterName = ((OCPropertySymbol)symbol).getGetterName();
                } else if (symbol instanceof OCMethodSymbol) {
                    getterName = symbol.getName();
                } else {
                    return;
                }
                OCSendMessageExpression getter = (OCSendMessageExpression)OCElementFactory.expressionFromText("[x " + getterName + "]", element, true);
                OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(getter.getReceiverExpression(), ((OCQualifiedExpression)expression).getQualifier());
                OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(expression, getter);
            } else if (access == ReadWriteAccessDetector.Access.Write) {
                String setterName;
                PsiElement parent = OCParenthesesUtils.topmostParenthesized(expression).getParent();
                if (symbol instanceof OCPropertySymbol) {
                    setterName = ((OCPropertySymbol)symbol).getSetterName();
                } else if (symbol instanceof OCMethodSymbol) {
                    setterName = symbol.getName();
                } else {
                    return;
                }
                if (parent instanceof OCAssignmentExpression) {
                    OCSendMessageExpression setter = (OCSendMessageExpression)OCElementFactory.expressionFromText("[x " + setterName + "x]", element, true);
                    OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(setter.getReceiverExpression(), ((OCQualifiedExpression)expression).getQualifier());
                    OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(setter.getArgumentExpressions().get(0), ((OCAssignmentExpression)parent).getSourceExpression());
                    OCChangeUtil.replaceHandlingMacros(parent, setter);
                }
            }
        } else if (expression instanceof OCSendMessageExpression) {
            OCMethodSymbol responder = ((OCSendMessageExpression)expression).getProbableResponders().getKnownResponder();
            OCPropertySymbol property = responder != null ? responder.getGeneratedFromProperty() : null;
            String propertyName = property != null ? property.getName() : null;
            OCResolveContext context = OCResolveContext.forPsi(element);
            if (responder != null && responder.isGetter(context)) {
                if (propertyName == null) {
                    propertyName = responder.getName();
                }
                OCQualifiedExpression accessor = (OCQualifiedExpression)OCElementFactory.expressionFromText("x." + propertyName, element, true);
                OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(accessor.getQualifier(), ((OCSendMessageExpression)expression).getReceiverExpression());
                OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(expression, accessor);
            } else if (responder != null && responder.isSetter(context)) {
                if (propertyName == null) {
                    propertyName = OCNameSuggester.getObjCGetterFromSetter(responder.getName());
                }
                OCAssignmentExpression assignment = (OCAssignmentExpression)OCElementFactory.expressionFromText("x." + propertyName + "=x", element, true);
                OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(assignment.getSourceExpression(), ((OCSendMessageExpression)expression).getArgumentExpressions().get(0));
                OCQualifiedExpression accessor = (OCQualifiedExpression)assignment.getReceiverExpression();
                OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(accessor.getQualifier(), ((OCSendMessageExpression)expression).getReceiverExpression());
                OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(expression, assignment);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCSwitchPropertyDotMethodIntentionAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCSwitchPropertyDotMethodIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

