/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.daemon;

import com.intellij.openapi.util.Ref;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCThrowExpression;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.v2.Conversions;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConditionalExpressionTypesCalc {
    public static OCType calcAndAnnotateConditionalExprType(@NotNull OCType lTy, @NotNull OCTypeOwner lhs, @NotNull OCType rTy, @NotNull OCTypeOwner rhs, @NotNull OCTypeOwner wholeExpr, @Nullable OCAnnotatorSink sink, @NotNull OCResolveContext context) {
        if (lTy == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(0);
        }
        if (lhs == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(1);
        }
        if (rTy == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(2);
        }
        if (rhs == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(3);
        }
        if (wholeExpr == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(4);
        }
        if (context == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(5);
        }
        lTy = OCTypeUtils.getCppReferencedType(lTy);
        rTy = OCTypeUtils.getCppReferencedType(rTy);
        CalcTypeResult result = OCConditionalExpressionTypesCalc.calcConditionalExprTypeImpl(lTy, lhs, rTy, rhs, wholeExpr, sink, context);
        if (sink != null && result.needToAnnotateIndividualParameters) {
            OCTypeCompatibilityVisitor.checkConvertible(rTy, lTy, lhs, (OCExpression)lhs, true, true, context).annotate(sink);
            OCTypeCompatibilityVisitor.checkConvertible(lTy, rTy, rhs, (OCExpression)rhs, true, true, context).annotate(sink);
        }
        return OCType.updateWithCommonGuessedType(lTy, rTy, result.type, context);
    }

    private static CalcTypeResult calcConditionalExprTypeImpl(@NotNull OCType lTy, @NotNull OCTypeOwner lhs, @NotNull OCType rTy, @NotNull OCTypeOwner rhs, @NotNull OCTypeOwner wholeExpr, @Nullable OCAnnotatorSink sink, @NotNull OCResolveContext context) {
        boolean same;
        if (lTy == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(6);
        }
        if (lhs == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(7);
        }
        if (rTy == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(8);
        }
        if (rhs == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(9);
        }
        if (wholeExpr == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(10);
        }
        if (context == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(11);
        }
        if (lTy.isVoid() || rTy.isVoid()) {
            if (OCConditionalExpressionTypesCalc.isThrow(lhs)) {
                return CalcTypeResult.ok(rTy);
            }
            if (OCConditionalExpressionTypesCalc.isThrow(rhs)) {
                return CalcTypeResult.ok(lTy);
            }
            if (!(!context.isCpp() || lTy.isVoid() && rTy.isVoid())) {
                return CalcTypeResult.fail();
            }
            return CalcTypeResult.ok(OCVoidType.instance());
        }
        if ((lTy.isCppStructType(context) || rTy.isCppStructType(context)) && !OCConditionalExpressionTypesCalc.areLeftAndRightEqual(lTy, rTy, context)) {
            boolean haveR2L = OCConditionalExpressionTypesCalc.hasStructConversion(lTy, rTy, rhs, context);
            boolean haveL2R = OCConditionalExpressionTypesCalc.hasStructConversion(rTy, lTy, lhs, context);
            if (haveL2R && haveR2L) {
                OCConditionalExpressionTypesCalc.annotateAmbiguousStructs(lTy, rTy, (OCExpression)wholeExpr, sink, context);
                return new CalcTypeResult(OCUnknownType.INSTANCE, false);
            }
            if (haveL2R) {
                lTy = rTy;
            } else if (haveR2L) {
                rTy = lTy;
            }
        }
        OCExprValueCategory lvc = OCExprValueCategory.classify(lhs, context);
        OCExprValueCategory rvc = OCExprValueCategory.classify(rhs, context);
        if (!OCConditionalExpressionTypesCalc.areLeftAndRightEqual(lTy, rTy, context) && lvc == rvc && lvc != OCExprValueCategory.PRValue) {
            if (OCConditionalExpressionTypesCalc.areRefCompatible(lTy, rTy, context)) {
                rTy = lTy;
            } else if (OCConditionalExpressionTypesCalc.areRefCompatible(rTy, lTy, context)) {
                lTy = rTy;
            }
        }
        if ((same = OCConditionalExpressionTypesCalc.areLeftAndRightEqual(lTy, rTy, context)) && lvc == rvc && lvc != OCExprValueCategory.PRValue) {
            return CalcTypeResult.ok(lTy.isMagicInside(context) ? lTy : rTy);
        }
        if ((lTy.isCppStructType(context) || rTy.isCppStructType(context)) && !same) {
            return CalcTypeResult.fail();
        }
        if (OCConditionalExpressionTypesCalc.areLeftAndRightEqual(lTy = OCTypeUtils.decayType(lTy, context.getProject(), false), rTy = OCTypeUtils.decayType(rTy, context.getProject(), false), context)) {
            return CalcTypeResult.ok(lTy.isMagicInside(context) ? lTy : rTy);
        }
        if (TypeProperties.isArithmeticType(lTy) && TypeProperties.isArithmeticType(rTy)) {
            return CalcTypeResult.ok(lTy.getLeastCommonType(rTy, context));
        }
        if (lTy.isPointer() && OCExpressionEvaluator.isLikeNil(rhs, context)) {
            return CalcTypeResult.ok(lTy);
        }
        if (rTy.isPointer() && OCExpressionEvaluator.isLikeNil(lhs, context)) {
            return CalcTypeResult.ok(rTy);
        }
        if (lTy.isPointer() || rTy.isPointer()) {
            return OCConditionalExpressionTypesCalc.getCommonPointerType(lTy, rTy, context);
        }
        return CalcTypeResult.fail();
    }

    private static boolean hasStructConversion(@NotNull OCType destType, @NotNull OCType sourceType, @NotNull OCTypeOwner sourceExpr, @NotNull OCResolveContext context) {
        if (destType == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(12);
        }
        if (sourceType == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(13);
        }
        if (sourceExpr == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(14);
        }
        if (context == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(15);
        }
        return sourceType.getCVQualifiers().isSuperset(destType.getCVQualifiers()) && !destType.checkCompatible(sourceType, sourceExpr, context.getElement(), true, context).getState().isError(context.getElement());
    }

    private static void annotateAmbiguousStructs(@NotNull OCType LTy, @NotNull OCType RTy, @NotNull OCExpression wholeExpr, @Nullable OCAnnotatorSink sink, @NotNull OCResolveContext context) {
        if (LTy == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(16);
        }
        if (RTy == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(17);
        }
        if (wholeExpr == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(18);
        }
        if (context == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(19);
        }
        if (sink != null) {
            sink.addErrorAnnotation(wholeExpr, "err_conditional_ambiguous", String.format("Ambiguous conditional operator: '%s' and '%s' can be converted to each other", LTy.getName(context), RTy.getName(context)));
        }
    }

    private static boolean areRefCompatible(@NotNull OCType LTy, @NotNull OCType RTy, @NotNull OCResolveContext context) {
        Ref objCLifetimeConversion;
        Ref objCConversion;
        Ref derivedToBase;
        Conversions.ReferenceCompareResult refRel;
        if (LTy == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(20);
        }
        if (RTy == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(21);
        }
        if (context == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(22);
        }
        return (refRel = Conversions.CompareReferenceRelationship(LTy, RTy, (Ref<Boolean>)(derivedToBase = Ref.create()), (Ref<Boolean>)(objCConversion = Ref.create()), (Ref<Boolean>)(objCLifetimeConversion = Ref.create()), context)).compareTo(Conversions.ReferenceCompareResult.Ref_Compatible_With_Added_Qualification) >= 0 && (Boolean)derivedToBase.get() == false && (Boolean)objCConversion.get() == false && (Boolean)objCLifetimeConversion.get() == false;
    }

    @NotNull
    private static CalcTypeResult getCommonPointerType(@NotNull OCType lTy, @NotNull OCType rTy, @NotNull OCResolveContext context) {
        if (lTy == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(23);
        }
        if (rTy == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(24);
        }
        if (context == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(25);
        }
        assert (lTy.isPointer() || rTy.isPointer());
        if (lTy.isPointerToObject() && rTy.isPointerToObject()) {
            return new CalcTypeResult(lTy.getLeastCommonType(rTy, context), true);
        }
        if (lTy.isPointer() && rTy.isPointer()) {
            OCType rPointee;
            OCPointerType lp = (OCPointerType)lTy;
            OCPointerType rp = (OCPointerType)rTy;
            OCType lPointee = lp.getRefType();
            OCType commonUnqualifiedPointee = OCConditionalExpressionTypesCalc.getBaseType(lPointee, rPointee = rp.getRefType(), context);
            if (commonUnqualifiedPointee != null) {
                CVQualifiers mergedPointeesCV = lPointee.getCVQualifiers().or(rPointee.getCVQualifiers());
                CVQualifiers mergedPointersCV = lp.getCVQualifiers().or(rp.getCVQualifiers());
                OCType commonQualifiedPointee = commonUnqualifiedPointee.cloneWithAddedCVQualifiers(mergedPointeesCV, context.getProject());
                OCPointerType resultType = OCPointerType.to(commonQualifiedPointee, lp.getARCAttribute(), lp.getClassQualifier(), lp.getNullability(), mergedPointersCV.isConst(), mergedPointersCV.isVolatile());
                CalcTypeResult calcTypeResult = CalcTypeResult.ok(resultType);
                if (calcTypeResult == null) {
                    OCConditionalExpressionTypesCalc.$$$reportNull$$$0(26);
                }
                return calcTypeResult;
            }
        }
        if (!context.isCpp()) {
            if (lTy.isNumberCompatible(context)) {
                return new CalcTypeResult(rTy, true);
            }
            if (rTy.isNumberCompatible(context)) {
                return new CalcTypeResult(lTy, true);
            }
        }
        CalcTypeResult calcTypeResult = CalcTypeResult.fail();
        if (calcTypeResult == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(27);
        }
        return calcTypeResult;
    }

    @Nullable
    private static OCType getBaseType(@NotNull OCType lPointee, @NotNull OCType rPointee, @NotNull OCResolveContext context) {
        if (lPointee == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(28);
        }
        if (rPointee == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(29);
        }
        if (context == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(30);
        }
        if (TypeProperties.hasSameUnqualifiedType(lPointee, rPointee, context) || TypeProperties.IsDerivedFrom(rPointee, lPointee, context)) {
            return lPointee.cloneWithoutCVQualifiers(context.getProject());
        }
        if (TypeProperties.IsDerivedFrom(lPointee, rPointee, context)) {
            return rPointee.cloneWithoutCVQualifiers(context.getProject());
        }
        if (lPointee.isVoid() || rPointee.isVoid()) {
            return OCVoidType.instance();
        }
        return null;
    }

    private static boolean areLeftAndRightEqual(@NotNull OCType LTy, @NotNull OCType RTy, @NotNull OCResolveContext context) {
        if (LTy == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(31);
        }
        if (RTy == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(32);
        }
        if (context == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(33);
        }
        return new OCTypeEqualityVisitor(RTy, true, false, context).equal(LTy);
    }

    private static boolean isThrow(@NotNull OCTypeOwner expr) {
        if (expr == null) {
            OCConditionalExpressionTypesCalc.$$$reportNull$$$0(34);
        }
        OCTypeOwner inner = OCParenthesesUtils.diveIntoParentheses(expr);
        return inner instanceof OCThrowExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lTy";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lhs";
                break;
            }
            case 2: 
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rTy";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rhs";
                break;
            }
            case 4: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wholeExpr";
                break;
            }
            case 5: 
            case 11: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceExpr";
                break;
            }
            case 16: 
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "LTy";
                break;
            }
            case 17: 
            case 21: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "RTy";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/legacy/daemon/OCConditionalExpressionTypesCalc";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lPointee";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPointee";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/legacy/daemon/OCConditionalExpressionTypesCalc";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonPointerType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcAndAnnotateConditionalExprType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calcConditionalExprTypeImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasStructConversion";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "annotateAmbiguousStructs";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "areRefCompatible";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCommonPointerType";
                break;
            }
            case 26: 
            case 27: {
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getBaseType";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "areLeftAndRightEqual";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isThrow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CalcTypeResult {
        public final OCType type;
        public final boolean needToAnnotateIndividualParameters;

        CalcTypeResult(OCType type, boolean needToAnnotateIndividualParameters) {
            this.type = type;
            this.needToAnnotateIndividualParameters = needToAnnotateIndividualParameters;
        }

        public static CalcTypeResult ok(OCType type) {
            return new CalcTypeResult(type, false);
        }

        public static CalcTypeResult fail() {
            return new CalcTypeResult(OCUnknownType.INSTANCE, true);
        }
    }
}

