/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.daemon;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.daemon.OCLegacyAnnotator;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.intentions.OCDeclareSpecificMethodInPrivateCategoryAction;
import com.jetbrains.cidr.lang.legacy.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppQualifiedPointer;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCGenericParameter;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCQualifiedDesignator;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.impl.OCDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.OCMacroParameterImpl;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.quickfixes.OCChangeMethodSignatureIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCDeclareMethodInInterfaceAction;
import com.jetbrains.cidr.lang.quickfixes.OCHighPriorityCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCMigrateToARCIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCMoveDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCPredeclareSymbolIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRenameReferenceIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.OCSelectorAdHocResolver;
import com.jetbrains.cidr.lang.resolve.references.OCCompositeResourceReference;
import com.jetbrains.cidr.lang.resolve.references.OCFileResourceReference;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveAnnotator
extends OCLegacyAnnotator {
    public static final boolean ourIsEnabled = Registry.is((String)"cidr.enable.error.annotator", (boolean)true);

    @Override
    protected boolean isEnabled(@NotNull PsiFile file) {
        if (file == null) {
            OCResolveAnnotator.$$$reportNull$$$0(0);
        }
        return ourIsEnabled && super.isEnabled(file);
    }

    @Nullable
    private Annotation checkReferences(@NotNull PsiElement psiElement, @Nullable String cannotResolveMessage, @Nullable OCSymbolGroupContext groupContext, @Nullable String newName, @Nullable Class<? extends OCInspection> inspectionClass) {
        PsiReference[] refs;
        if (psiElement == null) {
            OCResolveAnnotator.$$$reportNull$$$0(1);
        }
        if (cannotResolveMessage == null) {
            cannotResolveMessage = groupContext != null ? groupContext.getCannotResolveMessagePrefix(psiElement.getProject()) : "Can't resolve";
        }
        for (PsiReference reference : refs = psiElement.getReferences()) {
            OCSymbol symbol = null;
            Annotation annotation = null;
            if (reference instanceof OCPolyVariantReference) {
                List symbols = ((OCPolyVariantReference)reference).resolveToSymbols();
                if (symbols.size() == 0) {
                    if (!reference.isSoft()) {
                        annotation = this.highlightUnresolvedReference(cannotResolveMessage, reference, inspectionClass);
                    }
                } else {
                    symbol = (OCSymbol)symbols.get(0);
                }
            } else if (reference instanceof OCReference) {
                symbol = ((OCReference)reference).resolveToSymbol();
                if (symbol == null) {
                    PsiElement context2 = psiElement.getContext();
                    if (psiElement instanceof OCQualifiedExpression) {
                        OCExpression oCExpression = ((OCQualifiedExpression)psiElement).getQualifier();
                        if (oCExpression.getResolvedType() instanceof OCMagicType) {
                            this.highlight(reference, OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.TEMPLATE_VALUE_PARAMETER, false));
                            continue;
                        }
                    } else if (psiElement instanceof OCReferenceElement) {
                        OCReferenceElement oCReferenceElement = (OCReferenceElement)psiElement;
                        boolean soft = false;
                        OCCppNamespaceQualifier namespaceQualifier = oCReferenceElement.getNamespaceQualifier();
                        if (namespaceQualifier != null) {
                            for (OCSymbol candidate : namespaceQualifier.resolveToSymbols()) {
                                if (!(candidate instanceof OCTypeParameterSymbol)) continue;
                                soft = true;
                                break;
                            }
                            if (soft) {
                                this.highlight(reference, OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.TEMPLATE_VALUE_PARAMETER, false));
                                continue;
                            }
                        }
                    }
                    if (!(context2 instanceof OCStructLike) && !reference.isSoft() && PsiTreeUtil.getContextOfType((PsiElement)psiElement, (Class[])new Class[]{OCDirectiveImpl.class}) == null) {
                        annotation = this.highlightUnresolvedReference(cannotResolveMessage, reference, inspectionClass);
                    }
                }
            } else if (reference.resolve() == null) {
                if (reference instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)reference).multiResolve(false).length > 0) continue;
                if (!reference.isSoft()) {
                    annotation = this.highlightUnresolvedReference(cannotResolveMessage, reference, inspectionClass);
                }
            }
            if (annotation != null) {
                if (groupContext != null) {
                    for (OCSymbolContext oCSymbolContext : groupContext.getSymbolContexts()) {
                        String name = newName != null ? newName : reference.getCanonicalText();
                        this.registerCreateNewDefinitionFix(psiElement, annotation, oCSymbolContext, name);
                        if (psiElement == null) continue;
                        this.registerQuickFix(annotation, new OCRenameReferenceIntentionAction(psiElement));
                    }
                }
                return annotation;
            }
            if (symbol == null) continue;
            if (symbol instanceof OCFunctionGroupSymbol) {
                symbol = (OCSymbol)ContainerUtil.getFirstItem(((OCFunctionGroupSymbol)symbol).getOverloads());
            }
            if (symbol instanceof OCThisSelfSuperSymbol) {
                this.highlight(reference, OCHighlightingKeys.SELFSUPERTHIS);
                return null;
            }
            OCSymbolKind kind = symbol.getKind();
            if (kind == OCSymbolKind.MACRO) {
                if (psiElement.getTextLength() > 0) {
                    this.highlight(psiElement, OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.MACRO, false));
                }
            } else if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppOperator()) {
                this.highlight(reference, OCHighlightingKeys.OVERLOADED_OPERATOR);
            } else {
                this.highlight(reference, OCResolveAnnotator.getTextAttributesKeyByKind(kind, false));
            }
            if (symbol.isForbiddenByARC(psiElement)) {
                annotation = this.addErrorAnnotation(psiElement, OCInspections.ARCIssues.class, "CIDR", "Explicit usage of '" + symbol.getName() + "' is forbidden in ARC");
                if (psiElement instanceof OCReferenceElement) {
                    this.registerQuickFix(annotation, new OCMigrateToARCIntentionAction((OCReferenceElement)psiElement));
                }
                this.registerQuickFix(annotation, new OCMigrateToARCIntentionAction((OCFile)psiElement.getContainingFile()));
                break;
            }
            OCCompilationContext oCCompilationContext = OCCompilationContext.create(psiElement);
            if (symbol.isUnavailable()) {
                this.addErrorAnnotation(psiElement, OCInspections.DeprecatedApi.class, "CIDR", symbol.getUnavailableMessage(oCCompilationContext));
            } else if (symbol.isDeprecated()) {
                this.addWarningAnnotation(psiElement, OCInspections.DeprecatedApi.class, "warn_deprecated", symbol.getDeprecatedMessage(oCCompilationContext), ProblemHighlightType.LIKE_DEPRECATED);
            }
            String string = OCResolveUtil.checkAvailability(symbol, psiElement);
            if (string == null) continue;
            this.addWarningAnnotation(psiElement, OCInspections.UnavailableInDeploymentTarget.class, "CIDR", string, ProblemHighlightType.LIKE_DEPRECATED);
            break;
        }
        return null;
    }

    private void registerCreateNewDefinitionFix(PsiElement psiElement, Annotation annotation, OCSymbolContext context, String name) {
        if (context.getSymbolKind() == OCSymbolKind.METHOD && psiElement instanceof OCQualifiedExpression) {
            boolean isSetter = new OCReadWriteAccessDetector().getExpressionAccess(psiElement) == ReadWriteAccessDetector.Access.Write;
            OCObjectTypeContext receiverContext = ((OCQualifiedExpression)psiElement).getQualifier().getTypeContext();
            OCType expectedType = context.getExpectedType();
            if (receiverContext == null || expectedType == null) {
                return;
            }
            expectedType = expectedType.resolve(psiElement);
            OCType returnType = isSetter ? OCVoidType.instance() : expectedType;
            String methodName = isSetter ? OCNameSuggester.getObjCSetterFromGetter(name) : name;
            String staticToken = receiverContext.getStaticMode() == OCObjectTypeContext.StaticMode.STATIC ? "+" : "-";
            StringBuilder signature2 = new StringBuilder();
            signature2.append(staticToken).append('(').append(returnType.getName(psiElement)).append(')').append(methodName);
            if (isSetter) {
                signature2.append('(').append(expectedType.getName(psiElement)).append(')').append(name);
            }
            this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(psiElement, context.getParent(), staticToken + methodName, signature2.toString(), returnType, receiverContext.getType()));
        } else if (OCHighPriorityCreateNewDefinitionIntentionAction.isHighPrioritySymbolKind(context.getSymbolKind())) {
            this.registerQuickFix(annotation, new OCHighPriorityCreateNewDefinitionIntentionAction(context, psiElement, name));
        } else {
            this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(context, psiElement, name));
        }
    }

    @Nullable
    private Annotation highlightUnresolvedReference(String cannotResolveMessage, PsiReference reference, @Nullable Class<? extends OCInspection> inspectionClass) {
        TextRange refRange = reference.getRangeInElement();
        TextRange range = TextRange.from((int)(reference.getElement().getTextOffset() + refRange.getStartOffset()), (int)refRange.getLength());
        if (inspectionClass != null) {
            return this.addWarningAnnotation(reference.getElement(), range, inspectionClass, "CIDR", cannotResolveMessage + " '" + reference.getCanonicalText() + "'", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        return this.addErrorAnnotation(reference.getElement(), range, OCInspections.CannotResolve.class, "CIDR", cannotResolveMessage + " '" + reference.getCanonicalText() + "'", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
    }

    @Override
    public void visitClassDeclaration(OCClassDeclaration dcl) {
        PsiElement id = dcl.getNameIdentifier();
        if (id != null) {
            this.highlight(id.getTextRange(), dcl instanceof OCProtocol ? OCHighlightingKeys.PROTOCOL_REFERENCE : OCHighlightingKeys.CLASS_REFERENCE);
        }
    }

    @Nullable
    public Annotation checkNamespaceQualifierOwnerElement(OCCppNamespaceQualifier element) {
        Annotation annotation;
        OCCppNamespaceQualifier qualifier = element.getNamespaceQualifier();
        if (qualifier != null && (annotation = this.checkNamespaceQualifierOwnerElement(qualifier)) != null) {
            return annotation;
        }
        return this.checkReferences(element, "Can't resolve container", null, null, null);
    }

    @Override
    public void visitCppQualifiedPointer(OCCppQualifiedPointer pointer) {
        this.checkNamespaceQualifierOwnerElement(pointer.getNamespaceQualifier());
        super.visitCppQualifiedPointer(pointer);
    }

    @Override
    public void visitReferenceElement(OCReferenceElement referenceElement) {
        OCCppNamespaceQualifier qualifier = referenceElement.getNamespaceQualifier();
        Annotation annotation = null;
        if (qualifier != null) {
            annotation = this.checkNamespaceQualifierOwnerElement(qualifier);
        }
        if (annotation == null && (annotation = this.checkReferences(referenceElement, null, referenceElement.getSymbolContext(), null, null)) != null && referenceElement.resolveToSymbolIgnoringSymbolContext() != null) {
            annotation.setHighlightType(ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        if (annotation != null) {
            Object fix = new OCImportSymbolFix(referenceElement);
            if (!fix.isAvailable(referenceElement.getProject(), null, referenceElement.getContainingFile())) {
                fix = new OCPredeclareSymbolIntentionAction(referenceElement);
            }
            this.registerQuickFix(annotation, (IntentionAction)fix);
        }
    }

    @Override
    public void visitMacroReferenceElement(OCMacroReferenceElementImpl element) {
        this.visitReferenceElement(element);
    }

    @Override
    public void visitQualifiedDesignator(OCQualifiedDesignator designator) {
        if (designator.getNameIdentifier() != null) {
            this.checkReferences(designator, null, OCSymbolGroupContext.STRUCT_FIELD_CONTEXT, null, null);
        }
    }

    @Override
    public void visitQualifiedExpression(OCQualifiedExpression expression) {
        this.checkReferences(expression.getQualifyingElement(), "Can't resolve operator", null, null, null);
        Annotation annotation = this.checkReferences(expression, null, expression.getSymbolContext(), null, null);
        if (annotation != null) {
            OCObjectTypeContext typeContext = expression.getQualifier().getTypeContext();
            if (typeContext == null) {
                return;
            }
            OCClassSymbol symbol = typeContext.getType().getClassSymbol();
            Project project = expression.getProject();
            if (symbol != null && symbol.isPredeclaration() && (symbol = symbol.getDefinitionSymbol(project)) != null) {
                this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(expression.getNameIdentifier(), symbol));
            }
            for (OCProtocolSymbol protocol : typeContext.getType().getAllProtocols()) {
                if (!protocol.isPredeclaration() || (symbol = protocol.getDefinitionSymbol(project)) == null) continue;
                this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(expression.getNameIdentifier(), symbol));
            }
        }
    }

    @Override
    public void visitImportDirective(OCIncludeDirective directive) {
        if (directive.getText().isEmpty()) {
            return;
        }
        VirtualFile containingFile = directive.getContainingFile().getVirtualFile();
        if (containingFile == null) {
            return;
        }
        Annotation annotation = this.checkReferences(directive, "Cannot find", null, null, null);
        PsiReference[] references = directive.getReferences();
        if (annotation != null && references.length == 1) {
            String fileNameToImport = references[0].getCanonicalText();
            for (OCAutoImportHelper each : OCAutoImportHelper.EP_NAME.getExtensionList()) {
                for (IntentionAction eachAction : each.getAddHeaderSearchPathFixes(directive.getProject(), containingFile, fileNameToImport)) {
                    this.registerQuickFix(annotation, eachAction);
                }
            }
        }
    }

    @Override
    public void visitSelectorExpression(OCSelectorExpression stmt) {
        OCSymbolContext context;
        String message;
        Annotation annotation;
        OCObjectType type;
        String selector;
        OCSendMessageExpression sendMessageExpression;
        if (stmt.getParent() instanceof OCMessageArgument && (sendMessageExpression = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)stmt, OCSendMessageExpression.class)) != null && ("respondsToSelector:".equals(selector = sendMessageExpression.getMessageSelector()) || "instancesRespondToSelector:".equals(selector))) {
            return;
        }
        OCClassDeclaration classDeclaration = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)stmt, OCClassDeclaration.class);
        OCClassSymbol parent = classDeclaration != null ? classDeclaration.getSymbol() : null;
        OCObjectTypeContext targetContext = OCSelectorAdHocResolver.getActionTargetContext(stmt);
        OCObjectType oCObjectType = type = targetContext != null ? targetContext.getType() : null;
        if (!(type == null || parent != null && parent.getName().equals(type.getClassSymbol().getName()))) {
            parent = type.getClassSymbol();
        }
        if ((annotation = this.checkReferences(stmt, message = type != null ? "Type '" + type.getName(stmt) + "' doesn't have the method" : "Cannot find the method", new OCSymbolGroupContext(context = new OCSymbolContext(null, OCSymbolKind.METHOD, parent)), null, OCInspections.UnresolvedMessage.class)) != null) {
            ArrayList<String> selectors = new ArrayList<String>();
            ArrayList<OCExpression> expressions = new ArrayList<OCExpression>();
            ArrayList<OCType> argumentTypes = new ArrayList<OCType>();
            String selector2 = stmt.getSelector();
            int pos = selector2.indexOf(58);
            if (pos != -1) {
                int prevPos = 0;
                while (pos != -1) {
                    selectors.add(selector2.substring(prevPos, pos + 1));
                    expressions.add(null);
                    argumentTypes.add(null);
                    prevPos = pos + 1;
                    pos = selector2.indexOf(58, prevPos);
                }
            } else {
                selectors.add(selector2);
                expressions.add(null);
            }
            OCMethodSymbol similarResponder = OCObjectTypeContext.findSimilarResponder(type, selectors, argumentTypes, stmt);
            if (similarResponder != null) {
                for (int i2 = 0; i2 < argumentTypes.size(); ++i2) {
                    argumentTypes.set(i2, OCIdType.pointerToID());
                }
                this.registerQuickFix(annotation, new OCChangeMethodSignatureIntentionAction(similarResponder, argumentTypes, selectors, expressions, OCCompilationContext.create(stmt)));
            }
            this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(stmt, context.getParent(), "-" + selector2, stmt.getExpectedMethodSignature(), stmt.getExpectedReturnType(), type));
        }
    }

    @Override
    public void visitLiteralExpression(OCLiteralExpression expression) {
        OCClassSymbol receiverClass = null;
        String referencedName = null;
        String message = null;
        Class inspectionClass = null;
        IntentionAction quickFix = null;
        for (PsiReference ref : expression.getReferences()) {
            while (ref instanceof OCCompositeResourceReference) {
                ref = ((OCCompositeResourceReference)ref).getRepresentative();
            }
            boolean processed = false;
            for (OCAnnotatorHelper each : OCAnnotator.getAnnotatorHelpers()) {
                Ref referencedNameRef;
                Ref inspectionClassRef = Ref.create();
                Ref quickFixRef = Ref.create();
                Ref receiverClassRef = Ref.create();
                Ref messageRef = Ref.create();
                if (!each.customizeResolveErrorForReference(ref, (Ref<Class<? extends OCInspection>>)inspectionClassRef, (Ref<IntentionAction>)quickFixRef, (Ref<String>)messageRef, (Ref<OCClassSymbol>)receiverClassRef, (Ref<String>)(referencedNameRef = Ref.create()))) continue;
                inspectionClass = (Class)inspectionClassRef.get();
                quickFix = (IntentionAction)quickFixRef.get();
                message = (String)messageRef.get();
                receiverClass = (OCClassSymbol)receiverClassRef.get();
                referencedName = (String)referencedNameRef.get();
                processed = true;
                break;
            }
            if (processed || !(ref instanceof OCFileResourceReference)) continue;
            inspectionClass = OCInspections.ResourceNotFoundInspection.class;
            message = "Can't find the resource";
        }
        OCSymbolContext context = receiverClass != null ? new OCSymbolContext(new OCExpectedTypeUtil.Expectable(){

            @Override
            public OCType getExpectedType() {
                return OCIdType.pointerToID();
            }
        }, OCSymbolKind.PROPERTY, receiverClass) : null;
        Annotation annotation = this.checkReferences(expression, message, context != null ? new OCSymbolGroupContext(context) : null, referencedName, inspectionClass);
        if (annotation != null && quickFix != null) {
            this.registerQuickFix(annotation, quickFix);
        }
    }

    @Override
    public void visitDirective(OCDirective directive) {
        IElementType directiveType = directive.getHeaderToken().getNode().getElementType();
        if (directiveType == OCTokenTypes.UNKNOWN_DIRECTIVE) {
            Annotation annotation = this.addErrorAnnotation(directive, "CIDR", "Unknown preprocessor directive '" + directive.getHeaderToken().getText() + "'");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)directive, OCInspectionsBundle.message("intention.family.name.remove.directive", new Object[0])));
        }
    }

    @Override
    public void visitStructLike(OCStructLike struct) {
        OCStructSymbol symbol = (OCStructSymbol)struct.getSymbol();
        if (symbol != null) {
            this.highlight(struct.getNameIdentifier(), OCResolveAnnotator.getTextAttributesKeyByKind(symbol.getKind(), false));
        }
    }

    @Override
    public void visitMacroParameter(OCMacroParameterImpl parameter) {
        this.highlight(parameter, OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.MACRO_PARAMETER, false));
    }

    @Override
    public void visitDeclarator(OCDeclarator declarator) {
        PsiElement nameIdentifier = declarator.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)declarator, (Class[])new Class[]{OCInstanceVariablesList.class, OCEnum.class, OCProperty.class});
        if (parent != null) {
            if (parent instanceof OCInstanceVariablesList) {
                this.highlight(nameIdentifier, OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.INSTANCE_VARIABLE, true));
            } else if (parent instanceof OCEnum) {
                this.highlight(nameIdentifier, OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.ENUM_CONST, true));
            } else if (parent instanceof OCProperty) {
                this.highlight(nameIdentifier, OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.PROPERTY, true));
            }
        } else {
            OCSymbol symbol = declarator.getSymbol();
            OCCppNamespaceQualifier qualifier = declarator.getNamespaceQualifier();
            if (symbol != null) {
                this.highlight(nameIdentifier, OCResolveAnnotator.getTextAttributesKeyByKind(symbol.getKind(), true));
            }
            if (qualifier != null) {
                Annotation namespaceAnnotation = this.checkNamespaceQualifierOwnerElement(qualifier);
                if (namespaceAnnotation != null) {
                    OCSymbolReference.LocalReference symbolRef = OCSymbolReference.getLocalReference(OCSymbolReferenceResolver.getQualifiedName(declarator), (PsiElement)declarator);
                    OCResolveContext context = OCResolveContext.forPsi(declarator);
                    context.setProcessNonImported(true);
                    List<OCSymbol> symbols = context.resolveToSymbols(symbolRef, true, false);
                    for (OCSymbol s : symbols) {
                        OCImportSymbolFix fix = new OCImportSymbolFix(declarator, s);
                        if (!fix.isAvailable(qualifier.getProject(), null, qualifier.getContainingOCFile())) continue;
                        this.registerQuickFix(namespaceAnnotation, (IntentionAction)fix);
                        break;
                    }
                } else if (symbol instanceof OCSymbolWithQualifiedName) {
                    OCFile file = declarator.getContainingOCFile();
                    OCTypeElement typeElement = ((OCDeclaration)declarator.getParent()).getTypeElement();
                    boolean isOldAccessDeclaration = symbol instanceof OCDeclaratorSymbol && typeElement != null && typeElement.isEmpty();
                    OCSymbol predeclarationInParent = qualifier.getPredeclarationInParent((OCSymbolWithQualifiedName)symbol, !isOldAccessDeclaration);
                    if (predeclarationInParent == null && symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> !(symbol1 instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol1).isFriend()), declarator.getProject())) {
                        OCSymbol parentSymbol = OCReferenceElementImpl.getAppropriateToAppendSymbol(qualifier, OCResolveContext.forPsi(qualifier));
                        if (parentSymbol != null) {
                            OCResolveContext context = OCResolveContext.forPsi(declarator);
                            String message = OCInspectionsBundle.message("inspection.message.was.not.declared.in", symbol.getNameWithKindUppercase(context), parentSymbol.getNameWithKindLowercase(OCCompilationContext.create(declarator)));
                            Annotation annotation = this.addErrorAnnotation(declarator.getNameIdentifier(), OCInspections.CannotResolve.class, "err_member_decl_does_not_match", message, ProblemHighlightType.GENERIC_ERROR);
                            OCSymbolKind kind = ((OCSymbolWithQualifiedName)symbol).getResolvedKind(context);
                            boolean staticMember = kind == OCSymbolKind.STRUCT_FIELD;
                            OCCreateNewDefinitionIntentionAction fix = new OCCreateNewDefinitionIntentionAction(kind, declarator, null, parentSymbol, declarator.getName(), symbol.getResolvedType(context), staticMember);
                            fix.setSilentMode(true);
                            this.registerQuickFix(annotation, fix);
                        }
                    } else if (predeclarationInParent instanceof OCSymbolWithParent) {
                        OCFileSymbols.markSymbolAsUsed(file, ((OCSymbolWithParent)predeclarationInParent).getParent(), declarator);
                    }
                }
            }
        }
    }

    @Override
    public void visitTypeParameterDeclaration(OCTypeParameterDeclaration declaration) {
        this.highlight(declaration.getNameIdentifier(), OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.TEMPLATE_TYPE_PARAMETER, false));
        super.visitTypeParameterDeclaration(declaration);
    }

    @Override
    public void visitNamespace(OCCppNamespace declaration) {
        this.highlight(declaration.getNameIdentifier(), OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.NAMESPACE, false));
        super.visitNamespace(declaration);
    }

    @Override
    public void visitNamespaceAlias(OCCppNamespaceAlias declaration) {
        this.highlight(declaration.getNameIdentifier(), OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.NAMESPACE_ALIAS, false));
        super.visitNamespaceAlias(declaration);
    }

    @Override
    public void visitUsingStatement(OCCppUsingStatement usingStatement) {
        this.highlight(usingStatement.getNameIdentifier(), OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.USING_SYMBOL_ALIAS, false));
        super.visitUsingStatement(usingStatement);
    }

    @Override
    public void visitMethodSelectorPart(OCMethodSelectorPart part) {
        this.highlight(part.getSelectorIdentifier(), OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.METHOD, true));
        this.highlight(part.getParameter(), OCResolveAnnotator.getTextAttributesKeyByKind(OCSymbolKind.PARAMETER, true));
        super.visitMethodSelectorPart(part);
    }

    @Override
    public void visitArgumentSelector(OCArgumentSelector selector) {
        if (selector.getTextRange().getLength() > 0 && this.getHolder() != null) {
            this.getHolder().newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(OCHighlightingKeys.METHOD_CALL).create();
        }
    }

    @Override
    public void visitPropertyAttribute(OCPropertyAttribute attribute) {
        this.highlight(attribute, OCHighlightingKeys.PROPERTY_ATTRIBUTE);
    }

    @Override
    public void visitExpression(OCExpression expression) {
        this.checkReferences(expression, "Can't resolve operator", null, null, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression) {
        void var6_14;
        ArrayList<Object> quickFixes;
        ProblemHighlightType highlightType;
        boolean isError;
        boolean isInfo;
        String clangID;
        Object message;
        block23: {
            OCExpression oCExpression;
            Iterator<OCMessageArgument> iterator;
            ArrayList<OCType> argumentTypes;
            ArrayList<OCExpression> expressions;
            ArrayList<String> selectors;
            OCType returnExpectedType;
            OCResolveContext context;
            OCObjectType receiverType;
            String selector;
            block21: {
                OCMethodSymbol firstResponder;
                block26: {
                    block25: {
                        block24: {
                            block22: {
                                if (expression.getArguments().size() == 0) {
                                    return;
                                }
                                OCSendMessageExpression.ProbableResponders responders = expression.getProbableResponders();
                                selector = expression.getMessageSelector();
                                receiverType = responders.getReceiverType();
                                OCClassSymbol clazz = receiverType != null ? receiverType.getClassSymbol() : null;
                                Object var6_6 = null;
                                message = null;
                                clangID = null;
                                isInfo = false;
                                isError = false;
                                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                                quickFixes = new ArrayList<Object>();
                                context = OCResolveContext.forPsi(expression);
                                if (responders.getAllResponders().isEmpty()) {
                                    if (receiverType != null) {
                                        OCExpression receiver;
                                        message = "Cannot resolve method '" + selector + "'" + (String)(clazz != null ? " for " + clazz.getNameWithKindLowercase(OCCompilationContext.create(clazz, expression.getProject())) : "");
                                        Class<OCInspections.UnresolvedMessage> clazz2 = OCInspections.UnresolvedMessage.class;
                                        clangID = "CIDR";
                                        isError = true;
                                        returnExpectedType = OCExpectedTypeUtil.getExpectedType(expression, true, context);
                                        if (returnExpectedType == OCUnknownType.INSTANCE) {
                                            returnExpectedType = OCVoidType.instance();
                                        }
                                        if ((receiver = expression.getReceiverExpression()) instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() != null) {
                                            OCClassDeclaration classDeclaration = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)expression, OCClassDeclaration.class);
                                            OCClassSymbol oCClassSymbol = classDeclaration != null ? classDeclaration.getSymbol() : null;
                                        } else {
                                            OCInterfaceSymbol oCInterfaceSymbol = receiverType.getInterface();
                                        }
                                        String signature2 = expression.getExpectedMethodSignature(context);
                                        if (signature2 != null) {
                                            void var16_29;
                                            quickFixes.add(new OCCreateNewDefinitionIntentionAction(expression, (OCSymbol)var16_29, signature2.charAt(0) + expression.getMessageSelector(), signature2, returnExpectedType.resolve(expression), receiverType));
                                        }
                                        selectors = new ArrayList<String>();
                                        expressions = new ArrayList<OCExpression>();
                                        argumentTypes = new ArrayList<OCType>();
                                        iterator = expression.getArguments().iterator();
                                        break block21;
                                    } else {
                                        OCExpression receiverExpression = expression.getReceiverExpression();
                                        OCType type = receiverExpression != null ? receiverExpression.getResolvedType() : null;
                                        if (type == null) return;
                                        if (type.getTerminalType().isUnknown()) return;
                                        message = "Can't send messages to expressions of type '" + type.getName(receiverExpression) + "'";
                                        if (!type.isPointerCompatible(OCResolveContext.forPsi(expression))) {
                                            this.addErrorAnnotation(receiverExpression, "err_bad_receiver_type", (String)message);
                                            return;
                                        }
                                        if (OCCompilerFeaturesHelper.isArcEnabled(receiverExpression.getContainingFile())) {
                                            this.addErrorAnnotation(receiverExpression, "err_bad_receiver_type", (String)message);
                                            return;
                                        }
                                        this.addWarningAnnotation(receiverExpression, OCInspections.IncompatiblePointers.class, "warn_bad_receiver_type", (String)message);
                                        return;
                                    }
                                }
                                List<OCMethodSymbol> filteredResponders = responders.getFilteredByStaticnessResponders();
                                OCMethodSymbol oCMethodSymbol = firstResponder = filteredResponders.isEmpty() ? null : filteredResponders.get(0);
                                if (OCResolveAnnotator.haveSingleRoot(filteredResponders, expression.getProject())) break block22;
                                message = "Message '" + selector + "' can be resolved to several methods";
                                Class<OCInspections.SeveralTargetsMessage> clazz3 = OCInspections.SeveralTargetsMessage.class;
                                clangID = "CIDR";
                                isInfo = true;
                                break block23;
                            }
                            if (firstResponder == null || !firstResponder.isForbiddenByARC(expression)) break block24;
                            Annotation annotation = this.addErrorAnnotation(expression, OCInspections.ARCIssues.class, "CIDR", "Explicit usage of '" + selector + "' is forbidden in ARC");
                            this.registerQuickFix(annotation, new OCMigrateToARCIntentionAction(expression));
                            this.registerQuickFix(annotation, new OCMigrateToARCIntentionAction(expression.getContainingOCFile()));
                            break block23;
                        }
                        if (firstResponder == null || !firstResponder.isUnavailable()) break block25;
                        message = firstResponder.getUnavailableMessage(context);
                        Class<OCInspections.DeprecatedApi> clazz = OCInspections.DeprecatedApi.class;
                        clangID = "CIDR";
                        isError = true;
                        break block23;
                    }
                    if (firstResponder == null || !firstResponder.isDeprecated()) break block26;
                    message = firstResponder.getDeprecatedMessage(context);
                    Class<OCInspections.DeprecatedApi> clazz = OCInspections.DeprecatedApi.class;
                    clangID = "warn_deprecated";
                    highlightType = ProblemHighlightType.LIKE_DEPRECATED;
                    break block23;
                }
                if (firstResponder != null) {
                    void var6_12;
                    message = OCResolveUtil.checkAvailability(firstResponder, expression);
                    if (message != null) {
                        Class<OCInspections.UnavailableInDeploymentTarget> clazz = OCInspections.UnavailableInDeploymentTarget.class;
                        clangID = "CIDR";
                        highlightType = ProblemHighlightType.LIKE_DEPRECATED;
                    }
                    if (var6_12 == null && !OCResolveUtil.isEarlierInCode((OCSymbol)firstResponder, expression)) {
                        OCClassSymbol curClass;
                        OCClassDeclaration oCClassDeclaration = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)expression, OCClassDeclaration.class);
                        OCClassSymbol oCClassSymbol = curClass = oCClassDeclaration != null ? oCClassDeclaration.getSymbol() : null;
                        if (!Comparing.equal((Object)curClass, (Object)firstResponder.getParent())) {
                            message = "Method '" + selector + "' is declared in another category/implementation later in the scope";
                        } else if (!OCCompilerFeaturesHelper.supportsLaterMethodDeclaration()) {
                            message = "Method '" + selector + "' is declared later in the scope";
                            quickFixes.add(new OCMoveDefinitionIntentionAction(OCSymbolKind.METHOD, expression, null, firstResponder, " above"));
                            quickFixes.add(new OCDeclareSpecificMethodInPrivateCategoryAction(firstResponder.getParent(), firstResponder));
                        }
                        Class<OCInspections.MethodIsLaterInTheScope> clazz = OCInspections.MethodIsLaterInTheScope.class;
                        quickFixes.add(new OCDeclareMethodInInterfaceAction(firstResponder));
                    }
                }
                break block23;
            }
            while (iterator.hasNext()) {
                OCMessageArgument argument = iterator.next();
                selectors.add(argument.getArgumentSelector().getSelectorName());
                OCExpression oCExpression2 = argument.getArgumentExpression();
                expressions.add(oCExpression2);
                argumentTypes.add(oCExpression2 != null ? OCExpectedTypeUtil.getExpressionType(oCExpression2, true) : null);
            }
            OCMethodSymbol similarResponder = OCObjectTypeContext.findSimilarResponder(receiverType, selectors, argumentTypes, expression);
            if (similarResponder != null) {
                quickFixes.add(new OCChangeMethodSignatureIntentionAction(similarResponder, argumentTypes, selectors, expressions, context));
            }
            OCObjectTypeContext receiverContext = expression.getReceiverContext();
            if (OCNameSuggester.isObjCGetter(selector) && (receiverContext == null || receiverContext.getStaticMode() != OCObjectTypeContext.StaticMode.STATIC)) {
                OCType oCType = returnExpectedType.isVoid() ? OCIdType.pointerToID() : returnExpectedType;
                quickFixes.add(new OCCreateNewDefinitionIntentionAction(OCSymbolKind.PROPERTY, expression, receiverType.getInterface(), selector, oCType));
            }
            if (OCNameSuggester.isObjCSetter(selector) && OCElementUtil.startsWithWord(selector, "set") && expression.getArguments().size() == 1 && (oCExpression = expression.getArguments().get(0).getArgumentExpression()) != null) {
                String name = OCNameSuggester.getObjCGetterFromSetter(selector);
                quickFixes.add(new OCCreateNewDefinitionIntentionAction(OCSymbolKind.PROPERTY, expression, receiverType.getInterface(), name, oCExpression.getResolvedType()));
            }
        }
        if (message == null) return;
        Annotation annotation = isError ? this.addErrorAnnotation(expression, (Class)var6_14, clangID, (String)message) : this.addWarningAnnotation(expression, (Class<? extends OCInspection>)var6_14, clangID, (String)message, isInfo ? ProblemHighlightType.WEAK_WARNING : highlightType);
        Iterator iterator = quickFixes.iterator();
        while (iterator.hasNext()) {
            IntentionAction intentionAction = (IntentionAction)iterator.next();
            this.registerQuickFix(annotation, intentionAction);
        }
    }

    @Override
    public void visitGenericParameter(OCGenericParameter parameter) {
        this.highlight(parameter.getNameIdentifier(), OCHighlightingKeys.GENERIC_PARAMETER);
    }

    private static boolean haveSingleRoot(List<OCMethodSymbol> methods, @NotNull Project project) {
        if (project == null) {
            OCResolveAnnotator.$$$reportNull$$$0(2);
        }
        if (methods.size() <= 1) {
            return true;
        }
        HashSet<OCMethodSymbol> set = new HashSet<OCMethodSymbol>(methods);
        OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(methods.get(0), project);
        parameters.setInheritors(true);
        parameters.setAncestors(true);
        parameters.setIncludeSelfImplementation(true);
        OCMemberInheritorsSearch.search(parameters).forEach(method -> {
            set.remove(method);
            return true;
        });
        return set.isEmpty();
    }

    @Nullable
    private static TextAttributesKey getTextAttributesKeyByKind(@NotNull OCSymbolKind kind, boolean idInDeclarator) {
        if (kind == null) {
            OCResolveAnnotator.$$$reportNull$$$0(3);
        }
        switch (kind) {
            case LOCAL_VARIABLE: {
                return OCHighlightingKeys.LOCAL_VARIABLE;
            }
            case PARAMETER: {
                return OCHighlightingKeys.PARAMETER;
            }
            case INTERFACE: 
            case IMPLEMENTATION: 
            case COMPATIBILITY_ALIAS: {
                return OCHighlightingKeys.CLASS_REFERENCE;
            }
            case PROTOCOL: {
                return OCHighlightingKeys.PROTOCOL_REFERENCE;
            }
            case INSTANCE_VARIABLE: {
                return OCHighlightingKeys.INSTANCE_VARIABLE;
            }
            case PROPERTY: {
                return OCHighlightingKeys.PROPERTY;
            }
            case METHOD: {
                return idInDeclarator ? OCHighlightingKeys.METHOD_DECLARATION : OCHighlightingKeys.METHOD_CALL;
            }
            case CATCH_EXCEPTION_VARIABLE: {
                break;
            }
            case TYPEDEF: 
            case USING_SYMBOL_ALIAS: {
                return OCHighlightingKeys.TYPEDEF;
            }
            case FUNCTION_PREDECLARATION: 
            case FUNCTION_DECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: 
            case CPP_CONSTRUCTOR_DECLARATION: {
                return idInDeclarator ? OCHighlightingKeys.FUNCTION_DECLARATION : OCHighlightingKeys.FUNCTION_CALL;
            }
            case TEMPLATE_TYPE_PARAMETER: {
                return OCHighlightingKeys.TEMPLATE_TYPE;
            }
            case TEMPLATE_VALUE_PARAMETER: {
                return OCHighlightingKeys.TEMPLATE_VALUE;
            }
            case NAMESPACE: 
            case NAMESPACE_ALIAS: {
                return OCHighlightingKeys.NAMESPACE_LIKE;
            }
            case MACRO: 
            case UNDEF_MACRO: {
                return OCHighlightingKeys.MACRONAME;
            }
            case MACRO_PARAMETER: {
                return OCHighlightingKeys.MACRO_PARAMETER;
            }
            case STRUCT: 
            case UNION: 
            case ENUM: {
                return OCHighlightingKeys.STRUCT_LIKE;
            }
            case CPP_CONCEPT: {
                return OCHighlightingKeys.CONCEPT;
            }
            case CPP_DEDUCTION_GUIDE: {
                return OCHighlightingKeys.DEDUCTION_GUIDE;
            }
            case ENUM_CONST: {
                return OCHighlightingKeys.ENUM_CONST;
            }
            case STRUCT_FIELD: {
                return OCHighlightingKeys.STRUCT_FIELD;
            }
            case GLOBAL_VARIABLE: 
            case GLOBAL_VARIABLE_PREDECLARATION: {
                return OCHighlightingKeys.GLOBAL_VARIABLE;
            }
            case BUILTIN_SYMBOL: {
                break;
            }
            case SYNTHESIZE: {
                return OCHighlightingKeys.PROPERTY;
            }
            case BLOCK: {
                break;
            }
            case LABEL: {
                return OCHighlightingKeys.LABEL;
            }
            case GENERIC_PARAMETER: {
                return OCHighlightingKeys.GENERIC_PARAMETER;
            }
        }
        return null;
    }

    protected void highlight(@NotNull PsiReference reference, @Nullable TextAttributesKey key) {
        if (reference == null) {
            OCResolveAnnotator.$$$reportNull$$$0(4);
        }
        PsiElement psiElement = reference.getElement();
        int offset = psiElement.getTextRange().getStartOffset();
        if (reference instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)reference).getRanges()) {
                this.highlight(range.shiftRight(offset), key);
            }
        } else {
            this.highlight(reference.getRangeInElement().shiftRight(offset), key);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/legacy/daemon/OCResolveAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReferences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "haveSingleRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextAttributesKeyByKind";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "highlight";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

