/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.OCExternalInspections;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.intentions.OCConvertIfToTernaryIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCEmptyStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSimplifyInspectionLegacy
extends OCInspections.GeneralCpp {
    private static Key<Map<PsiElement, Pair<PsiElement, Simplifier>>> SIMPLIFIABLE_ELEMENTS = Key.create((String)"SIMPLIFIABLE_ELEMENTS");
    public boolean enableSimplifyEqualToYesNo = true;
    public boolean enableSimplifyIfWithConstantBranch = false;
    private static Set<String> GOOD_MACROS = Set.of("YES", "NO", "true", "false", "TRUE", "FALSE");

    @Override
    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        CheckBox checkBox1 = new CheckBox(OCInspectionsBundle.message("inspection.simplify.condition", new Object[0]), (InspectionProfileEntry)this, "enableSimplifyEqualToYesNo");
        CheckBox checkBox2 = new CheckBox(OCInspectionsBundle.message("inspection.simplify.ternary", new Object[0]), (InspectionProfileEntry)this, "enableSimplifyIfWithConstantBranch");
        panel2.add((Component)checkBox1);
        panel2.add((Component)checkBox2);
        return panel2;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = OCInspectionsBundle.message("inspection.simplifiable.statement", new Object[0]);
        if (string == null) {
            OCSimplifyInspectionLegacy.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public static String getInspectionShortName(@NotNull Class<? extends OCInspection> inspectionClass) {
        if (inspectionClass == null) {
            OCSimplifyInspectionLegacy.$$$reportNull$$$0(1);
        }
        try {
            return inspectionClass.newInstance().getShortName();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            OCSimplifyInspectionLegacy.$$$reportNull$$$0(2);
        }
        if (session == null) {
            OCSimplifyInspectionLegacy.$$$reportNull$$$0(3);
        }
        final HashMap map = new HashMap();
        session.putUserData(SIMPLIFIABLE_ELEMENTS, map);
        for (OCExternalInspections externalInspections : OCExternalInspections.EP_NAME.getExtensionList()) {
            if (!externalInspections.hasSimplifyInspection(holder.getFile())) continue;
            return new PsiElementVisitor(){};
        }
        return new SimplifyVisitor(){

            @Override
            protected void simplify(@NotNull PsiElement element, PsiElement simplified, Simplifier simplifier) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (simplified != null) {
                    map.put(element, Pair.create((Object)simplified, (Object)simplifier));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/legacy/inspections/OCSimplifyInspectionLegacy$2", "simplify"));
            }
        };
    }

    public static void simplify(PsiElement element) {
        element.accept((PsiElementVisitor)new SimplifyVisitor(){

            @Override
            protected void simplify(@NotNull PsiElement element, @Nullable PsiElement simplified, Simplifier simplifier) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (simplified != null && OCSimplifyInspectionLegacy.isSafeToSimplify(element, simplified)) {
                    IntentionAction fix = OCSimplifyInspectionLegacy.getSimplifyFix(element, simplified);
                    if (fix.startInWriteAction()) {
                        ApplicationManager.getApplication().runWriteAction(() -> fix.invoke(element.getProject(), null, element.getContainingFile()));
                    } else {
                        fix.invoke(element.getProject(), null, element.getContainingFile());
                    }
                } else {
                    this.visitElement(element);
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(1);
                }
                for (PsiElement child : element.getChildren()) {
                    child.accept((PsiElementVisitor)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "element";
                objectArray2[1] = "com/jetbrains/cidr/lang/legacy/inspections/OCSimplifyInspectionLegacy$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "simplify";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        if (session == null) {
            OCSimplifyInspectionLegacy.$$$reportNull$$$0(4);
        }
        if (problemsHolder == null) {
            OCSimplifyInspectionLegacy.$$$reportNull$$$0(5);
        }
        Map map = (Map)session.getUserData(SIMPLIFIABLE_ELEMENTS);
        assert (map != null);
        block0: for (PsiElement element : map.keySet()) {
            IntentionAction[] fixes;
            IntentionAction[] intentionActionArray;
            if (OCElementUtil.isPartOfMacroSubstitution(element)) continue;
            for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
                Pair parentInspection = (Pair)map.get(parent);
                if (parentInspection != null && !((Simplifier)parentInspection.getSecond()).isWarningDisabled(this)) continue block0;
            }
            Pair pair = (Pair)map.get(element);
            PsiElement simplified = (PsiElement)pair.getFirst();
            OCCondition warningElement = element instanceof OCIfStatement ? ((OCIfStatement)element).getCondition() : (element instanceof OCLoopStatement ? ((OCLoopStatement)element).getCondition() : element);
            String message = OCSimplifyInspectionLegacy.getSimplifyMessage(element, simplified);
            if (OCSimplifyInspectionLegacy.isSafeToSimplify(element, simplified)) {
                IntentionAction[] intentionActionArray2 = new IntentionAction[1];
                intentionActionArray = intentionActionArray2;
                intentionActionArray2[0] = OCSimplifyInspectionLegacy.getSimplifyFix(element, simplified);
            } else {
                intentionActionArray = fixes = IntentionAction.EMPTY_ARRAY;
            }
            if (((Simplifier)pair.getSecond()).isWarningDisabled(this)) continue;
            this.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), warningElement, message, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
        }
    }

    @InspectionMessage
    public static String getSimplifyMessage(PsiElement element, PsiElement simplified) {
        if (element instanceof OCIfStatement) {
            OCStatement thenBranch = ((OCIfStatement)element).getThenBranch();
            OCStatement elseBranch = ((OCIfStatement)element).getElseBranch();
            if (simplified == thenBranch) {
                return thenBranch != null && elseBranch != null && OCElementUtil.areElementsEquivalent(thenBranch, elseBranch, false, OCResolveContext.forPsi(element)) ? OCInspectionsBundle.message("inspection.message.if.statement.has.identical.branches", new Object[0]) : OCInspectionsBundle.message("inspection.message.condition.always.true", new Object[0]);
            }
            if (simplified == elseBranch || simplified instanceof OCEmptyStatement) {
                return OCInspectionsBundle.message("inspection.message.condition.always.false", new Object[0]);
            }
            return OCInspectionsBundle.message("inspection.message.statement.can.be.simplified", new Object[0]);
        }
        if (element instanceof OCLoopStatement) {
            return OCInspectionsBundle.message("inspection.message.condition.always.false", new Object[0]);
        }
        return OCInspectionsBundle.message("inspection.message.expression.can.be.simplified.to", OCElementUtil.getTextWithMacros(simplified));
    }

    public static boolean isSafeToSimplify(@NotNull PsiElement element, @NotNull PsiElement simplified) {
        if (element == null) {
            OCSimplifyInspectionLegacy.$$$reportNull$$$0(6);
        }
        if (simplified == null) {
            OCSimplifyInspectionLegacy.$$$reportNull$$$0(7);
        }
        if (element instanceof OCDoWhileStatement) {
            Collection statements = PsiTreeUtil.findChildrenOfAnyType((PsiElement)simplified, (Class[])new Class[]{OCBreakStatement.class, OCContinueStatement.class});
            for (OCStatement statement : statements) {
                PsiElement parentElement = statement instanceof OCBreakStatement ? PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{OCSwitchStatement.class, OCLoopStatement.class}) : PsiTreeUtil.getParentOfType((PsiElement)statement, OCLoopStatement.class);
                if (parentElement != element) continue;
                return false;
            }
        }
        return true;
    }

    public static IntentionAction getSimplifyFix(PsiElement element, @NotNull PsiElement simplified) {
        if (simplified == null) {
            OCSimplifyInspectionLegacy.$$$reportNull$$$0(8);
        }
        String subject = OCSimplifyInspectionLegacy.getStatementName(element);
        if (element instanceof OCStatement && element.getParent() instanceof OCBlockStatement && simplified instanceof OCBlockStatement) {
            return new OCChangeElementIntentionAction(element, ((OCBlockStatement)simplified).getStatements(), OCInspectionsBundle.message("intention.family.name.simplify", subject));
        }
        if (simplified instanceof OCEmptyStatement) {
            return new OCRemoveElementsIntentionAction(element, OCInspectionsBundle.message("intention.family.name.remove", subject));
        }
        if (simplified instanceof OCExpression && element instanceof OCIfStatement) {
            return new IfToTernary(subject, element, simplified);
        }
        if (element instanceof OCExpression) {
            element = OCParenthesesUtils.topmostParenthesized((OCExpression)element);
        }
        return new OCChangeElementIntentionAction(element, simplified, OCInspectionsBundle.message("intention.family.name.simplify.choice", subject, element instanceof OCExpression ? 0 : 1));
    }

    private static String getStatementName(PsiElement element) {
        if (element instanceof OCIfStatement) {
            return "'if' statement";
        }
        if (element instanceof OCWhileStatement) {
            return "'while' statement";
        }
        if (element instanceof OCDoWhileStatement) {
            return "'do-while' statement";
        }
        if (element instanceof OCForStatement) {
            return "'for' statement";
        }
        return "statement";
    }

    @Nullable
    public static OCStatement simplifyStatementWithConstCondition(boolean conditionValue, @NotNull OCStatement statement) {
        if (statement == null) {
            OCSimplifyInspectionLegacy.$$$reportNull$$$0(9);
        }
        if (statement instanceof OCIfStatement) {
            OCStatement thenBranch = ((OCIfStatement)statement).getThenBranch();
            OCStatement elseBranch = ((OCIfStatement)statement).getElseBranch();
            return conditionValue ? thenBranch : (elseBranch != null ? elseBranch : OCSimplifyInspectionLegacy.createEmptyStatement(statement));
        }
        if (statement instanceof OCWhileStatement) {
            return conditionValue ? null : OCSimplifyInspectionLegacy.createEmptyStatement(statement);
        }
        if (statement instanceof OCDoWhileStatement) {
            return conditionValue ? null : ((OCDoWhileStatement)statement).getBody();
        }
        if (statement instanceof OCForStatement) {
            OCStatement initializer = ((OCForStatement)statement).getInitializer();
            return conditionValue ? null : (initializer != null ? initializer : OCSimplifyInspectionLegacy.createEmptyStatement(statement));
        }
        throw new UnsupportedOperationException(statement.getClass().getCanonicalName());
    }

    @Nullable
    public static OCExpression simplifyLogicExpression(boolean conditionValue, @NotNull OCBinaryExpression expression, PsiElement element) {
        OCExpression otherOperand;
        if (expression == null) {
            OCSimplifyInspectionLegacy.$$$reportNull$$$0(10);
        }
        OCElementType sign = expression.getOperationSign();
        if (PsiTreeUtil.isAncestor((PsiElement)expression.getLeft(), (PsiElement)element, (boolean)false)) {
            otherOperand = expression.getRight();
        } else if (PsiTreeUtil.isAncestor((PsiElement)expression.getRight(), (PsiElement)element, (boolean)false)) {
            otherOperand = expression.getLeft();
        } else {
            return null;
        }
        return Simplifier.trySimplifyLogicExpression(conditionValue, expression.getLeft(), otherOperand, sign, OCResolveContext.forPsi(expression));
    }

    private static OCStatement createEmptyStatement(PsiElement context) {
        return OCElementFactory.statementFromText(";", context);
    }

    @Nullable
    private static OCExpression simplify(@Nullable OCExpression expression) {
        OCExpression simplified = null;
        if (expression == null || OCCodeInsightUtil.isOverloadedOperatorUsage(expression)) {
            return expression;
        }
        if (expression instanceof OCConditionalExpression) {
            OCConditionalExpression condExpr = (OCConditionalExpression)expression;
            simplified = new Simplifier().trySimplifyCondExpr(condExpr.getCondition(), condExpr.getPositiveExpression(true), condExpr.getNegativeExpression());
        } else if (expression instanceof OCBinaryExpression) {
            OCBinaryExpression binaryExpr = (OCBinaryExpression)expression;
            simplified = new Simplifier().trySimplifyBinaryExpr(binaryExpr);
        } else if (expression instanceof OCUnaryExpression) {
            OCUnaryExpression unaryExpression = (OCUnaryExpression)expression;
            simplified = Simplifier.trySimplifyUnaryExpr(unaryExpression);
        } else if (expression instanceof OCParenthesizedExpression && !OCElementUtil.isPartOfMacroSubstitution(expression)) {
            simplified = OCSimplifyInspectionLegacy.simplify(((OCParenthesizedExpression)expression).getOperand());
        }
        return simplified != null ? simplified : expression;
    }

    private static boolean hasMacros(PsiElement element) {
        for (PsiElement child : element.getChildren()) {
            if ((!(child instanceof OCMacroCall) || GOOD_MACROS.contains(((OCMacroCall)child).getTextWithMacros())) && !OCSimplifyInspectionLegacy.hasMacros(child)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static <T> T nullIfHasMacros(T value, PsiElement element) {
        OCMacroRange range;
        if (OCElementUtil.isPartOfMacroSubstitution(element) && (range = OCElementUtil.getRangeInMacroCall(element)) != null && range.getMacroCall() != null && !GOOD_MACROS.contains(range.getMacroCall().getTextWithMacros())) {
            return null;
        }
        return OCSimplifyInspectionLegacy.hasMacros(element) ? null : (T)value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/legacy/inspections/OCSimplifyInspectionLegacy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simplified";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/legacy/inspections/OCSimplifyInspectionLegacy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionShortName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSafeToSimplify";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSimplifyFix";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "simplifyStatementWithConstCondition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "simplifyLogicExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IfToTernary
    extends OCConvertIfToTernaryIntentionAction {
        private final String mySubject;
        private final PsiElement myElement;
        private final PsiElement mySimplified;

        public IfToTernary(String subject, PsiElement element, PsiElement simplified) {
            this.mySubject = subject;
            this.myElement = element;
            this.mySimplified = simplified;
        }

        @Override
        @NotNull
        public String getText() {
            String string = OCInspectionsBundle.message("inspection.simplify", this.mySubject);
            if (string == null) {
                IfToTernary.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected OCConvertIfToTernaryIntentionAction.Converter createConverter(PsiElement fakeElement) {
            return new OCConvertIfToTernaryIntentionAction.Converter(this.myElement);
        }

        @Override
        protected OCExpression getNewExpression(OCConvertIfToTernaryIntentionAction.Converter converter) {
            return (OCExpression)this.mySimplified;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/legacy/inspections/OCSimplifyInspectionLegacy$IfToTernary", "getText"));
        }
    }

    private static class Simplifier {
        private boolean equalToYesNoUsed;
        private boolean ifWithConstBranchUsed;

        private Simplifier() {
        }

        public boolean isWarningDisabled(OCSimplifyInspectionLegacy inspection) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return false;
            }
            return this.equalToYesNoUsed && !inspection.enableSimplifyEqualToYesNo || this.ifWithConstBranchUsed && !inspection.enableSimplifyIfWithConstantBranch;
        }

        @Nullable
        private PsiElement trySimplifyIfStatement(@NotNull OCIfStatement statement) {
            OCCondition condition;
            OCExpression expression;
            if (statement == null) {
                Simplifier.$$$reportNull$$$0(0);
            }
            OCExpression oCExpression = expression = (condition = statement.getCondition()) != null ? condition.getExpression() : null;
            if (expression == null || OCElementUtil.isPartOfMacroSubstitution(expression)) {
                return null;
            }
            OCStatement thenBranch = statement.getThenBranch();
            OCStatement elseBranch = statement.getElseBranch();
            Number conditionValue = OCSimplifyInspectionLegacy.nullIfHasMacros(OCExpressionEvaluator.evaluate(expression), condition);
            if (conditionValue != null) {
                return OCSimplifyInspectionLegacy.simplifyStatementWithConstCondition(OCExpressionEvaluator.singAsInC(conditionValue) != 0, statement);
            }
            if (thenBranch != null && elseBranch != null && OCElementUtil.areElementsEquivalent(thenBranch, elseBranch, false, OCResolveContext.forPsi(statement)) && !OCCodeInsightUtil.hasSideEffects(condition)) {
                return thenBranch;
            }
            OCConvertIfToTernaryIntentionAction.Converter converter = new OCConvertIfToTernaryIntentionAction().new OCConvertIfToTernaryIntentionAction.Converter(condition);
            if (!converter.isAvailable()) {
                return null;
            }
            return this.trySimplifyCondExpr(converter.getCondition(), converter.getThenExpression(), converter.getElseExpression());
        }

        private static PsiElement trySimplifyLoopStatement(@NotNull OCLoopStatement statement) {
            PsiElement condition;
            if (statement == null) {
                Simplifier.$$$reportNull$$$0(1);
            }
            if ((condition = statement.getCondition()) instanceof OCCondition) {
                condition = ((OCCondition)condition).getExpression();
            }
            if (!(condition instanceof OCExpression) || OCElementUtil.isPartOfMacroSubstitution(condition)) {
                return null;
            }
            Number conditionValue = OCSimplifyInspectionLegacy.nullIfHasMacros(OCExpressionEvaluator.evaluate((OCExpression)condition), condition);
            if (conditionValue != null) {
                return OCSimplifyInspectionLegacy.simplifyStatementWithConstCondition(OCExpressionEvaluator.singAsInC(conditionValue) > 0, statement);
            }
            return null;
        }

        @Nullable
        private OCExpression trySimplifyCondExpr(@Nullable OCExpression condition, @Nullable OCExpression thenBranch, @Nullable OCExpression elseBranch) {
            if (condition == null || thenBranch == null || elseBranch == null) {
                return null;
            }
            Number conditionValue = OCSimplifyInspectionLegacy.nullIfHasMacros(OCExpressionEvaluator.evaluate(condition), condition);
            if (conditionValue != null) {
                return OCSimplifyInspectionLegacy.simplify(OCExpressionEvaluator.singAsInC(conditionValue) != 0 ? thenBranch : elseBranch);
            }
            OCResolveContext resolveContext = OCResolveContext.forPsi(condition);
            if (OCParenthesesUtils.areExpressionsEquivalent(thenBranch, elseBranch, false, resolveContext) && !OCCodeInsightUtil.hasSideEffects(condition)) {
                return OCSimplifyInspectionLegacy.simplify(thenBranch);
            }
            if (OCParenthesesUtils.areExpressionsOpposite(thenBranch, elseBranch, false, resolveContext)) {
                return Simplifier.binaryExpr(Simplifier.ensureIsBoolean(condition), thenBranch, OCTokenTypes.EQEQ);
            }
            if (OCTypeUtils.isInstanceOfTypeResolved(thenBranch, resolveContext, OCMagicType.class, OCStructType.class) || OCTypeUtils.isInstanceOfTypeResolved(elseBranch, resolveContext, OCMagicType.class, OCStructType.class)) {
                return null;
            }
            Object thenValue = OCSimplifyInspectionLegacy.nullIfHasMacros(OCExpressionEvaluator.evaluateToIntOrBoolean(thenBranch), thenBranch);
            Object elseValue = OCSimplifyInspectionLegacy.nullIfHasMacros(OCExpressionEvaluator.evaluateToIntOrBoolean(elseBranch), elseBranch);
            if (thenValue instanceof Boolean) {
                boolean bl = this.ifWithConstBranchUsed = !(elseValue instanceof Boolean);
                if (((Boolean)thenValue).booleanValue()) {
                    return Simplifier.binaryExpr(Simplifier.ensureIsBoolean(condition), elseBranch, OCTokenTypes.OROR);
                }
                return Simplifier.binaryExpr(Simplifier.negateExpr(Simplifier.ensureIsBoolean(condition)), elseBranch, OCTokenTypes.ANDAND);
            }
            if (elseValue instanceof Boolean) {
                this.ifWithConstBranchUsed = true;
                if (((Boolean)elseValue).booleanValue()) {
                    return Simplifier.binaryExpr(Simplifier.negateExpr(Simplifier.ensureIsBoolean(condition)), thenBranch, OCTokenTypes.OROR);
                }
                return Simplifier.binaryExpr(Simplifier.ensureIsBoolean(condition), thenBranch, OCTokenTypes.ANDAND);
            }
            return null;
        }

        @Nullable
        private OCExpression trySimplifyBinaryExpr(@NotNull OCBinaryExpression expression) {
            OCExpression otherOperand;
            boolean condition;
            if (expression == null) {
                Simplifier.$$$reportNull$$$0(2);
            }
            OCExpression left = expression.getLeft();
            OCExpression right = expression.getRight();
            OCElementType operatorSign = expression.getOperationSign();
            if (left == null || right == null) {
                return null;
            }
            OCResolveContext resolveContext = OCResolveContext.forPsi(left);
            OCType leftType = OCTypeUtils.getResolvedCppReferencedType(left, resolveContext);
            OCType rightType = OCTypeUtils.getResolvedCppReferencedType(right, resolveContext);
            if (OCTypeUtils.isInstanceOfType(leftType, OCMagicType.class, OCStructType.class) || OCTypeUtils.isInstanceOfType(rightType, OCMagicType.class, OCStructType.class)) {
                return null;
            }
            if (OCParenthesesUtils.areExpressionsEquivalent(left, right, false, resolveContext) && !OCCodeInsightUtil.hasSideEffects(left)) {
                if (operatorSign == OCTokenTypes.ANDAND || operatorSign == OCTokenTypes.OROR) {
                    return Simplifier.ensureIsBoolean(OCSimplifyInspectionLegacy.simplify(left));
                }
                if (operatorSign == OCTokenTypes.AND || operatorSign == OCTokenTypes.OR) {
                    return OCSimplifyInspectionLegacy.simplify(left);
                }
                if (operatorSign == OCTokenTypes.XOR || operatorSign == OCTokenTypes.EXCLEQ) {
                    return Simplifier.constFalse(resolveContext);
                }
                if (operatorSign == OCTokenTypes.EQEQ) {
                    return Simplifier.constTrue(resolveContext);
                }
            }
            if (OCParenthesesUtils.areExpressionsOpposite(left, right, false, resolveContext) && !OCCodeInsightUtil.hasSideEffects(left)) {
                if (operatorSign == OCTokenTypes.OROR || operatorSign == OCTokenTypes.XOR || operatorSign == OCTokenTypes.EXCLEQ) {
                    return Simplifier.constTrue(resolveContext);
                }
                if (operatorSign == OCTokenTypes.ANDAND || operatorSign == OCTokenTypes.EQEQ) {
                    return Simplifier.constFalse(resolveContext);
                }
            }
            Object leftValue = OCSimplifyInspectionLegacy.nullIfHasMacros(OCExpressionEvaluator.evaluateToIntOrBoolean(left), left);
            Object rightValue = OCSimplifyInspectionLegacy.nullIfHasMacros(OCExpressionEvaluator.evaluateToIntOrBoolean(right), right);
            if (leftValue instanceof Boolean) {
                condition = (Boolean)leftValue;
                otherOperand = right;
            } else if (rightValue instanceof Boolean) {
                condition = (Boolean)rightValue;
                otherOperand = left;
            } else if (leftValue instanceof Number && OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)operatorSign)) {
                condition = OCExpressionEvaluator.singAsInC(leftValue) != 0;
                otherOperand = right;
            } else if (rightValue instanceof Number && OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)operatorSign)) {
                condition = OCExpressionEvaluator.singAsInC(rightValue) != 0;
                otherOperand = left;
            } else {
                return null;
            }
            if (operatorSign == OCTokenTypes.EQEQ || operatorSign == OCTokenTypes.EXCLEQ) {
                this.equalToYesNoUsed = true;
            }
            return Simplifier.trySimplifyLogicExpression(condition, left, otherOperand, operatorSign, resolveContext);
        }

        private static OCExpression trySimplifyLogicExpression(boolean condition, OCExpression left, OCExpression otherOperand, OCElementType operator, @NotNull OCResolveContext context) {
            if (context == null) {
                Simplifier.$$$reportNull$$$0(3);
            }
            if (OCTypeUtils.isInstanceOfTypeResolved(otherOperand, OCMagicType.class, OCStructType.class)) {
                return null;
            }
            if (condition) {
                if (operator == OCTokenTypes.ANDAND || operator == OCTokenTypes.AND || operator == OCTokenTypes.EQEQ) {
                    return Simplifier.ensureIsBoolean(OCSimplifyInspectionLegacy.simplify(otherOperand));
                }
                if (!(operator != OCTokenTypes.OROR && operator != OCTokenTypes.OR || otherOperand == left && OCCodeInsightUtil.hasSideEffects(left))) {
                    return Simplifier.constTrue(context);
                }
                if (operator == OCTokenTypes.XOR || operator == OCTokenTypes.EXCLEQ) {
                    return Simplifier.negateExpr(Simplifier.ensureIsBoolean(otherOperand));
                }
            } else {
                if (!(operator != OCTokenTypes.ANDAND && operator != OCTokenTypes.AND || otherOperand == left && OCCodeInsightUtil.hasSideEffects(left))) {
                    return Simplifier.constFalse(context);
                }
                if (operator == OCTokenTypes.OROR || operator == OCTokenTypes.XOR || operator == OCTokenTypes.EXCLEQ) {
                    return Simplifier.ensureIsBoolean(OCSimplifyInspectionLegacy.simplify(otherOperand));
                }
                if (operator == OCTokenTypes.EQEQ) {
                    return Simplifier.negateExpr(Simplifier.ensureIsBoolean(otherOperand));
                }
            }
            return null;
        }

        @Nullable
        private static OCExpression trySimplifyUnaryExpr(@NotNull OCUnaryExpression expression) {
            OCExpression operand;
            if (expression == null) {
                Simplifier.$$$reportNull$$$0(4);
            }
            if ((operand = expression.getOperand()) == null || expression.getOperationSign() != OCTokenTypes.EXCL) {
                return null;
            }
            Number value = OCSimplifyInspectionLegacy.nullIfHasMacros(OCExpressionEvaluator.evaluate(operand), operand);
            OCResolveContext resolveContext = OCResolveContext.forPsi(expression);
            if (value != null) {
                return OCExpressionEvaluator.singAsInC(value) != 0 ? Simplifier.constFalse(resolveContext) : Simplifier.constTrue(resolveContext);
            }
            if ((operand = OCParenthesesUtils.diveIntoParentheses(operand)) == null || OCElementUtil.isPartOfMacroSubstitution(operand)) {
                return null;
            }
            if (operand instanceof OCUnaryExpression) {
                OCUnaryExpression unaryExpression = (OCUnaryExpression)operand;
                boolean hasMagicOrStructTypeArgument = OCTypeUtils.isInstanceOfTypeResolved(unaryExpression.getOperand(), resolveContext, OCMagicType.class, OCStructType.class);
                if (unaryExpression.getOperationSign() == OCTokenTypes.EXCL && !hasMagicOrStructTypeArgument) {
                    return OCSimplifyInspectionLegacy.simplify(Simplifier.ensureIsBoolean(unaryExpression.getOperand()));
                }
            } else if (operand instanceof OCBinaryExpression && !OCCodeInsightUtil.isOverloadedOperatorUsage(operand)) {
                OCBinaryExpression binaryExpr = (OCBinaryExpression)operand;
                boolean hasMagicOrStructTypeArguments = OCTypeUtils.isInstanceOfTypeResolved(binaryExpr.getLeft(), resolveContext, OCMagicType.class, OCStructType.class) || OCTypeUtils.isInstanceOfTypeResolved(binaryExpr.getRight(), resolveContext, OCMagicType.class, OCStructType.class);
                OCElementType oppositeOperator = OCCodeInsightUtil.getOppositeOperator(binaryExpr.getOperationSign());
                if (oppositeOperator != null && !hasMagicOrStructTypeArguments) {
                    return Simplifier.binaryExpr(binaryExpr.getLeft(), binaryExpr.getRight(), oppositeOperator);
                }
            }
            return null;
        }

        @Nullable
        private static OCExpression simplifyAndParenthesize(OCExpression expression, int parentPrecedence) {
            if (expression == null || OCElementUtil.isPartOfMacroSubstitution(expression)) {
                return expression;
            }
            if ((expression = OCSimplifyInspectionLegacy.simplify(expression)) != null && OCParenthesesUtils.getPrecedence(expression, false) > parentPrecedence) {
                return OCParenthesesUtils.appendParentheses(expression);
            }
            return expression;
        }

        @Nullable
        public static OCExpression binaryExpr(@Nullable OCExpression left, @Nullable OCExpression right, @Nullable OCElementType operator) {
            if (left == null || right == null) {
                return null;
            }
            int precedence = OCParenthesesUtils.getPrecedence(operator);
            left = Simplifier.simplifyAndParenthesize(left, precedence);
            right = Simplifier.simplifyAndParenthesize(right, precedence);
            return OCSimplifyInspectionLegacy.simplify(OCElementFactory.binaryExpression(left, right, operator));
        }

        @Nullable
        private static OCExpression negateExpr(@Nullable OCExpression operand) {
            if (operand == null) {
                return null;
            }
            operand = Simplifier.simplifyAndParenthesize(operand, OCParenthesesUtils.getPrecedence(OCTokenTypes.EXCL));
            return OCSimplifyInspectionLegacy.simplify(OCElementFactory.unaryExpression(operand, OCTokenTypes.EXCL));
        }

        private static OCExpression constTrue(@NotNull OCResolveContext context) {
            if (context == null) {
                Simplifier.$$$reportNull$$$0(5);
            }
            return OCElementFactory.booleanConstant(true, context);
        }

        private static OCExpression constFalse(@NotNull OCResolveContext context) {
            if (context == null) {
                Simplifier.$$$reportNull$$$0(6);
            }
            return OCElementFactory.booleanConstant(false, context);
        }

        @Nullable
        private static OCExpression ensureIsBoolean(OCExpression expression) {
            if (expression == null) {
                return null;
            }
            OCResolveContext context = OCResolveContext.forPsi(expression);
            OCType type = OCTypeUtils.getResolvedCppReferencedType(expression, context);
            if (OCIntType.isBool(type, context)) {
                return expression;
            }
            if (type instanceof OCStructType || type instanceof OCMagicType || type instanceof OCBlockPointerType) {
                return null;
            }
            return Simplifier.binaryExpr(expression, OCElementFactory.expressionFromText(type.getDefaultValue(context), expression, false), OCTokenTypes.EXCLEQ);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/legacy/inspections/OCSimplifyInspectionLegacy$Simplifier";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "trySimplifyIfStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "trySimplifyLoopStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "trySimplifyBinaryExpr";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "trySimplifyLogicExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "trySimplifyUnaryExpr";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "constTrue";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "constFalse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class SimplifyVisitor
    extends OCVisitor {
        private SimplifyVisitor() {
        }

        @Override
        public void visitConditionalExpression(OCConditionalExpression expression) {
            if (OCElementUtil.insideDirective(expression)) {
                return;
            }
            Simplifier simplifier = new Simplifier();
            OCExpression simplified = simplifier.trySimplifyCondExpr(expression.getCondition(), expression.getPositiveExpression(true), expression.getNegativeExpression());
            this.simplifyAndParenthesize(expression, simplified, simplifier);
        }

        @Override
        public void visitIfStatement(OCIfStatement stmt) {
            Simplifier simplifier = new Simplifier();
            PsiElement simplified = simplifier.trySimplifyIfStatement(stmt);
            this.simplifyAndParenthesize(stmt, simplified, simplifier);
        }

        @Override
        public void visitWhileStatement(OCWhileStatement stmt) {
            this.simplify(stmt, Simplifier.trySimplifyLoopStatement(stmt), new Simplifier());
        }

        @Override
        public void visitDoWhileStatement(OCDoWhileStatement stmt) {
            this.simplify(stmt, Simplifier.trySimplifyLoopStatement(stmt), new Simplifier());
        }

        @Override
        public void visitForStatement(OCForStatement stmt) {
            this.simplify(stmt, Simplifier.trySimplifyLoopStatement(stmt), new Simplifier());
        }

        @Override
        public void visitBinaryExpression(OCBinaryExpression expression) {
            if (OCElementUtil.insideDirective(expression) || OCCodeInsightUtil.isOverloadedOperatorUsage(expression)) {
                return;
            }
            Simplifier simplifier = new Simplifier();
            OCExpression simplified = simplifier.trySimplifyBinaryExpr(expression);
            this.simplifyAndParenthesize(expression, simplified, simplifier);
        }

        @Override
        public void visitUnaryExpression(OCUnaryExpression expression) {
            if (OCElementUtil.insideDirective(expression) || OCCodeInsightUtil.isOverloadedOperatorUsage(expression)) {
                return;
            }
            Simplifier simplifier = new Simplifier();
            OCExpression simplified = Simplifier.trySimplifyUnaryExpr(expression);
            this.simplifyAndParenthesize(expression, simplified, simplifier);
        }

        private void simplifyAndParenthesize(@NotNull PsiElement element, @Nullable PsiElement simplified, Simplifier simplifier) {
            if (element == null) {
                SimplifyVisitor.$$$reportNull$$$0(0);
            }
            PsiElement parent = element.getParent();
            while (parent instanceof OCParenthesizedExpression && simplified instanceof OCExpression && !OCParenthesesUtils.isParenthesesNeededInReplacing((OCExpression)parent, (OCExpression)simplified)) {
                element = parent;
                parent = parent.getParent();
            }
            if (element instanceof OCExpression && simplified instanceof OCExpression && OCParenthesesUtils.isParenthesesNeededInReplacing((OCExpression)element, (OCExpression)simplified)) {
                this.simplify(element, OCParenthesesUtils.appendParentheses((OCExpression)simplified), simplifier);
            } else {
                this.simplify(element, simplified, simplifier);
            }
        }

        protected abstract void simplify(@NotNull PsiElement var1, @Nullable PsiElement var2, Simplifier var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/legacy/inspections/OCSimplifyInspectionLegacy$SimplifyVisitor", "simplifyAndParenthesize"));
        }
    }
}

