/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import org.jetbrains.annotations.NotNull;

public class OCChangeARCAttributeIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private ARCAttribute myAttribute;
    @IntentionName
    private final String myText;

    public OCChangeARCAttributeIntentionAction(@NotNull OCSymbol symbol, ARCAttribute attribute, @NotNull OCCompilationContext context) {
        if (symbol == null) {
            OCChangeARCAttributeIntentionAction.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCChangeARCAttributeIntentionAction.$$$reportNull$$$0(1);
        }
        super(context.getProject(), symbol);
        this.myAttribute = attribute;
        this.myText = OCInspectionsBundle.message("intention.name.make", this.mySymbol.getNameWithKindLowercase(context), this.myAttribute.getTokenName());
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message("intentions.change.arc.attribute", new Object[0]);
        if (string == null) {
            OCChangeARCAttributeIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        PsiElement declarator;
        OCDeclaration declaration;
        if (project == null) {
            OCChangeARCAttributeIntentionAction.$$$reportNull$$$0(3);
        }
        if ((declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)(declarator = this.mySymbol.locateDefinition(project)), OCDeclaration.class)) == null) {
            return;
        }
        OCTypeElement typeElement = declaration.getTypeElement();
        if (typeElement == null) {
            return;
        }
        OCChangeARCAttributeIntentionAction.removeOldAttributes(typeElement);
        OCChangeARCAttributeIntentionAction.removeOldAttributes(declarator);
        OCChangeUtil.changeText(declaration.getProject(), declaration.getContainingFile(), declaration.getTextOffset(), 0, this.myAttribute.getTokenName() + " ", true);
    }

    private static void removeOldAttributes(PsiElement typeElement) {
        for (ASTNode node : typeElement.getNode().getChildren(null)) {
            IElementType elementType = node.getElementType();
            if (elementType != OCTokenTypes.STRONG_KEYWORD && elementType != OCTokenTypes.WEAK_KEYWORD && elementType != OCTokenTypes.UNSAFE_UNRETAINED_KEYWORD && elementType != OCTokenTypes.AUTORELEASING_KEYWORD) continue;
            OCChangeUtil.delete(node.getPsi());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCChangeARCAttributeIntentionAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCChangeARCAttributeIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

