/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCopyElementIntentionAction
extends OCPsiElementQuickFix<PsiElement> {
    @IntentionName
    private final String myIntentionName;
    private final SmartPsiElementPointer<?> mySourceElementPtr;
    @IntentionFamilyName
    private final String myFamilyName;

    public OCCopyElementIntentionAction(@NotNull PsiElement sourceElement, PsiElement destinationElement, @IntentionFamilyName String intentionName) {
        if (sourceElement == null) {
            OCCopyElementIntentionAction.$$$reportNull$$$0(0);
        }
        super(destinationElement);
        this.mySourceElementPtr = OCElementUtil.createPsiElementPointer(sourceElement);
        this.myIntentionName = intentionName;
        this.myFamilyName = intentionName;
    }

    @Override
    protected String getTextInternal() {
        return this.myIntentionName;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            OCCopyElementIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean isAvailable(@NotNull PsiElement destinationElement) {
        if (destinationElement == null) {
            OCCopyElementIntentionAction.$$$reportNull$$$0(2);
        }
        return OCElementUtil.getPsiElementByPointer(this.mySourceElementPtr) != null;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            OCCopyElementIntentionAction.$$$reportNull$$$0(3);
        }
        return this.myElementPtr.getElement();
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            OCCopyElementIntentionAction.$$$reportNull$$$0(4);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement destinationElement = this.myElementPtr.getElement();
        Object sourceElement = OCElementUtil.getPsiElementByPointer(this.mySourceElementPtr);
        destinationElement.replace(sourceElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCCopyElementIntentionAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCCopyElementIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

