/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import icons.CidrLangIcons;
import org.jetbrains.annotations.NotNull;

public class OCCreateInterfaceIntentionAction
extends OCNewFileActionBase
implements IntentionAction {
    private final OCImplementationSymbol myImplementation;
    @NotNull
    private final PsiElement myImplNameIdentifier;

    public OCCreateInterfaceIntentionAction(OCImplementationSymbol anImplementation, @NotNull PsiElement implNameIdentifier) {
        if (implNameIdentifier == null) {
            OCCreateInterfaceIntentionAction.$$$reportNull$$$0(0);
        }
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.interface.title", new Object[0]), OCBundle.message("create.interface.description", new Object[0]), CidrLangIcons.CodeAssistantClass);
        this.myImplementation = anImplementation;
        this.myImplNameIdentifier = implNameIdentifier;
    }

    @NotNull
    public String getText() {
        if (this.myImplementation == null) {
            String string = OCBundle.message("action.invalid.title", new Object[0]);
            if (string == null) {
                OCCreateInterfaceIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }
        OCCompilationContext context = OCCompilationContext.create(this.myImplementation, this.myImplNameIdentifier.getProject());
        String string = OCInspectionsBundle.message("intentions.create.interface", this.myImplementation.getNameWithKindLowercase(context));
        if (string == null) {
            OCCreateInterfaceIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCCreateInterfaceIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected String getDefaultName() {
        return "Interface";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            OCCreateInterfaceIntentionAction.$$$reportNull$$$0(4);
        }
        return super.isAvailable() && OCSearchScope.isInProjectSources(this.myImplementation, project);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            OCCreateInterfaceIntentionAction.$$$reportNull$$$0(5);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        this.addAuxAction(createdElements -> {
            OCInterfaceSymbol interfaceSymbol = this.myImplementation.getInterface(true, this.myImplementation.getCategoryName(), project);
            new OCImportSymbolFix(this.myImplNameIdentifier, interfaceSymbol).fixBestItem(project, file);
            OCImportSymbolFix.fixAllSymbolsRecursively(this.myImplNameIdentifier);
        });
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.performAction(project, file.getParent(), file, this.myImplementation.getName());
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected String getFileTemplate(String fileName) {
        return "Objective-C Header File.h";
    }

    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        return new OCNewFileActionBase.NewFileNames(null, selectedName + ".h");
    }

    @NotNull
    protected CreateInterfaceDialog createDialog(@NotNull @NlsContexts.Label String defaultName) {
        if (defaultName == null) {
            OCCreateInterfaceIntentionAction.$$$reportNull$$$0(6);
        }
        return new CreateInterfaceDialog(defaultName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implNameIdentifier";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCCreateInterfaceIntentionAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCCreateInterfaceIntentionAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class CreateInterfaceDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        public CreateInterfaceDialog(String defaultName) {
            super((OCNewFileActionBase)OCCreateInterfaceIntentionAction.this, OCCreateInterfaceIntentionAction.this.getText(), defaultName, null);
        }
    }
}

