/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import icons.CidrLangIcons;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class OCImplementInterfaceIntentionAction
extends OCNewFileActionBase
implements IntentionAction {
    private final OCInterfaceSymbol myInterface;
    private final Project myProject;

    public OCImplementInterfaceIntentionAction(OCInterfaceSymbol anInterface, Project project) {
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.implementation.title", new Object[0]), OCBundle.message("create.implementation.description", new Object[0]), CidrLangIcons.CodeAssistantClass);
        this.myInterface = anInterface;
        this.myProject = project;
    }

    @NotNull
    public String getText() {
        if (this.myInterface == null) {
            String string = OCBundle.message("action.invalid.title", new Object[0]);
            if (string == null) {
                OCImplementInterfaceIntentionAction.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = OCInspectionsBundle.message("intentions.create.implementation", this.myInterface.getNameWithKindLowercase(OCCompilationContext.create(this.myInterface, this.myProject)));
        if (string == null) {
            OCImplementInterfaceIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCImplementInterfaceIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected String getDefaultName() {
        return "Implementation";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            OCImplementInterfaceIntentionAction.$$$reportNull$$$0(3);
        }
        return super.isAvailable() && OCSearchScope.isInProjectSources(this.myInterface, project);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            OCImplementInterfaceIntentionAction.$$$reportNull$$$0(4);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.performAction(project, file.getParent(), file, this.myInterface.getName());
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected String getFileTemplate(String fileName) {
        return "Objective-C Class.m";
    }

    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        return new OCNewFileActionBase.NewFileNames(selectedName + ".m", null);
    }

    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project) {
        VirtualFile file = this.myInterface.getContainingFile();
        OCLog.LOG.assertTrue(file != null);
        properties.setProperty("HEADER_FILENAME", file.getName());
    }

    @NotNull
    protected CreateImplementationDialog createDialog(@NotNull @NlsContexts.Label String defaultName) {
        if (defaultName == null) {
            OCImplementInterfaceIntentionAction.$$$reportNull$$$0(5);
        }
        return new CreateImplementationDialog(defaultName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCImplementInterfaceIntentionAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCImplementInterfaceIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class CreateImplementationDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        public CreateImplementationDialog(String defaultName) {
            super((OCNewFileActionBase)OCImplementInterfaceIntentionAction.this, OCImplementInterfaceIntentionAction.this.getText(), defaultName, null);
        }
    }
}

