/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class OCIncludeSuggester {
    private static final Map<String, ImportData> STD_NAME_TO_HEADER;

    private static Map<String, ImportData> readImportData(String ... kvs) {
        Pattern keyPattern = Pattern.compile("(!\\((.*)\\))?(.*)");
        HashMap<String, ImportData> result = new HashMap<String, ImportData>();
        String key = null;
        Availability availability = Availability.REQUIRED;
        for (String kv : kvs) {
            if (key == null) {
                availability = Availability.REQUIRED;
                Matcher matcher = keyPattern.matcher(kv);
                OCLog.LOG.assertTrue(matcher.matches());
                key = matcher.group(3).trim();
                @NonNls String modifier = matcher.group(2);
                if (modifier == null) continue;
                if ("cpp14+".equals(modifier)) {
                    availability = Availability.CPP14_PLUS;
                    continue;
                }
                if ("clang".equals(modifier)) {
                    availability = Availability.CLANG_ONLY;
                    continue;
                }
                if ("no_win".equals(modifier)) {
                    availability = Availability.NO_WINDOWS;
                    continue;
                }
                if ("no_mingw".equals(modifier)) {
                    availability = Availability.NO_MINGW;
                    continue;
                }
                if ("mingw_non_standard".equals(modifier)) {
                    availability = Availability.MINGW_NON_STANDARD;
                    continue;
                }
                if ("optional".equals(modifier)) {
                    availability = Availability.OPTIONAL;
                    continue;
                }
                OCLog.LOG.error("unexpected modifier: " + modifier);
                continue;
            }
            ImportData data = (ImportData)result.get(key);
            if (data == null) {
                data = new ImportData();
                result.put(key, data);
            }
            data.addImport(new Import(kv, availability));
            key = null;
        }
        OCLog.LOG.assertTrue(key == null);
        return result;
    }

    @NotNull
    public static Collection<String> getRecommendedHeaderNames(@NotNull OCSymbol symbol, @NotNull PsiFile currentFile) {
        ImportData data;
        OCResolveContext context;
        OCQualifiedName rqn;
        if (symbol == null) {
            OCIncludeSuggester.$$$reportNull$$$0(0);
        }
        if (currentFile == null) {
            OCIncludeSuggester.$$$reportNull$$$0(1);
        }
        if (!(currentFile instanceof OCFile) || !((OCFile)currentFile).getKind().isCpp()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                OCIncludeSuggester.$$$reportNull$$$0(2);
            }
            return set;
        }
        String fullName = symbol.getName();
        if (symbol instanceof OCSymbolWithQualifiedName && (rqn = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(true, false, context = OCResolveContext.forPsi((PsiElement)currentFile))) != null && ((fullName = rqn.getCanonicalName(OCType.Presentation.FULL, false, context, 0)).startsWith("_") || fullName.contains("::_"))) {
            StringBuilder sb = new StringBuilder();
            String[] comps = fullName.split("::");
            for (int i2 = 0; i2 < comps.length - 1; ++i2) {
                String comp = comps[i2];
                if (comp.startsWith("_")) continue;
                sb.append(comp).append("::");
            }
            sb.append(comps[comps.length - 1]);
            fullName = sb.toString();
        }
        List<Object> list = (data = STD_NAME_TO_HEADER.get(fullName)) == null ? Collections.emptyList() : data.rawImports;
        if (list == null) {
            OCIncludeSuggester.$$$reportNull$$$0(3);
        }
        return list;
    }

    @TestOnly
    @NotNull
    public static Map<String, ImportData> getStdNameToHeader() {
        Map<String, ImportData> map = STD_NAME_TO_HEADER;
        if (map == null) {
            OCIncludeSuggester.$$$reportNull$$$0(4);
        }
        return map;
    }

    /*
     * Opcode count of 16912 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        @NonNls String[] rawImportData = new String[]{"ATOMIC_FLAG_INIT", "atomic", "ATOMIC_VAR_INIT", "atomic", "BUFSIZ", "cstdio", "CHAR_BIT", "climits", "CHAR_MAX", "climits", "CHAR_MIN", "climits", "CLOCKS_PER_SEC", "ctime", "DBL_DIG", "cfloat", "DBL_EPSILON", "cfloat", "DBL_MANT_DIG", "cfloat", "DBL_MAX", "cfloat", "DBL_MAX_10_EXP", "cfloat", "DBL_MAX_EXP", "cfloat", "DBL_MIN", "cfloat", "DBL_MIN_10_EXP", "cfloat", "DBL_MIN_EXP", "cfloat", "DECIMAL_DIG", "cfloat", "E2BIG", "cerrno", "EACCES", "cerrno", "!(no_mingw) EADDRINUSE", "cerrno", "!(no_mingw) EADDRNOTAVAIL", "cerrno", "!(no_mingw) EAFNOSUPPORT", "cerrno", "EAGAIN", "cerrno", "!(no_mingw) EALREADY", "cerrno", "EBADF", "cerrno", "!(no_mingw) EBADMSG", "cerrno", "EBUSY", "cerrno", "!(no_mingw) ECANCELED", "cerrno", "ECHILD", "cerrno", "!(no_mingw) ECONNABORTED", "cerrno", "!(no_mingw) ECONNREFUSED", "cerrno", "!(no_mingw) ECONNRESET", "cerrno", "EDEADLK", "cerrno", "!(no_mingw) EDESTADDRREQ", "cerrno", "EDOM", "cerrno", "EEXIST", "cerrno", "EFAULT", "cerrno", "EFBIG", "cerrno", "!(no_mingw) EHOSTUNREACH", "cerrno", "!(no_mingw) EIDRM", "cerrno", "EILSEQ", "cerrno", "!(no_mingw) EINPROGRESS", "cerrno", "EINTR", "cerrno", "EINVAL", "cerrno", "EIO", "cerrno", "!(no_mingw) EISCONN", "cerrno", "EISDIR", "cerrno", "!(no_mingw) ELOOP", "cerrno", "EMFILE", "cerrno", "EMLINK", "cerrno", "!(no_mingw) EMSGSIZE", "cerrno", "ENAMETOOLONG", "cerrno", "!(no_mingw) ENETDOWN", "cerrno", "!(no_mingw) ENETRESET", "cerrno", "!(no_mingw) ENETUNREACH", "cerrno", "ENFILE", "cerrno", "!(no_mingw) ENOBUFS", "cerrno", "!(no_mingw) ENODATA", "cerrno", "ENODEV", "cerrno", "ENOENT", "cerrno", "ENOEXEC", "cerrno", "ENOLCK", "cerrno", "!(no_mingw) ENOLINK", "cerrno", "ENOMEM", "cerrno", "!(no_mingw) ENOMSG", "cerrno", "!(no_mingw) ENOPROTOOPT", "cerrno", "ENOSPC", "cerrno", "!(no_mingw) ENOSR", "cerrno", "!(no_mingw) ENOSTR", "cerrno", "ENOSYS", "cerrno", "!(no_mingw) ENOTCONN", "cerrno", "ENOTDIR", "cerrno", "ENOTEMPTY", "cerrno", "!(no_mingw) ENOTRECOVERABLE", "cerrno", "!(no_mingw) ENOTSOCK", "cerrno", "!(no_mingw) ENOTSUP", "cerrno", "ENOTTY", "cerrno", "ENXIO", "cerrno", "EOF", "cstdio", "!(no_mingw) EOPNOTSUPP", "cerrno", "!(no_mingw) EOVERFLOW", "cerrno", "!(no_mingw) EOWNERDEAD", "cerrno", "EPERM", "cerrno", "EPIPE", "cerrno", "!(no_mingw) EPROTO", "cerrno", "!(no_mingw) EPROTONOSUPPORT", "cerrno", "!(no_mingw) EPROTOTYPE", "cerrno", "ERANGE", "cerrno", "EROFS", "cerrno", "ESPIPE", "cerrno", "ESRCH", "cerrno", "!(no_mingw) ETIME", "cerrno", "!(no_mingw) ETIMEDOUT", "cerrno", "!(no_mingw) ETXTBSY", "cerrno", "!(no_mingw) EWOULDBLOCK", "cerrno", "EXDEV", "cerrno", "EXIT_FAILURE", "cstdlib", "EXIT_SUCCESS", "cstdlib", "!(mingw_non_standard) FE_ALL_EXCEPT", "cfenv", "!(mingw_non_standard) FE_DFL_ENV", "cfenv", "!(mingw_non_standard) FE_DIVBYZERO", "cfenv", "!(mingw_non_standard) FE_DOWNWARD", "cfenv", "!(mingw_non_standard) FE_INEXACT", "cfenv", "!(mingw_non_standard) FE_INVALID", "cfenv", "!(mingw_non_standard) FE_OVERFLOW", "cfenv", "!(mingw_non_standard) FE_TONEAREST", "cfenv", "!(mingw_non_standard) FE_TOWARDZERO", "cfenv", "!(mingw_non_standard) FE_UNDERFLOW", "cfenv", "!(mingw_non_standard) FE_UPWARD", "cfenv", "FILE", "cstdio", "FILENAME_MAX", "cstdio", "FLT_DIG", "cfloat", "FLT_EPSILON", "cfloat", "FLT_EVAL_METHOD", "cfloat", "FLT_MANT_DIG", "cfloat", "FLT_MAX", "cfloat", "FLT_MAX_10_EXP", "cfloat", "FLT_MAX_EXP", "cfloat", "FLT_MIN", "cfloat", "FLT_MIN_10_EXP", "cfloat", "FLT_MIN_EXP", "cfloat", "FLT_RADIX", "cfloat", "FLT_ROUNDS", "cfloat", "FOPEN_MAX", "cstdio", "FP_INFINITE", "cmath", "FP_NAN", "cmath", "FP_NORMAL", "cmath", "FP_SUBNORMAL", "cmath", "FP_ZERO", "cmath", "HUGE_VAL", "cmath", "HUGE_VALF", "cmath", "HUGE_VALL", "cmath", "INFINITY", "cmath", "INT16_C", "cstdint", "INT16_MAX", "cstdint", "INT16_MIN", "cstdint", "INT32_C", "cstdint", "INT32_MAX", "cstdint", "INT32_MIN", "cstdint", "INT64_C", "cstdint", "INT64_MAX", "cstdint", "INT64_MIN", "cstdint", "INT8_C", "cstdint", "INT8_MAX", "cstdint", "INT8_MIN", "cstdint", "INTMAX_C", "cstdint", "INTMAX_MAX", "cstdint", "INTMAX_MIN", "cstdint", "INTPTR_MAX", "cstdint", "INTPTR_MIN", "cstdint", "INT_FAST16_MAX", "cstdint", "INT_FAST16_MIN", "cstdint", "INT_FAST32_MAX", "cstdint", "INT_FAST32_MIN", "cstdint", "INT_FAST64_MAX", "cstdint", "INT_FAST64_MIN", "cstdint", "INT_FAST8_MAX", "cstdint", "INT_FAST8_MIN", "cstdint", "INT_LEAST16_MAX", "cstdint", "INT_LEAST16_MIN", "cstdint", "INT_LEAST32_MAX", "cstdint", "INT_LEAST32_MIN", "cstdint", "INT_LEAST64_MAX", "cstdint", "INT_LEAST64_MIN", "cstdint", "INT_LEAST8_MAX", "cstdint", "INT_LEAST8_MIN", "cstdint", "INT_MAX", "climits", "INT_MIN", "climits", "LC_ALL", "clocale", "LC_COLLATE", "clocale", "LC_CTYPE", "clocale", "LC_MONETARY", "clocale", "LC_NUMERIC", "clocale", "LC_TIME", "clocale", "LDBL_DIG", "cfloat", "LDBL_EPSILON", "cfloat", "LDBL_MANT_DIG", "cfloat", "LDBL_MAX", "cfloat", "LDBL_MAX_10_EXP", "cfloat", "LDBL_MAX_EXP", "cfloat", "LDBL_MIN", "cfloat", "LDBL_MIN_10_EXP", "cfloat", "LDBL_MIN_EXP", "cfloat", "LLONG_MAX", "climits", "LLONG_MIN", "climits", "LONG_MAX", "climits", "LONG_MIN", "climits", "L_tmpnam", "cstdio", "!(no_mingw) MATH_ERREXCEPT", "cmath", "!(no_mingw) MATH_ERRNO", "cmath", "MB_CUR_MAX", "cstdlib", "MB_LEN_MAX", "climits", "NAN", "cmath", "NULL", "clocale", "NULL", "cstddef", "NULL", "cstdio", "NULL", "cstdlib", "NULL", "cstring", "NULL", "ctime", "NULL", "cwchar", "PRIX16", "cinttypes", "PRIX32", "cinttypes", "PRIX64", "cinttypes", "PRIX8", "cinttypes", "PRIXFAST16", "cinttypes", "PRIXFAST32", "cinttypes", "PRIXFAST64", "cinttypes", "PRIXFAST8", "cinttypes", "PRIXLEAST16", "cinttypes", "PRIXLEAST32", "cinttypes", "PRIXLEAST64", "cinttypes", "PRIXLEAST8", "cinttypes", "PRIXMAX", "cinttypes", "PRIXPTR", "cinttypes", "PRId16", "cinttypes", "PRId32", "cinttypes", "PRId64", "cinttypes", "PRId8", "cinttypes", "PRIdFAST16", "cinttypes", "PRIdFAST32", "cinttypes", "PRIdFAST64", "cinttypes", "PRIdFAST8", "cinttypes", "PRIdLEAST16", "cinttypes", "PRIdLEAST32", "cinttypes", "PRIdLEAST64", "cinttypes", "PRIdLEAST8", "cinttypes", "PRIdMAX", "cinttypes", "PRIdPTR", "cinttypes", "PRIi16", "cinttypes", "PRIi32", "cinttypes", "PRIi64", "cinttypes", "PRIi8", "cinttypes", "PRIiFAST16", "cinttypes", "PRIiFAST32", "cinttypes", "PRIiFAST64", "cinttypes", "PRIiFAST8", "cinttypes", "PRIiLEAST16", "cinttypes", "PRIiLEAST32", "cinttypes", "PRIiLEAST64", "cinttypes", "PRIiLEAST8", "cinttypes", "PRIiMAX", "cinttypes", "PRIiPTR", "cinttypes", "PRIo16", "cinttypes", "PRIo32", "cinttypes", "PRIo64", "cinttypes", "PRIo8", "cinttypes", "PRIoFAST16", "cinttypes", "PRIoFAST32", "cinttypes", "PRIoFAST64", "cinttypes", "PRIoFAST8", "cinttypes", "PRIoLEAST16", "cinttypes", "PRIoLEAST32", "cinttypes", "PRIoLEAST64", "cinttypes", "PRIoLEAST8", "cinttypes", "PRIoMAX", "cinttypes", "PRIoPTR", "cinttypes", "PRIu16", "cinttypes", "PRIu32", "cinttypes", "PRIu64", "cinttypes", "PRIu8", "cinttypes", "PRIuFAST16", "cinttypes", "PRIuFAST32", "cinttypes", "PRIuFAST64", "cinttypes", "PRIuFAST8", "cinttypes", "PRIuLEAST16", "cinttypes", "PRIuLEAST32", "cinttypes", "PRIuLEAST64", "cinttypes", "PRIuLEAST8", "cinttypes", "PRIuMAX", "cinttypes", "PRIuPTR", "cinttypes", "PRIx16", "cinttypes", "PRIx32", "cinttypes", "PRIx64", "cinttypes", "PRIx8", "cinttypes", "PRIxFAST16", "cinttypes", "PRIxFAST32", "cinttypes", "PRIxFAST64", "cinttypes", "PRIxFAST8", "cinttypes", "PRIxLEAST16", "cinttypes", "PRIxLEAST32", "cinttypes", "PRIxLEAST64", "cinttypes", "PRIxLEAST8", "cinttypes", "PRIxMAX", "cinttypes", "PRIxPTR", "cinttypes", "PTRDIFF_MAX", "cstdint", "PTRDIFF_MIN", "cstdint", "RAND_MAX", "cstdlib", "SCHAR_MAX", "climits", "SCHAR_MIN", "climits", "SCNd16", "cinttypes", "SCNd32", "cinttypes", "SCNd64", "cinttypes", "!(no_mingw) SCNd8", "cinttypes", "SCNdFAST16", "cinttypes", "SCNdFAST32", "cinttypes", "SCNdFAST64", "cinttypes", "!(no_mingw) SCNdFAST8", "cinttypes", "SCNdLEAST16", "cinttypes", "SCNdLEAST32", "cinttypes", "SCNdLEAST64", "cinttypes", "!(no_mingw) SCNdLEAST8", "cinttypes", "SCNdMAX", "cinttypes", "SCNdPTR", "cinttypes", "SCNi16", "cinttypes", "SCNi32", "cinttypes", "SCNi64", "cinttypes", "!(no_mingw) SCNi8", "cinttypes", "SCNiFAST16", "cinttypes", "SCNiFAST32", "cinttypes", "SCNiFAST64", "cinttypes", "!(no_mingw) SCNiFAST8", "cinttypes", "SCNiLEAST16", "cinttypes", "SCNiLEAST32", "cinttypes", "SCNiLEAST64", "cinttypes", "!(no_mingw) SCNiLEAST8", "cinttypes", "SCNiMAX", "cinttypes", "SCNiPTR", "cinttypes", "SCNo16", "cinttypes", "SCNo32", "cinttypes", "SCNo64", "cinttypes", "!(no_mingw) SCNo8", "cinttypes", "SCNoFAST16", "cinttypes", "SCNoFAST32", "cinttypes", "SCNoFAST64", "cinttypes", "!(no_mingw) SCNoFAST8", "cinttypes", "SCNoLEAST16", "cinttypes", "SCNoLEAST32", "cinttypes", "SCNoLEAST64", "cinttypes", "!(no_mingw) SCNoLEAST8", "cinttypes", "SCNoMAX", "cinttypes", "SCNoPTR", "cinttypes", "SCNu16", "cinttypes", "SCNu32", "cinttypes", "SCNu64", "cinttypes", "!(no_mingw) SCNu8", "cinttypes", "SCNuFAST16", "cinttypes", "SCNuFAST32", "cinttypes", "SCNuFAST64", "cinttypes", "!(no_mingw) SCNuFAST8", "cinttypes", "SCNuLEAST16", "cinttypes", "SCNuLEAST32", "cinttypes", "SCNuLEAST64", "cinttypes", "!(no_mingw) SCNuLEAST8", "cinttypes", "SCNuMAX", "cinttypes", "SCNuPTR", "cinttypes", "SCNx16", "cinttypes", "SCNx32", "cinttypes", "SCNx64", "cinttypes", "!(no_mingw) SCNx8", "cinttypes", "SCNxFAST16", "cinttypes", "SCNxFAST32", "cinttypes", "SCNxFAST64", "cinttypes", "!(no_mingw) SCNxFAST8", "cinttypes", "SCNxLEAST16", "cinttypes", "SCNxLEAST32", "cinttypes", "SCNxLEAST64", "cinttypes", "!(no_mingw) SCNxLEAST8", "cinttypes", "SCNxMAX", "cinttypes", "SCNxPTR", "cinttypes", "SEEK_CUR", "cstdio", "SEEK_END", "cstdio", "SEEK_SET", "cstdio", "SHRT_MAX", "climits", "SHRT_MIN", "climits", "SIGABRT", "csignal", "SIGFPE", "csignal", "SIGILL", "csignal", "SIGINT", "csignal", "SIGSEGV", "csignal", "SIGTERM", "csignal", "SIG_ATOMIC_MAX", "cstdint", "SIG_ATOMIC_MIN", "cstdint", "SIG_DFL", "csignal", "SIG_ERR", "csignal", "SIG_IGN", "csignal", "SIZE_MAX", "cstdint", "TMP_MAX", "cstdio", "UCHAR_MAX", "climits", "UINT16_C", "cstdint", "UINT16_MAX", "cstdint", "UINT32_C", "cstdint", "UINT32_MAX", "cstdint", "UINT64_C", "cstdint", "UINT64_MAX", "cstdint", "UINT8_C", "cstdint", "UINT8_MAX", "cstdint", "UINTMAX_C", "cstdint", "UINTMAX_MAX", "cstdint", "UINTPTR_MAX", "cstdint", "UINT_FAST16_MAX", "cstdint", "UINT_FAST32_MAX", "cstdint", "UINT_FAST64_MAX", "cstdint", "UINT_FAST8_MAX", "cstdint", "UINT_LEAST16_MAX", "cstdint", "UINT_LEAST32_MAX", "cstdint", "UINT_LEAST64_MAX", "cstdint", "UINT_LEAST8_MAX", "cstdint", "UINT_MAX", "climits", "ULLONG_MAX", "climits", "ULONG_MAX", "climits", "USHRT_MAX", "climits", "WCHAR_MAX", "cstdint", "WCHAR_MAX", "cwchar", "WCHAR_MIN", "cstdint", "WCHAR_MIN", "cwchar", "WEOF", "cwchar", "WEOF", "cwctype", "WINT_MAX", "cstdint", "WINT_MIN", "cstdint", "_Exit", "cstdlib", "_IOFBF", "cstdio", "_IOLBF", "cstdio", "_IONBF", "cstdio", "!(clang) __alignas_is_defined", "cstdalign", "!(clang) __alignas_is_defined", "stdalign.h", "!(no_mingw) __bool_true_false_are_defined", "cstdbool", "abort", "cstdlib", "abs", "cinttypes", "abs", "cmath", "abs", "complex", "abs", "cstdlib", "abs", "valarray", "acos", "cmath", "acos", "complex", "acos", "valarray", "acosh", "cmath", "acosh", "complex", "asctime", "ctime", "asin", "cmath", "asin", "complex", "asin", "valarray", "asinh", "cmath", "asinh", "complex", "assert", "cassert", "!(optional) at_quick_exit", "cstdlib", "atan", "cmath", "atan", "complex", "atan", "valarray", "atan2", "cmath", "atan2", "valarray", "atanh", "cmath", "atanh", "complex", "atexit", "cstdlib", "atof", "cstdlib", "atoi", "cstdlib", "atol", "cstdlib", "atoll", "cstdlib", "bsearch", "cstdlib", "btowc", "cwchar", "!(optional) c16rtomb", "cuchar", "!(optional) c32rtomb", "cuchar", "calloc", "cstdlib", "cbrt", "cmath", "ceil", "cmath", "clearerr", "cstdio", "clock", "ctime", "clock_t", "ctime", "copysign", "cmath", "cos", "cmath", "cos", "complex", "cos", "valarray", "cosh", "cmath", "cosh", "complex", "cosh", "valarray", "ctime", "ctime", "difftime", "ctime", "div", "cinttypes", "div", "cstdlib", "div_t", "cstdlib", "double_t", "cmath", "erf", "cmath", "erfc", "cmath", "errno", "cerrno", "exit", "cstdlib", "exp", "cmath", "exp", "complex", "exp", "valarray", "exp2", "cmath", "expm1", "cmath", "fabs", "cmath", "fclose", "cstdio", "fdim", "cmath", "feclearexcept", "cfenv", "fegetenv", "cfenv", "fegetexceptflag", "cfenv", "fegetround", "cfenv", "feholdexcept", "cfenv", "fenv_t", "cfenv", "feof", "cstdio", "feraiseexcept", "cfenv", "ferror", "cstdio", "fesetenv", "cfenv", "fesetexceptflag", "cfenv", "fesetround", "cfenv", "fetestexcept", "cfenv", "feupdateenv", "cfenv", "fexcept_t", "cfenv", "fflush", "cstdio", "fgetc", "cstdio", "fgetpos", "cstdio", "fgets", "cstdio", "fgetwc", "cwchar", "fgetws", "cwchar", "float_t", "cmath", "floor", "cmath", "fma", "cmath", "fmax", "cmath", "fmin", "cmath", "fmod", "cmath", "fopen", "cstdio", "fpclassify", "cmath", "fpos_t", "cstdio", "fprintf", "cstdio", "fputc", "cstdio", "fputs", "cstdio", "fputwc", "cwchar", "fputws", "cwchar", "fread", "cstdio", "free", "cstdlib", "freopen", "cstdio", "frexp", "cmath", "fscanf", "cstdio", "fseek", "cstdio", "fsetpos", "cstdio", "ftell", "cstdio", "fwide", "cwchar", "fwprintf", "cwchar", "fwrite", "cstdio", "fwscanf", "cwchar", "getc", "cstdio", "getchar", "cstdio", "getenv", "cstdlib", "gets", "cstdio", "getwc", "cwchar", "getwchar", "cwchar", "gmtime", "ctime", "hypot", "cmath", "ilogb", "cmath", "imaxabs", "cinttypes", "imaxdiv", "cinttypes", "imaxdiv_t", "cinttypes", "int16_t", "cstdint", "int32_t", "cstdint", "int64_t", "cstdint", "int8_t", "cstdint", "int_fast16_t", "cstdint", "int_fast32_t", "cstdint", "int_fast64_t", "cstdint", "int_fast8_t", "cstdint", "int_least16_t", "cstdint", "int_least32_t", "cstdint", "int_least64_t", "cstdint", "int_least8_t", "cstdint", "intmax_t", "cstdint", "intptr_t", "cstdint", "isalnum", "cctype", "isalnum", "locale", "isalpha", "cctype", "isalpha", "locale", "isblank", "cctype", "isblank", "locale", "iscntrl", "cctype", "iscntrl", "locale", "isdigit", "cctype", "isdigit", "locale", "isfinite", "cmath", "isgraph", "cctype", "isgraph", "locale", "isgreater", "cmath", "isgreaterequal", "cmath", "isinf", "cmath", "isless", "cmath", "islessequal", "cmath", "islessgreater", "cmath", "islower", "cctype", "islower", "locale", "isnan", "cmath", "isnormal", "cmath", "isprint", "cctype", "isprint", "locale", "ispunct", "cctype", "ispunct", "locale", "isspace", "cctype", "isspace", "locale", "isunordered", "cmath", "isupper", "cctype", "isupper", "locale", "iswalnum", "cwctype", "iswalpha", "cwctype", "iswblank", "cwctype", "iswcntrl", "cwctype", "iswctype", "cwctype", "iswdigit", "cwctype", "iswgraph", "cwctype", "iswlower", "cwctype", "iswprint", "cwctype", "iswpunct", "cwctype", "iswspace", "cwctype", "iswupper", "cwctype", "iswxdigit", "cwctype", "isxdigit", "cctype", "isxdigit", "locale", "jmp_buf", "csetjmp", "labs", "cstdlib", "lconv", "clocale", "ldexp", "cmath", "ldiv", "cstdlib", "ldiv_t", "cstdlib", "lgamma", "cmath", "llabs", "cstdlib", "lldiv", "cstdlib", "lldiv_t", "cstdlib", "llrint", "cmath", "llround", "cmath", "localeconv", "clocale", "localtime", "ctime", "log", "cmath", "log", "complex", "log", "valarray", "log10", "cmath", "log10", "complex", "log10", "valarray", "log1p", "cmath", "log2", "cmath", "logb", "cmath", "longjmp", "csetjmp", "lrint", "cmath", "lround", "cmath", "malloc", "cstdlib", "!(no_mingw) math_errhandling", "cmath", "max_align_t", "cstddef", "mblen", "cstdlib", "mbrlen", "cwchar", "!(optional) mbrtoc16", "cuchar", "!(optional) mbrtoc32", "cuchar", "mbrtowc", "cwchar", "mbsinit", "cwchar", "mbsrtowcs", "cwchar", "mbstate_t", "cwchar", "mbstowcs", "cstdlib", "mbtowc", "cstdlib", "memchr", "cstring", "memcmp", "cstring", "memcpy", "cstring", "memmove", "cstring", "memset", "cstring", "mktime", "ctime", "modf", "cmath", "nan", "cmath", "nanf", "cmath", "nanl", "cmath", "nearbyint", "cmath", "nextafter", "cmath", "nexttoward", "cmath", "offsetof", "cstddef", "perror", "cstdio", "pow", "cmath", "pow", "complex", "pow", "valarray", "printf", "cstdio", "ptrdiff_t", "cstddef", "putc", "cstdio", "putchar", "cstdio", "puts", "cstdio", "putwc", "cwchar", "putwchar", "cwchar", "qsort", "cstdlib", "!(optional) quick_exit", "cstdlib", "raise", "csignal", "rand", "cstdlib", "realloc", "cstdlib", "remainder", "cmath", "remove", "algorithm", "remove", "cstdio", "remquo", "cmath", "rename", "cstdio", "rewind", "cstdio", "rint", "cmath", "round", "cmath", "scalbln", "cmath", "scalbn", "cmath", "scanf", "cstdio", "setbuf", "cstdio", "setjmp", "csetjmp", "!(optional) setlocale", "clocale", "setvbuf", "cstdio", "sig_atomic_t", "csignal", "signal", "csignal", "signbit", "cmath", "sin", "cmath", "sin", "complex", "sin", "valarray", "sinh", "cmath", "sinh", "complex", "sinh", "valarray", "size_t", "cstddef", "size_t", "cstdio", "size_t", "cstdlib", "size_t", "cstring", "size_t", "ctime", "size_t", "cwchar", "snprintf", "cstdio", "sprintf", "cstdio", "sqrt", "cmath", "sqrt", "complex", "sqrt", "valarray", "srand", "cstdlib", "sscanf", "cstdio", "std::FILE", "cstdio", "!(no_win) std::_Exit", "cstdlib", "std::abort", "cstdlib", "std::abs", "cinttypes", "std::abs", "cmath", "std::abs", "complex", "std::abs", "cstdlib", "std::abs", "valarray", "std::accumulate", "numeric", "std::acos", "cmath", "std::acos", "complex", "std::acos", "valarray", "std::acosh", "cmath", "std::acosh", "complex", "std::add_const", "type_traits", "std::add_cv", "type_traits", "std::add_lvalue_reference", "type_traits", "std::add_pointer", "type_traits", "std::add_rvalue_reference", "type_traits", "std::add_volatile", "type_traits", "std::addressof", "memory", "std::adjacent_difference", "numeric", "std::adjacent_find", "algorithm", "std::adopt_lock", "mutex", "std::adopt_lock_t", "mutex", "std::advance", "iterator", "std::align", "memory", "std::aligned_storage", "type_traits", "std::aligned_union", "type_traits", "std::alignment_of", "type_traits", "std::all_of", "algorithm", "std::allocate_shared", "memory", "std::allocator", "memory", "std::allocator_arg", "memory", "std::allocator_arg_t", "memory", "std::allocator_traits", "memory", "std::any_of", "algorithm", "std::arg", "complex", "std::array", "array", "std::asctime", "ctime", "std::asin", "cmath", "std::asin", "complex", "std::asin", "valarray", "std::asinh", "cmath", "std::asinh", "complex", "std::async", "future", "std::atan", "cmath", "std::atan", "complex", "std::atan", "valarray", "std::atan2", "cmath", "std::atan2", "valarray", "std::atanh", "cmath", "std::atanh", "complex", "!(optional) std::at_quick_exit", "cstdlib", "std::atexit", "cstdlib", "std::atof", "cstdlib", "std::atoi", "cstdlib", "std::atol", "cstdlib", "!(no_win) std::atoll", "cstdlib", "std::atomic", "atomic", "std::atomic_bool", "atomic", "std::atomic_char", "atomic", "std::atomic_char16_t", "atomic", "std::atomic_char32_t", "atomic", "std::atomic_compare_exchange_strong", "atomic", "std::atomic_compare_exchange_strong_explicit", "atomic", "std::atomic_compare_exchange_strong_explicit", "memory", "std::atomic_compare_exchange_weak", "atomic", "std::atomic_compare_exchange_weak_explicit", "atomic", "std::atomic_exchange", "atomic", "std::atomic_exchange_explicit", "atomic", "std::atomic_fetch_add", "atomic", "std::atomic_fetch_add_explicit", "atomic", "std::atomic_fetch_and", "atomic", "std::atomic_fetch_and_explicit", "atomic", "std::atomic_fetch_or", "atomic", "std::atomic_fetch_or_explicit", "atomic", "std::atomic_fetch_sub", "atomic", "std::atomic_fetch_sub_explicit", "atomic", "std::atomic_fetch_xor", "atomic", "std::atomic_fetch_xor_explicit", "atomic", "std::atomic_flag", "atomic", "std::atomic_flag_clear", "atomic", "std::atomic_flag_clear_explicit", "atomic", "std::atomic_flag_test_and_set", "atomic", "std::atomic_flag_test_and_set_explicit", "atomic", "std::atomic_init", "atomic", "std::atomic_int", "atomic", "std::atomic_int_fast16_t", "atomic", "std::atomic_int_fast32_t", "atomic", "std::atomic_int_fast64_t", "atomic", "std::atomic_int_fast8_t", "atomic", "std::atomic_int_least16_t", "atomic", "std::atomic_int_least32_t", "atomic", "std::atomic_int_least64_t", "atomic", "std::atomic_int_least8_t", "atomic", "std::atomic_intmax_t", "atomic", "std::atomic_intptr_t", "atomic", "std::atomic_is_lock_free", "atomic", "std::atomic_llong", "atomic", "std::atomic_load", "atomic", "std::atomic_load_explicit", "atomic", "std::atomic_long", "atomic", "std::atomic_ptrdiff_t", "atomic", "std::atomic_schar", "atomic", "std::atomic_short", "atomic", "std::atomic_signal_fence", "atomic", "std::atomic_size_t", "atomic", "std::atomic_store", "atomic", "std::atomic_store_explicit", "atomic", "std::atomic_thread_fence", "atomic", "std::atomic_uchar", "atomic", "std::atomic_uint", "atomic", "std::atomic_uint_fast16_t", "atomic", "std::atomic_uint_fast32_t", "atomic", "std::atomic_uint_fast64_t", "atomic", "std::atomic_uint_fast8_t", "atomic", "std::atomic_uint_least16_t", "atomic", "std::atomic_uint_least32_t", "atomic", "std::atomic_uint_least64_t", "atomic", "std::atomic_uint_least8_t", "atomic", "std::atomic_uintmax_t", "atomic", "std::atomic_uintptr_t", "atomic", "std::atomic_ullong", "atomic", "std::atomic_ulong", "atomic", "std::atomic_ushort", "atomic", "std::atomic_wchar_t", "atomic", "std::atto", "ratio", "std::auto_ptr", "memory", "std::back_insert_iterator", "iterator", "std::back_inserter", "iterator", "std::bad_alloc", "new", "std::bad_array_new_length", "new", "std::bad_cast", "typeinfo", "std::bad_exception", "exception", "std::bad_function_call", "functional", "std::bad_typeid", "typeinfo", "std::bad_weak_ptr", "memory", "std::basic_filebuf", "fstream", "std::basic_filebuf", "iosfwd", "std::basic_fstream", "fstream", "std::basic_fstream", "iosfwd", "std::basic_ifstream", "fstream", "std::basic_ifstream", "iosfwd", "std::basic_ios", "ios", "std::basic_ios", "iosfwd", "std::basic_iostream", "iosfwd", "std::basic_iostream", "istream", "std::basic_istream", "iosfwd", "std::basic_istream", "istream", "std::basic_istringstream", "iosfwd", "std::basic_istringstream", "sstream", "std::basic_ofstream", "fstream", "std::basic_ofstream", "iosfwd", "std::basic_ostream", "iosfwd", "std::basic_ostream", "ostream", "std::basic_ostringstream", "iosfwd", "std::basic_ostringstream", "sstream", "std::basic_regex", "regex", "std::basic_streambuf", "iosfwd", "std::basic_streambuf", "streambuf", "std::basic_string", "string", "std::basic_stringbuf", "iosfwd", "std::basic_stringbuf", "sstream", "std::basic_stringstream", "iosfwd", "std::basic_stringstream", "sstream", "std::begin", "initializer_list", "std::begin", "iterator", "std::begin", "valarray", "std::bernoulli_distribution", "random", "std::bidirectional_iterator_tag", "iterator", "std::binary_function", "functional", "std::binary_negate", "functional", "std::binary_search", "algorithm", "std::bind", "functional", "std::bind1st", "functional", "std::bind2nd", "functional", "std::binder1st", "functional", "std::binder2nd", "functional", "std::binomial_distribution", "random", "std::bit_and", "functional", "std::bit_or", "functional", "std::bit_xor", "functional", "std::bitset", "bitset", "std::boolalpha", "ios", "std::bsearch", "cstdlib", "std::btowc", "cwchar", "!(optional) std::c16rtomb", "cuchar", "!(optional) std::c32rtomb", "cuchar", "!(no_mingw) std::call_once", "mutex", "std::calloc", "cstdlib", "std::cauchy_distribution", "random", "!(cpp14+) std::cbegin", "iterator", "std::cbrt", "cmath", "std::ceil", "cmath", "!(cpp14+) std::cend", "iterator", "std::centi", "ratio", "std::cerr", "iostream", "std::char_traits", "iosfwd", "std::char_traits", "string", "std::chi_squared_distribution", "random", "std::chrono::duration", "chrono", "std::chrono::duration_cast", "chrono", "std::chrono::duration_values", "chrono", "std::chrono::high_resolution_clock", "chrono", "std::chrono::hours", "chrono", "std::chrono::microseconds", "chrono", "std::chrono::milliseconds", "chrono", "std::chrono::minutes", "chrono", "std::chrono::nanoseconds", "chrono", "std::chrono::seconds", "chrono", "std::chrono::steady_clock", "chrono", "std::chrono::system_clock", "chrono", "std::chrono::time_point", "chrono", "std::chrono::time_point_cast", "chrono", "std::chrono::treat_as_floating_point", "chrono", "std::cin", "iostream", "std::clearerr", "cstdio", "std::clock", "ctime", "std::clock_t", "ctime", "std::clog", "iostream", "std::codecvt", "locale", "std::codecvt_base", "locale", "std::codecvt_byname", "locale", "std::codecvt_mode", "codecvt", "std::codecvt_utf16", "codecvt", "std::codecvt_utf8", "codecvt", "std::codecvt_utf8_utf16", "codecvt", "std::collate", "locale", "std::collate", "regex", "std::collate_byname", "locale", "std::common_type", "type_traits", "std::complex", "complex", "!(no_mingw) std::condition_variable", "condition_variable", "!(no_mingw) std::condition_variable_any", "condition_variable", "std::conditional", "type_traits", "std::conj", "complex", "std::const_mem_fun1_ref_t", "functional", "std::const_mem_fun1_t", "functional", "std::const_mem_fun_ref_t", "functional", "std::const_mem_fun_t", "functional", "std::const_pointer_cast", "memory", "std::copy", "algorithm", "std::copy_backward", "algorithm", "std::copy_if", "algorithm", "std::copy_n", "algorithm", "std::copysign", "cmath", "std::cos", "cmath", "std::cos", "complex", "std::cos", "valarray", "std::cosh", "cmath", "std::cosh", "complex", "std::cosh", "valarray", "std::count", "algorithm", "std::count_if", "algorithm", "std::cout", "iostream", "!(cpp14+) std::crbegin", "iterator", "std::cref", "functional", "!(cpp14+) std::crend", "iterator", "std::ctime", "ctime", "std::ctype", "locale", "std::ctype_base", "locale", "std::ctype_byname", "locale", "std::current_exception", "exception", "!(no_mingw) std::cv_status", "condition_variable", "std::dec", "ios", "std::deca", "ratio", "std::decay", "type_traits", "std::deci", "ratio", "std::declare_no_pointers", "memory", "std::declare_reachable", "memory", "std::default_delete", "memory", "std::default_random_engine", "random", "std::defaultfloat", "ios", "std::defer_lock", "mutex", "std::defer_lock_t", "mutex", "std::deque", "deque", "std::difftime", "ctime", "std::discard_block_engine", "random", "std::discrete_distribution", "random", "std::distance", "iterator", "std::div", "cinttypes", "std::div", "cstdlib", "std::div_t", "cstdlib", "std::divides", "functional", "std::domain_error", "stdexcept", "std::double_t", "cmath", "std::dynamic_pointer_cast", "memory", "std::enable_if", "type_traits", "std::enable_shared_from_this", "memory", "std::end", "initializer_list", "std::end", "iterator", "std::end", "valarray", "std::endl", "ostream", "std::endl", "iostream", "std::ends", "ostream", "std::ends", "iostream", "std::equal", "algorithm", "std::equal_range", "algorithm", "std::equal_to", "functional", "std::erf", "cmath", "std::erfc", "cmath", "std::errc", "system_error", "std::error_category", "system_error", "std::error_code", "system_error", "std::error_condition", "system_error", "std::exa", "ratio", "std::exception", "exception", "std::exception_ptr", "exception", "std::exit", "cstdlib", "std::exp", "cmath", "std::exp", "complex", "std::exp", "valarray", "std::exp2", "cmath", "std::expm1", "cmath", "std::exponential_distribution", "random", "std::extent", "type_traits", "std::extreme_value_distribution", "random", "std::fabs", "cmath", "std::false_type", "type_traits", "std::fclose", "cstdio", "std::fdim", "cmath", "!(no_mingw) std::feclearexcept", "cfenv", "!(no_mingw) std::fegetenv", "cfenv", "!(no_mingw) std::fegetexceptflag", "cfenv", "!(no_mingw) std::fegetround", "cfenv", "!(no_mingw) std::feholdexcept", "cfenv", "std::femto", "ratio", "!(no_mingw) std::fenv_t", "cfenv", "std::feof", "cstdio", "!(no_mingw) std::feraiseexcept", "cfenv", "std::ferror", "cstdio", "!(no_mingw) std::fesetenv", "cfenv", "!(no_mingw) std::fesetexceptflag", "cfenv", "!(no_mingw) std::fesetround", "cfenv", "!(no_mingw) std::fetestexcept", "cfenv", "!(no_mingw) std::feupdateenv", "cfenv", "!(no_mingw) std::fexcept_t", "cfenv", "std::fflush", "cstdio", "std::fgetc", "cstdio", "std::fgetpos", "cstdio", "std::fgets", "cstdio", "std::fgetwc", "cwchar", "std::fgetws", "cwchar", "std::filebuf", "fstream", "std::filebuf", "iosfwd", "std::fill", "algorithm", "std::fill_n", "algorithm", "std::find", "algorithm", "std::find_end", "algorithm", "std::find_first_of", "algorithm", "std::find_if", "algorithm", "std::find_if_not", "algorithm", "std::fisher_f_distribution", "random", "std::fixed", "ios", "std::float_denorm_style", "limits", "std::float_round_style", "limits", "std::float_t", "cmath", "std::floor", "cmath", "std::flush", "ostream", "std::flush", "iostream", "std::fma", "cmath", "std::fmax", "cmath", "std::fmin", "cmath", "std::fmod", "cmath", "std::fopen", "cstdio", "std::for_each", "algorithm", "std::forward_as_tuple", "tuple", "std::forward_iterator_tag", "iterator", "std::forward_list", "forward_list", "std::fpclassify", "cmath", "std::fpos", "ios", "std::fpos_t", "cstdio", "std::fprintf", "cstdio", "std::fputc", "cstdio", "std::fputs", "cstdio", "std::fputwc", "cwchar", "std::fputws", "cwchar", "std::fread", "cstdio", "std::free", "cstdlib", "std::freopen", "cstdio", "std::frexp", "cmath", "std::front_insert_iterator", "iterator", "std::front_inserter", "iterator", "std::fscanf", "cstdio", "std::fseek", "cstdio", "std::fsetpos", "cstdio", "std::fstream", "fstream", "std::fstream", "iosfwd", "std::ftell", "cstdio", "std::function", "functional", "std::future", "future", "std::future_category", "future", "std::future_errc", "future", "std::future_error", "future", "std::future_status", "future", "std::fwide", "cwchar", "std::fwprintf", "cwchar", "std::fwrite", "cstdio", "std::fwscanf", "cwchar", "std::gamma_distribution", "random", "std::generate", "algorithm", "std::generate_canonical", "random", "std::generate_n", "algorithm", "std::generic_category", "system_error", "std::geometric_distribution", "random", "std::get_deleter", "memory", "std::get_money", "iomanip", "std::get_new_handler", "new", "std::get_pointer_safety", "memory", "std::get_temporary_buffer", "memory", "std::get_terminate", "exception", "std::get_time", "iomanip", "std::get_unexpected", "exception", "std::getc", "cstdio", "std::getchar", "cstdio", "std::getenv", "cstdlib", "std::getline", "string", "std::gets", "cstdio", "std::getwc", "cwchar", "std::getwchar", "cwchar", "std::giga", "ratio", "std::gmtime", "ctime", "std::greater", "functional", "std::greater_equal", "functional", "std::gslice", "valarray", "std::gslice_array", "valarray", "std::has_facet", "locale", "std::has_virtual_destructor", "type_traits", "std::hash", "functional", "std::hash", "memory", "std::hash", "typeindex", "std::hecto", "ratio", "std::hex", "ios", "std::hexfloat", "ios", "std::hypot", "cmath", "std::ifstream", "fstream", "std::ifstream", "iosfwd", "std::ignore", "tuple", "std::ilogb", "cmath", "std::imag", "complex", "std::imaxabs", "cinttypes", "std::imaxdiv", "cinttypes", "std::imaxdiv_t", "cinttypes", "std::includes", "algorithm", "std::independent_bits_engine", "random", "std::indirect_array", "valarray", "std::initializer_list", "initializer_list", "std::inner_product", "numeric", "std::inplace_merge", "algorithm", "std::input_iterator_tag", "iterator", "std::insert_iterator", "iterator", "std::inserter", "iterator", "std::int16_t", "cstdint", "std::int32_t", "cstdint", "std::int64_t", "cstdint", "std::int8_t", "cstdint", "std::int_fast16_t", "cstdint", "std::int_fast32_t", "cstdint", "std::int_fast64_t", "cstdint", "std::int_fast8_t", "cstdint", "std::int_least16_t", "cstdint", "std::int_least32_t", "cstdint", "std::int_least64_t", "cstdint", "std::int_least8_t", "cstdint", "std::integral_constant", "type_traits", "std::internal", "ios", "std::intmax_t", "cstdint", "std::intptr_t", "cstdint", "std::invalid_argument", "stdexcept", "std::io_errc", "ios", "std::ios", "ios", "std::ios_base", "ios", "std::iostream", "iosfwd", "std::iostream", "istream", "std::iostream_category", "ios", "std::iota", "numeric", "std::is_abstract", "type_traits", "std::is_arithmetic", "type_traits", "std::is_array", "type_traits", "std::is_assignable", "type_traits", "std::is_base_of", "type_traits", "std::is_bind_expression", "functional", "std::is_class", "type_traits", "std::is_compound", "type_traits", "std::is_const", "type_traits", "std::is_constructible", "type_traits", "std::is_convertible", "type_traits", "std::is_copy_assignable", "type_traits", "std::is_copy_constructible", "type_traits", "std::is_default_constructible", "type_traits", "std::is_destructible", "type_traits", "std::is_empty", "type_traits", "std::is_enum", "type_traits", "std::is_error_code_enum", "ios", "std::is_error_code_enum", "system_error", "std::is_error_condition_enum", "system_error", "std::is_floating_point", "type_traits", "std::is_function", "type_traits", "std::is_fundamental", "type_traits", "std::is_heap", "algorithm", "std::is_heap_until", "algorithm", "std::is_integral", "type_traits", "std::is_literal_type", "type_traits", "std::is_lvalue_reference", "type_traits", "std::is_member_function_pointer", "type_traits", "std::is_member_object_pointer", "type_traits", "std::is_member_pointer", "type_traits", "std::is_move_assignable", "type_traits", "std::is_move_constructible", "type_traits", "std::is_nothrow_assignable", "type_traits", "std::is_nothrow_constructible", "type_traits", "std::is_nothrow_copy_assignable", "type_traits", "std::is_nothrow_copy_constructible", "type_traits", "std::is_nothrow_default_constructible", "type_traits", "std::is_nothrow_destructible", "type_traits", "std::is_nothrow_move_assignable", "type_traits", "std::is_nothrow_move_constructible", "type_traits", "std::is_null_pointer", "type_traits", "std::is_object", "type_traits", "std::is_partitioned", "algorithm", "std::is_permutation", "algorithm", "std::is_placeholder", "functional", "std::is_pod", "type_traits", "std::is_pointer", "type_traits", "std::is_polymorphic", "type_traits", "std::is_reference", "type_traits", "std::is_rvalue_reference", "type_traits", "std::is_same", "type_traits", "std::is_scalar", "type_traits", "std::is_signed", "type_traits", "std::is_sorted", "algorithm", "std::is_sorted_until", "algorithm", "std::is_standard_layout", "type_traits", "std::is_trivial", "type_traits", "std::is_trivially_assignable", "type_traits", "std::is_trivially_constructible", "type_traits", "std::is_trivially_copy_assignable", "type_traits", "std::is_trivially_copy_constructible", "type_traits", "std::is_trivially_copyable", "type_traits", "std::is_trivially_default_constructible", "type_traits", "std::is_trivially_destructible", "type_traits", "std::is_trivially_move_assignable", "type_traits", "std::is_trivially_move_constructible", "type_traits", "std::is_union", "type_traits", "std::is_unsigned", "type_traits", "std::is_void", "type_traits", "std::is_volatile", "type_traits", "std::isalnum", "cctype", "std::isalnum", "locale", "std::isalpha", "cctype", "std::isalpha", "locale", "!(no_mingw) std::isblank", "cctype", "!(no_mingw) std::isblank", "locale", "std::iscntrl", "cctype", "std::iscntrl", "locale", "std::isdigit", "cctype", "std::isdigit", "locale", "std::isfinite", "cmath", "std::isgraph", "cctype", "std::isgraph", "locale", "std::isgreater", "cmath", "std::isgreaterequal", "cmath", "std::isinf", "cmath", "std::isless", "cmath", "std::islessequal", "cmath", "std::islessgreater", "cmath", "std::islower", "cctype", "std::islower", "locale", "std::isnan", "cmath", "std::isnormal", "cmath", "std::isprint", "cctype", "std::isprint", "locale", "std::ispunct", "cctype", "std::ispunct", "locale", "std::isspace", "cctype", "std::isspace", "locale", "std::istream", "iosfwd", "std::istream", "istream", "std::istream_iterator", "iterator", "std::istreambuf_iterator", "iterator", "std::istringstream", "sstream", "std::istrstream", "iosfwd", "std::istrstream", "strstream", "std::isunordered", "cmath", "std::isupper", "cctype", "std::isupper", "locale", "std::iswalnum", "cwctype", "std::iswalpha", "cwctype", "std::iswblank", "cwctype", "std::iswcntrl", "cwctype", "std::iswctype", "cwctype", "std::iswdigit", "cwctype", "std::iswgraph", "cwctype", "std::iswlower", "cwctype", "std::iswprint", "cwctype", "std::iswpunct", "cwctype", "std::iswspace", "cwctype", "std::iswupper", "cwctype", "std::iswxdigit", "cwctype", "std::isxdigit", "cctype", "std::isxdigit", "locale", "std::iter_swap", "algorithm", "std::iterator", "iterator", "std::iterator_traits", "iterator", "std::jmp_buf", "csetjmp", "std::kill_dependency", "atomic", "std::kilo", "ratio", "std::knuth_b", "random", "std::labs", "cstdlib", "std::launch", "future", "std::lconv", "clocale", "std::ldexp", "cmath", "std::ldiv", "cstdlib", "std::ldiv_t", "cstdlib", "std::left", "ios", "std::length_error", "stdexcept", "std::less", "functional", "std::less_equal", "functional", "std::lexicographical_compare", "algorithm", "std::lgamma", "cmath", "std::linear_congruential_engine", "random", "std::list", "list", "!(no_win) std::llabs", "cstdlib", "!(no_win) std::lldiv", "cstdlib", "!(no_win) std::lldiv_t", "cstdlib", "std::llrint", "cmath", "std::llround", "cmath", "std::locale", "locale", "std::localeconv", "clocale", "std::localtime", "ctime", "std::lock", "mutex", "std::lock_guard", "mutex", "std::log", "cmath", "std::log", "complex", "std::log", "valarray", "std::log10", "cmath", "std::log10", "complex", "std::log10", "valarray", "std::log1p", "cmath", "std::log2", "cmath", "std::logb", "cmath", "std::logic_error", "stdexcept", "std::logical_and", "functional", "std::logical_not", "functional", "std::logical_or", "functional", "std::lognormal_distribution", "random", "std::longjmp", "csetjmp", "std::lower_bound", "algorithm", "std::lrint", "cmath", "std::lround", "cmath", "std::make_error_code", "ios", "std::make_error_code", "system_error", "std::make_error_condition", "ios", "std::make_error_condition", "system_error", "std::make_exception_ptr", "exception", "std::make_heap", "algorithm", "std::make_move_iterator", "iterator", "!(cpp14+) std::make_reverse_iterator", "iterator", "std::make_shared", "memory", "std::make_signed", "type_traits", "std::make_tuple", "tuple", "!(cpp14+) std::make_unique", "memory", "std::make_unsigned", "type_traits", "std::malloc", "cstdlib", "std::map", "map", "std::mask_array", "valarray", "std::match_results", "regex", "std::max", "algorithm", "std::max_align_t", "cstddef", "std::max_element", "algorithm", "std::mblen", "cstdlib", "std::mbrlen", "cwchar", "std::mbrtowc", "cwchar", "!(optional) std::mbrtoc16", "cuchar", "!(optional) std::mbrtoc32", "cuchar", "std::mbsinit", "cwchar", "std::mbsrtowcs", "cwchar", "std::mbstate_t", "cwchar", "std::mbstowcs", "cstdlib", "std::mbtowc", "cstdlib", "std::mega", "ratio", "std::mem_fn", "functional", "std::mem_fun", "functional", "std::mem_fun1_ref_t", "functional", "std::mem_fun1_t", "functional", "std::mem_fun_ref", "functional", "std::mem_fun_ref_t", "functional", "std::mem_fun_t", "functional", "std::memchr", "cstring", "std::memcmp", "cstring", "std::memcpy", "cstring", "std::memmove", "cstring", "std::memory_order", "atomic", "std::memory_order_relaxed", "atomic", "std::memory_order_consume", "atomic", "std::memory_order_acquire", "atomic", "std::memory_order_release", "atomic", "std::memory_order_acq_rel", "atomic", "std::memory_order_seq_cst", "atomic", "std::memset", "cstring", "std::merge", "algorithm", "std::mersenne_twister_engine", "random", "std::messages", "locale", "std::messages_base", "locale", "std::messages_byname", "locale", "std::micro", "ratio", "std::milli", "ratio", "std::min", "algorithm", "std::min_element", "algorithm", "std::minmax", "algorithm", "std::minmax_element", "algorithm", "std::minstd_rand", "random", "std::minstd_rand0", "random", "std::minus", "functional", "std::mismatch", "algorithm", "std::mktime", "ctime", "std::modf", "cmath", "std::modulus", "functional", "std::money_base", "locale", "std::money_get", "locale", "std::money_put", "locale", "std::moneypunct", "locale", "std::moneypunct_byname", "locale", "std::move", "algorithm", "std::move", "utility", "std::move_backward", "algorithm", "std::move_iterator", "iterator", "std::mt19937", "random", "std::mt19937_64", "random", "std::multimap", "map", "std::multiplies", "functional", "std::multiset", "set", "!(no_mingw) std::mutex", "mutex", "std::nan", "cmath", "std::nanf", "cmath", "std::nanl", "cmath", "std::nano", "ratio", "std::nearbyint", "cmath", "std::negate", "functional", "std::negative_binomial_distribution", "random", "std::nested_exception", "exception", "std::new_handler", "new", "std::next", "iterator", "std::next_permutation", "algorithm", "std::nextafter", "cmath", "std::nexttoward", "cmath", "std::noboolalpha", "ios", "std::none_of", "algorithm", "std::norm", "complex", "std::normal_distribution", "random", "std::noshowbase", "ios", "std::noshowpoint", "ios", "std::noshowpos", "ios", "std::noskipws", "ios", "std::not1", "functional", "std::not2", "functional", "std::not_equal_to", "functional", "std::nothrow", "new", "std::nothrow_t", "new", "std::notify_all_at_thread_exit", "condition_variable", "std::nounitbuf", "ios", "std::nouppercase", "ios", "std::nth_element", "algorithm", "std::nullptr_t", "cstddef", "std::num_get", "locale", "std::num_put", "locale", "std::numeric_limits", "limits", "std::numpunct", "locale", "std::numpunct_byname", "locale", "std::oct", "ios", "std::ofstream", "fstream", "std::ofstream", "iosfwd", "!(no_mingw) std::once_flag", "mutex", "std::ostream", "iosfwd", "std::ostream", "ostream", "std::ostream_iterator", "iterator", "std::ostreambuf_iterator", "iterator", "std::ostringstream", "sstream", "std::ostrstream", "iosfwd", "std::ostrstream", "strstream", "std::out_of_range", "stdexcept", "std::output_iterator_tag", "iterator", "std::overflow_error", "stdexcept", "std::owner_less", "memory", "!(no_mingw) std::packaged_task", "future", "std::partial_sort", "algorithm", "std::partial_sort_copy", "algorithm", "std::partial_sum", "numeric", "std::partition", "algorithm", "std::partition_copy", "algorithm", "std::partition_point", "algorithm", "std::perror", "cstdio", "std::peta", "ratio", "std::pico", "ratio", "std::piecewise_constant_distribution", "random", "std::piecewise_linear_distribution", "random", "std::plus", "functional", "std::pointer_safety", "memory", "std::pointer_to_binary_function", "functional", "std::pointer_to_unary_function", "functional", "std::pointer_traits", "memory", "std::poisson_distribution", "random", "std::polar", "complex", "std::pop_heap", "algorithm", "std::pow", "cmath", "std::pow", "complex", "std::pow", "valarray", "std::prev", "iterator", "std::prev_permutation", "algorithm", "std::printf", "cstdio", "std::priority_queue", "queue", "std::proj", "complex", "!(no_mingw) std::promise", "future", "std::ptr_fun", "functional", "std::ptrdiff_t", "cstddef", "std::push_heap", "algorithm", "std::put_money", "iomanip", "std::put_time", "iomanip", "std::putc", "cstdio", "std::putchar", "cstdio", "std::puts", "cstdio", "std::putwc", "cwchar", "std::putwchar", "cwchar", "std::qsort", "cstdlib", "std::queue", "queue", "!(optional) std::quick_exit", "cstdlib", "!(cpp14+) std::quoted", "iomanip", "std::raise", "csignal", "std::rand", "cstdlib", "std::random_access_iterator_tag", "iterator", "std::random_shuffle", "algorithm", "std::range_error", "stdexcept", "std::rank", "type_traits", "std::ranlux24", "random", "std::ranlux24_base", "random", "std::ranlux48", "random", "std::ranlux48_base", "random", "std::ratio", "ratio", "std::ratio_add", "ratio", "std::ratio_divide", "ratio", "std::ratio_equal", "ratio", "std::ratio_greater", "ratio", "std::ratio_greater_equal", "ratio", "std::ratio_less", "ratio", "std::ratio_less_equal", "ratio", "std::ratio_multiply", "ratio", "std::ratio_not_equal", "ratio", "std::ratio_subtract", "ratio", "std::raw_storage_iterator", "memory", "!(cpp14+) std::rbegin", "iterator", "std::real", "complex", "std::realloc", "cstdlib", "!(no_mingw) std::recursive_mutex", "mutex", "std::recursive_timed_mutex", "mutex", "std::ref", "functional", "std::reference_wrapper", "functional", "std::regex_constants::ECMAScript", "regex", "std::regex_constants::awk", "regex", "std::regex_constants::basic", "regex", "std::regex_constants::collate", "locale", "std::regex_constants::collate", "regex", "std::regex_constants::egrep", "regex", "std::regex_constants::error_backref", "regex", "std::regex_constants::error_badbrace", "regex", "std::regex_constants::error_badrepeat", "regex", "std::regex_constants::error_brace", "regex", "std::regex_constants::error_brack", "regex", "std::regex_constants::error_collate", "regex", "std::regex_constants::error_complexity", "regex", "std::regex_constants::error_ctype", "regex", "std::regex_constants::error_escape", "regex", "std::regex_constants::error_paren", "regex", "std::regex_constants::error_range", "regex", "std::regex_constants::error_space", "regex", "std::regex_constants::error_stack", "regex", "std::regex_constants::error_type", "regex", "std::regex_constants::extended", "regex", "std::regex_constants::format_default", "regex", "std::regex_constants::format_first_only", "regex", "std::regex_constants::format_no_copy", "regex", "std::regex_constants::format_sed", "regex", "std::regex_constants::grep", "regex", "std::regex_constants::icase", "regex", "std::regex_constants::match_any", "regex", "std::regex_constants::match_continuous", "regex", "std::regex_constants::match_flag_type", "regex", "std::regex_constants::match_not_bol", "regex", "std::regex_constants::match_not_bow", "regex", "std::regex_constants::match_not_eol", "regex", "std::regex_constants::match_not_eow", "regex", "std::regex_constants::match_not_null", "regex", "std::regex_constants::match_prev_avail", "regex", "std::regex_constants::nosubs", "regex", "std::regex_constants::optimize", "regex", "std::regex_constants::syntax_option_type", "regex", "std::regex_error", "regex", "std::regex_iterator", "regex", "std::regex_match", "regex", "std::regex_replace", "regex", "std::regex_search", "regex", "std::regex_token_iterator", "regex", "std::regex_traits", "regex", "std::declval", "utility", "!(cpp14+) std::exchange", "utility", "std::forward", "utility", "std::get", "array", "std::get", "tuple", "std::get", "utility", "!(cpp14+) std::integer_sequence", "utility", "std::make_pair", "utility", "std::move_if_noexcept", "utility", "std::pair", "utility", "std::piecewise_construct", "utility", "std::piecewise_construct_t", "utility", "std::remainder", "cmath", "std::remove", "algorithm", "std::remove", "cstdio", "std::remove_all_extents", "type_traits", "std::remove_const", "type_traits", "std::remove_copy", "algorithm", "std::remove_copy_if", "algorithm", "std::remove_cv", "type_traits", "std::remove_extent", "type_traits", "std::remove_if", "algorithm", "std::remove_pointer", "type_traits", "std::remove_reference", "type_traits", "std::remove_volatile", "type_traits", "std::remquo", "cmath", "std::rename", "cstdio", "!(cpp14+) std::rend", "iterator", "std::replace", "algorithm", "std::replace_copy", "algorithm", "std::replace_copy_if", "algorithm", "std::replace_if", "algorithm", "std::resetiosflags", "iomanip", "std::result_of", "type_traits", "std::rethrow_exception", "exception", "std::rethrow_if_nested", "exception", "std::return_temporary_buffer", "memory", "std::reverse", "algorithm", "std::reverse_copy", "algorithm", "std::reverse_iterator", "iterator", "std::rewind", "cstdio", "std::right", "ios", "std::rint", "cmath", "std::rotate", "algorithm", "std::rotate_copy", "algorithm", "std::round", "cmath", "std::runtime_error", "stdexcept", "std::scalbln", "cmath", "std::scalbn", "cmath", "std::scanf", "cstdio", "std::scientific", "ios", "!(optional) std::scoped_allocator_adaptor", "scoped_allocator", "std::search", "algorithm", "std::search_n", "algorithm", "std::seed_seq", "random", "std::set", "set", "std::set_difference", "algorithm", "std::set_intersection", "algorithm", "std::set_new_handler", "new", "std::set_symmetric_difference", "algorithm", "std::set_terminate", "exception", "std::set_unexpected", "exception", "std::set_union", "algorithm", "std::setbase", "iomanip", "std::setbuf", "cstdio", "std::setfill", "iomanip", "std::setiosflags", "iomanip", "!(optional) std::setlocale", "clocale", "std::setprecision", "iomanip", "std::setvbuf", "cstdio", "std::setw", "iomanip", "!(no_mingw) std::shared_future", "future", "!(cpp14+) std::shared_lock", "shared_mutex", "!(cpp14+) std::shared_mutex", "shared_mutex", "std::shared_ptr", "memory", "!(cpp14+) std::shared_timed_mutex", "shared_mutex", "std::showbase", "ios", "std::showpoint", "ios", "std::showpos", "ios", "std::shuffle", "algorithm", "std::shuffle_order_engine", "random", "std::sig_atomic_t", "csignal", "std::signal", "csignal", "std::signbit", "cmath", "std::sin", "cmath", "std::sin", "complex", "std::sin", "valarray", "std::sinh", "cmath", "std::sinh", "complex", "std::sinh", "valarray", "std::size_t", "cstddef", "std::size_t", "cstdio", "std::size_t", "cstdlib", "std::size_t", "cstring", "std::size_t", "ctime", "std::size_t", "cwchar", "std::skipws", "ios", "std::slice", "valarray", "std::slice_array", "valarray", "!(no_win) std::snprintf", "cstdio", "std::sort", "algorithm", "std::sort_heap", "algorithm", "std::sprintf", "cstdio", "std::sqrt", "cmath", "std::sqrt", "complex", "std::sqrt", "valarray", "std::srand", "cstdlib", "std::sscanf", "cstdio", "std::stable_partition", "algorithm", "std::stable_sort", "algorithm", "std::stack", "stack", "std::static_pointer_cast", "memory", "!(no_win) std::stod", "string", "!(no_win) std::stof", "string", "!(no_win) std::stoi", "string", "!(no_win) std::stol", "string", "!(no_win) std::stold", "string", "!(no_win) std::stoll", "string", "!(no_win) std::stoul", "string", "!(no_win) std::stoull", "string", "std::strcat", "cstring", "std::strchr", "cstring", "std::strcmp", "cstring", "std::strcoll", "cstring", "std::strcpy", "cstring", "std::strcspn", "cstring", "std::streambuf", "iosfwd", "std::streambuf", "streambuf", "std::streamoff", "ios", "std::streampos", "iosfwd", "std::streamsize", "ios", "std::strerror", "cstring", "std::strftime", "ctime", "std::string", "string", "std::stringbuf", "iosfwd", "std::stringbuf", "sstream", "std::stringstream", "iosfwd", "std::stringstream", "sstream", "std::strlen", "cstring", "std::strncat", "cstring", "std::strncmp", "cstring", "std::strncpy", "cstring", "std::strpbrk", "cstring", "std::strrchr", "cstring", "std::strspn", "cstring", "std::strstr", "cstring", "std::strstream", "iosfwd", "std::strstream", "strstream", "std::strstreambuf", "iosfwd", "std::strstreambuf", "strstream", "std::strtod", "cstdlib", "!(no_win) std::strtof", "cstdlib", "std::strtoimax", "cinttypes", "std::strtok", "cstring", "std::strtol", "cstdlib", "!(no_win) std::strtold", "cstdlib", "!(no_win) std::strtoll", "cstdlib", "std::strtoul", "cstdlib", "!(no_win) std::strtoull", "cstdlib", "std::strtoumax", "cinttypes", "std::strxfrm", "cstring", "std::student_t_distribution", "random", "std::sub_match", "regex", "std::subtract_with_carry_engine", "random", "std::swap", "algorithm", "std::swap", "utility", "std::swap_ranges", "algorithm", "!(no_mingw) std::swprintf", "cwchar", "std::swscanf", "cwchar", "std::system", "cstdlib", "std::system_category", "system_error", "std::system_error", "system_error", "std::tan", "cmath", "std::tan", "complex", "std::tan", "valarray", "std::tanh", "cmath", "std::tanh", "complex", "std::tanh", "valarray", "std::tera", "ratio", "std::terminate", "exception", "std::terminate_handler", "exception", "std::tgamma", "cmath", "!(no_mingw) std::this_thread::get_id", "thread", "!(no_mingw) std::this_thread::sleep_for", "thread", "!(no_mingw) std::this_thread::sleep_until", "thread", "!(no_mingw) std::this_thread::yield", "thread", "!(no_mingw) std::thread", "thread", "std::throw_with_nested", "exception", "std::tie", "tuple", "std::time", "ctime", "std::time_base", "locale", "std::time_get", "locale", "std::time_get_byname", "locale", "std::time_put", "locale", "std::time_put_byname", "locale", "std::time_t", "ctime", "std::timed_mutex", "mutex", "std::tm", "ctime", "std::tm", "cwchar", "std::tmpfile", "cstdio", "std::tmpnam", "cstdio", "!(no_win) std::to_string", "string", "!(no_win) std::to_wstring", "string", "std::tolower", "cctype", "std::tolower", "locale", "std::toupper", "cctype", "std::toupper", "locale", "std::towctrans", "cwctype", "std::towlower", "cwctype", "std::towupper", "cwctype", "std::transform", "algorithm", "std::true_type", "type_traits", "std::trunc", "cmath", "std::try_lock", "mutex", "std::try_to_lock", "mutex", "std::try_to_lock_t", "mutex", "std::tuple", "tuple", "std::tuple", "utility", "std::tuple_cat", "tuple", "std::type_index", "typeindex", "std::type_info", "typeinfo", "std::u16string", "string", "std::u32string", "string", "std::uint16_t", "cstdint", "std::uint32_t", "cstdint", "std::uint64_t", "cstdint", "std::uint8_t", "cstdint", "std::uint_fast16_t", "cstdint", "std::uint_fast32_t", "cstdint", "std::uint_fast64_t", "cstdint", "std::uint_fast8_t", "cstdint", "std::uint_least16_t", "cstdint", "std::uint_least32_t", "cstdint", "std::uint_least64_t", "cstdint", "std::uint_least8_t", "cstdint", "std::uintmax_t", "cstdint", "std::uintptr_t", "cstdint", "std::unary_function", "functional", "std::unary_negate", "functional", "std::uncaught_exception", "exception", "!(optional) std::uncaught_exceptions", "exception", "std::undeclare_no_pointers", "memory", "std::undeclare_reachable", "memory", "std::underflow_error", "stdexcept", "std::underlying_type", "type_traits", "std::unexpected", "exception", "std::unexpected_handler", "exception", "std::ungetc", "cstdio", "std::ungetwc", "cwchar", "std::uniform_int_distribution", "random", "std::uniform_real_distribution", "random", "std::uninitialized_copy", "memory", "std::uninitialized_copy_n", "memory", "std::uninitialized_fill", "memory", "std::uninitialized_fill_n", "memory", "std::unique", "algorithm", "std::unique_copy", "algorithm", "std::unique_lock", "mutex", "std::unique_ptr", "memory", "std::unitbuf", "ios", "std::unordered_map", "unordered_map", "std::unordered_multimap", "unordered_map", "std::unordered_multiset", "unordered_set", "std::unordered_set", "unordered_set", "std::upper_bound", "algorithm", "std::uppercase", "ios", "std::use_facet", "locale", "std::uses_allocator", "memory", "std::uses_allocator", "queue", "std::uses_allocator", "stack", "std::va_list", "cstdarg", "std::valarray", "valarray", "std::vector", "vector", "std::vfprintf", "cstdio", "!(no_win) std::vfscanf", "cstdio", "std::vfwprintf", "cwchar", "std::vfwscanf", "cwchar", "std::vprintf", "cstdio", "!(no_win) std::vscanf", "cstdio", "!(no_win) std::vsnprintf", "cstdio", "std::vsprintf", "cstdio", "!(no_win) std::vsscanf", "cstdio", "!(no_mingw) std::vswprintf", "cwchar", "std::vswscanf", "cwchar", "std::vwprintf", "cwchar", "std::vwscanf", "cwchar", "std::wbuffer_convert", "locale", "std::wcerr", "iostream", "std::wcin", "iostream", "std::wclog", "iostream", "std::wcout", "iostream", "std::wcrtomb", "cwchar", "std::wcscat", "cwchar", "std::wcschr", "cwchar", "std::wcscmp", "cwchar", "std::wcscoll", "cwchar", "std::wcscpy", "cwchar", "std::wcscspn", "cwchar", "std::wcsftime", "ctime", "std::wcsftime", "cwchar", "std::wcslen", "cwchar", "std::wcsncat", "cwchar", "std::wcsncmp", "cwchar", "std::wcsncpy", "cwchar", "std::wcspbrk", "cwchar", "std::wcsrchr", "cwchar", "std::wcsrtombs", "cwchar", "std::wcsspn", "cwchar", "std::wcsstr", "cwchar", "std::wcstod", "cwchar", "std::wcstof", "cwchar", "std::wcstoimax", "cinttypes", "std::wcstok", "cwchar", "std::wcstol", "cwchar", "!(no_win) std::wcstold", "cwchar", "!(no_win) std::wcstoll", "cwchar", "std::wcstombs", "cstdlib", "std::wcstoul", "cwchar", "!(no_win) std::wcstoull", "cwchar", "std::wcstoumax", "cinttypes", "std::wcsxfrm", "cwchar", "std::wctob", "cwchar", "std::wctomb", "cstdlib", "std::wctrans", "cwctype", "std::wctrans_t", "cwctype", "std::wctype", "cwctype", "std::wctype_t", "cwctype", "std::weak_ptr", "memory", "std::weibull_distribution", "random", "std::wfilebuf", "fstream", "std::wfilebuf", "iosfwd", "std::wfstream", "fstream", "std::wfstream", "iosfwd", "std::wifstream", "fstream", "std::wifstream", "iosfwd", "std::wint_t", "cwchar", "std::wint_t", "cwctype", "std::wios", "iosfwd", "std::wiostream", "iosfwd", "std::wiostream", "istream", "std::wistream", "iosfwd", "std::wistream", "istream", "std::wistringstream", "sstream", "std::wmemchr", "cwchar", "std::wmemcmp", "cwchar", "std::wmemcpy", "cwchar", "std::wmemmove", "cwchar", "std::wmemset", "cwchar", "std::wofstream", "fstream", "std::wofstream", "iosfwd", "std::wostream", "iosfwd", "std::wostream", "ostream", "std::wostringstream", "sstream", "std::wprintf", "cwchar", "std::ws", "istream", "std::wscanf", "cwchar", "std::wstreambuf", "iosfwd", "std::wstreambuf", "streambuf", "std::wstreampos", "iosfwd", "std::wstring", "string", "std::wstring_convert", "locale", "std::wstringbuf", "iosfwd", "std::wstringbuf", "sstream", "std::wstringstream", "iosfwd", "std::wstringstream", "sstream", "!(optional) std::yocto", "ratio", "!(optional) std::yotta", "ratio", "!(optional) std::zepto", "ratio", "!(optional) std::zetta", "ratio", "stderr", "cstdio", "stdin", "cstdio", "stdout", "cstdio", "strcat", "cstring", "strchr", "cstring", "strcmp", "cstring", "strcoll", "cstring", "strcpy", "cstring", "strcspn", "cstring", "strerror", "cstring", "strftime", "ctime", "strlen", "cstring", "strncat", "cstring", "strncmp", "cstring", "strncpy", "cstring", "strpbrk", "cstring", "strrchr", "cstring", "strspn", "cstring", "strstr", "cstring", "strtod", "cstdlib", "strtof", "cstdlib", "strtoimax", "cinttypes", "strtok", "cstring", "strtol", "cstdlib", "strtold", "cstdlib", "strtoll", "cstdlib", "strtoul", "cstdlib", "strtoull", "cstdlib", "strtoumax", "cinttypes", "strxfrm", "cstring", "!(no_mingw) swprintf", "cwchar", "swscanf", "cwchar", "system", "cstdlib", "tan", "cmath", "tan", "complex", "tan", "valarray", "tanh", "cmath", "tanh", "complex", "tanh", "valarray", "tgamma", "cmath", "time", "ctime", "time_t", "ctime", "tm", "ctime", "tm", "cwchar", "tmpfile", "cstdio", "tmpnam", "cstdio", "tolower", "cctype", "tolower", "locale", "toupper", "cctype", "toupper", "locale", "towctrans", "cwctype", "towlower", "cwctype", "towupper", "cwctype", "trunc", "cmath", "uint16_t", "cstdint", "uint32_t", "cstdint", "uint64_t", "cstdint", "uint8_t", "cstdint", "uint_fast16_t", "cstdint", "uint_fast32_t", "cstdint", "uint_fast64_t", "cstdint", "uint_fast8_t", "cstdint", "uint_least16_t", "cstdint", "uint_least32_t", "cstdint", "uint_least64_t", "cstdint", "uint_least8_t", "cstdint", "uintmax_t", "cstdint", "uintptr_t", "cstdint", "ungetc", "cstdio", "ungetwc", "cwchar", "va_arg", "cstdarg", "va_copy", "cstdarg", "va_end", "cstdarg", "va_list", "cstdarg", "va_start", "cstdarg", "vfprintf", "cstdio", "vfscanf", "cstdio", "vfwprintf", "cwchar", "vfwscanf", "cwchar", "vprintf", "cstdio", "vscanf", "cstdio", "vsnprintf", "cstdio", "vsprintf", "cstdio", "vsscanf", "cstdio", "!(no_mingw) vswprintf", "cwchar", "vswscanf", "cwchar", "vwprintf", "cwchar", "vwscanf", "cwchar", "wcrtomb", "cwchar", "wcscat", "cwchar", "wcschr", "cwchar", "wcscmp", "cwchar", "wcscoll", "cwchar", "wcscpy", "cwchar", "wcscspn", "cwchar", "wcsftime", "ctime", "wcsftime", "cwchar", "wcslen", "cwchar", "wcsncat", "cwchar", "wcsncmp", "cwchar", "wcsncpy", "cwchar", "wcspbrk", "cwchar", "wcsrchr", "cwchar", "wcsrtombs", "cwchar", "wcsspn", "cwchar", "wcsstr", "cwchar", "wcstod", "cwchar", "wcstof", "cwchar", "wcstoimax", "cinttypes", "wcstok", "cwchar", "wcstol", "cwchar", "wcstold", "cwchar", "wcstoll", "cwchar", "wcstombs", "cstdlib", "wcstoul", "cwchar", "wcstoull", "cwchar", "wcstoumax", "cinttypes", "wcsxfrm", "cwchar", "wctob", "cwchar", "wctomb", "cstdlib", "wctrans", "cwctype", "wctrans_t", "cwctype", "wctype", "cwctype", "wctype_t", "cwctype", "wint_t", "cwchar", "wint_t", "cwctype", "wmemchr", "cwchar", "wmemcmp", "cwchar", "wmemcpy", "cwchar", "wmemmove", "cwchar", "wmemset", "cwchar", "wprintf", "cwchar", "wscanf", "cwchar"};
        STD_NAME_TO_HEADER = OCIncludeSuggester.readImportData(rawImportData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCIncludeSuggester";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCIncludeSuggester";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecommendedHeaderNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdNameToHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRecommendedHeaderNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ImportData {
        @NotNull
        public final List<Import> imports = new ArrayList<Import>();
        @NotNull
        public final List<String> rawImports = new ArrayList<String>();

        public void addImport(@NotNull Import anImport) {
            if (anImport == null) {
                ImportData.$$$reportNull$$$0(0);
            }
            this.imports.add(anImport);
            this.rawImports.add(anImport.header);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anImport", "com/jetbrains/cidr/lang/quickfixes/OCIncludeSuggester$ImportData", "addImport"));
        }
    }

    public static class Import {
        @NotNull
        public final String header;
        @NotNull
        public final Availability availability;

        public Import(@NotNull String header, @NotNull Availability availability) {
            if (header == null) {
                Import.$$$reportNull$$$0(0);
            }
            if (availability == null) {
                Import.$$$reportNull$$$0(1);
            }
            this.header = header;
            this.availability = availability;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "header";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "availability";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/quickfixes/OCIncludeSuggester$Import";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Availability {
        REQUIRED,
        CLANG_ONLY,
        CPP14_PLUS,
        NO_WINDOWS,
        NO_MINGW,
        MINGW_NON_STANDARD,
        OPTIONAL,
        FORBIDDEN;

    }
}

