/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForCallable;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForStatement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSuppressClangDiagnosticIntentionAction
extends SuppressIntentionAction {
    private SmartPsiElementPointer<PsiElement> myElementPtr;
    private String myCompiler;
    private String mySuppressOption;
    private String mySuppressScope;

    protected OCSuppressClangDiagnosticIntentionAction(@Nullable PsiElement element, @Nullable OCSuppressionGroup suppressionGroup, String suppressScope) {
        this.myElementPtr = OCElementUtil.createPsiElementPointer(element);
        this.myCompiler = suppressionGroup == null ? null : suppressionGroup.compiler;
        this.mySuppressOption = suppressionGroup == null ? null : suppressionGroup.suppressionOption;
        this.mySuppressScope = suppressScope;
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message("intentions.suppress.for", this.mySuppressScope);
        if (string == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message("intentions.suppress.option.for", this.mySuppressOption, this.mySuppressScope);
        if (string == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    protected TextRange getSuppressionRange(OCFile file) {
        PsiElement element = OCElementUtil.getPsiElementByPointer(this.myElementPtr);
        return element != null ? OCElementUtil.getRangeWithMacros(element) : null;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(3);
        }
        return element.isValid() && this.myElementPtr != null && this.mySuppressOption != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(5);
        }
        OCFile file = (OCFile)element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)file);
        int elementOffset = OCElementUtil.getRangeWithMacros(element).getStartOffset();
        TextRange suppressionRange = this.getSuppressionRange(file);
        if (document == null || suppressionRange == null) {
            return;
        }
        if (OCPragmaSuppressionUtils.getDiagnosticMode(file, elementOffset, this.mySuppressOption) == OCPragma.Mode.IGNORE) {
            return;
        }
        int startLine = document.getLineNumber(suppressionRange.getStartOffset());
        int endLine = document.getLineNumber(suppressionRange.getEndOffset());
        if (startLine >= 0 && startLine < document.getLineCount() && endLine >= 0 && endLine < document.getLineCount()) {
            int startOffset = document.getLineStartOffset(startLine);
            int endOffset = document.getLineEndOffset(endLine);
            boolean pushToStack = true;
            if (OCPragmaSuppressionUtils.findExactScope(file, startOffset, endOffset) != null) {
                pushToStack = false;
            }
            if (pushToStack) {
                document.insertString(endOffset, (CharSequence)"\n#pragma clang diagnostic pop");
            }
            document.insertString(startOffset, (CharSequence)("#pragma " + this.myCompiler + " diagnostic ignored \"" + this.mySuppressOption + "\"\n"));
            if (pushToStack) {
                document.insertString(startOffset, (CharSequence)"#pragma clang diagnostic push\n");
            }
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SuppressFixForFile
    extends SuppressFix {
        public SuppressFixForFile(@Nullable OCSuppressionGroup suppressionGroup) {
            super(suppressionGroup);
        }

        @Override
        @NotNull
        protected OCSuppressClangDiagnosticIntentionAction createFix(PsiElement element) {
            return new OCSuppressClangForFile((OCFile)element.getContainingFile(), OCElementUtil.getRangeWithMacros(element), this.mySuppressionGroup);
        }

        @NotNull
        public String getName() {
            String string = OCInspectionsBundle.message("intentions.suppress.for.file", new Object[0]);
            if (string == null) {
                SuppressFixForFile.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFixForFile", "getName"));
        }
    }

    public static class SuppressFixForCallable
    extends SuppressFix {
        public SuppressFixForCallable(@Nullable OCSuppressionGroup suppressionGroup) {
            super(suppressionGroup);
        }

        @Override
        @NotNull
        protected OCSuppressClangDiagnosticIntentionAction createFix(PsiElement element) {
            return new OCSuppressClangForCallable(element.getContainingFile(), OCElementUtil.getRangeWithMacros(element), this.mySuppressionGroup);
        }

        @NotNull
        public String getName() {
            String string = OCInspectionsBundle.message("intentions.suppress.for.method", new Object[0]);
            if (string == null) {
                SuppressFixForCallable.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFixForCallable", "getName"));
        }
    }

    public static class SuppressFixForStatement
    extends SuppressFix {
        public SuppressFixForStatement(@Nullable OCSuppressionGroup suppressionGroup) {
            super(suppressionGroup);
        }

        @Override
        @NotNull
        protected OCSuppressClangDiagnosticIntentionAction createFix(PsiElement element) {
            return new OCSuppressClangForStatement(element.getContainingFile(), OCElementUtil.getRangeWithMacros(element), this.mySuppressionGroup);
        }

        @NotNull
        public String getName() {
            String string = OCInspectionsBundle.message("intentions.suppress.for.statement", new Object[0]);
            if (string == null) {
                SuppressFixForStatement.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFixForStatement", "getName"));
        }
    }

    private static abstract class SuppressFix
    implements SuppressQuickFix {
        @Nullable
        protected OCSuppressionGroup mySuppressionGroup;

        protected SuppressFix(@Nullable OCSuppressionGroup suppressionGroup) {
            this.mySuppressionGroup = suppressionGroup;
        }

        @NotNull
        protected abstract OCSuppressClangDiagnosticIntentionAction createFix(PsiElement var1);

        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            if (project == null) {
                SuppressFix.$$$reportNull$$$0(0);
            }
            if (context == null) {
                SuppressFix.$$$reportNull$$$0(1);
            }
            return this.createFix(context).isAvailable(project, null, context);
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                SuppressFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                SuppressFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                SuppressFix.$$$reportNull$$$0(4);
            }
            this.createFix(descriptor.getPsiElement()).invoke(project, null, descriptor.getPsiElement());
        }

        public boolean isSuppressAll() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

