/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class OCCallableKind
extends Enum<OCCallableKind> {
    public static final /* enum */ OCCallableKind METHOD = new OCCallableKind();
    public static final /* enum */ OCCallableKind FUNCTION = new OCCallableKind();
    public static final /* enum */ OCCallableKind BLOCK = new OCCallableKind();
    public static final /* enum */ OCCallableKind LAMBDA = new OCCallableKind();
    private static final /* synthetic */ OCCallableKind[] $VALUES;

    public static OCCallableKind[] values() {
        return (OCCallableKind[])$VALUES.clone();
    }

    public static OCCallableKind valueOf(String name) {
        return Enum.valueOf(OCCallableKind.class, name);
    }

    @NotNull
    @Nls
    public String getPresentableName() {
        switch (this) {
            case METHOD: {
                String string = OCBundle.message("method", new Object[0]);
                if (string == null) {
                    OCCallableKind.$$$reportNull$$$0(0);
                }
                return string;
            }
            case FUNCTION: {
                String string = OCBundle.message("function", new Object[0]);
                if (string == null) {
                    OCCallableKind.$$$reportNull$$$0(1);
                }
                return string;
            }
            case BLOCK: {
                String string = OCBundle.message("block", new Object[0]);
                if (string == null) {
                    OCCallableKind.$$$reportNull$$$0(2);
                }
                return string;
            }
            case LAMBDA: {
                String string = OCBundle.message("lambda", new Object[0]);
                if (string == null) {
                    OCCallableKind.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        throw new IllegalStateException("Presentable name for " + this.name() + " is not available");
    }

    @NotNull
    public String toString() {
        switch (this) {
            case METHOD: {
                return "Method";
            }
            case FUNCTION: {
                return "Function";
            }
            case BLOCK: {
                return "Block";
            }
            case LAMBDA: {
                return "Lambda";
            }
        }
        throw new IllegalStateException(this.name());
    }

    public String toStringLowercase() {
        return StringUtil.decapitalize((String)this.toString());
    }

    public OCSymbolKind getSymbolKind() {
        switch (this) {
            case METHOD: {
                return OCSymbolKind.METHOD;
            }
            case FUNCTION: {
                return OCSymbolKind.FUNCTION_DECLARATION;
            }
            case BLOCK: {
                return OCSymbolKind.BLOCK;
            }
            case LAMBDA: {
                return OCSymbolKind.LAMBDA;
            }
        }
        return null;
    }

    public static OCCallableKind parse(String value) {
        for (OCCallableKind kind : OCCallableKind.values()) {
            if (!kind.toString().equals(value)) continue;
            return kind;
        }
        assert (false) : "Unknown callable kind: " + value;
        return null;
    }

    static {
        $VALUES = new OCCallableKind[]{METHOD, FUNCTION, BLOCK, LAMBDA};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/changeSignature/OCCallableKind", "getPresentableName"));
    }
}

