/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCMethodDescriptor
implements MethodDescriptor<OCParameterInfo, Object> {
    @NotNull
    private final OCCallable myCallable;
    private final OCSymbol mySymbol;
    private final String myName;
    private boolean mySureIsConstructor;
    private boolean myChangeCallableKindPossible;
    private final List<OCParameterInfo> myParameters;
    private final OCClassDeclaration myContainerClass;
    private final List<OCReferenceExpression> mySelfReferences;

    public OCMethodDescriptor(OCBlockExpression block) {
        this(block, "", block.getParameterList());
    }

    public OCMethodDescriptor(OCFunctionDeclaration function) {
        this(function, function.getSymbolName(), function.getParameterList());
    }

    public OCMethodDescriptor(@NotNull OCMethod method) {
        if (method == null) {
            OCMethodDescriptor.$$$reportNull$$$0(0);
        }
        this.myParameters = new ArrayList<OCParameterInfo>();
        this.mySelfReferences = new ArrayList<OCReferenceExpression>();
        this.myCallable = method;
        this.mySymbol = method.getSymbol();
        this.myName = method.getSelector();
        this.myContainerClass = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)method, OCClassDeclaration.class);
        int index = 0;
        for (OCMethodSelectorPart part : method.getParameters()) {
            OCTypeElement typeElement = part.getTypeElement();
            OCType type = typeElement != null ? typeElement.getType() : null;
            OCParameterInfo parameterInfo = new OCParameterInfo(part.getSelectorPart(), part.getParameterName(), type, index++, method);
            if (typeElement != null) {
                parameterInfo.setTypeText(typeElement.getTextWithMacros());
            }
            this.myParameters.add(parameterInfo);
        }
        OCBlockStatement body = method.getBody();
        if (body != null) {
            body.accept(new OCRecursiveVisitor(){

                @Override
                public void visitReferenceExpression(OCReferenceExpression expression) {
                    if (expression.getSelfSuperToken() != null) {
                        OCMethodDescriptor.this.mySelfReferences.add(expression);
                    }
                }
            });
        }
    }

    private OCMethodDescriptor(@NotNull OCCallable callable, String name, OCParameterList parameterList) {
        if (callable == null) {
            OCMethodDescriptor.$$$reportNull$$$0(1);
        }
        this.myParameters = new ArrayList<OCParameterInfo>();
        this.mySelfReferences = new ArrayList<OCReferenceExpression>();
        this.myCallable = callable;
        this.mySymbol = callable.getSymbol();
        this.myName = name;
        this.myContainerClass = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)callable, OCClassDeclaration.class);
        if (parameterList == null) {
            return;
        }
        int index = 0;
        for (OCParameterDeclaration param : parameterList.getParameterDeclarations()) {
            OCDeclarator declarator = param.getDeclarator();
            if (declarator == null) continue;
            PsiElement nameIdentifier = declarator.getNameIdentifier();
            String paramName = nameIdentifier != null ? nameIdentifier.getText() : "";
            OCParameterInfo parameterInfo = new OCParameterInfo("", paramName, declarator.getType(), index++, callable);
            String typeText = OCElementUtil.getTypeTextWithModifiers(param);
            if (typeText != null) {
                parameterInfo.setTypeText(typeText);
            }
            if (declarator.getInitializer() != null) {
                parameterInfo.setInitializer(declarator.getInitializer());
            }
            parameterInfo.setEllipsisType(param.isEllipsis());
            this.myParameters.add(parameterInfo);
        }
    }

    @NotNull
    public static OCMethodDescriptor createMethodDescriptor(@NotNull OCCallable callable) {
        if (callable == null) {
            OCMethodDescriptor.$$$reportNull$$$0(2);
        }
        if (callable instanceof OCFunctionDeclaration) {
            return new OCMethodDescriptor((OCFunctionDeclaration)callable);
        }
        if (callable instanceof OCBlockExpression) {
            return new OCMethodDescriptor((OCBlockExpression)callable);
        }
        if (callable instanceof OCMethod) {
            return new OCMethodDescriptor((OCMethod)callable);
        }
        assert (false);
        if (null == null) {
            OCMethodDescriptor.$$$reportNull$$$0(3);
        }
        return null;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public List<OCParameterInfo> getParameters() {
        ArrayList<OCParameterInfo> parameters = new ArrayList<OCParameterInfo>(this.myParameters.size());
        for (OCParameterInfo parameter : this.myParameters) {
            parameters.add(parameter.clone());
        }
        ArrayList<OCParameterInfo> arrayList = parameters;
        if (arrayList == null) {
            OCMethodDescriptor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public OCParameterInfo getParameter(int index) {
        return this.myParameters.get(index).clone();
    }

    public int getParametersCount() {
        return this.myParameters.size();
    }

    public OCType getReturnType() {
        return this.myCallable.getReturnType();
    }

    public OCSymbol getMethodSymbol() {
        return this.mySymbol;
    }

    public boolean isConstructor() {
        return this.mySureIsConstructor || this.mySymbol != null && this.mySymbol.getKind().isConstructorOrDestructor();
    }

    public boolean isChangeCallableKindPossible() {
        return this.myChangeCallableKindPossible;
    }

    public void setChangeCallableKindPossible(boolean changeCallableKindPossible) {
        this.myChangeCallableKindPossible = changeCallableKindPossible;
    }

    public void setSureIsConstructor(boolean sureIsConstructor) {
        this.mySureIsConstructor = sureIsConstructor;
    }

    public String getReturnTypeText(PsiElement context) {
        if (this.mySymbol instanceof OCMemberSymbol && this.myCallable.getReturnType().isVoid() && this.mySymbol.hasAttribute("ibaction")) {
            return "IBAction";
        }
        OCTypeElement returnTypeElement = this.myCallable.getReturnTypeElement();
        if (returnTypeElement == null) {
            return this.myCallable.getReturnType().getBestNameInContext((PsiElement)(context != null ? context : this.myCallable));
        }
        if (this.myCallable instanceof OCFunctionDeclaration) {
            return OCElementUtil.getTypeTextWithModifiers((OCFunctionDeclaration)this.myCallable);
        }
        return returnTypeElement.getTextWithMacros();
    }

    @NotNull
    public Object getVisibility() {
        OCCallableKind oCCallableKind = this.getCallableKind();
        if (oCCallableKind == null) {
            OCMethodDescriptor.$$$reportNull$$$0(5);
        }
        return oCCallableKind;
    }

    public List<OCReferenceExpression> getSelfReferences() {
        return this.mySelfReferences;
    }

    @NotNull
    public OCCallableKind getCallableKind() {
        if (this.myCallable instanceof OCMethod) {
            OCCallableKind oCCallableKind = OCCallableKind.METHOD;
            if (oCCallableKind == null) {
                OCMethodDescriptor.$$$reportNull$$$0(6);
            }
            return oCCallableKind;
        }
        if (this.myCallable instanceof OCFunctionDeclaration) {
            OCCallableKind oCCallableKind = OCCallableKind.FUNCTION;
            if (oCCallableKind == null) {
                OCMethodDescriptor.$$$reportNull$$$0(7);
            }
            return oCCallableKind;
        }
        if (this.myCallable instanceof OCBlockExpression) {
            OCCallableKind oCCallableKind = OCCallableKind.BLOCK;
            if (oCCallableKind == null) {
                OCMethodDescriptor.$$$reportNull$$$0(8);
            }
            return oCCallableKind;
        }
        if (this.myCallable instanceof OCLambdaExpression) {
            OCCallableKind oCCallableKind = OCCallableKind.LAMBDA;
            if (oCCallableKind == null) {
                OCMethodDescriptor.$$$reportNull$$$0(9);
            }
            return oCCallableKind;
        }
        assert (false);
        if (null == null) {
            OCMethodDescriptor.$$$reportNull$$$0(10);
        }
        return null;
    }

    public OCClassDeclaration getContainerClass() {
        return this.myContainerClass;
    }

    @NotNull
    public OCCallable getMethod() {
        OCCallable oCCallable = this.myCallable;
        if (oCCallable == null) {
            OCMethodDescriptor.$$$reportNull$$$0(11);
        }
        return oCCallable;
    }

    public boolean canChangeVisibility() {
        return true;
    }

    public boolean canChangeParameters() {
        return true;
    }

    @NotNull
    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        MethodDescriptor.ReadWriteOption readWriteOption = this.isConstructor() ? MethodDescriptor.ReadWriteOption.None : MethodDescriptor.ReadWriteOption.ReadWrite;
        if (readWriteOption == null) {
            OCMethodDescriptor.$$$reportNull$$$0(12);
        }
        return readWriteOption;
    }

    public boolean canChangeName() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCMethodDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCMethodDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallableKind";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "canChangeReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createMethodDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

