/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCEmptyChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseExpressionInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseLocalConvertibleHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;

public class OCParameterInplaceIntroducer
extends OCBaseExpressionInplaceIntroducer<PsiNameIdentifierOwner, PsiElement> {
    private JCheckBox myRefactorSuperCB;
    private JCheckBox myConstCB;

    public OCParameterInplaceIntroducer(Project project, Editor editor, PsiElement expression, List<PsiElement> occurrences, @NlsContexts.Command String refactoringName) {
        super(project, editor, expression, occurrences, PsiNameIdentifierOwner.class, PsiElement.class, refactoringName);
    }

    @Override
    public void configurePanel() {
        super.configurePanel();
        OCCallable callable = OCParameterInplaceIntroducer.getCallable(this.getAnchor());
        OCSymbol symbol = callable != null ? callable.getSymbol() : null;
        OCSearchUtil.Ancestor ancestor = symbol instanceof OCSymbolWithParent ? OCSearchUtil.findSomeAncestor((OCSymbolWithParent)symbol, this.myProject) : null;
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Editor)this.myEditor).getCustomSettings(OCCodeStyleSettings.class);
        if (this.isConstAvailable()) {
            this.myConstCB = this.createCheckBox(OCRefactoringBundle.message("refactoring.introducer.declare.const", new Object[0]), settings.INTRODUCE_CONST_PARAMS, () -> {
                settings.INTRODUCE_CONST_PARAMS = this.myConstCB.isSelected();
                this.rebuildDeclaration();
            });
        }
        if (ancestor != null && !ancestor.isOutOfProject()) {
            this.myRefactorSuperCB = this.createCheckBox(OCRefactoringBundle.message("refactoring.parameter.introducer.refactor.super.method", symbol.getKind().getNameLowercase()), true, null);
        }
    }

    private void rebuildDeclaration() {
        PsiNameIdentifierOwner variable = this.getVariable();
        if (variable instanceof OCDeclarator) {
            this.rebuildDeclarator((OCDeclarator)variable, new OCBaseExpressionInplaceIntroducer.Rebuilder(){

                @Override
                public OCDeclarator rebuild(OCDeclarator declarator) {
                    boolean isConst = OCParameterInplaceIntroducer.this.myConstCB != null && OCParameterInplaceIntroducer.this.myConstCB.isSelected();
                    OCDeclaration newDeclaration = OCElementFactory.paramDeclarationByNameAndType(declarator.getName(), OCParameterInplaceIntroducer.this.getType(declarator.getInitializer(), false, isConst), null, declarator);
                    newDeclaration = (OCDeclaration)OCChangeUtil.replaceHandlingMacros(declarator.getParent(), newDeclaration);
                    return newDeclaration.getDeclarators().get(0);
                }
            });
        }
    }

    @Override
    protected OCSymbolKind getDeclaratorKind() {
        return OCSymbolKind.PARAMETER;
    }

    @Override
    protected String checkExpression(PsiElement expression) {
        List<OCDeclarator> parameters;
        String message = super.checkExpression(expression);
        if (message != null) {
            return message;
        }
        PsiElement block = PsiTreeUtil.getContextOfType((PsiElement)this.myExpr, (boolean)false, (Class[])new Class[]{OCBlockStatement.class, OCConstructorFieldInitializer.class});
        OCCallable callable = OCParameterInplaceIntroducer.getCallable(block);
        if (callable == null) {
            return OCRefactoringBundle.message("selected.expression.should.be.inside.a.function.or.method", new Object[0]);
        }
        List<OCDeclarator> list = parameters = callable instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)callable).getParameters() : null;
        if (parameters != null && ContainerUtil.exists(parameters, p -> p.getInitializer() != null)) {
            return OCRefactoringBundle.message("can.t.introduce.parameter.to.a.function.with.default.parameter.values", new Object[0]);
        }
        return null;
    }

    @Override
    public PsiElement evaluateAnchor() {
        PsiElement initializer = PsiTreeUtil.getContextOfType((PsiElement)this.myExpr, (boolean)false, (Class[])new Class[]{OCConstructorFieldInitializer.class});
        return initializer != null ? initializer : super.evaluateAnchor();
    }

    @Override
    protected String getVariableTextWithReplacedName(PsiNameIdentifierOwner variable, String newName) {
        if (variable instanceof OCMethodSelectorPart && ((OCMethod)variable.getParent()).getParameters().size() > 1) {
            PsiElement element = this.getPreviewElement(variable);
            Object text = element.getText();
            int offset = variable.getTextOffset() - element.getTextRange().getStartOffset();
            text = ((String)text).substring(0, offset) + ((String)text).substring(offset).replaceFirst(variable.getName(), newName);
            offset = variable.getTextRange().getStartOffset() - element.getTextRange().getStartOffset();
            return ((String)text).substring(0, offset) + ((String)text).substring(offset).replaceFirst(((OCMethodSelectorPart)variable).getSelectorIdentifier().getText(), newName);
        }
        return super.getVariableTextWithReplacedName(variable, newName);
    }

    @Override
    protected String trimTextForPreview(String text) {
        int index = text.indexOf(123);
        return super.trimTextForPreview(index != -1 ? text.substring(0, index) : text);
    }

    @Override
    protected TextRange getMarkupRange(PsiNameIdentifierOwner variable) {
        if (variable instanceof OCDeclarator) {
            return variable.getParent().getTextRange();
        }
        OCMethodSelectorPart part = (OCMethodSelectorPart)variable;
        OCTypeElement typeElement = part.getTypeElement();
        OCMethod method = (OCMethod)part.getParent();
        if (method.getParameters().size() > 1 || typeElement == null) {
            return variable.getTextRange();
        }
        return new TextRange(typeElement.getTextOffset() - 1, part.getTextRange().getEndOffset());
    }

    @Override
    protected PsiNameIdentifierOwner getVariable() {
        Object variable = super.getVariable();
        if (variable instanceof OCMethodSelectorPart && ((OCMethodSelectorPart)variable).getParameter() == null || variable instanceof OCDeclarator && variable.getNameIdentifier() == null) {
            return null;
        }
        return variable;
    }

    @Override
    protected void introduceForPreview(String name) {
        OCCallable callable = (OCCallable)ReadAction.compute(() -> OCParameterInplaceIntroducer.getCallable(this.getAnchor()));
        assert (callable != null);
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(callable, callable, true);
        if (handler instanceof OCEmptyChangeSignatureHandler) {
            return;
        }
        this.addParameter(name, handler);
        WriteAction.run(() -> OCParameterInplaceIntroducer.replaceMethodDefinition(callable, handler));
        List<PsiNamedElement> parameters = callable.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            this.setVariable((PsiNameIdentifierOwner)parameters.get(parameters.size() - 1));
        }
    }

    @Override
    protected void introduceForReal(String name) {
        OCCallable callable = (OCCallable)ReadAction.compute(() -> OCParameterInplaceIntroducer.getCallable(this.getAnchor()));
        assert (callable != null);
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(callable, callable, true);
        OCParameterInfo parameterInfo = this.addParameter(name, handler);
        if (this.myRefactorSuperCB != null && this.myRefactorSuperCB.isSelected()) {
            handler.setChangeAncestors(true);
        }
        WriteAction.run(() -> {
            CommandProcessor.getInstance().setCurrentCommandName(this.myTitle);
            this.setDefaultArgumentValue(parameterInfo);
            if (this.changeUsages(name)) {
                for (PsiElement occurrence : this.myOccurrences) {
                    if (OCBaseLocalConvertibleHandler.isDeclaratorIdentifier(occurrence)) continue;
                    OCChangeUtil.replaceHandlingMacros(occurrence, OCElementFactory.expressionFromText(name, occurrence));
                }
            }
            for (PsiElement occurence : this.myOccurrences) {
                if (!OCBaseLocalConvertibleHandler.isDeclaratorIdentifier(occurence)) continue;
                OCChangeUtil.delete(occurence.getParent());
            }
        });
        handler.setTitle(this.myTitle);
        handler.invokeSynchronously();
        List<PsiNamedElement> parameters = callable.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            this.setVariable((PsiNameIdentifierOwner)parameters.get(parameters.size() - 1));
        }
    }

    @Override
    protected boolean performIntroduceUnderWriteAction() {
        return false;
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.introduceParameter";
    }

    private void setDefaultArgumentValue(@NotNull OCParameterInfo parameterInfo) {
        if (parameterInfo == null) {
            OCParameterInplaceIntroducer.$$$reportNull$$$0(0);
        }
        if (this.myIsUnresolvedReference && this.myExpr instanceof OCReferenceExpression && this.myExpr.getParent() instanceof OCAssignmentExpression && this.myExpr.getParent().getParent() instanceof OCExpressionStatement && this.myOccurrences[0] == this.myExpr && ((OCAssignmentExpression)this.myExpr.getParent()).getReceiverExpression() == this.myExpr && ((OCAssignmentExpression)this.myExpr.getParent()).getOperationSign() == OCTokenTypes.EQ) {
            OCExpression argumentValue = ((OCAssignmentExpression)this.myExpr.getParent()).getSourceExpression();
            if (argumentValue != null) {
                parameterInfo.setDefaultValue(argumentValue.getTextWithMacros());
            }
            OCChangeUtil.delete(this.myExpr.getParent().getParent());
        } else if (!this.isCreateFromUsageMode()) {
            OCExpression argumentValue;
            OCExpression oCExpression = argumentValue = OCBaseLocalConvertibleHandler.isDeclaratorIdentifier(this.myExpr) ? ((OCDeclarator)this.myExpr.getParent()).getInitializer() : (OCExpression)this.myExpr;
            if (argumentValue != null) {
                parameterInfo.setDefaultValue(argumentValue.getTextWithMacros());
            }
        }
    }

    private OCParameterInfo addParameter(String name, OCChangeSignatureHandler handler) {
        OCType type = !this.isCreateFromUsageMode() ? this.getType(this.myExpr, false, this.myConstCB != null && this.myConstCB.isSelected()) : this.myExprType;
        return handler.addParameter(name, name, type, -1, false);
    }

    private static void replaceMethodDefinition(OCCallable callable, OCChangeSignatureHandler handler) {
        OCCallable newCallable = OCChangeSignatureUsageProcessor.generateMethodDefinition(handler.getChangeInfo(), callable, true, false, false, false);
        OCBlockStatement body = callable.getBody();
        assert (body != null);
        callable.getNode().removeRange(callable.getNode().getFirstChildNode(), body.getNode());
        for (ASTNode child : newCallable.getNode().getChildren(null)) {
            if (OCElementTypes.BLOCK_STATEMENTS.contains(child.getElementType())) break;
            callable.addBefore(child.getPsi(), body);
        }
    }

    @Override
    protected PsiElement getPreviewElement(PsiNameIdentifierOwner element) {
        return OCParameterInplaceIntroducer.getCallable((PsiElement)element);
    }

    private static OCCallable getCallable(PsiElement element) {
        return (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCMethod.class, OCFunctionDefinition.class});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterInfo", "com/jetbrains/cidr/lang/refactoring/introduce/OCParameterInplaceIntroducer", "setDefaultArgumentValue"));
    }
}

