/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import org.jetbrains.annotations.NotNull;

public class OCMemberInfo
extends MemberInfoBase<OCSymbolHolderVirtualPsiElement> {
    private OCVisibility myVisibility;
    private OCSymbol mySymbol;
    private boolean isAbstract;

    public OCMemberInfo(OCSymbol symbol, OCMembersContainer parent, @NotNull Project project) {
        if (project == null) {
            OCMemberInfo.$$$reportNull$$$0(0);
        }
        this(symbol, symbol, false, parent, project);
    }

    public OCMemberInfo(OCSymbol intfSymbol, OCSymbol implSymbol, boolean nameWithParent, OCMembersContainer parent, @NotNull Project project) {
        if (project == null) {
            OCMemberInfo.$$$reportNull$$$0(1);
        }
        super((PsiElement)new OCSymbolHolderVirtualPsiElement(implSymbol, project));
        this.mySymbol = implSymbol;
        this.displayName = intfSymbol.getPresentableName();
        this.myVisibility = OCVisibility.getDeclaredVisibility(this.mySymbol, project);
        OCResolveContext context = OCResolveContext.forSymbol(intfSymbol, project);
        if (nameWithParent && intfSymbol instanceof OCSymbolWithParent) {
            this.displayName = ((OCSymbolWithParent)intfSymbol).getNameWithParent(context);
        }
        if (intfSymbol instanceof OCMemberSymbol) {
            this.isAbstract = ((OCMemberSymbol)this.mySymbol).getParent() instanceof OCProtocolSymbol;
        }
        if (this.myVisibility == null || intfSymbol.getKind() == OCSymbolKind.PROPERTY) {
            this.myVisibility = OCVisibility.PUBLIC;
        }
        if (intfSymbol instanceof OCDeclaratorSymbol) {
            this.isStatic = ((OCDeclaratorSymbol)intfSymbol).isFriendOrStatic();
        } else if (intfSymbol instanceof OCFunctionSymbol) {
            this.isStatic = ((OCFunctionSymbol)intfSymbol).isFriendOrStatic();
            this.isAbstract = ((OCFunctionSymbol)intfSymbol).isPureVirtual();
            this.displayName = ((OCFunctionSymbol)intfSymbol).getSignatureWithoutParamNames(nameWithParent, true, context);
        } else if (intfSymbol instanceof OCMethodSymbol) {
            this.isStatic = ((OCMethodSymbol)intfSymbol).isStatic();
            if (!nameWithParent) {
                this.displayName = intfSymbol.getSignature(project);
            }
        } else if (parent instanceof OCClassSymbol && intfSymbol instanceof OCProtocolSymbol) {
            this.displayName = "conforms to " + intfSymbol.getNameWithKindLowercase(context);
            this.isAbstract = true;
        } else if (parent instanceof OCStructSymbol && intfSymbol instanceof OCStructSymbol && ((OCStructSymbol)intfSymbol).getParent() != parent) {
            this.displayName = "super " + intfSymbol.getNameWithKindLowercase(context);
            this.isAbstract = true;
        }
        if ((parent instanceof OCClassSymbol || parent instanceof OCStructSymbol) && intfSymbol instanceof OCSymbolWithParent) {
            OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)intfSymbol, symbol -> {
                if (symbol.getParent() instanceof OCClassSymbol && symbol.getParent().getName().equals(((OCSymbolWithParent)intfSymbol).getParent().getName())) {
                    return true;
                }
                if (symbol.getParent() instanceof OCProtocolSymbol || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isVirtual()) {
                    this.overrides = Boolean.FALSE;
                    return true;
                }
                this.overrides = Boolean.TRUE;
                return false;
            }, true, false, project);
        }
    }

    public OCMemberInfo(OCStructSymbol member, OCVisibility visibility, OCMembersContainer parent, @NotNull Project project) {
        if (project == null) {
            OCMemberInfo.$$$reportNull$$$0(2);
        }
        this(member, parent, project);
        this.myVisibility = visibility;
    }

    public OCSymbol getSymbol() {
        return this.mySymbol;
    }

    @NotNull
    public OCVisibility getVisibility() {
        OCVisibility oCVisibility = this.myVisibility;
        if (oCVisibility == null) {
            OCMemberInfo.$$$reportNull$$$0(3);
        }
        return oCVisibility;
    }

    public String getDisplayNameWithKind(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCMemberInfo.$$$reportNull$$$0(4);
        }
        return this.mySymbol.getKindUppercase(context) + " '" + this.getDisplayName() + "'";
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/move/OCMemberInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/move/OCMemberInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayNameWithKind";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

