/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.util;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.psi.OCCppBaseClause;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveModifyableVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCChangeVisibilityIntentionAction;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCEscalateVisibilityHelper;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCBindUtil {
    private static final Key<OCSymbolWithParent> REF_TO_SYMBOL = Key.create((String)"REF_TO_SYMBOL_KEY");
    private static final Key<PsiElement> REF_TO_DEFINITION = Key.create((String)"REF_TO_DEFINITION_KEY");
    private static final Key<Object> KEY_ENCODED = Key.create((String)"KEY_ENCODED");
    private static final Key<Boolean> KEY_IS_REF_TO_PARENT = Key.create((String)"KEY_IS_REF_TO_PARENT");
    private static final Key<Boolean> KEY_BIND_QUALIFIER = Key.create((String)"KEY_BIND_QUALIFIER");

    private OCBindUtil() {
    }

    public static void encodeContextInfo(PsiElement element, boolean encodeLocals) {
        OCBindUtil.encodeContextInfo(Collections.singletonList(element), null, encodeLocals, false);
    }

    public static void encodeContextInfo(Collection<PsiElement> elements, @Nullable OCSymbol parentSymbol, boolean encodeLocals, boolean encodeThis) {
        for (PsiElement element : elements) {
            OCBindUtil.encodeContextInfo(element, elements, parentSymbol, encodeLocals, encodeThis);
        }
    }

    private static void encodeContextInfo(PsiElement element, final Collection<PsiElement> scope, final @Nullable OCSymbol parentSymbol, final boolean encodeLocals, final boolean encodeThis) {
        element.accept((PsiElementVisitor)new OCRecursiveModifyableVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (OCElementUtil.isPartOfMacroSubstitution(element)) {
                    return;
                }
                super.visitElement(element);
                OCSymbol refSymbol = null;
                if (element instanceof OCReferenceElement) {
                    refSymbol = ((OCReferenceElement)element).resolveToSymbol();
                } else {
                    PsiReference ref = element.getReference();
                    if (ref instanceof OCReference) {
                        refSymbol = ((OCReference)ref).resolveToSymbol();
                    } else if (ref instanceof OCPolyVariantReference) {
                        List symbols = ((OCPolyVariantReference)ref).resolveToSymbols();
                        OCSymbol oCSymbol = refSymbol = symbols.isEmpty() ? null : (OCSymbol)symbols.iterator().next();
                    }
                }
                if (refSymbol != null) {
                    Project project = element.getProject();
                    PsiElement definition = refSymbol.locateDefinition(project);
                    if (refSymbol instanceof OCSymbolWithParent) {
                        boolean isInScope = false;
                        if (definition != null) {
                            for (PsiElement scopePart : scope) {
                                if (!PsiTreeUtil.isContextAncestor((PsiElement)scopePart, (PsiElement)definition, (boolean)false)) continue;
                                isInScope = true;
                                break;
                            }
                        }
                        if (encodeThis && element instanceof OCQualifiedExpression && OCGetSymbolVisitor.getSymbol(((OCQualifiedExpression)element).getQualifier()) instanceof OCThisSelfSuperSymbol) {
                            OCBindUtil.encodeAsRefToParent(element);
                        } else if (isInScope) {
                            if (parentSymbol != null) {
                                PsiReference qualifierRef = OCBindUtil.getQualifierReference(element);
                                if (qualifierRef instanceof OCReference && parentSymbol.isSameSymbol(((OCReference)qualifierRef).resolveToSymbol(), project)) {
                                    OCBindUtil.encodeAsRefToParent(element);
                                } else if (qualifierRef instanceof OCPolyVariantReference) {
                                    for (OCSymbol symbol : ((OCPolyVariantReference)qualifierRef).resolveToSymbols()) {
                                        if (!parentSymbol.isSameSymbol(symbol, project)) continue;
                                        OCBindUtil.encodeAsRefToParent(element);
                                        break;
                                    }
                                }
                            }
                        } else if ((encodeLocals || !refSymbol.getKind().isLocal()) && OCBindUtil.encodeElement(element)) {
                            element.putCopyableUserData(KEY_ENCODED, KEY_ENCODED);
                            element.putCopyableUserData(REF_TO_SYMBOL, (Object)((OCSymbolWithParent)refSymbol));
                            element.putCopyableUserData(REF_TO_DEFINITION, (Object)definition);
                            element.putCopyableUserData(KEY_IS_REF_TO_PARENT, (Object)false);
                            element.putCopyableUserData(KEY_BIND_QUALIFIER, (Object)(((OCSymbolWithParent)refSymbol).getParent() == parentSymbol ? 1 : 0));
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/refactoring/util/OCBindUtil$1", "visitElement"));
            }
        });
    }

    private static boolean encodeElement(PsiElement element) {
        PsiElement parent;
        return !(element instanceof OCReferenceElement) || ((OCReferenceElement)element).getNamespaceQualifier() == null || !((parent = element.getParent()) instanceof OCReferenceExpression) || !(parent.getParent() instanceof OCUnaryExpression) || !((OCUnaryExpression)parent.getParent()).isGetAddress();
    }

    public static void encodeAsRefToParent(PsiElement element) {
        element.putCopyableUserData(KEY_ENCODED, KEY_ENCODED);
        element.putCopyableUserData(KEY_IS_REF_TO_PARENT, (Object)true);
        element.putCopyableUserData(KEY_BIND_QUALIFIER, (Object)false);
    }

    public static void decodeContextInfo(Collection<PsiElement> elements) {
        for (PsiElement element : elements) {
            OCBindUtil.decodeContextInfo(element, null, null);
        }
    }

    public static void decodeContextInfo(PsiElement element) {
        OCBindUtil.decodeContextInfo(element, null, null);
    }

    public static void decodeContextInfo(PsiElement element, final @Nullable OCSymbol newParentSymbol, final @Nullable Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        element.accept((PsiElementVisitor)new OCRecursiveModifyableVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (OCElementUtil.isPartOfMacroSubstitution(element)) {
                    return;
                }
                super.visitElement(element);
                if (element.getCopyableUserData(KEY_ENCODED) != null) {
                    OCSymbolWithParent symbol = (OCSymbolWithParent)element.getCopyableUserData(REF_TO_SYMBOL);
                    PsiElement definition = (PsiElement)element.getCopyableUserData(REF_TO_DEFINITION);
                    Boolean isRefToParent = (Boolean)element.getCopyableUserData(KEY_IS_REF_TO_PARENT);
                    Boolean bindQualifier = (Boolean)element.getCopyableUserData(KEY_BIND_QUALIFIER);
                    element.putCopyableUserData(KEY_ENCODED, null);
                    element.putCopyableUserData(KEY_IS_REF_TO_PARENT, null);
                    element.putCopyableUserData(KEY_BIND_QUALIFIER, null);
                    element.putCopyableUserData(REF_TO_SYMBOL, null);
                    element.putCopyableUserData(REF_TO_DEFINITION, null);
                    assert (bindQualifier != null);
                    Project project = element.getProject();
                    if (isRefToParent == Boolean.TRUE) {
                        PsiReference reference;
                        PsiReference psiReference = reference = element instanceof OCDeclarator ? ((OCDeclarator)element).getNamespaceQualifier().getReference() : OCBindUtil.getQualifierReference(element);
                        if (newParentSymbol != null) {
                            OCBindUtil.bindReferenceAndMakeVisible(reference, newParentSymbol, newParentSymbol.locateDefinition(project), elemsToEscalateVisibility, bindQualifier, project);
                        }
                    } else if (symbol != null) {
                        OCBindUtil.bindReferenceAndMakeVisible(element.getReference(), symbol, definition, elemsToEscalateVisibility, bindQualifier, project);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/refactoring/util/OCBindUtil$2", "visitElement"));
            }
        });
    }

    public static PsiElement insertRedundantQualifiers(final PsiElement rootElement, final boolean isDotCall) {
        final Ref result = Ref.create((Object)rootElement);
        rootElement.accept((PsiElementVisitor)new OCRecursiveModifyableVisitor(){

            @Override
            public void visitReferenceExpression(OCReferenceExpression expression) {
                if (OCElementUtil.isPartOfMacroSubstitution(expression)) {
                    return;
                }
                super.visitReferenceExpression(expression);
                OCSymbol symbol = expression.resolveToSymbol();
                OCExpression newElement = null;
                if (symbol instanceof OCInstanceVariableSymbol) {
                    newElement = OCElementFactory.expressionFromText("self->" + symbol.getName(), expression);
                } else if (!(!(symbol instanceof OCSymbolWithQualifiedName) || !(((OCSymbolWithQualifiedName)symbol).getParent() instanceof OCStructSymbol) || ((OCSymbolWithQualifiedName)symbol).isFriendOrStatic() || symbol.getKind() == OCSymbolKind.ENUM_CONST || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() || symbol instanceof OCTypeParameterSymbol || expression.getReferenceElement().getNamespaceQualifier() != null)) {
                    newElement = OCElementFactory.expressionFromText((isDotCall ? "this." : "this->") + symbol.getName(), expression);
                }
                if (newElement != null) {
                    if (expression == rootElement) {
                        result.set((Object)newElement);
                    } else {
                        OCChangeUtil.replaceHandlingMacros(expression, newElement);
                    }
                }
            }
        });
        return (PsiElement)result.get();
    }

    public static List<PsiElement> insertRedundantQualifiers(Collection<PsiElement> elements, boolean isDotCall) {
        ArrayList<PsiElement> newElements = new ArrayList<PsiElement>();
        for (PsiElement element : elements) {
            if (element.isPhysical()) {
                newElements.add(OCBindUtil.insertRedundantQualifiers(element, isDotCall));
                continue;
            }
            newElements.add(element);
        }
        return newElements;
    }

    public static void removeRedundantQualifiers(PsiElement expression) {
        expression.accept((PsiElementVisitor)new OCRecursiveModifyableVisitor(){

            @Override
            public void visitQualifiedExpression(OCQualifiedExpression expression) {
                if (OCElementUtil.isPartOfMacroSubstitution(expression)) {
                    return;
                }
                super.visitQualifiedExpression(expression);
                OCExpression qualifier = expression.getQualifier();
                OCSymbol symbol = expression.resolveToSymbol();
                PsiElement copy2 = expression.copy();
                if (symbol instanceof OCSymbolWithParent && qualifier instanceof OCReferenceExpression && ((OCReferenceExpression)qualifier).isSelfSuperOrThis()) {
                    OCReferenceExpression refExpr = (OCReferenceExpression)OCElementFactory.expressionFromText(symbol.getName(), expression);
                    if (!OCBindUtil.bindReferenceToSymbol((refExpr = (OCReferenceExpression)OCChangeUtil.replaceHandlingMacros(expression, refExpr)).getReferenceElement().getReference(), symbol, false)) {
                        OCChangeUtil.replaceHandlingMacros(refExpr, copy2);
                    }
                }
            }
        });
    }

    public static boolean setShortestPossibleName(OCReferenceElement element) {
        OCSymbol symbol = element.resolveToSymbol();
        if (symbol instanceof OCSymbolWithQualifiedName) {
            OCQualifiedName parent;
            OCQualifiedName qualifiedName = OCSymbolReferenceResolver.getQualifiedName(element);
            for (parent = qualifiedName.getQualifier(); parent != null && parent != OCQualifiedName.GLOBAL; parent = parent.getQualifier()) {
            }
            if (parent == OCQualifiedName.GLOBAL) {
                qualifiedName = qualifiedName.dropSuperQualifier();
            }
            return OCBindUtil.setShortestPossibleName(qualifiedName, element, (OCSymbolWithQualifiedName)symbol);
        }
        return false;
    }

    public static boolean setShortestPossibleName(OCQualifiedName shortName, OCNamespaceQualifierOwner element, OCSymbolWithQualifiedName symbol) {
        int newComplexity;
        boolean isOldBinded = OCBindUtil.symbolIsBinded(element, symbol);
        int oldComplexity = OCElementUtil.getQualifiedNameComplexity(OCSymbolReferenceResolver.getQualifiedName(element));
        OCQualifiedName newShortestName = OCBindUtil.getShortestPossibleName(shortName, element, symbol);
        int n = newComplexity = newShortestName != null ? OCElementUtil.getSubstitutedQualifiedNameComplexity(element, newShortestName) : 0;
        if (!(newShortestName == null || isOldBinded && oldComplexity <= newComplexity)) {
            OCElementUtil.changeQualifiedName(element, newShortestName);
            return true;
        }
        return isOldBinded;
    }

    private static OCQualifiedName getShortestPossibleName(OCQualifiedName shortName, OCNamespaceQualifierOwner element, OCSymbolWithQualifiedName symbol) {
        OCSymbolGroupContext symbolContext;
        OCSymbolWithQualifiedName symbolFinal;
        OCQualifiedName shortestName;
        if (shortName.getQualifier() != null && (shortestName = OCBindUtil.getShortestPossibleName(shortName.dropSuperQualifier(), element, symbol)) != null) {
            return shortestName;
        }
        if (shortName == OCQualifiedName.GLOBAL) {
            return shortName;
        }
        OCSymbolWithQualifiedName oCSymbolWithQualifiedName = symbolFinal = symbol.getKind().isConstructorOrDestructor() ? symbol.getParent() : symbol;
        OCSymbolReference.SymbolFilter filter = element instanceof OCReferenceElement ? ((symbolContext = ((OCReferenceElement)element).getSymbolContext()) != null ? symbolContext::isSuitableSymbol : OCSymbolReference.SymbolFilter.NONE) : OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE;
        OCSymbolReference reference = element.getParent() instanceof OCCppBaseClause ? OCSymbolReference.getBaseClauseReference(shortName, null, null, 0L) : OCSymbolReference.getLocalReference(shortName, element, filter);
        List<OCSymbol> symbols = reference.resolveToSymbols(OCResolveContext.forPsi(element));
        boolean isBinded = ContainerUtil.exists(symbols, s -> s.isSameSymbol(symbolFinal, element.getProject()));
        return isBinded ? shortName : null;
    }

    private static boolean symbolIsBinded(OCNamespaceQualifierOwner element, OCSymbolWithQualifiedName symbol) {
        if (element instanceof OCReferenceElement) {
            return symbol.isSameSymbol(((OCReferenceElement)element).resolveToSymbol(), element.getProject());
        }
        if (element instanceof OCCppNamespaceQualifier) {
            return ((OCCppNamespaceQualifier)element).resolveToSymbols().contains(symbol);
        }
        return false;
    }

    @Nullable
    public static OCQualifiedName getShortestPossibleName(OCQualifiedName shortName, OCReferenceElement element, OCSymbol symbol) {
        OCQualifiedName name;
        if (element == null) {
            return null;
        }
        if (shortName.getQualifier() != null && (name = OCBindUtil.getShortestPossibleName(shortName.dropSuperQualifier(), element, symbol)) != null) {
            return name;
        }
        OCLog.LOG.assertTrue((element = OCElementFactory.referenceElementFromText(shortName.getFullName(OCResolveContext.forPsi(element)), element, true)) != null);
        OCElementUtil.changeQualifiedName(element, shortName);
        OCSymbol resolvedElement = element.resolveToSymbol();
        if (Comparing.equal((Object)resolvedElement, (Object)symbol)) {
            return shortName;
        }
        return null;
    }

    @Nullable
    public static PsiReference getQualifierReference(PsiElement element) {
        OCElement qualifier = null;
        if (element instanceof OCReferenceElement) {
            qualifier = ((OCReferenceElement)element).getNamespaceQualifier();
        } else if (element instanceof OCQualifiedExpression) {
            qualifier = ((OCQualifiedExpression)element).getQualifier();
        } else if (element instanceof OCSendMessageExpression) {
            qualifier = ((OCSendMessageExpression)element).getReceiverExpression();
        } else if (element instanceof OCCppNamespaceQualifier) {
            qualifier = ((OCCppNamespaceQualifier)element).getNamespaceQualifier();
        }
        if (qualifier instanceof OCExpression) {
            qualifier = OCParenthesesUtils.diveIntoParentheses((OCExpression)qualifier);
        }
        if (qualifier instanceof OCReferenceExpression) {
            OCReferenceElement referenceElement = ((OCReferenceExpression)qualifier).getReferenceElement();
            if (referenceElement != null && (((OCReferenceExpression)qualifier).isSelfSuperOrThis() || ((OCElement)element).getContainingOCFile().isCpp() && qualifier.getText().equals("this"))) {
                return referenceElement.getReference();
            }
            OCSymbol symbol = referenceElement != null ? referenceElement.resolveToSymbol() : null;
            return symbol != null && symbol.getKind().isClass() ? referenceElement.getReference() : null;
        }
        if (qualifier instanceof OCCppNamespaceQualifier) {
            return qualifier.getReference();
        }
        return null;
    }

    private static boolean bindReferenceToSymbol(@Nullable PsiReference reference, @Nullable OCSymbol symbol, boolean bindQualifier) {
        if (symbol != null) {
            PsiReference qualifierReference;
            List<Object> resolvedSymbols;
            PsiElement newElement;
            if (reference instanceof OCReference) {
                newElement = ((OCReference)reference).bindToSymbol(symbol);
            } else if (reference instanceof OCPolyVariantReference) {
                newElement = ((OCPolyVariantReference)reference).bindToSymbol(symbol);
            } else {
                return false;
            }
            PsiReference newReference = newElement.getReference();
            if (newReference instanceof OCReference) {
                OCSymbol resolvedSymbol = ((OCReference)newReference).resolveToSymbol();
                resolvedSymbols = resolvedSymbol != null ? Collections.singletonList(resolvedSymbol) : Collections.emptyList();
            } else if (newElement instanceof OCSendMessageExpression) {
                OCMethodSymbol responder = ((OCSendMessageExpression)newElement).getProbableResponders().getKnownResponder();
                resolvedSymbols = responder != null ? Collections.singletonList(responder) : Collections.emptyList();
            } else if (newReference instanceof OCPolyVariantReference) {
                resolvedSymbols = ((OCPolyVariantReference)newReference).resolveToSymbols();
            } else {
                return false;
            }
            boolean resolves = ContainerUtil.exists(resolvedSymbols, s -> s.isSameSymbol(symbol, newElement.getProject()));
            if ((bindQualifier || !resolves) && (symbol instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).isStatic() || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isFriendOrStatic() || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isFriendOrStatic() || symbol instanceof OCNamespaceSymbol) && (qualifierReference = OCBindUtil.getQualifierReference(newElement)) != null) {
                return OCBindUtil.bindReferenceToSymbol(qualifierReference, ((OCSymbolWithParent)symbol).getParent(), false);
            }
            return resolves;
        }
        return false;
    }

    public static void bindReferenceAndMakeVisible(@Nullable PsiReference reference, @Nullable OCSymbol symbol, @Nullable PsiElement definition, @Nullable Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility, boolean bindQualifier, @NotNull Project project) {
        OCSymbol newSymbol;
        if (project == null) {
            OCBindUtil.$$$reportNull$$$0(0);
        }
        if (reference == null) {
            return;
        }
        OCSymbol oCSymbol = newSymbol = definition instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)definition).getSymbol() : null;
        if (elemsToEscalateVisibility != null && newSymbol instanceof OCSymbolWithParent && OCSearchScope.isInProjectSources(newSymbol, project)) {
            OCType qualifierType = reference.getElement() instanceof OCQualifiedExpression ? ((OCQualifiedExpression)reference.getElement()).getQualifier().getResolvedType().getTerminalType() : null;
            OCVisibility visibility = OCVisibility.getMinimalVisibilityForSymbolToBeAccessible(newSymbol, reference.getElement(), qualifierType);
            if (visibility != OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC && !OCVisibility.isVisible(newSymbol, visibility, project)) {
                Pair<OCSymbol, OCVisibility> oldPair = elemsToEscalateVisibility.get(definition);
                OCVisibility newVisibility = oldPair != null ? OCVisibility.mostVisible((OCVisibility)((Object)oldPair.getSecond()), visibility) : visibility;
                SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)definition.getProject()).createSmartPsiElementPointer(definition);
                elemsToEscalateVisibility.put(pointer, (Pair<OCSymbol, OCVisibility>)Pair.create(newSymbol, (Object)((Object)newVisibility)));
            }
        }
        OCBindUtil.bindReferenceToSymbol(reference, symbol, bindQualifier);
    }

    public static void escalateVisibilities(Project project, VirtualFile ... affectedFiles2) {
        List elemsToEscalateVisibility = (List)OCEscalateVisibilityHelper.SELECTED_ELEMENTS_TO_ESCALATE_VISIBILITY.get((UserDataHolder)project);
        OCEscalateVisibilityHelper.SELECTED_ELEMENTS_TO_ESCALATE_VISIBILITY.set((UserDataHolder)project, null);
        if (elemsToEscalateVisibility != null && !elemsToEscalateVisibility.isEmpty()) {
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                CommandProcessor.getInstance().setCurrentCommandName(OCBundle.message("escalate.visibility", new Object[0]));
                CommandProcessor.getInstance().addAffectedFiles(project, affectedFiles2);
                for (Pair pair : elemsToEscalateVisibility) {
                    PsiElement element = ((SmartPsiElementPointer)pair.getFirst()).getElement();
                    Object symbol = element instanceof OCSymbolDeclarator ? ((OCSymbolDeclarator)element).getSymbol() : null;
                    if (!(symbol instanceof OCSymbolWithParent)) continue;
                    new OCChangeVisibilityIntentionAction(symbol, (OCVisibility)((Object)((Object)pair.getSecond())), OCCompilationContext.create(element)).invoke(project, null, element.getContainingFile());
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/refactoring/util/OCBindUtil", "bindReferenceAndMakeVisible"));
    }
}

