/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.search.OCDirectInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCClassInheritorsSearch
extends QueryFactory<OCClassSymbol, SearchParameters> {
    private static final OCClassInheritorsSearch INSTANCE = new OCClassInheritorsSearch();

    private OCClassInheritorsSearch() {
    }

    @NotNull
    public static Query<OCClassSymbol> search(@NotNull OCClassDeclaration aClass) {
        if (aClass == null) {
            OCClassInheritorsSearch.$$$reportNull$$$0(0);
        }
        Project project = aClass.getProject();
        return OCClassInheritorsSearch.search(aClass.getName(), aClass.getSymbol(), aClass instanceof OCProtocol, (SearchScope)GlobalSearchScope.allScope((Project)project), project, aClass instanceof OCImplementation);
    }

    @NotNull
    public static Query<OCClassSymbol> search(OCClassSymbol aClass, @NotNull Project project) {
        if (project == null) {
            OCClassInheritorsSearch.$$$reportNull$$$0(1);
        }
        return OCClassInheritorsSearch.search(aClass.getName(), aClass, aClass instanceof OCProtocolSymbol, (SearchScope)GlobalSearchScope.allScope((Project)project), project, aClass instanceof OCImplementationSymbol);
    }

    @NotNull
    public static Query<OCClassSymbol> search(@Nullable String className, boolean isProtocol, @NotNull SearchScope scope, @NotNull Project project, boolean myPreferImplementations) {
        if (scope == null) {
            OCClassInheritorsSearch.$$$reportNull$$$0(2);
        }
        if (project == null) {
            OCClassInheritorsSearch.$$$reportNull$$$0(3);
        }
        return OCClassInheritorsSearch.search(className, null, isProtocol, scope, project, myPreferImplementations);
    }

    @NotNull
    private static Query<OCClassSymbol> search(@Nullable String className, @Nullable OCClassSymbol symbol, boolean isProtocol, @NotNull SearchScope scope, @NotNull Project project, boolean myPreferImplementations) {
        if (scope == null) {
            OCClassInheritorsSearch.$$$reportNull$$$0(4);
        }
        if (project == null) {
            OCClassInheritorsSearch.$$$reportNull$$$0(5);
        }
        Query query = INSTANCE.createQuery(new SearchParameters(scope, className, symbol, isProtocol, project, myPreferImplementations));
        if (query == null) {
            OCClassInheritorsSearch.$$$reportNull$$$0(6);
        }
        return query;
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultExecutor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/search/OCClassInheritorsSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/search/OCClassInheritorsSearch";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "search";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SymbolAndName {
        @Nullable
        final String name;
        @Nullable
        final OCClassSymbol symbol;
        final boolean isProtocol;

        private SymbolAndName(@Nullable String name, @Nullable OCClassSymbol symbol, boolean isProtocol) {
            this.name = name;
            this.symbol = symbol;
            this.isProtocol = isProtocol;
        }

        Pair<String, Boolean> getNameAndProtocol() {
            return new Pair((Object)this.name, (Object)this.isProtocol);
        }
    }

    private static class DefaultExecutor
    extends QueryExecutorBase<OCClassSymbol, SearchParameters> {
        private DefaultExecutor() {
        }

        public void processQuery(@NotNull SearchParameters p, @NotNull Processor<? super OCClassSymbol> consumer) {
            if (p == null) {
                DefaultExecutor.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                DefaultExecutor.$$$reportNull$$$0(1);
            }
            SearchScope scope = p.getScope();
            Project project = p.getProject();
            Stack names = new Stack();
            HashSet<Pair<String, Boolean>> processed = new HashSet<Pair<String, Boolean>>();
            names.push((Object)new SymbolAndName(p.getClassName(), p.getSymbol(), p.isProtocol()));
            while (!names.isEmpty()) {
                ProgressManager.checkCanceled();
                SymbolAndName symbolAndName = (SymbolAndName)names.pop();
                if (!processed.add(symbolAndName.getNameAndProtocol())) continue;
                Query<OCClassSymbol> search = OCDirectInheritorsSearch.search(symbolAndName.name, symbolAndName.symbol, (SearchScope)GlobalSearchScope.allScope((Project)project), project, symbolAndName.isProtocol, p.isPreferImplementations());
                search.forEach(symbol -> {
                    names.push((Object)new SymbolAndName(symbol.getName(), (OCClassSymbol)symbol, symbol instanceof OCProtocolSymbol));
                    VirtualFile file = symbol.getContainingFile();
                    return file == null || !scope.contains(file) || consumer.process(symbol);
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "p";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/search/OCClassInheritorsSearch$DefaultExecutor";
            objectArray[2] = "processQuery";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SearchParameters {
        private final SearchScope myScope;
        private final String myClassName;
        private final OCClassSymbol mySymbol;
        private final Project myProject;
        private final boolean myProtocol;
        private final boolean myPreferImplementations;

        public SearchParameters(@NotNull SearchScope scope, @Nullable String className, @Nullable OCClassSymbol symbol, boolean protocol, @NotNull Project project, boolean preferImplementations) {
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            if (project == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            this.myScope = scope;
            this.myClassName = className;
            this.mySymbol = symbol;
            this.myProtocol = protocol;
            this.myProject = project;
            this.myPreferImplementations = preferImplementations;
        }

        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.myScope;
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            return searchScope;
        }

        @Nullable
        public String getClassName() {
            return this.myClassName;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                SearchParameters.$$$reportNull$$$0(3);
            }
            return project;
        }

        public boolean isProtocol() {
            return this.myProtocol;
        }

        public boolean isPreferImplementations() {
            return this.myPreferImplementations;
        }

        @Nullable
        public OCClassSymbol getSymbol() {
            return this.mySymbol;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/search/OCClassInheritorsSearch$SearchParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/search/OCClassInheritorsSearch$SearchParameters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

