/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.search.scopes.OCExplicitSourcesSearchScope;
import com.jetbrains.cidr.lang.search.scopes.ProjectSourcesScopeProvider;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSearchScope {
    private static final NotNullLazyKey<GlobalSearchScope, Project> PROJECT_SOURCES_SCOPE = NotNullLazyKey.create((String)"PROJECT_SOURCES_SCOPE", project -> OCSearchScope.createProjectSourcesScope(project));
    private static final Key<CachedValue<Map<VirtualFile, Boolean>>> IMPORTED_HEADERS = Key.create((String)"IMPORTED_HEADERS");

    @NotNull
    public static GlobalSearchScope getGotoSymbolScope(@NotNull Project project, boolean includeNonProjectFiles) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(0);
        }
        return includeNonProjectFiles ? ProjectScope.getAllScope((Project)project) : OCSearchScope.getProjectSourcesScope(project);
    }

    @NotNull
    public static GlobalSearchScope getProjectSourcesScope(@NotNull Project project) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(1);
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)PROJECT_SOURCES_SCOPE.getValue((UserDataHolder)project);
        if (globalSearchScope == null) {
            OCSearchScope.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    @NotNull
    private static DelegatingGlobalSearchScope createProjectSourcesScope(final @NotNull Project project) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(3);
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        final Condition sourceCondition = file -> OCSearchScope.isInExplicitProjectSources(index, file);
        final Condition projectCondition = file -> OCSearchScope.isInProject(index, file);
        return new DelegatingGlobalSearchScope(ProjectScope.getContentScope((Project)project)){

            @NotNull
            public String getDisplayName() {
                String string = ProjectSourcesScopeProvider.SourceFilesScope.presentableName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                return (Boolean)ReadAction.compute(() -> sourceCondition.value((Object)file) || projectCondition.value((Object)file) && OCSearchScope.isImportedFromSource(project, file, (Condition<VirtualFile>)sourceCondition));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/search/scopes/OCSearchScope$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/search/scopes/OCSearchScope$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "contains";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static boolean isImportedFromSource(@NotNull Project project, @NotNull VirtualFile header, @NotNull Condition<VirtualFile> sourceCondition) {
        Map<VirtualFile, Boolean> cache;
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(4);
        }
        if (header == null) {
            OCSearchScope.$$$reportNull$$$0(5);
        }
        if (sourceCondition == null) {
            OCSearchScope.$$$reportNull$$$0(6);
        }
        if (!(cache = OCSearchScope.getImportedHeadersCache(project)).containsKey(header)) {
            boolean imported = SymbolTableProvider.isSourceFile(project, header) && !OCImportGraph.getInstance(project).processIncludingFiles(header, false, true, (Processor<? super VirtualFile>)((Processor)includer -> !sourceCondition.value(includer)));
            cache.put(header, imported);
        }
        return cache.get(header);
    }

    @NotNull
    private static Map<VirtualFile, Boolean> getImportedHeadersCache(@NotNull Project project) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(7);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, IMPORTED_HEADERS, () -> {
            ConcurrentHashMap result = new ConcurrentHashMap();
            return CachedValueProvider.Result.create(result, OCSearchScope.getProjectSourcesCacheDependencies(project, false));
        }, false);
        if (map == null) {
            OCSearchScope.$$$reportNull$$$0(8);
        }
        return map;
    }

    @NotNull
    public static Collection<VirtualFile> getExplicitlySpecifiedProjectSourceFiles(@NotNull Project project) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(9);
        }
        Collection collection = OCExplicitSourcesSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)project);
        if (collection == null) {
            OCSearchScope.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    private static Collection<?> getProjectSourcesCacheDependencies(@NotNull Project project, boolean explicitRootsOnly) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(11);
        }
        List baseDeps = Arrays.asList(OCExplicitSourcesSearchScope.getProjectSourcesCacheDependenciesExplicitRootsOnly((Project)project));
        List list = explicitRootsOnly ? baseDeps : ContainerUtil.append(baseDeps, (Object[])new ModificationTracker[]{OCImportGraph.getInstance(project).getModificationTracker()});
        if (list == null) {
            OCSearchScope.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Contract(value="null, _->false")
    public static boolean isInProjectSources(@Nullable OCSymbol symbol, Project project) {
        return OCSearchScope.isInProjectSources((PsiElement)OCSearchScope.getContainingFile(symbol, project));
    }

    @Nullable
    private static PsiFile getContainingFile(@Nullable OCSymbol symbol, @NotNull Project project) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(13);
        }
        if (symbol == null || symbol.getKind() == OCSymbolKind.BUILTIN_SYMBOL) {
            return null;
        }
        return symbol.getContainingPsiFile(project);
    }

    @Contract(value="null->false")
    public static boolean isInProjectSources(@Nullable PsiElement element) {
        return element != null && OCSearchScope.isInProjectSources(element.getProject(), OCSearchScope.getVirtualFile(element));
    }

    public static boolean isInProjectSources(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(14);
        }
        return file != null && OCSearchScope.getProjectSourcesScope(project).contains(file);
    }

    private static boolean isInExplicitProjectSources(@NotNull ProjectFileIndex index, @NotNull VirtualFile file) {
        if (index == null) {
            OCSearchScope.$$$reportNull$$$0(15);
        }
        if (file == null) {
            OCSearchScope.$$$reportNull$$$0(16);
        }
        return OCExplicitSourcesSearchScope.isInExplicitProjectSources((ProjectFileIndex)index, (VirtualFile)file);
    }

    private static boolean isInProject(@NotNull ProjectFileIndex index, @NotNull VirtualFile file) {
        if (index == null) {
            OCSearchScope.$$$reportNull$$$0(17);
        }
        if (file == null) {
            OCSearchScope.$$$reportNull$$$0(18);
        }
        return index.isInContent(file) && !index.isInLibrary(file);
    }

    public static boolean isInProjectNonSources(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(19);
        }
        if (file == null) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return OCSearchScope.isInProject(index, file) && !OCSearchScope.getProjectSourcesScope(project).contains(file);
    }

    public static boolean isInProject(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(20);
        }
        if (file == null) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return OCSearchScope.isInProject(index, file);
    }

    @Contract(value="null->false")
    public static boolean isInProjectSourcesOrLibraries(@Nullable PsiElement element) {
        return element != null && OCSearchScope.isInProjectSourcesOrLibraries(element.getProject(), OCSearchScope.getVirtualFile(element));
    }

    public static boolean isInProjectSourcesOrLibraries(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(21);
        }
        if (file == null) {
            return false;
        }
        return OCSearchScope.getProjectSourcesScope(project).contains(file) || ProjectScope.getLibrariesScope((Project)project).contains(file);
    }

    @Contract(value="null, _->false")
    public static boolean isInLibraries(@Nullable OCSymbol symbol, @NotNull Project project) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(22);
        }
        return OCSearchScope.isInLibraries((PsiElement)OCSearchScope.getContainingFile(symbol, project));
    }

    @Contract(value="null->false")
    public static boolean isInLibraries(@Nullable PsiElement element) {
        VirtualFile file = OCSearchScope.getVirtualFile(element);
        if (file == null) {
            return false;
        }
        return OCSearchScope.isInLibraries(file, element.getProject());
    }

    public static boolean isInLibraries(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            OCSearchScope.$$$reportNull$$$0(23);
        }
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(24);
        }
        return ProjectScope.getLibrariesScope((Project)project).contains(file);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiCodeFragment) {
            PsiElement context = file.getContext();
            file = context == null ? null : context.getContainingFile();
        }
        return file == null ? null : OCInclusionContextUtil.getVirtualFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/search/scopes/OCSearchScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceCondition";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 16: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/search/scopes/OCSearchScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSourcesScope";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedHeadersCache";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitlySpecifiedProjectSourceFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSourcesCacheDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGotoSymbolScope";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSourcesScope";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProjectSourcesScope";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isImportedFromSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImportedHeadersCache";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitlySpecifiedProjectSourceFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSourcesCacheDependencies";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectSources";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInExplicitProjectSources";
                break;
            }
            case 17: 
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInProject";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectNonSources";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectSourcesOrLibraries";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

