/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.application.options.editor.AutoImportOptionsProvider;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.settings.OCCodeInsightSettings;
import com.jetbrains.cidr.lang.settings.OCEnumGroupOption;
import com.jetbrains.cidr.lang.settings.OCHeaderImportStyle;
import com.jetbrains.cidr.lang.settings.OCOption;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class OCAutoImportOptionsProvider
implements AutoImportOptionsProvider {
    private JPanel myHeaderImportStyleComponent;
    private JCheckBox myShowImportPopupBox;
    private JCheckBox myAllowImportInCompletionBox;
    private OCEnumGroupOption<OCHeaderImportStyle> myHeaderImportStyleOption;

    public JComponent createComponent() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultAnchor(17);
        this.myHeaderImportStyleOption = new OCEnumGroupOption<OCHeaderImportStyle>(ApplicationBundle.message((String)"auto.import", (Object[])new Object[0]), OCEnumGroupOption.Presentation.Section, OCHeaderImportStyle.values(), OCBundle.message("group.option.predefine", new Object[0]), OCBundle.message("group.option.import", new Object[0]));
        this.myShowImportPopupBox = new JCheckBox(ApplicationBundle.message((String)"checkbox.show.import.popup", (Object[])new Object[0]));
        this.myAllowImportInCompletionBox = new JCheckBox(OCBundle.message("checkbox.allow.import.in.completion", new Object[0]));
        this.myHeaderImportStyleComponent = this.myHeaderImportStyleOption.createComponent(false);
        panel2.add((Component)this.myShowImportPopupBox, bag.nextLine());
        panel2.add((Component)this.myAllowImportInCompletionBox, bag.nextLine());
        if (PlatformUtils.isAppCode()) {
            panel2.add((Component)this.myHeaderImportStyleComponent, bag.nextLine());
        }
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)panel2, "West");
        wrapper.setBorder(IdeBorderFactory.createTitledBorder((String)OCLanguageUtils.getConfigLanguage().getDisplayName()));
        return wrapper;
    }

    public boolean isModified() {
        OCCodeInsightSettings settings = OCCodeInsightSettings.getInstance();
        boolean isModified = OCAutoImportOptionsProvider.isModified(this.myHeaderImportStyleOption, this.myHeaderImportStyleComponent, settings.HEADER_IMPORT_STYLE);
        isModified |= OCAutoImportOptionsProvider.isModified(this.myShowImportPopupBox, settings.SHOW_IMPORT_POPUP);
        return isModified |= OCAutoImportOptionsProvider.isModified(this.myAllowImportInCompletionBox, settings.ALLOW_IMPORT_IN_COMPLETION);
    }

    private static <T, Comp extends JComponent> boolean isModified(OCOption<T, Comp> option, Comp component, T value) {
        return !option.getSelectedValue(component).equals(value);
    }

    private static boolean isModified(JToggleButton checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    public void apply() throws ConfigurationException {
        OCCodeInsightSettings settings = OCCodeInsightSettings.getInstance();
        settings.HEADER_IMPORT_STYLE = this.myHeaderImportStyleOption.getSelectedValue(this.myHeaderImportStyleComponent);
        settings.SHOW_IMPORT_POPUP = this.myShowImportPopupBox.isSelected();
        settings.ALLOW_IMPORT_IN_COMPLETION = this.myAllowImportInCompletionBox.isSelected();
    }

    public void reset() {
        OCCodeInsightSettings settings = OCCodeInsightSettings.getInstance();
        this.myShowImportPopupBox.setSelected(settings.SHOW_IMPORT_POPUP);
        this.myAllowImportInCompletionBox.setSelected(settings.ALLOW_IMPORT_IN_COMPLETION);
        this.myHeaderImportStyleOption.selectValue(this.myHeaderImportStyleComponent, settings.HEADER_IMPORT_STYLE);
    }
}

