/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.lang.settings.OCOption;
import java.awt.FlowLayout;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;

public class OCEnumComboOption<T>
implements OCOption<T, JPanel> {
    private final T[] myValues;
    @Nls
    private final String[] myChoices;
    private final @NlsContexts.Label String myGroupName;

    public OCEnumComboOption(@NlsContexts.Label String groupName, T[] values, String ... choices) {
        this.myGroupName = groupName;
        this.myChoices = choices;
        this.myValues = values;
    }

    @Override
    public JPanel createComponent() {
        JPanel panel2 = new JPanel(new FlowLayout(0, 0, 0));
        panel2.add(Box.createHorizontalStrut(7));
        panel2.add(new JLabel(this.myGroupName + ":"));
        panel2.add(new JComboBox<String>(this.myChoices));
        return panel2;
    }

    @Override
    public T getSelectedValue(JPanel component) {
        JComboBox comboBox = (JComboBox)component.getComponent(2);
        return this.myValues[comboBox.getSelectedIndex()];
    }

    @Override
    public void selectValue(JPanel component, T value) {
        JComboBox comboBox = (JComboBox)component.getComponent(2);
        comboBox.setSelectedIndex(ArrayUtil.indexOf((Object[])this.myValues, value));
    }

    @Override
    public void addItemListener(JPanel component, ItemListener listener) {
        JComboBox comboBox = (JComboBox)component.getComponent(2);
        comboBox.addItemListener(listener);
    }
}

