/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.psi.impl.OCBinaryExpressionImpl;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBinaryExpressionSymbol
extends OCExpressionSymbol {
    private OCElementType myOperator;
    private OCExpressionSymbol myLeftOperand;
    private OCExpressionSymbol myRightOperand;

    public OCBinaryExpressionSymbol() {
    }

    /*
     * WARNING - void declaration
     */
    public OCBinaryExpressionSymbol(@Nullable VirtualFile file, long offset, @NotNull OCElementType operator, @NotNull OCExpressionSymbol operand, @NotNull OCExpressionSymbol oCExpressionSymbol) {
        void operand1;
        if (operator == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(0);
        }
        if (operand == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(1);
        }
        if (oCExpressionSymbol == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(2);
        }
        super(file, offset);
        this.myOperator = operator;
        this.myLeftOperand = operand;
        this.myRightOperand = operand1;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(3);
        }
        if (first == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(4);
        }
        if (second == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(5);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCBinaryExpressionSymbol firstSymbol = (OCBinaryExpressionSymbol)first;
        OCBinaryExpressionSymbol secondSymbol = (OCBinaryExpressionSymbol)second;
        if (firstSymbol.myOperator != secondSymbol.myOperator) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myLeftOperand, secondSymbol.myLeftOperand)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myRightOperand, secondSymbol.myRightOperand);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(6);
        }
        return evaluator.evalBinary(this.myOperator, this.myLeftOperand.evaluate(evaluator), this.myRightOperand.evaluate(evaluator));
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(7);
        }
        Info info = this.getInfo(context);
        if (info.customReturnType != null) {
            OCType oCType = info.customReturnType;
            if (oCType == null) {
                OCBinaryExpressionSymbol.$$$reportNull$$$0(8);
            }
            return oCType;
        }
        if (info.leftType != null && info.rightType != null) {
            OCType oCType = OCBinaryExpressionImpl.getBinaryExprType(this.myOperator, info.leftType, info.rightType, context);
            if (oCType == null) {
                OCBinaryExpressionSymbol.$$$reportNull$$$0(9);
            }
            return oCType;
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(10);
        }
        return oCUnknownType;
    }

    @Nullable
    public OCType getCustomReturnType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(11);
        }
        return this.getInfo((OCResolveContext)context).customReturnType;
    }

    @NotNull
    private Info getInfo(@NotNull OCResolveContext context) {
        OCFunctionSymbol symbol;
        if (context == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(12);
        }
        OCType leftType = this.myLeftOperand.getResolvedType(context);
        OCType rightType = this.myRightOperand.getResolvedType(context);
        OCType customReturnType = null;
        if (leftType != null && rightType != null && (symbol = this.tryResolveOperator(context, leftType, rightType)) != null) {
            customReturnType = symbol.getType().getReturnType().resolve(context);
        }
        return new Info(leftType, rightType, customReturnType);
    }

    @Nullable
    public OCFunctionSymbol tryResolveOperator(@NotNull OCResolveContext context) {
        if (context == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(13);
        }
        OCType leftType = this.myLeftOperand.getResolvedType(context);
        OCType rightType = this.myRightOperand.getResolvedType(context);
        return this.tryResolveOperator(context, leftType, rightType);
    }

    @Nullable
    private OCFunctionSymbol tryResolveOperator(@NotNull OCResolveContext context, @Nullable OCType leftType, @Nullable OCType rightType) {
        if (context == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(14);
        }
        if (leftType instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)leftType).getSymbol());
        }
        if (rightType instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)rightType).getSymbol());
        }
        if (leftType != null && rightType != null) {
            return OCOperatorReference.resolveOperator(this.myOperator.getName(), OCOperatorReference.OperatorPlacement.INFIX, Arrays.asList(leftType, rightType), Arrays.asList(this.myLeftOperand, this.myRightOperand), context);
        }
        return null;
    }

    @NotNull
    public OCElementType getOperator() {
        OCElementType oCElementType = this.myOperator;
        if (oCElementType == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(15);
        }
        return oCElementType;
    }

    @NotNull
    public OCExpressionSymbol getLeftOperand() {
        OCExpressionSymbol oCExpressionSymbol = this.myLeftOperand;
        if (oCExpressionSymbol == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(16);
        }
        return oCExpressionSymbol;
    }

    @NotNull
    public OCExpressionSymbol getRightOperand() {
        OCExpressionSymbol oCExpressionSymbol = this.myRightOperand;
        if (oCExpressionSymbol == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(17);
        }
        return oCExpressionSymbol;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myLeftOperand.getPresentableName() + " " + this.myOperator.getName() + " " + this.myRightOperand.getPresentableName();
        if (string == null) {
            OCBinaryExpressionSymbol.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/expression/OCBinaryExpressionSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/expression/OCBinaryExpressionSymbol";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperator";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeftOperand";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRightOperand";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCustomReturnType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryResolveOperator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Info {
        @Nullable
        public final OCType leftType;
        @Nullable
        public final OCType rightType;
        @Nullable
        public final OCType customReturnType;

        private Info(@Nullable OCType leftType, @Nullable OCType rightType, @Nullable OCType customReturnType) {
            this.leftType = leftType;
            this.rightType = rightType;
            this.customReturnType = customReturnType;
        }
    }
}

