/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import org.jetbrains.annotations.NotNull;

public class FileContentSnapshot {
    @NotNull
    private final CharSequence myText;
    private final Stamp myStamp;

    /*
     * WARNING - void declaration
     */
    public FileContentSnapshot(@NotNull CharSequence text, long modificationStamp, boolean bl) {
        void isPsi;
        if (text == null) {
            FileContentSnapshot.$$$reportNull$$$0(0);
        }
        this.myText = text;
        this.myStamp = new Stamp(modificationStamp, (boolean)isPsi);
    }

    @NotNull
    public CharSequence getText() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            FileContentSnapshot.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public Stamp getStamp() {
        return this.myStamp;
    }

    @NotNull
    public static FileContentSnapshot get(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        PsiDocumentManager manager;
        Document document;
        PsiFile psiFile;
        if (virtualFile == null) {
            FileContentSnapshot.$$$reportNull$$$0(2);
        }
        if (project == null) {
            FileContentSnapshot.$$$reportNull$$$0(3);
        }
        if ((psiFile = OCInclusionContextUtil.findCachedPsiFile(virtualFile, project)) != null && (document = (manager = PsiDocumentManager.getInstance((Project)project)).getCachedDocument(psiFile)) != null) {
            return new FileContentSnapshot(document.getCharsSequence(), psiFile.getModificationStamp(), true);
        }
        long modificationStamp = virtualFile.getModificationStamp();
        if (virtualFile.getFileType().isBinary()) {
            return new FileContentSnapshot("", modificationStamp, false);
        }
        return new FileContentSnapshot(LoadTextUtil.loadText((VirtualFile)virtualFile), modificationStamp, false);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isUpToDate(@NotNull Project project, @NotNull VirtualFile file, long stamp, boolean bl) {
        void isPsi;
        if (project == null) {
            FileContentSnapshot.$$$reportNull$$$0(4);
        }
        if (file == null) {
            FileContentSnapshot.$$$reportNull$$$0(5);
        }
        if (isPsi != false) {
            PsiFile psiFile = OCInclusionContextUtil.findCachedPsiFile(file, project);
            return psiFile != null && psiFile.getModificationStamp() == stamp;
        }
        return file.getModificationStamp() == stamp;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/FileContentSnapshot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileContentSnapshot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Stamp {
        private final long myStamp;
        private final boolean myIsPsi;

        public Stamp(long modificationStamp, boolean isPsi) {
            this.myStamp = modificationStamp;
            this.myIsPsi = isPsi;
        }

        public boolean isUpToDate(@NotNull Project project, @NotNull VirtualFile file) {
            if (project == null) {
                Stamp.$$$reportNull$$$0(0);
            }
            if (file == null) {
                Stamp.$$$reportNull$$$0(1);
            }
            return FileContentSnapshot.isUpToDate(project, file, this.myStamp, this.myIsPsi);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileContentSnapshot$Stamp";
            objectArray[2] = "isUpToDate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

