/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapCacheBuildingSession;
import com.jetbrains.cidr.lang.symbols.symtable.ImpatientDeferredException;
import com.jetbrains.cidr.lang.symbols.symtable.ModuleMapDescriptor;
import com.jetbrains.cidr.lang.symbols.symtable.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.RecursiveSymbolBuilding;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.List;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleMapBuildingActivity {
    private final Project myProject;
    private final OCBuildingActivityProgressIndicator myIndicator;
    private final ModuleMapManager myModuleMapManager;

    public ModuleMapBuildingActivity(@NotNull Project project, @NotNull OCBuildingActivityProgressIndicator indicator) {
        if (project == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myIndicator = indicator;
        this.myModuleMapManager = ModuleMapManager.getInstance(this.myProject);
    }

    public void buildModuleMaps() {
        List<ModuleMapDescriptor> descriptors = this.collectHeadersSearchRoots();
        this.buildModuleMaps(descriptors);
    }

    public static void buildModuleMaps(@NotNull List<ModuleMapDescriptor> descriptors, @NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (descriptors == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(4);
        }
        new ModuleMapBuildingActivity(project, new OCBuildingActivityProgressIndicator(indicator)).buildModuleMaps(descriptors);
    }

    @NotNull
    private List<ModuleMapDescriptor> collectHeadersSearchRoots() {
        List list = OCSymbolTablesBuildingActivity.runCancelableReadAction(this.myProject, (ProgressIndicator)this.myIndicator, () -> this.myModuleMapManager.getDescriptorsForInitialBuilding());
        if (list == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(5);
        }
        return list;
    }

    private void buildModuleMaps(@NotNull List<ModuleMapDescriptor> descriptors) {
        if (descriptors == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(6);
        }
        String projectHash = this.getProjectLocationHash();
        ImmutableListMultimap<Object, ModuleMapDescriptor> clusterizationMap = ModuleMapBuildingActivity.buildClusterization(descriptors);
        int size = clusterizationMap.values().size();
        ModuleMapLog.LOG.info("Building module maps for " + size + " (root, configuration) pairs");
        this.buildModuleMaps(projectHash, clusterizationMap, 0.1, 0.7);
        this.processModuleMaps(projectHash, clusterizationMap, 0.7, 0.85);
        if (!ModuleMapCacheBuildingSession.INSTANCE.isModuleMapBuildingSession()) {
            this.processModulesPerConfiguration(projectHash, 0.85, 0.9);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildModuleMaps(@NotNull String projectHash, @NotNull ImmutableListMultimap<Object, ModuleMapDescriptor> clusterizationMap, double from, double d) {
        void to;
        if (projectHash == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(7);
        }
        if (clusterizationMap == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(8);
        }
        int size = clusterizationMap.values().size();
        AtomicInteger processedCount = new AtomicInteger(0);
        this.processModuleMapBuilding(projectHash, clusterizationMap, from, (double)to, OCBundle.message("building.module.maps", new Object[0]), (item, session, rescheduling) -> {
            HeadersSearchRoot root = item.getHeadersSearchRoot();
            this.myIndicator.setText2(root.getPresentableName());
            this.myModuleMapManager.buildModule((ModuleMapDescriptor)item, rescheduling, session);
            this.myIndicator.setFraction((double)processedCount.incrementAndGet() / (double)size);
        });
    }

    /*
     * WARNING - void declaration
     */
    private void processModuleMaps(@NotNull String projectHash, @NotNull ImmutableListMultimap<Object, ModuleMapDescriptor> clusterizationMap, double from, double d) {
        void to;
        if (projectHash == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(9);
        }
        if (clusterizationMap == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(10);
        }
        int size = clusterizationMap.values().size();
        AtomicInteger processedCount = new AtomicInteger(0);
        this.processModuleMapBuilding(projectHash, clusterizationMap, from, (double)to, OCBundle.message("processing.module.maps", new Object[0]), (item, session, rescheduling) -> {
            HeadersSearchRoot root = item.getHeadersSearchRoot();
            this.myIndicator.setText2(root.getPresentableName());
            this.myModuleMapManager.buildDependencies((ModuleMapDescriptor)item, rescheduling, session);
            this.myIndicator.setFraction((double)processedCount.incrementAndGet() / (double)size);
        });
    }

    /*
     * WARNING - void declaration
     */
    private void processModulesPerConfiguration(@NotNull String projectHash, double from, double d) {
        void to;
        if (projectHash == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(11);
        }
        ImmutableListMultimap<Object, ConfigurationItem> configurationsCluster = this.setupConfigurationsClusterization();
        AtomicInteger processedCount = new AtomicInteger(0);
        int size = configurationsCluster.values().size();
        this.processModuleMapBuilding(projectHash, configurationsCluster, from, (double)to, OCBundle.message("processing.module.maps", new Object[0]), (item, _1, _2) -> {
            OCResolveConfiguration configuration = item.configuration;
            this.myIndicator.setText2(configuration != null ? configuration.getDisplayName() : "");
            this.myModuleMapManager.cacheFor(configuration).getModules();
            this.myIndicator.setFraction((double)processedCount.incrementAndGet() / (double)size);
        });
    }

    @NotNull
    private ImmutableListMultimap<Object, ConfigurationItem> setupConfigurationsClusterization() {
        ImmutableListMultimap.Builder builder2 = ImmutableListMultimap.builder();
        for (OCResolveConfiguration configuration : OCWorkspace.getInstance((Project)this.myProject).getConfigurations()) {
            builder2.put(new Object(), (Object)new ConfigurationItem(configuration));
        }
        builder2.put(new Object(), (Object)new ConfigurationItem(null));
        ImmutableListMultimap immutableListMultimap = builder2.build();
        if (immutableListMultimap == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(12);
        }
        return immutableListMultimap;
    }

    @NotNull
    private static ImmutableListMultimap<Object, ModuleMapDescriptor> buildClusterization(@NotNull List<ModuleMapDescriptor> descriptors) {
        if (descriptors == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(13);
        }
        ImmutableListMultimap.Builder clusterization = ImmutableListMultimap.builder();
        for (ModuleMapDescriptor descriptor : descriptors) {
            OCResolveConfiguration configuration = descriptor.getConfiguration();
            Object cluster = ModuleMapBuildingActivity.getClusterization(configuration);
            clusterization.put(cluster, (Object)descriptor);
        }
        ImmutableListMultimap immutableListMultimap = clusterization.build();
        if (immutableListMultimap == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(14);
        }
        return immutableListMultimap;
    }

    @NotNull
    @NonNls
    private String getProjectLocationHash() {
        String[] projectLocationHash = new String[1];
        OCSymbolTablesBuildingActivity.runCancelableReadAction(this.myProject, (ProgressIndicator)this.myIndicator, () -> {
            projectLocationHash[0] = this.myProject.getLocationHash();
        });
        String string = projectLocationHash[0];
        if (string == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(15);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private <T> void processModuleMapBuilding(@NotNull @NonNls String projectHash, @NotNull ImmutableListMultimap<Object, T> clusterizationMap, double from, double to, @NotNull @NlsContexts.ProgressText String string, @NotNull Task<T> task) {
        void action;
        void message;
        if (projectHash == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(16);
        }
        if (clusterizationMap == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(17);
        }
        if (string == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(18);
        }
        if (task == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(19);
        }
        OCSymbolTablesBuildingActivity.processRecursiveTasks(this.myProject, this.myIndicator, from, to, clusterizationMap, (arg_0, arg_1) -> this.lambda$processModuleMapBuilding$5((String)message, projectHash, (Task)action, arg_0, arg_1));
    }

    @NotNull
    private static Object getClusterization(@NotNull OCResolveConfiguration configuration) {
        Object cluster;
        if (configuration == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(20);
        }
        if ((cluster = configuration.getCompilerSettings(ModuleMapUtil.getPreferredLanguageKind(configuration)).getIndexingCluster()) == null) {
            cluster = ObjectUtils.NULL;
        }
        Object object = cluster;
        if (object == null) {
            ModuleMapBuildingActivity.$$$reportNull$$$0(21);
        }
        return object;
    }

    private /* synthetic */ RecursiveSymbolBuilding lambda$processModuleMapBuilding$5(String message, String projectHash, Task action, ProgressIndicator global, ProgressIndicator read) {
        return new ModuleMapBuilding(this.myProject, global, read, 1, message, projectHash, action);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/ModuleMapBuildingActivity";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectHash";
                break;
            }
            case 8: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clusterizationMap";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/ModuleMapBuildingActivity";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectHeadersSearchRoots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "setupConfigurationsClusterization";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildClusterization";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectLocationHash";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getClusterization";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildModuleMaps";
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 21: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processModuleMaps";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processModulesPerConfiguration";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildClusterization";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processModuleMapBuilding";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getClusterization";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConfigurationItem {
        @Nullable
        final OCResolveConfiguration configuration;

        ConfigurationItem(@Nullable OCResolveConfiguration configuration) {
            this.configuration = configuration;
        }
    }

    private static interface Task<T> {
        public void perform(@NotNull T var1, @NotNull SerializationSession var2, @Nullable Runnable var3);
    }

    private static class ModuleMapBuilding<T>
    extends RecursiveSymbolBuilding<T> {
        private final ThreadLocal<SerializationSession> serializationSession;
        private final boolean isImpatient;
        private final Task<T> myTask;

        private ModuleMapBuilding(@NotNull Project project, @NotNull ProgressIndicator globalIndicator, @NotNull ProgressIndicator readIndicator, int maxLeafSize, @NotNull @NlsContexts.ProgressText String indicatorText, @NotNull @NonNls String projectHash, @NotNull Task<T> task) {
            if (project == null) {
                ModuleMapBuilding.$$$reportNull$$$0(0);
            }
            if (globalIndicator == null) {
                ModuleMapBuilding.$$$reportNull$$$0(1);
            }
            if (readIndicator == null) {
                ModuleMapBuilding.$$$reportNull$$$0(2);
            }
            if (indicatorText == null) {
                ModuleMapBuilding.$$$reportNull$$$0(3);
            }
            if (projectHash == null) {
                ModuleMapBuilding.$$$reportNull$$$0(4);
            }
            if (task == null) {
                ModuleMapBuilding.$$$reportNull$$$0(5);
            }
            super(project, globalIndicator, readIndicator, maxLeafSize, indicatorText);
            this.isImpatient = Registry.is((String)"cidr.modulemaps.building.impatient", (boolean)true);
            this.serializationSession = ThreadLocal.withInitial(() -> new SerializationSession(projectHash));
            this.myTask = task;
        }

        @Override
        @NotNull
        protected RecursiveSymbolBuilding.ReadActionTask createWorkerTask(@NotNull CountedCompleter<?> parent, @NotNull ImmutableList<T> workset) {
            if (parent == null) {
                ModuleMapBuilding.$$$reportNull$$$0(6);
            }
            if (workset == null) {
                ModuleMapBuilding.$$$reportNull$$$0(7);
            }
            return new RecursiveSymbolBuilding.ReadActionTask(parent, workset){

                @Override
                protected void computeInReadAction(@NotNull T item) {
                    if (item == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        myTask.perform(item, serializationSession.get(), isImpatient ? () -> this.reschedule(ImmutableList.of((Object)item), 0) : null);
                    }
                    catch (ImpatientDeferredException e) {
                        this.addToPendingCount(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/cidr/lang/symbols/symtable/ModuleMapBuildingActivity$ModuleMapBuilding$1", "computeInReadAction"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "globalIndicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readIndicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicatorText";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectHash";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workset";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/ModuleMapBuildingActivity$ModuleMapBuilding";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createWorkerTask";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

