/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import org.jetbrains.annotations.NotNull;

class OCClearingSymbolsActivity {
    OCClearingSymbolsActivity() {
    }

    public static void build(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userData) {
        if (indicator == null) {
            OCClearingSymbolsActivity.$$$reportNull$$$0(0);
        }
        if (userData == null) {
            OCClearingSymbolsActivity.$$$reportNull$$$0(1);
        }
        indicator.checkCanceled();
        indicator.setText(OCBundle.message("symbol.table.activity.building.symbols", new Object[0]));
        indicator.setText2("");
        indicator.setIndeterminate(true);
        indicator.startTiming("Clearing symbols");
        OCSymbolTablesBuildingActivity.invokeAndWaitSafely((ProgressIndicator)indicator, () -> {
            if (indicator.isCanceled()) {
                return;
            }
            Project project = userData.getProject();
            FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
            cache.notifySymbolsUnloaded();
            cache.clearAllTables();
            cache.reparseCachedPsiFiles();
            OCClearingSymbolsActivity.clearAllSymbolDependentCaches(project);
            ModuleMapCache.getInstance(project).reset();
            ModuleMapManager.getInstance(project).clearCache();
        });
        indicator.checkCanceled();
        indicator.logTiming();
    }

    private static void clearAllSymbolDependentCaches(@NotNull Project project) {
        if (project == null) {
            OCClearingSymbolsActivity.$$$reportNull$$$0(2);
        }
        for (OCResolveConfiguration configuration : OCWorkspace.getInstance((Project)project).getConfigurations()) {
            OCInclusionContext.onPrecompiledContextChange(configuration);
            OCInclusionContext.clearSymbolTableConformanceCache(configuration);
            OCImportGraph.invalidateRootHeadersCache(configuration);
        }
        OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCClearingSymbolsActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "clearAllSymbolDependentCaches";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

