/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.symbols.symtable.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class OCHeaderMapLoadingActivity {
    OCHeaderMapLoadingActivity() {
    }

    static void build(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userData) {
        if (indicator == null) {
            OCHeaderMapLoadingActivity.$$$reportNull$$$0(0);
        }
        if (userData == null) {
            OCHeaderMapLoadingActivity.$$$reportNull$$$0(1);
        }
        Project project = userData.getProject();
        indicator.checkCanceled();
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        indicator.startTiming("Loading Header Maps");
        indicator.setText(OCBundle.message("symbol.table.activity.loading.header.maps", new Object[0]));
        OCHeaderMapManager.getInstance(project).load(OCHeaderMapLoadingActivity.getAllHeaderRoots(project, indicator, false));
        indicator.logTiming();
    }

    @NotNull
    static Set<HeadersSearchRoot> getAllHeaderRoots(@NotNull Project project, @NotNull OCBuildingActivityProgressIndicator indicator, boolean forModuleMapsBuilding) {
        if (project == null) {
            OCHeaderMapLoadingActivity.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            OCHeaderMapLoadingActivity.$$$reportNull$$$0(3);
        }
        ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(project);
        Set set = (Set)OCSymbolTablesBuildingActivity.runCancelableReadAction(project, (ProgressIndicator)indicator, () -> {
            if (forModuleMapsBuilding) {
                return new THashSet(moduleMapManager.getGlobalCache().getHeaderSearchRoots());
            }
            List configurations = OCWorkspace.getInstance((Project)project).getConfigurations();
            return configurations.stream().flatMap(configuration -> configuration.getAllCompilerSettings()).flatMap(settings -> {
                ProgressManager.checkCanceled();
                return settings.getHeadersSearchRoots().getAllRoots().stream();
            }).collect(Collectors.toCollection(THashSet::new));
        });
        if (set == null) {
            OCHeaderMapLoadingActivity.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/OCHeaderMapLoadingActivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCHeaderMapLoadingActivity";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllHeaderRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllHeaderRoots";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

