/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.ArcAnnotatedType;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCReferenceTypeFull;
import com.jetbrains.cidr.lang.types.OCReferenceTypeSimple;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCReferenceType
extends OCType
implements Serializable,
ArcAnnotatedType {
    @NotNull
    private OCSymbolReference myReference;
    private boolean myIsKindof;
    private boolean myFunctionParameterType;

    @NotNull
    public static OCReferenceType create(boolean isConst, boolean isVolatile, @NotNull OCSymbolReference reference, String @NotNull [] protocolNames, @NotNull OCTypeSubstitution substitution, @Nullable ARCAttribute arcAttribute, @Nullable OCNullability nullability, boolean functionParameterType, boolean isKindof) {
        if (reference == null) {
            OCReferenceType.$$$reportNull$$$0(0);
        }
        if (substitution == null) {
            OCReferenceType.$$$reportNull$$$0(1);
        }
        if (protocolNames == null) {
            OCReferenceType.$$$reportNull$$$0(2);
        }
        if (protocolNames.length == 0 && substitution == OCTypeSubstitution.ID && arcAttribute == null) {
            return new OCReferenceTypeSimple(reference, isConst, isVolatile, nullability, functionParameterType, isKindof);
        }
        return new OCReferenceTypeFull(isConst, isVolatile, reference, protocolNames, substitution, arcAttribute, nullability, functionParameterType, isKindof);
    }

    protected OCReferenceType() {
        this.myFunctionParameterType = false;
    }

    protected OCReferenceType(boolean isConst, boolean isVolatile, @NotNull OCSymbolReference reference, @Nullable OCNullability nullability, boolean functionParameterType, boolean isKindof) {
        if (reference == null) {
            OCReferenceType.$$$reportNull$$$0(3);
        }
        super(isConst, isVolatile, nullability);
        this.myFunctionParameterType = false;
        this.myReference = reference;
        this.myFunctionParameterType = functionParameterType;
        this.myIsKindof = isKindof;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitReferenceType(this);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCReferenceType.$$$reportNull$$$0(4);
        }
        if (first == null) {
            OCReferenceType.$$$reportNull$$$0(5);
        }
        if (second == null) {
            OCReferenceType.$$$reportNull$$$0(6);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCReferenceType f = (OCReferenceType)first;
        OCReferenceType s = (OCReferenceType)second;
        if (f.getARCAttribute() != s.getARCAttribute()) {
            return false;
        }
        if (f.myIsKindof != s.myIsKindof) {
            return false;
        }
        if (!Arrays.equals(f.getProtocolNames(), s.getProtocolNames())) {
            return false;
        }
        if (!c.equalObjects(f.myReference, s.myReference)) {
            return false;
        }
        return c.equalObjects(f.getSubstitution(), s.getSubstitution());
    }

    @Override
    public int hashCode() {
        int result = this.baseHashCode();
        result = 31 * result + this.myReference.hashCode();
        result = 31 * result + Objects.hashCode((Object)this.getARCAttribute());
        result = 31 * result + Arrays.hashCode(this.getProtocolNames());
        result = 31 * result + this.getSubstitution().hashCode();
        result = 31 * result + Boolean.valueOf(this.myIsKindof).hashCode();
        return result;
    }

    public abstract String @NotNull [] getProtocolNames();

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        if (context == null) {
            OCReferenceType.$$$reportNull$$$0(7);
        }
        return true;
    }

    @NotNull
    public abstract OCTypeSubstitution getSubstitution();

    @NotNull
    public static OCType resolvedFromText(@NonNls String name, @NotNull PsiElement context) {
        if (context == null) {
            OCReferenceType.$$$reportNull$$$0(8);
        }
        OCType oCType = OCReferenceType.fromText(name).resolve(context);
        if (oCType == null) {
            OCReferenceType.$$$reportNull$$$0(9);
        }
        return oCType;
    }

    @NotNull
    public static OCType resolvedFromText(@NonNls String name, @NotNull OCResolveContext context) {
        if (context == null) {
            OCReferenceType.$$$reportNull$$$0(10);
        }
        OCType oCType = OCReferenceType.fromText(name).resolve(context);
        if (oCType == null) {
            OCReferenceType.$$$reportNull$$$0(11);
        }
        return oCType;
    }

    @NotNull
    public static OCType resolvedFromText(@NonNls String name, @NotNull @NonNls String protocolName, @NotNull PsiElement context) {
        if (protocolName == null) {
            OCReferenceType.$$$reportNull$$$0(12);
        }
        if (context == null) {
            OCReferenceType.$$$reportNull$$$0(13);
        }
        OCType oCType = OCReferenceType.fromText(name, protocolName).resolve(context);
        if (oCType == null) {
            OCReferenceType.$$$reportNull$$$0(14);
        }
        return oCType;
    }

    @NotNull
    public static OCType resolvedFromText(@NonNls String name, @NotNull @NonNls String protocolName, @NotNull OCResolveContext context) {
        if (protocolName == null) {
            OCReferenceType.$$$reportNull$$$0(15);
        }
        if (context == null) {
            OCReferenceType.$$$reportNull$$$0(16);
        }
        OCType oCType = OCReferenceType.fromText(name, protocolName).resolve(context);
        if (oCType == null) {
            OCReferenceType.$$$reportNull$$$0(17);
        }
        return oCType;
    }

    @NotNull
    public static OCType resolvedFromText(@NonNls String name, @NotNull OCResolveContext context, boolean ignoreImports) {
        if (context == null) {
            OCReferenceType.$$$reportNull$$$0(18);
        }
        OCType oCType = OCReferenceType.fromText(name).resolve(context, ignoreImports);
        if (oCType == null) {
            OCReferenceType.$$$reportNull$$$0(19);
        }
        return oCType;
    }

    @NotNull
    public static OCReferenceType fromText(@NonNls @Nullable String name) {
        OCReferenceType oCReferenceType = new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(OCQualifiedName.interned(name))).build();
        if (oCReferenceType == null) {
            OCReferenceType.$$$reportNull$$$0(20);
        }
        return oCReferenceType;
    }

    @NotNull
    public static OCReferenceType fromText(@NonNls @NotNull String name, @NotNull String protocolName) {
        if (name == null) {
            OCReferenceType.$$$reportNull$$$0(21);
        }
        if (protocolName == null) {
            OCReferenceType.$$$reportNull$$$0(22);
        }
        OCReferenceType oCReferenceType = new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(OCQualifiedName.interned(name))).setSingleProtocolName(protocolName).build();
        if (oCReferenceType == null) {
            OCReferenceType.$$$reportNull$$$0(23);
        }
        return oCReferenceType;
    }

    @NotNull
    public static OCReferenceType fromText(@NonNls @NotNull String name, String @NotNull [] protocolNames) {
        if (name == null) {
            OCReferenceType.$$$reportNull$$$0(24);
        }
        if (protocolNames == null) {
            OCReferenceType.$$$reportNull$$$0(25);
        }
        OCReferenceType oCReferenceType = new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(OCQualifiedName.interned(name))).setProtocolNames(protocolNames).build();
        if (oCReferenceType == null) {
            OCReferenceType.$$$reportNull$$$0(26);
        }
        return oCReferenceType;
    }

    public static OCReferenceType fromQualifiedName(OCQualifiedName name) {
        return new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(name)).build();
    }

    @NotNull
    public abstract OCReferenceType cloneWithReference(@NotNull OCSymbolReference var1);

    @NotNull
    public OCSymbolReference getReference() {
        OCSymbolReference oCSymbolReference = this.myReference;
        if (oCSymbolReference == null) {
            OCReferenceType.$$$reportNull$$$0(27);
        }
        return oCSymbolReference;
    }

    @NotNull
    public OCSymbolReference getReference(@NotNull OCResolveContext context) {
        if (context == null) {
            OCReferenceType.$$$reportNull$$$0(28);
        }
        OCSymbolReference oCSymbolReference = this.getReference(context.getFile());
        if (oCSymbolReference == null) {
            OCReferenceType.$$$reportNull$$$0(29);
        }
        return oCSymbolReference;
    }

    @NotNull
    public OCSymbolReference getReference(@Nullable PsiFile file) {
        OCLanguageKind kind = OCPsiFile.getKind(file);
        OCSymbolReference oCSymbolReference = this.getReference(kind == null || kind.isObjC());
        if (oCSymbolReference == null) {
            OCReferenceType.$$$reportNull$$$0(30);
        }
        return oCSymbolReference;
    }

    @NotNull
    public OCSymbolReference getReference(boolean maybeObjC) {
        OCSymbolReference oCSymbolReference = this.myReference;
        if (oCSymbolReference == null) {
            OCReferenceType.$$$reportNull$$$0(31);
        }
        return oCSymbolReference;
    }

    @Override
    protected String getBestNameInContext(@NotNull OCResolveContext context, @Nullable String nameHint, int templateDepth) {
        if (context == null) {
            OCReferenceType.$$$reportNull$$$0(32);
        }
        if (nameHint == null) {
            nameHint = CVQualifiers.appendCVQualifiers(this.myReference.getQualifiedName().getFullName(context), this, context.getProject());
        }
        return super.getBestNameInContext(context, nameHint, templateDepth);
    }

    @Override
    @Nullable
    public abstract ARCAttribute getARCAttribute();

    @Override
    @NotNull
    public OCReferenceType cloneWithArcAttribute(@Nullable ARCAttribute arcAttribute) {
        return OCReferenceType.create(this.isConst(), this.isVolatile(), this.getReference(), this.getProtocolNames(), this.getSubstitution(), arcAttribute, this.getNullability(), this.isFunctionParameterType(), this.isKindof());
    }

    public boolean isFunctionParameterType() {
        return this.myFunctionParameterType;
    }

    public void setFunctionParameterType(boolean functionParameterType) {
        this.myFunctionParameterType = functionParameterType;
    }

    public boolean isKindof() {
        return this.myIsKindof;
    }

    public boolean hasElaboratedTypeSpecifier() {
        return OCSymbolReference.removeTypeToken((String)this.myReference.getQualifiedName().getName()).typeToken != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 2: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocolNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/OCReferenceType";
                break;
            }
            case 12: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocolName";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/OCReferenceType";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvedFromText";
                break;
            }
            case 20: 
            case 23: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "fromText";
                break;
            }
            case 27: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolved";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolvedFromText";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fromText";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getBestNameInContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

