/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapRealFrameworkPathResolver;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapAwareAppleFramework;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RealFramework
extends ModuleMapAwareAppleFramework {
    @Nullable
    private final PsiFileSystemItem myParent;
    @NotNull
    private final VirtualFile myBaseFile;
    @Nullable
    private final String myResolveConfigurationId;

    public RealFramework(@NotNull Project project, @NotNull VirtualFile baseFile, @Nullable PsiFileSystemItem parentSdkOrFramework) {
        if (project == null) {
            RealFramework.$$$reportNull$$$0(0);
        }
        if (baseFile == null) {
            RealFramework.$$$reportNull$$$0(1);
        }
        this(project, null, baseFile, parentSdkOrFramework);
    }

    public RealFramework(@NotNull Project project, @Nullable String resolveConfigurationId, @NotNull VirtualFile baseFile, @Nullable PsiFileSystemItem parentSdkOrFramework) {
        if (project == null) {
            RealFramework.$$$reportNull$$$0(2);
        }
        if (baseFile == null) {
            RealFramework.$$$reportNull$$$0(3);
        }
        super(project, baseFile.getNameWithoutExtension());
        this.myParent = parentSdkOrFramework;
        this.myBaseFile = baseFile;
        this.myResolveConfigurationId = resolveConfigurationId;
    }

    @Nullable
    public PsiFileSystemItem getParent() {
        return this.myBaseFile.isValid() ? this.myManager.findDirectory(this.myBaseFile) : null;
    }

    @Override
    @NotNull
    public ModuleMapPathResolver createModuleMapPathResolver() {
        return new ModuleMapRealFrameworkPathResolver(this.myBaseFile);
    }

    @Override
    @Nullable
    public VirtualFile findModuleMapVirtualFile() {
        VirtualFile moduleMapFile;
        if (!this.myBaseFile.isValid()) {
            OCLog.LOG.error("Invalid base file for RealFramework" + this.getName());
            return null;
        }
        VirtualFile modulesDir = this.myBaseFile.findChild("Modules");
        if (modulesDir != null && modulesDir.isDirectory() && ModuleMapUtil.checkModuleMapFile(moduleMapFile = modulesDir.findChild("module.modulemap"))) {
            return moduleMapFile;
        }
        VirtualFile legacyFile = this.myBaseFile.findChild("module.map");
        if (ModuleMapUtil.checkModuleMapFile(legacyFile)) {
            return legacyFile;
        }
        return null;
    }

    @Nullable
    public PsiFileSystemItem getParentSdkOrFrameworkItem() {
        return this.myParent;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myBaseFile;
        if (virtualFile == null) {
            RealFramework.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    public boolean isValid() {
        return this.myBaseFile.isValid();
    }

    public boolean containsHeader(@Nullable VirtualFile file) {
        OCResolveConfiguration configuration;
        if (file == null) {
            return false;
        }
        if (this.myResolveConfigurationId != null) {
            OCWorkspace workspace = OCWorkspace.getInstance((Project)this.myProject);
            configuration = workspace.getConfigurationById(this.myResolveConfigurationId);
        } else {
            configuration = null;
        }
        ModuleMapSymbol module = ModuleMapUtil.getMainFrameworkModule((AppleFramework)this, configuration);
        if (module == null) {
            return false;
        }
        return module.getPathResolver().containsHeader(file);
    }

    protected boolean processFrameworkChildren(PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (this.myBaseFile.isValid()) {
            for (String eachDir : HEADERS_DIR_NAMES) {
                if (RealFramework.processUnder(processor, (VirtualFile)this.myBaseFile.findChild(eachDir), (boolean)false, (Project)this.myProject)) continue;
                return false;
            }
            if (!RealFramework.processUnder(processor, (VirtualFile)this.myBaseFile.findChild("Modules"), (boolean)false, (Project)this.myProject)) {
                return false;
            }
            if (!FrameworksSearchRoot.processFrameworksUnder((PsiFileSystemItem)this, this.myBaseFile.findChild("Frameworks"), processor, (Set<? super String>)new THashSet())) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RealFramework framework = (RealFramework)o;
        return this.myBaseFile.equals(framework.myBaseFile);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myBaseFile.hashCode();
        return result;
    }

    public String toString() {
        return "AppleFramework: [" + this.getName() + ": " + this.myBaseFile.getPath() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/RealFramework";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/RealFramework";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

