/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridgeInterface;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdBridge {
    private static final ImmutableList<FileExtensionPair> ourDefaultFileExtensions = ContainerUtil.immutableList((List)new ArrayList<FileExtensionPair>(3){
        {
            if (PlatformUtils.isAppCode()) {
                this.add(new FileExtensionPair("mm", "h", NamingConventionStyle.NONE));
            }
            ContainerUtil.addAll((Collection)this, (Object[])new FileExtensionPair[]{new FileExtensionPair("cpp", "h", NamingConventionStyle.NONE), new FileExtensionPair("c", "h", NamingConventionStyle.NONE)});
            if (PlatformUtils.isCLion()) {
                this.add(new FileExtensionPair("cu", "cuh", NamingConventionStyle.NONE));
            }
        }
    });
    public static final Key<Object> CLANG_CAN_OPEN_FILE = Key.create((String)"ClangCanOpenFileOnResolve");
    public static final Key<Object> CLANG_DONT_CLOSE_FILE = Key.create((String)"ClangDontCloseFileIfOpenedForResolve");

    public static boolean isClangdOnlyMode() {
        for (ClangdBridgeInterface bridge : ClangdBridgeInterface.EP_NAME.getExtensionList()) {
            if (bridge.isClangdOnlyMode()) continue;
            return false;
        }
        return true;
    }

    public static void registerAnnotatorPassFactories(@NotNull TextEditorHighlightingPassRegistrar registrar, int reparsingPassId, int clangErrorsPassId) {
        if (registrar == null) {
            ClangdBridge.$$$reportNull$$$0(0);
        }
        for (ClangdBridgeInterface bridge : ClangdBridgeInterface.EP_NAME.getExtensionList()) {
            bridge.registerAnnotatorPassFactories(registrar, reparsingPassId, clangErrorsPassId);
        }
    }

    @NotNull
    public static ImmutableList<FileExtensionPair> getFileExtensions(@NotNull Project project) {
        Iterator iterator;
        if (project == null) {
            ClangdBridge.$$$reportNull$$$0(1);
        }
        if ((iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator()).hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            ImmutableList<FileExtensionPair> immutableList = bridge.getFileExtensions(project);
            if (immutableList == null) {
                ClangdBridge.$$$reportNull$$$0(2);
            }
            return immutableList;
        }
        ImmutableList<FileExtensionPair> immutableList = ourDefaultFileExtensions;
        if (immutableList == null) {
            ClangdBridge.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    public static boolean isSupported(@NotNull Project project, @Nullable VirtualFile vf) {
        if (project == null) {
            ClangdBridge.$$$reportNull$$$0(4);
        }
        if (vf == null) {
            return false;
        }
        List list = ClangdBridgeInterface.EP_NAME.getExtensionList();
        if (!list.isEmpty()) {
            for (ClangdBridgeInterface bridge : list) {
                if (bridge.isSupported(vf)) continue;
                return false;
            }
            return true;
        }
        if (!(vf instanceof VirtualFileWithId)) {
            return false;
        }
        String ext = vf.getExtension();
        if (ext != null) {
            for (FileExtensionPair extPair : ClangdBridge.getFileExtensions(project)) {
                if (!ext.equalsIgnoreCase(extPair.mySourceExt) && !ext.equalsIgnoreCase(extPair.myHeaderExt)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean getParameterHints(@NotNull Project project) {
        Iterator iterator;
        if (project == null) {
            ClangdBridge.$$$reportNull$$$0(5);
        }
        if ((iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator()).hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.getParameterHints(project);
        }
        return false;
    }

    public static void setParameterHints(@NotNull Project project, boolean enabled) {
        if (project == null) {
            ClangdBridge.$$$reportNull$$$0(6);
        }
        for (ClangdBridgeInterface bridge : ClangdBridgeInterface.EP_NAME.getExtensionList()) {
            bridge.setParameterHints(project, enabled);
        }
    }

    @Nullable
    public static Class<? extends OCInspectionBase> getClazyInspection() {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.getClazyInspection();
        }
        return null;
    }

    @Nullable
    public static Class<? extends OCInspectionBase> getUnusedIncludesInspection() {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.getUnusedIncludesInspection();
        }
        return null;
    }

    public static boolean isInProjectSourcesOrLibraries(@NotNull Project project, @NotNull VirtualFile vf) {
        Iterator iterator;
        if (project == null) {
            ClangdBridge.$$$reportNull$$$0(7);
        }
        if (vf == null) {
            ClangdBridge.$$$reportNull$$$0(8);
        }
        if ((iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator()).hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.isInProjectSourcesOrLibraries(project, vf);
        }
        return true;
    }

    @NotNull
    public static List<SuppressIntentionAction> createSuppressActions(@NotNull PsiFile psiFile, @NotNull TextRange range, @NotNull String warningName) {
        Iterator iterator;
        if (psiFile == null) {
            ClangdBridge.$$$reportNull$$$0(9);
        }
        if (range == null) {
            ClangdBridge.$$$reportNull$$$0(10);
        }
        if (warningName == null) {
            ClangdBridge.$$$reportNull$$$0(11);
        }
        if ((iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator()).hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            List<SuppressIntentionAction> list = bridge.createSuppressActions(psiFile, range, warningName);
            if (list == null) {
                ClangdBridge.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<SuppressIntentionAction> list = Collections.emptyList();
        if (list == null) {
            ClangdBridge.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public static ClangIdeFacade createClangIdeFacade(@NotNull @NonNls String descriptor, boolean forIndexer) {
        Iterator iterator;
        if (descriptor == null) {
            ClangdBridge.$$$reportNull$$$0(14);
        }
        if ((iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator()).hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            ClangIdeFacade clangIdeFacade = bridge.createClangIdeFacade(descriptor, forIndexer);
            if (clangIdeFacade == null) {
                ClangdBridge.$$$reportNull$$$0(15);
            }
            return clangIdeFacade;
        }
        return forIndexer ? new ClangIndexerIdeFacadeImpl(descriptor) : new ClangIdeFacadeImpl(descriptor);
    }

    @Nullable
    public static Obfuscator getObfuscator() {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.createObfuscator();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangdBridge";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warningName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangdBridge";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtensions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuppressActions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createClangIdeFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerAnnotatorPassFactories";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFileExtensions";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParameterHints";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setParameterHints";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectSourcesOrLibraries";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSuppressActions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createClangIdeFacade";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

