/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.EditorOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClazyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangNamehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionGlobalCompletionCacheParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangIdeFacadeImpl
implements ClangIdeFacade {
    @NotNull
    private final ExecutorService myMessagingService;

    public ClangIdeFacadeImpl(@NotNull @NonNls String descriptor) {
        if (descriptor == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(0);
        }
        this.myMessagingService = ConcurrencyUtil.newSingleThreadExecutor((String)("ClangdMessagingThread [" + descriptor + "]"));
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile(@NotNull @NonNls String url) {
        if (url == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(1);
        }
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    @Override
    @Nullable
    public Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(2);
        }
        return FileDocumentManager.getInstance().getDocument(file);
    }

    @Override
    @NotNull
    public List<OpenRequestId> getOpenRequests(@NotNull Project project, @NotNull VirtualFile file) {
        Document document;
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(4);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(file)) != null) {
            List<OpenRequestId> list = EditorFactory.getInstance().editors(document).filter(editor -> editor.getProject() == project).map(EditorOpenRequestId::new).collect(Collectors.toList());
            if (list == null) {
                ClangIdeFacadeImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<OpenRequestId> list = Collections.emptyList();
        if (list == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public boolean isModified(@NotNull VirtualFile file) {
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileDocumentManager fileDocManager = FileDocumentManager.getInstance();
        return fileDocManager.isFileModified(file);
    }

    @Override
    @Nullable
    public ClangFileFacade getFileFacade(@NotNull VirtualFile file) {
        Document document;
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(8);
        }
        if ((document = this.getDocument(file)) == null) {
            return null;
        }
        return this.getFileFacade(file, document);
    }

    @Override
    @NotNull
    public ClangFileFacade getFileFacade(@NotNull VirtualFile file, @NotNull Document document) {
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(9);
        }
        if (document == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(10);
        }
        return new ClangFileFacadeImpl(document);
    }

    @Nullable
    protected ClangUtils.ResolveInfo getResolveInfoForFile(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(11);
        }
        if (vf == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(12);
        }
        return ClangUtils.getResolveInfoForFileFromWorkspace(project, vf);
    }

    @Override
    @Nullable
    public ClangdCompilationCommand getCompilationCommand(@NotNull ClangUrlConverter converter, @NotNull Project project, @NotNull VirtualFile file, @NotNull @NonNls String pathToMacrosFile) {
        if (converter == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(13);
        }
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(14);
        }
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(15);
        }
        if (pathToMacrosFile == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ClangUtils.ResolveInfo resolveInfo = this.getResolveInfoForFile(project, file);
        return ClangUtils.getCompilationCommand(converter, project, file, pathToMacrosFile, resolveInfo);
    }

    @Override
    @Nullable
    public UnusedIncludesInspectionMode getUnusedIncludesInspectionMode(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(17);
        }
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(18);
        }
        return UnusedIncludesInspectionMode.RemoveNotDirectlyUsed;
    }

    @Override
    @Nullable
    public CLionClazyConfigParams getClazyConfig(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(19);
        }
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(20);
        }
        return null;
    }

    @Override
    public ClionClangDFAConfigParams getDFAOptions(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(21);
        }
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(22);
        }
        return null;
    }

    @Override
    public ClionGlobalCompletionCacheParams getGlobalCompletionCacheParams(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(23);
        }
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(24);
        }
        return null;
    }

    @Override
    @Nullable
    public ClionClangTidyConfigParams getClangTidyConfig(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(25);
        }
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(26);
        }
        return null;
    }

    @Override
    @NotNull
    public ClionClangNamehintConfigParams getNamehintConfig() {
        return new ClionClangNamehintConfigParams(false, false, false, false, false);
    }

    @Override
    @Nullable
    public Long getPsiModificationCounter(@NotNull Project project) {
        PsiModificationTracker psiModificationTracker;
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(27);
        }
        return (psiModificationTracker = PsiModificationTracker.SERVICE.getInstance((Project)project)) != null ? Long.valueOf(psiModificationTracker.getModificationCount()) : null;
    }

    @Override
    public void sendMessageLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(28);
        }
        if (!this.myMessagingService.isShutdown()) {
            this.myMessagingService.execute(() -> {
                while (!this.myMessagingService.isShutdown()) {
                    if (ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)runnable)) {
                        return;
                    }
                    ProgressIndicatorUtils.yieldToPendingWriteActions();
                }
                return;
            });
        }
    }

    @Override
    public void stop() {
        this.myMessagingService.shutdown();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIdeFacadeImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToMacrosFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIdeFacadeImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOpenRequests";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileFacade";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResolveInfoForFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCompilationCommand";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedIncludesInspectionMode";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getClazyConfig";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDFAOptions";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalCompletionCacheParams";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getClangTidyConfig";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getPsiModificationCounter";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sendMessageLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

