/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.execution.debugger.NativeStacktraceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ProcessServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangLanguageServiceUtils {
    private static final Logger LOG = Logger.getInstance((String)ClangLanguageServiceUtils.class.getName());
    @NonNls
    private static final String ERROR_FRAGMENT = "error:";
    @NonNls
    private static final String NOTE_FRAGMENT = "note:";
    private static final Pattern NOTE_POSITION_PATTERN = Pattern.compile("(?<path>.*?):(?<line>[0-9]+):(?<character>[0-9]+)\\s*");

    public static int lspPos2Offset(@NotNull Document doc, @NotNull Position pos) {
        if (doc == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(0);
        }
        if (pos == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (doc.getLineCount() <= pos.getLine()) {
            return Math.min(doc.getTextLength(), doc.getLineStartOffset(doc.getLineCount() - 1) + pos.getCharacter());
        }
        return doc.getLineStartOffset(pos.getLine()) + pos.getCharacter();
    }

    @NotNull
    public static Position offset2LspPos(@NotNull Document doc, int offset) {
        if (doc == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int lineNumber = doc.getLineNumber(offset);
        int columnNumber = offset - doc.getLineStartOffset(lineNumber);
        return new Position(lineNumber, columnNumber);
    }

    @NotNull
    public static Range offsets2Range(@NotNull Document doc, int from, int to) {
        if (doc == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return new Range(ClangLanguageServiceUtils.offset2LspPos(doc, from), ClangLanguageServiceUtils.offset2LspPos(doc, to));
    }

    public static void finishOperation(@NotNull ClangParseResponse response, boolean success) {
        if (response == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(4);
        }
        if (!ClangParseResponse.isInDoneState(response)) {
            response.getOperationState().complete(success);
            if (!success) {
                ClangParseResponse.completeAnswers(response);
            }
        }
    }

    @Nullable
    public static <T> T getFromClangFuture(@NotNull Future<? extends Supplier<? extends T>> future) throws ExecutionException, InterruptedException {
        if (future == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(5);
        }
        assert (future.isDone());
        Supplier<? extends T> supplier = future.get();
        return supplier != null ? (T)supplier.get() : null;
    }

    @Nullable
    public static ClangNote parseNote(@NotNull String note) {
        String pathAndPosition;
        Matcher matcher;
        if (note == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(6);
        }
        int separatorLength = NOTE_FRAGMENT.length();
        int separator = note.indexOf(NOTE_FRAGMENT);
        if (separator == -1) {
            separatorLength = ERROR_FRAGMENT.length();
            separator = note.indexOf(ERROR_FRAGMENT);
        }
        if (separator >= 0 && (matcher = NOTE_POSITION_PATTERN.matcher(pathAndPosition = note.substring(0, separator))).find()) {
            String path = matcher.group("path");
            if (path.equals("<command-line>")) {
                return null;
            }
            String lineAsString = matcher.group("line");
            String characterAsString = matcher.group("character");
            String message = note.substring(separator + separatorLength);
            try {
                int line = Integer.parseInt(lineAsString);
                int character = Integer.parseInt(characterAsString);
                return new ClangNote(message, path, line, character);
            }
            catch (NumberFormatException ex) {
                LOG.warn((Throwable)ex);
                return null;
            }
        }
        return null;
    }

    public static int getServerPid(@Nullable ServerConnection connection) {
        if (!(connection instanceof ProcessServerConnectionProvider.ProcessServerConnection)) {
            return -1;
        }
        Process serverProcess = ((ProcessServerConnectionProvider.ProcessServerConnection)connection).getProcess();
        return OSProcessUtil.getProcessID((Process)serverProcess);
    }

    @NonNls
    @NotNull
    public static String getNativeStacktrace(@Nullable ServerConnection connection) {
        block5: {
            NativeStacktraceProvider nativeStacktraceProvider;
            int pid = ClangLanguageServiceUtils.getServerPid(connection);
            if (pid != -1 && (nativeStacktraceProvider = (NativeStacktraceProvider)ApplicationManager.getApplication().getService(NativeStacktraceProvider.class)) != null) {
                String string;
                try {
                    String stacktrace = nativeStacktraceProvider.getNativeStacktrace(pid);
                    if (stacktrace == null) break block5;
                    string = stacktrace;
                }
                catch (ExecutionException ex) {
                    String string2 = ExceptionUtil.getThrowableText((Throwable)ex);
                    if (string2 == null) {
                        ClangLanguageServiceUtils.$$$reportNull$$$0(8);
                    }
                    return string2;
                }
                if (string == null) {
                    ClangLanguageServiceUtils.$$$reportNull$$$0(7);
                }
                return string;
            }
        }
        return "unavailable";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "note";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangLanguageServiceUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangLanguageServiceUtils";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeStacktrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "lspPos2Offset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "offset2LspPos";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "offsets2Range";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "finishOperation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFromClangFuture";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseNote";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ClangNote {
        @NotNull
        public final String message;
        @NotNull
        public final String path;
        public final int line;
        public final int character;

        private ClangNote(@NotNull String message, @NotNull String path, int line, int character) {
            if (message == null) {
                ClangNote.$$$reportNull$$$0(0);
            }
            if (path == null) {
                ClangNote.$$$reportNull$$$0(1);
            }
            this.message = message;
            this.path = path;
            this.line = line;
            this.character = character;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClangNote note = (ClangNote)o;
            return this.line == note.line && this.character == note.character && this.message.equals(note.message) && this.path.equals(note.path);
        }

        public int hashCode() {
            return Objects.hash(this.message, this.path, this.line, this.character);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangLanguageServiceUtils$ClangNote";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

