/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangAbstractNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import org.jetbrains.annotations.NotNull;

public abstract class ClangFileBasedNotification<T>
extends ClangAbstractNotification<T> {
    @NotNull
    protected final ClangDaemonContext myContext;
    @NotNull
    protected final String myUrl;
    protected final int myVersion;
    private final boolean myShouldRecover;

    ClangFileBasedNotification(@NotNull ClangDaemonContext context, @NotNull String url, int version, boolean shouldRecover, @NotNull T params) {
        if (context == null) {
            ClangFileBasedNotification.$$$reportNull$$$0(0);
        }
        if (url == null) {
            ClangFileBasedNotification.$$$reportNull$$$0(1);
        }
        if (params == null) {
            ClangFileBasedNotification.$$$reportNull$$$0(2);
        }
        super(params);
        this.myContext = context;
        this.myUrl = url;
        this.myVersion = version;
        this.myShouldRecover = shouldRecover;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            ClangFileBasedNotification.$$$reportNull$$$0(3);
        }
        return string;
    }

    public int getVersion() {
        return this.myVersion;
    }

    @Override
    public boolean requiresRecover() {
        return this.myShouldRecover;
    }

    @Override
    protected boolean sendNotification(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        if (server == null) {
            ClangFileBasedNotification.$$$reportNull$$$0(4);
        }
        if (ws == null) {
            ClangFileBasedNotification.$$$reportNull$$$0(5);
        }
        if (this.sendNotificationImpl(server, ws)) {
            this.toNextRemoteState(ws, this.myParams);
            return true;
        }
        return false;
    }

    @Override
    public void onSkipped(@NotNull ClangRemoteWorkspace ws) {
        if (ws == null) {
            ClangFileBasedNotification.$$$reportNull$$$0(6);
        }
        this.toNextRemoteState(ws, this.myParams);
    }

    protected abstract boolean sendNotificationImpl(@NotNull ClangServer var1, @NotNull ClangRemoteWorkspace var2);

    protected void toNextRemoteState(@NotNull ClangRemoteWorkspace ws, @NotNull T params) {
        if (ws == null) {
            ClangFileBasedNotification.$$$reportNull$$$0(7);
        }
        if (params == null) {
            ClangFileBasedNotification.$$$reportNull$$$0(8);
        }
        ws.modify(this.myUrl, wf -> {
            int prevVersion = wf.getOrDefault(RemoteWorkspaceFile.VERSION);
            Class<?> prevOpClass = wf.get(RemoteWorkspaceFile.OP_CLASS);
            if (this.myVersion <= prevVersion) {
                LOG.error("Wrong order of operations: prevVersion = " + prevVersion + ", prevOp = " + (prevOpClass != null ? prevOpClass.getSimpleName() : "unknown") + ", newVersion = " + this.myVersion + ", newOp = " + this.getClass().getSimpleName() + (ClangRequestsHelper.isMacroFile(this.myContext, wf.getUrl()) ? ", for macros file" : ""));
            } else {
                wf.put(RemoteWorkspaceFile.VERSION, this.myVersion);
                wf.put(RemoteWorkspaceFile.OP_CLASS, this.getClass());
                this.toNextRemoteState((RemoteWorkspaceFile)wf, params);
            }
        });
    }

    protected void toNextRemoteState(@NotNull RemoteWorkspaceFile wf, @NotNull T params) {
        if (wf == null) {
            ClangFileBasedNotification.$$$reportNull$$$0(9);
        }
        if (params == null) {
            ClangFileBasedNotification.$$$reportNull$$$0(10);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangFileBasedNotification";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ws";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangFileBasedNotification";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sendNotification";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onSkipped";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toNextRemoteState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

