/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.AbstractParseEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.BuildPreambleError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.PreambleCancelledEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.PreambleFailedEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.PreambleFileEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.PreambleParsedEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.PreambleReusedEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ClangPreambleTelemetry {
    public static final Logger LOG = Logger.getInstance(ClangPreambleTelemetry.class);
    @NotNull
    private final Map<PreambleStatisticsKey, PreambleStatistics> myPreambleStatisticsMap = new HashMap<PreambleStatisticsKey, PreambleStatistics>();
    @NotNull
    private final Map<String, List<PreambleStatistics>> myPreambleStatisticsPerTargetFile = new HashMap<String, List<PreambleStatistics>>();
    @NotNull
    private final Map<String, List<PreambleStatistics>> myPreambleStatisticsPerEntryFile = new HashMap<String, List<PreambleStatistics>>();
    @NotNull
    private final Set<String> myPreambleFiles = new HashSet<String>();

    public synchronized void cleanupPreambleFilesAsync() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cleaning up possibly remaining preamble files: " + this.myPreambleFiles);
        }
        FileUtil.asyncDelete((Collection)ContainerUtil.map(this.myPreambleFiles, File::new));
        this.myPreambleFiles.clear();
    }

    public synchronized int getPreambleFailures(@NotNull String targetFilePath) {
        if (targetFilePath == null) {
            ClangPreambleTelemetry.$$$reportNull$$$0(0);
        }
        return this.getPreambleFailures(targetFilePath, BuildPreambleError.CouldntCreateTempFile, BuildPreambleError.CouldntCreateTargetInfo, BuildPreambleError.BeginSourceFileFailed, BuildPreambleError.CouldntEmitPCH, BuildPreambleError.InvalidPreamble, BuildPreambleError.DidntHitTargetFile);
    }

    public synchronized int getPreambleFailures(@NotNull String targetFilePath, BuildPreambleError ... errors) {
        if (targetFilePath == null) {
            ClangPreambleTelemetry.$$$reportNull$$$0(1);
        }
        if (errors == null) {
            ClangPreambleTelemetry.$$$reportNull$$$0(2);
        }
        int failures = 0;
        for (PreambleStatistics statistics : this.getPreambleStatsForTargetFile(targetFilePath)) {
            for (BuildPreambleError error : errors) {
                failures += statistics.getErrors(error);
            }
        }
        return failures;
    }

    public synchronized int getPreambleParses(@NotNull String targetFilePath) {
        if (targetFilePath == null) {
            ClangPreambleTelemetry.$$$reportNull$$$0(3);
        }
        int parses = 0;
        for (PreambleStatistics statistics : this.getPreambleStatsForTargetFile(targetFilePath)) {
            parses += statistics.getParsedCounter();
        }
        return parses;
    }

    public synchronized int getPreambleReuses(@NotNull String targetFilePath) {
        if (targetFilePath == null) {
            ClangPreambleTelemetry.$$$reportNull$$$0(4);
        }
        int reuses = 0;
        for (PreambleStatistics statistics : this.getPreambleStatsForTargetFile(targetFilePath)) {
            reuses += statistics.getReusedCounter();
        }
        return reuses;
    }

    public synchronized int getPreambleCancels(@NotNull String targetFilePath) {
        if (targetFilePath == null) {
            ClangPreambleTelemetry.$$$reportNull$$$0(5);
        }
        int cancels = 0;
        for (PreambleStatistics statistics : this.getPreambleStatsForTargetFile(targetFilePath)) {
            cancels += statistics.getCancelledCounter();
        }
        return cancels;
    }

    synchronized boolean handle(Object rawEvent) {
        PreambleFailedEvent preambleFailedEvent = PreambleFailedEvent.tryInstantiate(rawEvent);
        if (preambleFailedEvent != null) {
            PreambleStatistics statistics = this.getOrCreatePreambleStatistics(preambleFailedEvent);
            statistics.addError(preambleFailedEvent.error);
            return true;
        }
        PreambleParsedEvent preambleParsedEvent = PreambleParsedEvent.tryInstantiate(rawEvent);
        if (preambleParsedEvent != null) {
            PreambleStatistics statistics = this.getOrCreatePreambleStatistics(preambleParsedEvent);
            statistics.incParsed();
            return true;
        }
        PreambleReusedEvent preambleReusedEvent = PreambleReusedEvent.tryInstantiate(rawEvent);
        if (preambleReusedEvent != null) {
            PreambleStatistics statistics = this.getOrCreatePreambleStatistics(preambleReusedEvent);
            statistics.incReused();
            return true;
        }
        PreambleCancelledEvent preambleCancelledEvent = PreambleCancelledEvent.tryInstantiate(rawEvent);
        if (preambleCancelledEvent != null) {
            PreambleStatistics statistics = this.getOrCreatePreambleStatistics(preambleCancelledEvent);
            statistics.incCancelled();
            return true;
        }
        PreambleFileEvent.Created preambleFileCreatedEvent = PreambleFileEvent.Created.tryInstantiate(rawEvent);
        if (preambleFileCreatedEvent != null) {
            this.myPreambleFiles.add(preambleFileCreatedEvent.preambleFile);
            LOG.debug("Created preamble file ", new Object[]{preambleFileCreatedEvent.preambleFile, ", total to cleanup: ", this.myPreambleFiles.size()});
            return true;
        }
        PreambleFileEvent.Destroyed preambleFileDestroyedEvent = PreambleFileEvent.Destroyed.tryInstantiate(rawEvent);
        if (preambleFileDestroyedEvent != null) {
            this.myPreambleFiles.remove(preambleFileDestroyedEvent.preambleFile);
            LOG.debug("Destroyed preamble file ", new Object[]{preambleFileDestroyedEvent.preambleFile, ", total to cleanup: ", this.myPreambleFiles.size()});
            return true;
        }
        return false;
    }

    @NotNull
    private List<PreambleStatistics> getPreambleStatsForTargetFile(@NotNull String targetFile) {
        List<PreambleStatistics> allStatistics;
        if (targetFile == null) {
            ClangPreambleTelemetry.$$$reportNull$$$0(6);
        }
        if ((allStatistics = this.myPreambleStatisticsPerTargetFile.get(targetFile = FileUtil.toSystemIndependentName((String)targetFile))) == null) {
            List<PreambleStatistics> list = Collections.emptyList();
            if (list == null) {
                ClangPreambleTelemetry.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<PreambleStatistics> list = allStatistics;
        if (list == null) {
            ClangPreambleTelemetry.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private PreambleStatistics getOrCreatePreambleStatistics(@NotNull AbstractParseEvent event) {
        PreambleStatisticsKey key;
        PreambleStatistics statistics;
        if (event == null) {
            ClangPreambleTelemetry.$$$reportNull$$$0(9);
        }
        if ((statistics = this.myPreambleStatisticsMap.get(key = new PreambleStatisticsKey(event))) == null) {
            statistics = new PreambleStatistics();
            this.myPreambleStatisticsMap.put(key, statistics);
            String entryFile = FileUtil.toSystemIndependentName((String)event.entryFile);
            List statsPerEntryFile = this.myPreambleStatisticsPerEntryFile.computeIfAbsent(entryFile, k -> new ArrayList());
            statsPerEntryFile.add(statistics);
            String targetFile = FileUtil.toSystemIndependentName((String)event.targetFile);
            List statsPerTargetFile = this.myPreambleStatisticsPerTargetFile.computeIfAbsent(targetFile, k -> new ArrayList());
            statsPerTargetFile.add(statistics);
        }
        PreambleStatistics preambleStatistics = statistics;
        if (preambleStatistics == null) {
            ClangPreambleTelemetry.$$$reportNull$$$0(10);
        }
        return preambleStatistics;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/telemetry/ClangPreambleTelemetry";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/telemetry/ClangPreambleTelemetry";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreambleStatsForTargetFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreatePreambleStatistics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPreambleFailures";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPreambleParses";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPreambleReuses";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPreambleCancels";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPreambleStatsForTargetFile";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreatePreambleStatistics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PreambleStatistics {
        private int myParsedCounter;
        private int myReusedCounter;
        private int myCancelledCounter;
        @NotNull
        private final Map<BuildPreambleError, Integer> myPreambleErrorsMap = new HashMap<BuildPreambleError, Integer>();

        private PreambleStatistics() {
        }

        void addError(@NotNull BuildPreambleError error) {
            Integer value;
            if (error == null) {
                PreambleStatistics.$$$reportNull$$$0(0);
            }
            value = (value = this.myPreambleErrorsMap.get((Object)error)) != null ? value + 1 : 1;
            this.myPreambleErrorsMap.put(error, value);
        }

        void incParsed() {
            ++this.myParsedCounter;
        }

        void incReused() {
            ++this.myReusedCounter;
        }

        void incCancelled() {
            ++this.myCancelledCounter;
        }

        int getErrors(@NotNull BuildPreambleError error) {
            Integer value;
            if (error == null) {
                PreambleStatistics.$$$reportNull$$$0(1);
            }
            return (value = this.myPreambleErrorsMap.get((Object)error)) != null ? value : 0;
        }

        public int getParsedCounter() {
            return this.myParsedCounter;
        }

        public int getReusedCounter() {
            return this.myReusedCounter;
        }

        public int getCancelledCounter() {
            return this.myCancelledCounter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "error";
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/telemetry/ClangPreambleTelemetry$PreambleStatistics";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addError";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getErrors";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PreambleStatisticsKey {
        @NotNull
        private final String myTargetFile;
        @NotNull
        private final String myEntryFile;

        PreambleStatisticsKey(@NotNull AbstractParseEvent preambleEvent) {
            if (preambleEvent == null) {
                PreambleStatisticsKey.$$$reportNull$$$0(0);
            }
            this.myTargetFile = preambleEvent.targetFile;
            this.myEntryFile = preambleEvent.entryFile;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PreambleStatisticsKey that = (PreambleStatisticsKey)o;
            return Objects.equals(this.myTargetFile, that.myTargetFile) && Objects.equals(this.myEntryFile, that.myEntryFile);
        }

        public int hashCode() {
            return Objects.hash(this.myTargetFile, this.myEntryFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preambleEvent", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/telemetry/ClangPreambleTelemetry$PreambleStatisticsKey", "<init>"));
        }
    }
}

