/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.util.UserDataHolderBase;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspaceImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.namehint.ClangNamehintInfo;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.sourceglider.contextSensitive.DFATuple;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

class ClangParseResponseImpl
extends UserDataHolderBase
implements ClangParseResponse {
    @NotNull
    private final String myUrl;
    private final int myVersion;
    private final boolean myIsCancellable;
    @NotNull
    private final CompletableFuture<Boolean> myOperationState;
    @NotNull
    private final CompletableFuture<Supplier<List<ClangDiagnostic>>> myDiagnostics;
    @NotNull
    private final CompletableFuture<Supplier<List<ClangHighlighting>>> myHighlightings;
    @NotNull
    private final CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> myOurTidyDiagnostics;
    @NotNull
    private final CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> myTidyDiagnostics;
    @NotNull
    private final CompletableFuture<Supplier<List<ClangDiagnostic>>> myClazyDiagnostics;
    @NotNull
    private final CompletableFuture<Supplier<List<ClangNamehintInfo>>> myNamehints;
    @NotNull
    private final CompletableFuture<Supplier<List<DFATuple>>> myDFAInput;
    @NotNull
    private final CompletableFuture<Boolean> myCompletionCacheReady;

    ClangParseResponseImpl(@NotNull String url, @NotNull String path, int version, boolean isCancellable) {
        if (url == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(0);
        }
        if (path == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(1);
        }
        this.myOperationState = new CompletableFuture();
        this.myDiagnostics = new CompletableFuture();
        this.myHighlightings = new CompletableFuture();
        this.myOurTidyDiagnostics = new CompletableFuture();
        this.myTidyDiagnostics = new CompletableFuture();
        this.myClazyDiagnostics = new CompletableFuture();
        this.myNamehints = new CompletableFuture();
        this.myDFAInput = new CompletableFuture();
        this.myCompletionCacheReady = new CompletableFuture();
        this.myUrl = url;
        this.myVersion = version;
        this.myIsCancellable = isCancellable;
        if (ClangDebugLevel.isTraceOrMore()) {
            long startTime = System.currentTimeMillis();
            String fileName = new File(path).getName();
            this.myDiagnostics.thenAccept(res -> {
                long diagnosticsCalculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.traceClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of diagnostics for " + fileName + " took " + diagnosticsCalculationDuration + " ms");
            });
            this.myHighlightings.thenAccept(res -> {
                long highlightingsCalculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.traceClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of highlightings for " + fileName + " took " + highlightingsCalculationDuration + " ms");
            });
            this.myCompletionCacheReady.thenAccept(res -> {
                long completionCacheCalculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.traceClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of completion cache for " + fileName + " took " + completionCacheCalculationDuration + " ms");
            });
            this.myOurTidyDiagnostics.thenAccept(res -> {
                long calculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.traceClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of our clang-tidy diagnostics for " + fileName + " took " + calculationDuration + " ms");
            });
            this.myTidyDiagnostics.thenAccept(res -> {
                long tidyDiagnosticsCalculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.traceClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of clang-tidy diagnostics for " + fileName + " took " + tidyDiagnosticsCalculationDuration + " ms");
            });
            this.myClazyDiagnostics.thenAccept(res -> {
                long calculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.traceClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of our clazy diagnostics for " + fileName + " took " + calculationDuration + " ms");
            });
            this.myNamehints.thenAccept(res -> {
                long namehintCalculationDuration = System.currentTimeMillis() - startTime;
                ClangUtils.traceClangd(ClangLocalWorkspaceImpl.LOG, "Calculation of clang namehints diagnostics for " + fileName + " took " + namehintCalculationDuration + " ms");
            });
        }
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public int getVersion() {
        return Math.abs(this.myVersion);
    }

    @Override
    public boolean isCancellable() {
        return this.myIsCancellable;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> getOperationState() {
        CompletableFuture<Boolean> completableFuture = this.myOperationState;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(3);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangDiagnostic>>> getDiagnostics() {
        CompletableFuture<Supplier<List<ClangDiagnostic>>> completableFuture = this.myDiagnostics;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangHighlighting>>> getHighlightings() {
        CompletableFuture<Supplier<List<ClangHighlighting>>> completableFuture = this.myHighlightings;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(5);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getOurTidyDiagnostics() {
        CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> completableFuture = this.myOurTidyDiagnostics;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(6);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getTidyDiagnostics() {
        CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> completableFuture = this.myTidyDiagnostics;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangDiagnostic>>> getClazyDiagnostics() {
        CompletableFuture<Supplier<List<ClangDiagnostic>>> completableFuture = this.myClazyDiagnostics;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(8);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<ClangNamehintInfo>>> getNamehints() {
        CompletableFuture<Supplier<List<ClangNamehintInfo>>> completableFuture = this.myNamehints;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(9);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Supplier<List<DFATuple>>> getDFAInput() {
        CompletableFuture<Supplier<List<DFATuple>>> completableFuture = this.myDFAInput;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(10);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> getCompletionCacheReady() {
        CompletableFuture<Boolean> completableFuture = this.myCompletionCacheReady;
        if (completableFuture == null) {
            ClangParseResponseImpl.$$$reportNull$$$0(11);
        }
        return completableFuture;
    }

    public String toString() {
        return this.getUrl() + "[" + this.getVersion() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangParseResponseImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangParseResponseImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagnostics";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOurTidyDiagnostics";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTidyDiagnostics";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClazyDiagnostics";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamehints";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDFAInput";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionCacheReady";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

