/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.settings;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

@State(name="ClangdSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ClangdSettings
implements PersistentStateComponent<StoredState> {
    private static final String GLOBAL_COMPLETION_CACHE_ID = "clangd.use.global.completion.cache";
    private static final List<ClangFeatures.Warning> DISABLE_FOR_UnusedInspections = Collections.singletonList(ClangFeatures.Warnings.UNUSED_VARIABLE);
    private static final List<ClangFeatures.Warning> DISABLE_FOR_InfiniteRecursion = Collections.singletonList(ClangFeatures.Warnings.INFINITE_RECURSION);
    private static final List<ClangFeatures.Warning> ENABLE_FOR_HidesUpperScope = Collections.singletonList(ClangFeatures.Warnings.SHADOW);
    private static final List<ClangFeatures.Warning> DISABLE_FOR_FunctionImplicitDeclarationInspection = Collections.singletonList(ClangFeatures.Warnings.IMPLICIT_FUNCTION_DECLARATION);
    @NlsSafe
    private static final String DEFAULT_DISABLED_WARNINGS = ClangdSettings.makeWarningsDisabled(DISABLE_FOR_UnusedInspections, DISABLE_FOR_InfiniteRecursion);
    @NlsSafe
    private static final String DEFAULT_ENABLED_WARNINGS = ClangdSettings.makeWarningsEnabled(ENABLE_FOR_HidesUpperScope, Collections.singletonList(ClangFeatures.Warnings.UNINITIALIZED), Collections.singletonList(ClangFeatures.Warnings.UNUSED_LABEL), Collections.singletonList(ClangFeatures.Warnings.UNUSED_LAMBDA_CAPTURE));
    @NlsSafe
    private static final String DEFAULT_DISABLED_ERRORS = ClangdSettings.makeWarningsAsErrors(DISABLE_FOR_FunctionImplicitDeclarationInspection);
    @NlsSafe
    private static final String DEFAULT_MESSAGE_FILTERS = PluginManagerCore.isRunningFromSources() ? "<-- clionDefinition\n--> reply:clionDefinition\n--> telemetry/event\n<-- clionDebugDumpMemoryStat\n--> reply:clionDebugDumpMemoryStat\nclion-method:clionDefinition\nclion-method:clionDebugDumpMemoryStat\nclion-method:telemetry/event" : "<-- clionDefinition\n--> reply:clionDefinition\n--> telemetry/event\n<-- clionDebugDumpMemoryStat\n--> reply:clionDebugDumpMemoryStat";
    @NotNull
    private final Project myProject;
    @NotNull
    private final StoredState myState;

    public ClangdSettings(@NotNull Project project) {
        if (project == null) {
            ClangdSettings.$$$reportNull$$$0(0);
        }
        this.myState = new StoredState();
        this.myProject = project;
        ClangLanguageServiceProvider provider = ClangLanguageServiceProvider.getProvider(project);
        if (provider != null) {
            Registry.get((String)"clion.clang.clangd.on").addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ClangdSettings.this.setClangdEnabledImpl(value.asBoolean());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/ClangdSettings$1", "afterValueChanged"));
                }
            }, (Disposable)provider);
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)provider).subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(){

                public void advancedSettingChanged(@NotNull String id, @NotNull Object oldValue, @NotNull Object newValue) {
                    if (id == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (oldValue == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (newValue == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (id.equals(ClangdSettings.GLOBAL_COMPLETION_CACHE_ID)) {
                        ClangdSettings.this.setGlobalCompletionCacheEnabled((Boolean)newValue);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "id";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "oldValue";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "newValue";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/ClangdSettings$2";
                    objectArray[2] = "advancedSettingChanged";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    public static ClangdSettings getInstance(@NotNull Project project) {
        if (project == null) {
            ClangdSettings.$$$reportNull$$$0(1);
        }
        return (ClangdSettings)project.getService(ClangdSettings.class);
    }

    public synchronized boolean isClangdOn() {
        return this.myState.clangdEnabled && (this.myState.clangdShowErrors || this.myState.clangTidyViaClangd || this.myState.navigationViaClangd || this.myState.formatViaClangd || this.myState.completionType != CompletionType.Builtin);
    }

    public synchronized boolean isClangdShowErrors() {
        return this.myState.clangdShowErrors;
    }

    public synchronized void setClangdShowErrors(boolean clangdShowErrors) {
        this.setProperty(value -> {
            this.myState.clangdShowErrors = value;
        }, ClangdSettingsListener::onClangdShowErrorsChanged, this.myState.clangdShowErrors, clangdShowErrors);
    }

    public synchronized boolean isClangTidyViaClangd() {
        return this.myState.clangTidyViaClangd;
    }

    public synchronized void setClangTidyViaClangd(boolean clangTidyViaClangd) {
        this.setProperty(value -> {
            this.myState.clangTidyViaClangd = value;
        }, ClangdSettingsListener::onClangTidyViaClangdChanged, this.myState.clangTidyViaClangd, clangTidyViaClangd);
    }

    public synchronized boolean isNavigationViaClangd() {
        return this.myState.navigationViaClangd;
    }

    public synchronized void setNavigationViaClangd(boolean navigationViaClangd) {
        this.setProperty(value -> {
            this.myState.navigationViaClangd = value;
        }, ClangdSettingsListener::onNavigationViaClangdChanged, this.myState.navigationViaClangd, navigationViaClangd);
    }

    public synchronized boolean isFormatViaClangd() {
        return this.myState.formatViaClangd;
    }

    public synchronized void setFormatViaClangd(boolean formatViaClangd) {
        this.setProperty(value -> {
            this.myState.formatViaClangd = value;
        }, ClangdSettingsListener::onFormatViaClangdChanged, this.myState.formatViaClangd, formatViaClangd);
    }

    public synchronized CompletionType getCompletionType() {
        return this.myState.completionType;
    }

    public synchronized void setCompletionType(CompletionType completionType) {
        this.setProperty(value -> {
            this.myState.completionType = completionType;
        }, ClangdSettingsListener::onCompletionTypeChanged, this.myState.completionType, completionType);
    }

    public synchronized boolean getGlobalCompletionCacheEnabled() {
        return this.myState.enableGlobalCompletionCache;
    }

    public synchronized void setGlobalCompletionCacheEnabled(boolean enabled) {
        this.setProperty(value -> {
            this.myState.enableGlobalCompletionCache = value;
        }, ClangdSettingsListener::onGlobalCompletionCacheChanged, this.myState.enableGlobalCompletionCache, enabled);
        ClangdSettings.rehighlight();
    }

    public synchronized boolean isClangdEnabled() {
        return this.myState.clangdEnabled;
    }

    public synchronized void setClangdEnabled(boolean clangdEnabled) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            CidrLogService.LOG.error("Enabling clangd in production programmatically? It is allowed from Registry only.");
        }
        this.setClangdEnabledImpl(clangdEnabled);
    }

    private synchronized void setClangdEnabledImpl(boolean clangdEnabled) {
        this.setProperty(value -> {
            this.myState.clangdEnabled = value;
        }, ClangdSettingsListener::onClangdEnabled, this.myState.clangdEnabled, clangdEnabled);
    }

    @NotNull
    @NlsSafe
    public synchronized String getClangdMessagesFilters() {
        String string = StringUtil.notNullize((String)this.myState.clangdMessagesFilters);
        if (string == null) {
            ClangdSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    public synchronized void setClangdMessagesFilters(@NlsSafe @NotNull String clangdMessagesFilters) {
        if (clangdMessagesFilters == null) {
            ClangdSettings.$$$reportNull$$$0(3);
        }
        this.setProperty(value -> {
            this.myState.clangdMessagesFilters = value;
        }, ClangdSettingsListener::onClangdMessagesFiltersChanged, this.myState.clangdMessagesFilters, clangdMessagesFilters);
    }

    @NotNull
    public synchronized String getClangFlags() {
        String string = StringUtil.notNullize((String)this.myState.clangWarnings);
        if (string == null) {
            ClangdSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    public synchronized void setClangFlags(@NlsSafe @NotNull String clangWarnings) {
        if (clangWarnings == null) {
            ClangdSettings.$$$reportNull$$$0(5);
        }
        this.myState.clangWarnings = clangWarnings;
    }

    @NotNull
    public synchronized StoredState getState() {
        return new StoredState(this.myState);
    }

    public synchronized void loadState(@NotNull StoredState state) {
        if (state == null) {
            ClangdSettings.$$$reportNull$$$0(6);
        }
        this.setClangdShowErrors(state.clangdShowErrors);
        this.setClangTidyViaClangd(state.clangTidyViaClangd);
        this.setNavigationViaClangd(state.navigationViaClangd);
        this.setFormatViaClangd(state.formatViaClangd);
        this.setCompletionType(state.completionType != null ? state.completionType : new StoredState().completionType);
        this.setClangFlags(state.clangWarnings);
        this.setClangdMessagesFilters(state.clangdMessagesFilters);
    }

    @NotNull
    private ClangdSettingsListener getPublisher() {
        ClangdSettingsListener clangdSettingsListener = (ClangdSettingsListener)this.myProject.getMessageBus().syncPublisher(ClangdSettingsListener.TOPIC);
        if (clangdSettingsListener == null) {
            ClangdSettings.$$$reportNull$$$0(7);
        }
        return clangdSettingsListener;
    }

    public static void rehighlight() {
        Project[] openProjects;
        for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            PsiManager.getInstance((Project)project).dropPsiCaches();
        }
    }

    @NlsSafe
    @NotNull
    private static String makeWarningsDisabled(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList args = new ArrayList();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getDisabledOnlyThis());
            }
        }
        String string = StringUtil.join(args, (String)",");
        if (string == null) {
            ClangdSettings.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String makeWarningsEnabled(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList args = new ArrayList();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getEnabledOnlyThis(false));
            }
        }
        String string = StringUtil.join(args, (String)",");
        if (string == null) {
            ClangdSettings.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String makeWarningsAsErrors(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList args = new ArrayList();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getEnabledOnlyThis(true));
            }
        }
        String string = StringUtil.join(args, (String)",");
        if (string == null) {
            ClangdSettings.$$$reportNull$$$0(10);
        }
        return string;
    }

    private <Type> void setProperty(@NotNull Consumer<Type> propertySetter, @NotNull BiConsumer<ClangdSettingsListener, Type> propertyListener, Type oldValue, Type newValue) {
        if (propertySetter == null) {
            ClangdSettings.$$$reportNull$$$0(11);
        }
        if (propertyListener == null) {
            ClangdSettings.$$$reportNull$$$0(12);
        }
        if (!Objects.equals(newValue, oldValue)) {
            boolean oldClangdOn = this.isClangdOn();
            propertySetter.accept(newValue);
            propertyListener.accept(this.getPublisher(), newValue);
            boolean newClangOn = this.isClangdOn();
            if (oldClangdOn != newClangOn) {
                this.getPublisher().onClangdOnChanged(newClangOn);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/ClangdSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangdMessagesFilters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangWarnings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySetter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/ClangdSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangdMessagesFilters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangFlags";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "makeWarningsDisabled";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "makeWarningsEnabled";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "makeWarningsAsErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setClangdMessagesFilters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setClangFlags";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class StoredState {
        public boolean clangdShowErrors;
        public boolean clangTidyViaClangd;
        public boolean navigationViaClangd;
        public boolean formatViaClangd;
        public CompletionType completionType;
        public boolean enableGlobalCompletionCache;
        public boolean clangdEnabled;
        @NlsSafe
        public String clangWarnings;
        @NlsSafe
        public String clangdMessagesFilters;

        StoredState() {
            this.clangdShowErrors = !ApplicationManager.getApplication().isUnitTestMode();
            this.clangTidyViaClangd = true;
            this.navigationViaClangd = true;
            this.formatViaClangd = true;
            this.completionType = ApplicationManager.getApplication().isUnitTestMode() ? CompletionType.Builtin : CompletionType.Clangd;
            this.enableGlobalCompletionCache = AdvancedSettings.getBoolean((String)ClangdSettings.GLOBAL_COMPLETION_CACHE_ID);
            this.clangdEnabled = Registry.is((String)"clion.clang.clangd.on");
            this.clangWarnings = StringUtil.join(Arrays.asList(DEFAULT_DISABLED_WARNINGS, DEFAULT_DISABLED_ERRORS, DEFAULT_ENABLED_WARNINGS, ApplicationManager.getApplication().isUnitTestMode() ? "-Wconversion" : null), (String)",");
            this.clangdMessagesFilters = DEFAULT_MESSAGE_FILTERS;
        }

        StoredState(@NotNull StoredState other) {
            if (other == null) {
                StoredState.$$$reportNull$$$0(0);
            }
            this.clangdShowErrors = !ApplicationManager.getApplication().isUnitTestMode();
            this.clangTidyViaClangd = true;
            this.navigationViaClangd = true;
            this.formatViaClangd = true;
            this.completionType = ApplicationManager.getApplication().isUnitTestMode() ? CompletionType.Builtin : CompletionType.Clangd;
            this.enableGlobalCompletionCache = AdvancedSettings.getBoolean((String)ClangdSettings.GLOBAL_COMPLETION_CACHE_ID);
            this.clangdEnabled = Registry.is((String)"clion.clang.clangd.on");
            this.clangWarnings = StringUtil.join(Arrays.asList(DEFAULT_DISABLED_WARNINGS, DEFAULT_DISABLED_ERRORS, DEFAULT_ENABLED_WARNINGS, ApplicationManager.getApplication().isUnitTestMode() ? "-Wconversion" : null), (String)",");
            this.clangdMessagesFilters = DEFAULT_MESSAGE_FILTERS;
            this.clangdShowErrors = other.clangdShowErrors;
            this.clangTidyViaClangd = other.clangTidyViaClangd;
            this.navigationViaClangd = other.navigationViaClangd;
            this.formatViaClangd = other.formatViaClangd;
            this.completionType = other.completionType;
            this.clangdEnabled = other.clangdEnabled;
            this.clangWarnings = other.clangWarnings;
            this.clangdMessagesFilters = other.clangdMessagesFilters;
            this.enableGlobalCompletionCache = other.enableGlobalCompletionCache;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/ClangdSettings$StoredState", "<init>"));
        }
    }

    public static enum CompletionType {
        Builtin(0),
        Clangd(1);

        private final int value;

        private CompletionType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static CompletionType forValue(int value) {
            CompletionType[] allValues = CompletionType.values();
            if (value < 0 || value >= allValues.length) {
                return Clangd;
            }
            return allValues[value];
        }
    }
}

