/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.LineSeparator;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.DepthCombo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Url;

public class ExportOptionsDialog
extends DialogWrapper
implements ActionListener {
    private final Url myURL;
    private final Project myProject;
    private final File myFile;
    private TextFieldWithBrowseButton myPathField;
    private DepthCombo myDepth;
    private JBCheckBox myExternalsCheckbox;
    private JBCheckBox myForceCheckbox;
    private final @NotNull CollectionComboBoxModel<@Nullable LineSeparator> myLineSeparatorComboBoxModel = new CollectionComboBoxModel(Arrays.asList(null, LineSeparator.LF, LineSeparator.CRLF, LineSeparator.CR));

    public ExportOptionsDialog(Project project, Url url, File target) {
        super(project, true);
        this.myURL = url;
        this.myProject = project;
        this.myFile = target;
        this.setTitle(SvnBundle.message("dialog.title.svn.export.options", new Object[0]));
        this.init();
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.export.options";
    }

    public File getTarget() {
        return new File(this.myPathField.getText());
    }

    public Depth getDepth() {
        return this.myDepth.getDepth();
    }

    public boolean isForce() {
        return this.myForceCheckbox.isSelected();
    }

    public boolean isIgnoreExternals() {
        return !this.myExternalsCheckbox.isSelected();
    }

    @Nullable
    public String getEOLStyle() {
        LineSeparator separator = (LineSeparator)this.myLineSeparatorComboBoxModel.getSelected();
        return separator != null ? separator.name() : null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = JBUI.insets((int)2);
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        gc.fill = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        panel2.add((Component)new JBLabel(SvnBundle.message("label.export", new Object[0])), gc);
        ++gc.gridx;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.fill = 2;
        JBLabel urlLabel = new JBLabel(this.myURL.toDecodedString());
        urlLabel.setFont(urlLabel.getFont().deriveFont(1));
        panel2.add((Component)urlLabel, gc);
        ++gc.gridy;
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.fill = 0;
        panel2.add((Component)new JBLabel(SvnBundle.message("label.destination", new Object[0])), gc);
        ++gc.gridx;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.fill = 2;
        this.myPathField = new TextFieldWithBrowseButton((ActionListener)this);
        this.myPathField.setText(this.myFile.getAbsolutePath());
        this.myPathField.setEditable(false);
        panel2.add((Component)this.myPathField, gc);
        ++gc.gridy;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.gridwidth = 3;
        gc.fill = 0;
        JBLabel depthLabel = new JBLabel(SvnBundle.message("label.depth.text", new Object[0]));
        depthLabel.setToolTipText(SvnBundle.message("label.depth.description", new Object[0]));
        panel2.add((Component)depthLabel, gc);
        ++gc.gridx;
        this.myDepth = new DepthCombo(false);
        panel2.add((Component)this.myDepth, gc);
        depthLabel.setLabelFor((Component)this.myDepth);
        gc.gridx = 0;
        ++gc.gridy;
        this.myForceCheckbox = new JBCheckBox(SvnBundle.message("checkbox.replace.existing.files", new Object[0]));
        this.myForceCheckbox.setSelected(true);
        panel2.add((Component)this.myForceCheckbox, gc);
        ++gc.gridy;
        this.myExternalsCheckbox = new JBCheckBox(SvnBundle.message("checkbox.include.externals.locations", new Object[0]));
        this.myExternalsCheckbox.setSelected(true);
        panel2.add((Component)this.myExternalsCheckbox, gc);
        ++gc.gridy;
        gc.gridwidth = 2;
        panel2.add((Component)new JBLabel(SvnBundle.message("label.override.native.eols.with", new Object[0])), gc);
        gc.gridx += 2;
        gc.gridwidth = 1;
        panel2.add((Component)this.createLineSeparatorComboBox(), gc);
        ++gc.gridy;
        gc.gridwidth = 3;
        gc.gridx = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.anchor = 15;
        gc.fill = 2;
        panel2.add((Component)new JSeparator(), gc);
        return panel2;
    }

    @NotNull
    private ComboBox<LineSeparator> createLineSeparatorComboBox() {
        ComboBox comboBox = new ComboBox(this.myLineSeparatorComboBoxModel);
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)SvnBundle.message("combobox.crlf.none", new Object[0]), separator -> {
            switch (separator) {
                case LF: {
                    return ApplicationBundle.message((String)"combobox.crlf.unix", (Object[])new Object[0]);
                }
                case CRLF: {
                    return ApplicationBundle.message((String)"combobox.crlf.windows", (Object[])new Object[0]);
                }
                case CR: {
                    return ApplicationBundle.message((String)"combobox.crlf.mac", (Object[])new Object[0]);
                }
            }
            throw new IllegalArgumentException("unknown line separator " + separator);
        }));
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            ExportOptionsDialog.$$$reportNull$$$0(0);
        }
        return comboBox2;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(SvnBundle.message("dialog.title.export.directory", new Object[0]));
        fcd.setDescription(SvnBundle.message("label.select.directory.to.export.from.subversion", new Object[0]));
        fcd.setHideIgnored(false);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fcd, (Component)this.getContentPane(), (Project)this.myProject, null);
        if (file == null) {
            return;
        }
        this.myPathField.setText(file.getPath().replace('/', File.separatorChar));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/browser/ExportOptionsDialog", "createLineSeparatorComboBox"));
    }
}

