/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import a.d.la;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageLogger;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.ref.SoftReference;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCoverageSuite
implements CoverageSuite,
JDOMExternalizable {
    private static final Logger LOG;
    @NonNls
    private static final String FILE_PATH = "FILE_PATH";
    @NonNls
    private static final String SOURCE_PROVIDER = "SOURCE_PROVIDER";
    @NonNls
    private static final String MODIFIED_STAMP = "MODIFIED";
    @NonNls
    private static final String NAME_ATTRIBUTE = "NAME";
    @NonNls
    private static final String COVERAGE_RUNNER = "RUNNER";
    @NonNls
    private static final String COVERAGE_BY_TEST_ENABLED_ATTRIBUTE_NAME = "COVERAGE_BY_TEST_ENABLED";
    @NonNls
    private static final String TRACING_ENABLED_ATTRIBUTE_NAME = "COVERAGE_TRACING_ENABLED";
    private SoftReference<ProjectData> myCoverageData = new SoftReference<Object>(null);
    private String myName;
    private long myLastCoverageTimeStamp;
    private boolean myCoverageByTestEnabled;
    private CoverageRunner myRunner;
    private CoverageFileProvider myCoverageDataFileProvider;
    private boolean myTrackTestFolders;
    private boolean myTracingEnabled;
    private Project myProject;
    private RunConfigurationBase myConfiguration;
    private static final long a;

    protected BaseCoverageSuite() {
    }

    public BaseCoverageSuite(String name, @Nullable CoverageFileProvider fileProvider, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, CoverageRunner coverageRunner) {
        this(name, fileProvider, lastCoverageTimeStamp, coverageByTestEnabled, tracingEnabled, trackTestFolders, coverageRunner, null);
    }

    public BaseCoverageSuite(String name, @Nullable CoverageFileProvider fileProvider, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, CoverageRunner coverageRunner, Project project) {
        this.myCoverageDataFileProvider = fileProvider;
        this.myName = name;
        this.myLastCoverageTimeStamp = lastCoverageTimeStamp;
        this.myCoverageByTestEnabled = coverageByTestEnabled;
        this.myTrackTestFolders = trackTestFolders;
        this.myTracingEnabled = tracingEnabled;
        this.myRunner = coverageRunner;
        this.myProject = project;
    }

    @Nullable
    public static CoverageRunner readRunnerAttribute(Element element) {
        long l2 = a ^ 0x6FC176232953L;
        String string = element.getAttributeValue(COVERAGE_RUNNER);
        if (string != null) {
            for (CoverageRunner coverageRunner : CoverageRunner.EP_NAME.getExtensionList()) {
                if (!Comparing.strEqual((String)coverageRunner.getId(), (String)string)) continue;
                return coverageRunner;
            }
        }
        return null;
    }

    public static CoverageFileProvider readDataFileProviderAttribute(Element element) {
        long l2 = a ^ 0x5FD6280D229EL;
        String string = element.getAttributeValue(SOURCE_PROVIDER);
        String string2 = FileUtil.toSystemDependentName((String)element.getAttributeValue(FILE_PATH));
        File file = new File(string2);
        return new DefaultCoverageFileProvider(file.exists() ? file : new File(PathManager.getSystemPath(), string2), string != null ? string : DefaultCoverageFileProvider.class.getName());
    }

    @Override
    public boolean isValid() {
        return this.myCoverageDataFileProvider.isValid();
    }

    @Override
    @NotNull
    public String getCoverageDataFileName() {
        String string = this.myCoverageDataFileProvider.getCoverageDataFilePath();
        if (string == null) {
            BaseCoverageSuite.a(0);
        }
        return string;
    }

    @Override
    @NotNull
    public CoverageFileProvider getCoverageDataFileProvider() {
        CoverageFileProvider coverageFileProvider = this.myCoverageDataFileProvider;
        if (coverageFileProvider == null) {
            BaseCoverageSuite.a(1);
        }
        return coverageFileProvider;
    }

    @Override
    public String getPresentableName() {
        return this.myName;
    }

    @Override
    public long getLastCoverageTimeStamp() {
        return this.myLastCoverageTimeStamp;
    }

    @Override
    public boolean isTrackTestFolders() {
        return this.myTrackTestFolders;
    }

    @Override
    public boolean isTracingEnabled() {
        return this.myTracingEnabled;
    }

    public void readExternal(Element element) throws InvalidDataException {
        long l2 = a ^ 0x7A838A25CF67L;
        this.myCoverageDataFileProvider = BaseCoverageSuite.readDataFileProviderAttribute(element);
        this.myName = element.getAttributeValue(NAME_ATTRIBUTE);
        if (this.myName == null) {
            this.myName = this.a();
        }
        this.myLastCoverageTimeStamp = Long.parseLong(element.getAttributeValue(MODIFIED_STAMP));
        this.myRunner = BaseCoverageSuite.readRunnerAttribute(element);
        String string = element.getAttributeValue(COVERAGE_BY_TEST_ENABLED_ATTRIBUTE_NAME);
        this.myCoverageByTestEnabled = string != null && Boolean.valueOf(string) != false;
        String string2 = element.getAttributeValue(TRACING_ENABLED_ATTRIBUTE_NAME);
        this.myTracingEnabled = string2 != null && Boolean.valueOf(string2) != false;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        long l2 = a ^ 0xDB3712DCCDEL;
        String string = FileUtil.getRelativePath((File)new File(PathManager.getSystemPath()), (File)new File(this.myCoverageDataFileProvider.getCoverageDataFilePath()));
        element.setAttribute(FILE_PATH, string != null ? FileUtil.toSystemIndependentName((String)string) : this.myCoverageDataFileProvider.getCoverageDataFilePath());
        element.setAttribute(NAME_ATTRIBUTE, this.myName);
        element.setAttribute(MODIFIED_STAMP, String.valueOf(this.myLastCoverageTimeStamp));
        element.setAttribute(SOURCE_PROVIDER, this.myCoverageDataFileProvider instanceof DefaultCoverageFileProvider ? ((DefaultCoverageFileProvider)this.myCoverageDataFileProvider).getSourceProvider() : this.myCoverageDataFileProvider.getClass().getName());
        if (this.getRunner() != null) {
            element.setAttribute(COVERAGE_RUNNER, this.myRunner.getId());
        }
        element.setAttribute(COVERAGE_BY_TEST_ENABLED_ATTRIBUTE_NAME, String.valueOf(this.myCoverageByTestEnabled));
        element.setAttribute(TRACING_ENABLED_ATTRIBUTE_NAME, String.valueOf(this.myTracingEnabled));
    }

    @Override
    public void setCoverageData(ProjectData projectData) {
        this.myCoverageData = new SoftReference<ProjectData>(projectData);
    }

    public ProjectData getCoverageData() {
        return this.myCoverageData.get();
    }

    @Override
    public void restoreCoverageData() {
        this.setCoverageData(this.loadProjectInfo());
    }

    @Override
    public boolean isCoverageByTestApplicable() {
        return this.getRunner().isCoverageByTestApplicable();
    }

    @Override
    public boolean isCoverageByTestEnabled() {
        return this.myCoverageByTestEnabled;
    }

    @Override
    @Nullable
    public ProjectData getCoverageData(CoverageDataManager coverageDataManager) {
        ProjectData projectData = this.getCoverageData();
        if (projectData != null) {
            return projectData;
        }
        ProjectData projectData2 = this.loadProjectInfo();
        this.setCoverageData(projectData2);
        return projectData2;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        String string = this.myCoverageDataFileProvider.getCoverageDataFilePath();
        String string2 = ((BaseCoverageSuite)o2).myCoverageDataFileProvider.getCoverageDataFilePath();
        return string.equals(string2);
    }

    public int hashCode() {
        return this.myCoverageDataFileProvider.getCoverageDataFilePath().hashCode();
    }

    @Nullable
    protected ProjectData loadProjectInfo() {
        String string = this.getCoverageDataFileName();
        File file = new File(string);
        if (!file.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Nonexistent file given +" + string);
            }
            return null;
        }
        long l2 = System.nanoTime();
        ProjectData projectData = this.myRunner.loadCoverageData(file, this);
        long l3 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
        if (projectData != null) {
            CoverageLogger.logReportLoading(this.myProject, this.myRunner, l3, projectData.getClassesNumber());
        }
        return projectData;
    }

    @Override
    public CoverageRunner getRunner() {
        return this.myRunner;
    }

    protected void setRunner(CoverageRunner runner) {
        this.myRunner = runner;
    }

    private String a() {
        String string = this.myCoverageDataFileProvider.getCoverageDataFilePath();
        int n2 = string.lastIndexOf(File.separatorChar);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        if ((n2 = string.lastIndexOf(46)) >= 0) {
            string = string.substring(0, n2);
        }
        return string;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    public void setConfiguration(RunConfigurationBase configuration) {
        this.myConfiguration = configuration;
    }

    @Nullable
    public RunConfigurationBase getConfiguration() {
        return this.myConfiguration;
    }

    static {
        a = la.a(5187783127545632917L, 8924804202433300055L, MethodHandles.lookup().lookupClass()).a(195712760547260L);
        LOG = Logger.getInstance((String)BaseCoverageSuite.class.getName());
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = a ^ 0x6B1BA06B74F7L;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/coverage/BaseCoverageSuite";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageDataFileName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageDataFileProvider";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

