/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.resourceRoots;

import a.d.la;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class MarkResourceRootActionBase
extends AnAction {
    private static final Logger LOG;
    private final boolean myMark;
    private static final long b;

    public MarkResourceRootActionBase(boolean mark, @NotNull Supplier<String> text) {
        if (text == null) {
            MarkResourceRootActionBase.a(0);
        }
        super(text);
        this.myMark = mark;
    }

    public void update(@NotNull AnActionEvent e10) {
        if (e10 == null) {
            MarkResourceRootActionBase.a(1);
        }
        boolean bl2 = this.a(e10);
        e10.getPresentation().setEnabledAndVisible(bl2);
    }

    public void actionPerformed(@NotNull AnActionEvent e10) {
        long l2 = b ^ 0x4E2CDFB15163L;
        if (e10 == null) {
            MarkResourceRootActionBase.a(2);
        }
        Project project = (Project)e10.getData(CommonDataKeys.PROJECT);
        VirtualFile[] virtualFileArray = (VirtualFile[])e10.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project == null) {
            LOG.warn("Can not resolve a project (null)");
            return;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        WebResourcesPathsConfiguration webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(project);
        MultiMap<String, String> multiMap = webResourcesPathsConfiguration.getResourceRoots();
        assert (virtualFileArray != null);
        for (VirtualFile virtualFile : virtualFileArray) {
            String string = projectFileIndex.getContentRootForFile(virtualFile).getUrl();
            if (this.myMark) {
                multiMap.putValue((Object)string, (Object)virtualFile.getUrl());
                continue;
            }
            multiMap.remove((Object)string, (Object)virtualFile.getUrl());
        }
        webResourcesPathsConfiguration.setResourceRoots(multiMap);
    }

    private boolean a(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            MarkResourceRootActionBase.a(3);
        }
        Module module = (Module)anActionEvent.getData(LangDataKeys.MODULE);
        VirtualFile[] virtualFileArray = (VirtualFile[])anActionEvent.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (module == null || virtualFileArray == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        for (VirtualFile virtualFile : virtualFileArray) {
            if (!virtualFile.isDirectory()) {
                return false;
            }
            if (!projectFileIndex.isInContent(virtualFile)) {
                return false;
            }
            WebResourcesPathsConfiguration webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(module.getProject());
            if (webResourcesPathsConfiguration != null) {
                MultiMap<String, String> multiMap = webResourcesPathsConfiguration.getResourceRoots();
                Collection collection = multiMap.get((Object)projectFileIndex.getContentRootForFile(virtualFile).getUrl());
                if (this.myMark != collection.contains(virtualFile.getUrl())) continue;
                return false;
            }
            LOG.warn("Can not get configuration for " + module.getProject());
            return false;
        }
        return true;
    }

    static {
        b = la.a(-6600053861873391864L, -5858197668347980782L, MethodHandles.lookup().lookupClass()).a(196113493177106L);
        LOG = Logger.getInstance(MarkResourceRootActionBase.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x419B8C3395AFL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/resourceRoots/MarkResourceRootActionBase";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canMark";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

