/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import a.d.la;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class CidrPathManager {
    private static final Logger LOG;
    private static Path ourCidrRootPath;
    private static final Map<Class<?>, Ref<Path>> ourPluginPathsCache;
    private static final Set<Path> ourFileWithExecutableUpdated;
    private static final long a;

    public static Path getCidrSourcesRoot() {
        long l2 = a ^ 0x2F212D3F846L;
        if (ourCidrRootPath == null) {
            ourCidrRootPath = Paths.get(PathManager.getHomePath(), System.getProperty("cidr.root.path", "CIDR"));
        }
        return ourCidrRootPath;
    }

    @NlsSafe
    @NotNull
    public static String getPlatformRelativePath(@NonNls @NotNull String relativePath) {
        long l2 = a ^ 0x1CB5C9D3BB22L;
        if (relativePath == null) {
            CidrPathManager.a(0);
        }
        String string = (SystemInfo.isWindows ? "win/" : (SystemInfo.isMac ? "mac/" : "linux/")) + relativePath;
        if (string == null) {
            CidrPathManager.a(1);
        }
        return string;
    }

    @NotNull
    public static File getBinFile(@NotNull Class<?> clazz, @NonNls @NotNull String inSourcesPath, @NonNls @NotNull String relativePath, @NonNls @Nullable String relativePathToAdditionalBinaries) {
        if (clazz == null) {
            CidrPathManager.a(2);
        }
        if (inSourcesPath == null) {
            CidrPathManager.a(3);
        }
        if (relativePath == null) {
            CidrPathManager.a(4);
        }
        File file = CidrPathManager.getBinPath(clazz, inSourcesPath, relativePath, relativePathToAdditionalBinaries).toFile();
        if (file == null) {
            CidrPathManager.a(5);
        }
        return file;
    }

    @NotNull
    public static Path getBinPath(@NotNull Class<?> clazz, @NonNls @NotNull String inSourcesPath, @NonNls @NotNull String relativePath, @NonNls @Nullable String relativePathToAdditionalBinaries) {
        Path path;
        if (clazz == null) {
            CidrPathManager.a(6);
        }
        if (inSourcesPath == null) {
            CidrPathManager.a(7);
        }
        if (relativePath == null) {
            CidrPathManager.a(8);
        }
        if ((path = CidrPathManager.a(clazz)) != null) {
            Path path2 = CidrPathManager.a(path.resolve("bin/" + relativePath));
            if (relativePathToAdditionalBinaries != null) {
                CidrPathManager.a(path.resolve("bin/" + relativePathToAdditionalBinaries));
            }
            Path path3 = path2;
            if (path3 == null) {
                CidrPathManager.a(9);
            }
            return path3;
        }
        if (PluginManagerCore.isRunningFromSources()) {
            Path path4 = CidrPathManager.a(CidrPathManager.getCidrSourcesRoot().resolve(inSourcesPath + "/" + relativePath));
            if (relativePathToAdditionalBinaries != null) {
                CidrPathManager.a(CidrPathManager.getCidrSourcesRoot().resolve(inSourcesPath + "/" + relativePathToAdditionalBinaries));
            }
            Path path5 = path4;
            if (path5 == null) {
                CidrPathManager.a(10);
            }
            return path5;
        }
        Path path6 = Paths.get(PathManager.getBinPath(), relativePath);
        if (path6 == null) {
            CidrPathManager.a(11);
        }
        return path6;
    }

    private static void a(@NotNull Path path) {
        if (path == null) {
            CidrPathManager.a(12);
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                CidrPathManager.a(path2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static Path a(@NotNull Path path) {
        if (path == null) {
            CidrPathManager.a(13);
        }
        if (ourFileWithExecutableUpdated.contains(path)) {
            Path path2 = path;
            if (path2 == null) {
                CidrPathManager.a(14);
            }
            return path2;
        }
        if (Files.isRegularFile(path, new LinkOption[0]) && !Files.isExecutable(path)) {
            LOG.info("Setting executable flag for " + path);
            EnumSet<PosixFilePermission> enumSet = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.GROUP_EXECUTE);
            try {
                enumSet.addAll(Files.getPosixFilePermissions(path, new LinkOption[0]));
                Files.setPosixFilePermissions(path, enumSet);
            }
            catch (IOException iOException) {
                LOG.warn("Cannot set executable flag for " + path, (Throwable)iOException);
            }
        }
        ourFileWithExecutableUpdated.add(path);
        Path path3 = path;
        if (path3 == null) {
            CidrPathManager.a(15);
        }
        return path3;
    }

    @Nullable
    private static Path a(@NotNull Class<?> clazz) {
        if (clazz == null) {
            CidrPathManager.a(16);
        }
        if (PlatformUtils.isCidr()) {
            return null;
        }
        Ref ref = ourPluginPathsCache.get(clazz);
        if (ref == null) {
            PluginId pluginId;
            IdeaPluginDescriptor ideaPluginDescriptor;
            ref = new Ref();
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader instanceof PluginAwareClassLoader && (ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)(pluginId = ((PluginAwareClassLoader)classLoader).getPluginId()))) != null) {
                ref.set((Object)ideaPluginDescriptor.getPluginPath());
            }
            ourPluginPathsCache.putIfAbsent(clazz, (Ref<Path>)ref);
        }
        return (Path)ref.get();
    }

    static {
        a = la.a(-7428228427145019025L, -8289994057725951299L, MethodHandles.lookup().lookupClass()).a(115759772048419L);
        LOG = Logger.getInstance((String)("#" + CidrPathManager.class.getPackage().getName()));
        ourPluginPathsCache = new ConcurrentHashMap();
        ourFileWithExecutableUpdated = ContainerUtil.newConcurrentSet();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x24B04005E4C0L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrPathManager";
                break;
            }
            case 2: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inSourcesPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrPathManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformRelativePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFileIsExecutable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformRelativePath";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBinFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesInDirAreExecutable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "ensureFileIsExecutable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPluginPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

