/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.daemon.impl.EditorTracker;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0016\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"findOrCreateEditor", "Lcom/intellij/openapi/editor/Editor;", "target", "Lcom/intellij/database/psi/DbElement;", "preferExisting", "", "getSelectDbAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "file", "moveCaretToEnd", "", "editor", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.impl"})
@JvmName(name="DbActionUtils")
public final class DbActionUtils {
    @NotNull
    public static final AnAction getSelectDbAction(boolean file) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(file, !file, false, false, false, false);
        descriptor2.setHideIgnored(false);
        descriptor2.setTitle(DatabaseBundle.message("dialog.title.choose.database", file ? DatabaseBundle.message("dialog.title.choose.database.file", new Object[0]) : DatabaseBundle.message("dialog.title.choose.database.path", new Object[0])));
        return (AnAction)new ParamEditorBase.FMChooseAction(descriptor2);
    }

    @Nullable
    public static final Editor findOrCreateEditor(@NotNull DbElement target, boolean preferExisting) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"target.project");
        Project project2 = project;
        DbDataSource dbDataSource = target.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"target.dataSource");
        DbDataSource dataSource2 = dbDataSource;
        if (preferExisting) {
            Object v6;
            block8: {
                EditorTracker editorTracker = EditorTracker.getInstance((Project)target.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)editorTracker, (String)"EditorTracker.getInstance(target.project)");
                List list = editorTracker.getActiveEditors();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"EditorTracker.getInstanc\u2026et.project).activeEditors");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DbDataSource dbDataSource2;
                    Editor it2 = (Editor)element$iv;
                    boolean bl = false;
                    Editor editor = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"it");
                    if (DbActionUtils.getVirtualFile(editor, project2) != null) {
                        VirtualFile virtualFile;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        VirtualFile it3 = virtualFile;
                        boolean bl4 = false;
                        dbDataSource2 = DbVFSUtils.getDataSource(project2, it3);
                    } else {
                        dbDataSource2 = null;
                    }
                    if (!Intrinsics.areEqual(dbDataSource2, (Object)dataSource2)) continue;
                    v6 = element$iv;
                    break block8;
                }
                v6 = null;
            }
            Editor activeEditor = v6;
            if (activeEditor != null) {
                VirtualFile virtualFile = DbActionUtils.getVirtualFile(activeEditor, project2);
                Intrinsics.checkNotNull((Object)virtualFile);
                VirtualFile virtualFile2 = virtualFile;
                FileEditorManager.getInstance((Project)project2).openFile(virtualFile2, true);
                return activeEditor;
            }
        }
        VirtualFile virtualFile = DbUIUtil.openInConsole(dataSource2, target, "", preferExisting);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"DbUIUtil.openInConsole(d\u2026rExisting) ?: return null");
        VirtualFile vFile = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(vFile);
        if (psiFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026ile(vFile) ?: return null");
        PsiFile psiFile2 = psiFile;
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile2);
        if (document == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"PsiDocumentManager.getIn\u2026t(psiFile) ?: return null");
        Document document2 = document;
        Object[] objectArray = EditorFactory.getInstance().getEditors(document2, project2);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"EditorFactory.getInstanc\u2026ditors(document, project)");
        return (Editor)ArraysKt.firstOrNull((Object[])objectArray);
    }

    public static final void moveCaretToEnd(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        int textLength = document2.getTextLength();
        if (textLength > 0 && document2.getCharsSequence().charAt(textLength - 1) != '\n') {
            WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), null, null, (Runnable)new Runnable(document2, textLength){
                final /* synthetic */ Document $document;
                final /* synthetic */ int $textLength;

                public final void run() {
                    this.$document.insertString(this.$textLength, (CharSequence)"\n");
                }
                {
                    this.$document = document;
                    this.$textLength = n;
                }
            }, (PsiFile[])new PsiFile[0]);
        }
        editor.getCaretModel().moveToOffset(document2.getTextLength());
    }

    private static final VirtualFile getVirtualFile(Editor $this$getVirtualFile, Project project) {
        PsiFile psiFile;
        Document document = $this$getVirtualFile.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
        Document document2 = document;
        PsiFile psiFile2 = psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document2);
        return psiFile2 != null ? psiFile2.getVirtualFile() : null;
    }
}

