/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.SynchronizeHandler;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RefreshSchemaAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        DataContext dataContext;
        JBIterable<DbElement> selection;
        boolean enabled;
        if (e == null) {
            RefreshSchemaAction.$$$reportNull$$$0(0);
        }
        boolean visible = enabled = !(selection = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext = e.getDataContext())).isEmpty();
        for (DbElement o : selection) {
            LocalDataSource dataSource2 = DbImplUtil.getMaybeLocalDataSource(o.getDataSource());
            visible &= dataSource2 != null && this.isEnabledForContextElement(o);
            enabled &= dataSource2 != null && !dataSource2.isLoading() && DbImplUtilCore.canConnectTo(dataSource2);
        }
        e.getPresentation().setVisible(visible || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || e.isFromActionToolbar());
        e.getPresentation().setEnabled(enabled);
    }

    protected boolean isEnabledForContextElement(@NotNull DbElement o) {
        if (o == null) {
            RefreshSchemaAction.$$$reportNull$$$0(1);
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RefreshSchemaAction.$$$reportNull$$$0(2);
        }
        @NotNull DataContext dataContext = e.getDataContext();
        JBIterable<DbElement> selection = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext);
        RefreshSchemaAction.refresh(e.getProject(), selection);
    }

    public static void refresh(Project project, JBIterable<DbElement> selection) {
        Map map2 = ContainerUtil.classify((Iterator)selection.iterator(), o -> o.getDataSource());
        HashSet<DbDataSource> dataSourceElements = new HashSet<DbDataSource>(map2.keySet());
        if (project != null) {
            for (SynchronizeHandler handler : (SynchronizeHandler[])SynchronizeHandler.EP_NAME.getExtensions()) {
                handler.synchronizationStarted(project, dataSourceElements);
            }
        }
        for (DbDataSource element2 : dataSourceElements) {
            Set elements = (Set)map2.get(element2);
            if (elements.contains(element2) && elements.size() > 1) {
                elements.retainAll(Collections.singletonList(element2));
            }
            RefreshSchemaAction.refresh(element2, elements);
        }
    }

    @NotNull
    public static AsyncTask<DataSourceSyncManager.SyncResult> refresh(DbDataSource element2, Collection<DbElement> selection) {
        DatabaseSystem delegate = element2.getDelegate();
        if (!(delegate instanceof LocalDataSource)) {
            AsyncTask<DataSourceSyncManager.SyncResult> asyncTask = AsyncTask.cancelled();
            if (asyncTask == null) {
                RefreshSchemaAction.$$$reportNull$$$0(3);
            }
            return asyncTask;
        }
        LocalDataSource dataSource2 = (LocalDataSource)delegate;
        LoaderContext context = RefreshSchemaAction.createLoaderContext(element2, selection, dataSource2);
        AsyncTask<DataSourceSyncManager.SyncResult> asyncTask = DataSourceUtil.performManualSyncTask(context);
        if (asyncTask == null) {
            RefreshSchemaAction.$$$reportNull$$$0(4);
        }
        return asyncTask;
    }

    static LoaderContext createLoaderContext(@NotNull DbDataSource dataSourceElement, @NotNull Collection<? extends DbElement> selection, @NotNull LocalDataSource dataSource2) {
        if (dataSourceElement == null) {
            RefreshSchemaAction.$$$reportNull$$$0(5);
        }
        if (selection == null) {
            RefreshSchemaAction.$$$reportNull$$$0(6);
        }
        if (dataSource2 == null) {
            RefreshSchemaAction.$$$reportNull$$$0(7);
        }
        LoaderContext context = new LoaderContext(dataSourceElement.getProject(), dataSource2);
        boolean loadEverything = selection.contains(dataSourceElement);
        if (loadEverything) {
            context.includeAllSchemas();
        }
        if (selection.size() > 1 || !loadEverything) {
            for (DbElement dbElement : selection) {
                if (dbElement == dataSourceElement || dbElement.getDataSource() != dataSourceElement) continue;
                DbElement parent2 = dbElement.getParent();
                if (parent2 instanceof DbTable || dbElement instanceof DbPackage) {
                    context.include(parent2);
                    continue;
                }
                context.include(dbElement);
            }
        }
        TreePattern scope = DbImplUtilCore.getIntrospectionScope(dataSourceElement);
        for (BasicMateNamespace namespace : JBIterable.from(selection).map(DbElement::getDelegate).filter(BasicMateNamespace.class)) {
            if (DataSourceSchemaMapping.isIntrospected(scope, namespace)) continue;
            context.getScopeUpdater().toAdd(BasicPaths.of(namespace));
        }
        return context;
    }

    public static void forgetAndRefresh(@NotNull Project project, @NotNull Iterable<DbDataSource> selection, boolean refresh2) {
        if (project == null) {
            RefreshSchemaAction.$$$reportNull$$$0(8);
        }
        if (selection == null) {
            RefreshSchemaAction.$$$reportNull$$$0(9);
        }
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(project);
        for (DbDataSource element2 : selection) {
            LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource(element2.getDataSource());
            if (localDataSource == null) continue;
            RefreshSchemaAction.doForgetAndRefreshForDataSource(project, storage, localDataSource, element2, refresh2);
        }
    }

    private static void doForgetAndRefreshForDataSource(@NotNull Project project, @NotNull DataSourceStorage storage, @NotNull LocalDataSource localDataSource, @NotNull DbDataSource dbDataSource, boolean refresh2) {
        if (project == null) {
            RefreshSchemaAction.$$$reportNull$$$0(10);
        }
        if (storage == null) {
            RefreshSchemaAction.$$$reportNull$$$0(11);
        }
        if (localDataSource == null) {
            RefreshSchemaAction.$$$reportNull$$$0(12);
        }
        if (dbDataSource == null) {
            RefreshSchemaAction.$$$reportNull$$$0(13);
        }
        String progressTitle = refresh2 ? DatabaseBundle.message("action.DatabaseView.ForceRefreshAction.progress", localDataSource.getName()) : DatabaseBundle.message("action.DatabaseView.ForgetSchemaAction.progress", new Object[0]);
        AsyncTask.Frame frame = AsyncTask.frame(progressTitle);
        AsyncTask.withBgIndicatorIfNeeded(frame, project, null).computeAsync(null, () -> {
            AsyncTask<DataSourceSyncManager.SyncResult> stage = DataSourceSyncManager.getInstance().stopSynchronization(localDataSource).whenComplete(AsyncUtil.getPoolExecutor(), (r, th) -> localDataSource.clearModel()).whenComplete(AsyncUtil.getEdtExecutor(), (r, th) -> storage.updateDataSource(localDataSource));
            return refresh2 ? stage.whenComplete(null, (r, th) -> RefreshSchemaAction.refresh(dbDataSource, Collections.singleton(dbDataSource))) : stage;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/RefreshSchemaAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceElement";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDataSource";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/RefreshSchemaAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "refresh";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForContextElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLoaderContext";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forgetAndRefresh";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doForgetAndRefreshForDataSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Forget
    extends RefreshSchemaAction {
        Forget() {
        }

        @Override
        protected boolean isEnabledForContextElement(@NotNull DbElement o) {
            if (o == null) {
                Forget.$$$reportNull$$$0(0);
            }
            return o instanceof DasDataSource;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                Forget.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            @NotNull DataContext dataContext = e.getDataContext();
            JBIterable selection = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext).filter(DbDataSource.class);
            Forget.forgetAndRefresh(project, (Iterable<DbDataSource>)selection, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/RefreshSchemaAction$Forget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForContextElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ForceRefresh
    extends RefreshSchemaAction {
        @Override
        protected boolean isEnabledForContextElement(@NotNull DbElement o) {
            if (o == null) {
                ForceRefresh.$$$reportNull$$$0(0);
            }
            return o instanceof DasDataSource;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ForceRefresh.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            @NotNull DataContext dataContext = e.getDataContext();
            JBIterable selection = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext).filter(DbDataSource.class);
            ForceRefresh.forgetAndRefresh(project, (Iterable<DbDataSource>)selection, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/RefreshSchemaAction$ForceRefresh";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForContextElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

