/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ToDatabaseScriptTranslationAction;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.actions.SubmitMutations;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.EditorTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToDatabaseScriptTranslationPreviewAction
extends ToDatabaseScriptTranslationAction {
    @Nullable
    private static JdbcConsoleProvider.Info getInfo(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        Project project;
        Document document;
        if (psiFile == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(1);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = psiFile.getProject())).getDocument(psiFile)) == null) {
            return null;
        }
        ScriptModel model = SqlPsiFacade.getInstance((Project)project).createScriptModel(psiFile);
        return new JdbcConsoleProvider.Info(psiFile, psiFile, (EditorEx)editor, model, DatabaseSettings.getDefaultExecOption(), null);
    }

    @NotNull
    private static EditorTextField createArea(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Language language, @NotNull String text2) {
        JdbcConsole console;
        if (e == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(3);
        }
        if (language == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(5);
        }
        SearchPath searchPath = (console = JdbcConsole.findConsole(e)) == null ? null : console.getSearchPath();
        DbDataSource dataSource2 = console == null ? null : DbPsiFacade.getInstance(project).findDataSource(((LocalDataSource)console.getTarget()).getUniqueId());
        EditorTextField editorTextField2 = DatabaseDialogsHelper.createLanguageEditorArea(project, language, dataSource2, searchPath, text2, false);
        if (editorTextField2 == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(6);
        }
        return editorTextField2;
    }

    @Override
    void handleTranslatedQueryText(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Language language, @NotNull String text2) {
        if (e == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(8);
        }
        if (language == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(10);
        }
        EditorTextField area = ToDatabaseScriptTranslationPreviewAction.createArea(e, project, language, text2);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)area, "Center");
        DialogBuilder builder = new DialogBuilder();
        builder.setCenterPanel((JComponent)panel2);
        builder.addOkAction().setText(DatabaseBundle.message("database.cli.integration.run.action", new Object[0]));
        builder.setOkOperation(() -> {
            JdbcConsole console = JdbcConsole.findConsole(e);
            if (console == null) {
                return;
            }
            Editor editor = area.getEditor();
            if (editor == null) {
                return;
            }
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            if (psiFile == null) {
                return;
            }
            JdbcConsoleProvider.Info info = ToDatabaseScriptTranslationPreviewAction.getInfo(psiFile, editor);
            if (info == null) {
                return;
            }
            JdbcConsoleProvider.doRunQueryInConsole(console, info);
            builder.getDialogWrapper().close(0);
        });
        builder.setOkActionEnabled(true);
        builder.addCancelAction();
        builder.setTitle(DatabaseBundle.message("dialog.title.js.script.preview", new Object[0]));
        if (builder.showAndGet()) {
            SubmitMutations.submitChangesIfExists(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ToDatabaseScriptTranslationPreviewAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ToDatabaseScriptTranslationPreviewAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createArea";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleTranslatedQueryText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

