/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.ddl;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.actions.ddl.BaseModifyObjectAction;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.schemaEditor.DbObjectEditor;
import com.intellij.database.schemaEditor.DbObjectEditorDialogBase;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTaskBuilder;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateObjectGroup
extends ActionGroup {
    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        BasicModel model;
        if (DdlActions.isDbViewToolbar(e)) {
            if (AnAction.EMPTY_ARRAY == null) {
                CreateObjectGroup.$$$reportNull$$$0(0);
            }
            return AnAction.EMPTY_ARRAY;
        }
        DbElement single = e == null ? null : CreateObject.getSingle(e);
        BasicElement element2 = BaseModifyObjectAction.getElement(single);
        BasicModel basicModel = model = element2 == null ? null : element2.getModel();
        if (model == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                CreateObjectGroup.$$$reportNull$$$0(1);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ModelHelper helper = ModelFacade.forDbms(model.getDbms()).getModelHelper();
        AnAction[] anActionArray = (AnAction[])this.getCreateTargets(element2).flatten(m -> helper.generationVariants((BasicMetaObject<?>)m).map(v -> Pair.create((Object)m, (Object)v))).map(p2 -> new CreateObject((BasicMetaObject)p2.first, (ModelHelper.ObjectKindVariant)p2.second)).toArray((Object[])AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            CreateObjectGroup.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    @NotNull
    protected JBIterable<BasicMetaObject<?>> getCreateTargets(BasicElement element2) {
        JBIterable jBIterable = JBIterable.generate(element2.getMetaObject(), BasicMetaObject::getParent).flatten(e -> JBIterable.of((Object[])e.children));
        if (jBIterable == null) {
            CreateObjectGroup.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/actions/ddl/CreateObjectGroup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateTargets";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class CreateObject
    extends DumbAwareAction {
        private final BasicMetaObject<?> myMeta;
        private final ModelHelper.ObjectKindVariant myVariant;

        CreateObject(@NotNull BasicMetaObject<?> meta, @NotNull ModelHelper.ObjectKindVariant variant) {
            if (meta == null) {
                CreateObject.$$$reportNull$$$0(0);
            }
            if (variant == null) {
                CreateObject.$$$reportNull$$$0(1);
            }
            super(variant != ModelHelper.DEFAULT ? variant::getText : () -> StringUtil.capitalizeWords((String)DbPresentation.getPresentableName(meta), (boolean)true), DbPresentationCore.getIcon(meta));
            this.myMeta = meta;
            this.myVariant = variant;
        }

        public static boolean isSupported(@NotNull BasicElement e) {
            if (e == null) {
                CreateObject.$$$reportNull$$$0(2);
            }
            Dbms dbms = DbImplUtilCore.getDbms(e);
            ScriptingCapabilities capabilities = ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms)).capabilities(e);
            BasicModel model = e.getModel();
            return capabilities.getCreateAlone().get(model == null ? Version.INFINITY : model.getRoot().getServerVersion());
        }

        public void update(@NotNull AnActionEvent e) {
            DbElement single;
            BasicElement element2;
            if (e == null) {
                CreateObject.$$$reportNull$$$0(3);
            }
            boolean visible = (element2 = BaseModifyObjectAction.getElement(single = CreateObject.getSingle(e))) != null && BaseModifyObjectAction.canPerformOn(single.getDataSource()) && CreateObject.getParent(element2, this.myMeta) != null && CreateObject.isSupported(this.myMeta.newDataObject());
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && ImportUtil.canModify(single));
        }

        @Nullable
        private static BasicElement getParent(@Nullable BasicElement e, BasicMetaObject<?> meta) {
            return e == null || meta.getParent() == e.getMetaObject() ? e : CreateObject.getParent(e.getParent(), meta);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement single;
            BasicElement element2;
            BasicModel model;
            if (e == null) {
                CreateObject.$$$reportNull$$$0(4);
            }
            BasicModel basicModel = model = (element2 = BaseModifyObjectAction.getElement(single = CreateObject.getSingle(e))) == null ? null : element2.getModel();
            if (model == null) {
                return;
            }
            final BasicElement parent2 = CreateObject.getParent(element2, this.myMeta);
            if (parent2 == null) {
                return;
            }
            final ModelHelper helper = ModelFacade.forDbms(model.getDbms()).getModelHelper();
            final DbDataSource dataSource2 = single.getDataSource();
            BasicNamespace current = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.getSearchPathObjectForSwitch(dataSource2, parent2), BasicNamespace.class);
            final SearchPath searchPath = ObjectPaths.searchPathOf(current);
            DbObjectEditorDialogBase dialog2 = new DbObjectEditorDialogBase(single.getProject(), dataSource2, searchPath, DatabaseBundle.message("action.CreateObject.dialog.title.create", new Object[0])){
                private final DbObjectEditor editor;
                private final BasicModModel myTargetModel;
                private final BasicModElement myTargetElement;
                {
                    super(project, dataSource22, searchPath3, title);
                    this.myTargetModel = new ModelFactory(new MemoryTextStorage()).createModel(model.getDbms());
                    DbObjectEditorFactory factory = DbObjectEditorFactory.forDbms(model.getDbms());
                    BasicModElement targetParent = factory.pull(this.myTargetModel, parent2, myMeta);
                    this.myTargetElement = ((ModFamily)Objects.requireNonNull(targetParent.familyOf(myMeta.kind))).createNewOne();
                    this.editor = factory.createObjectEditor(single.getProject(), myMeta);
                    helper.fillPropertiesWithExamples(this.myTargetElement, myVariant, new HashMap<String, String>());
                    this.editor.initCompletion(dataSource2, searchPath, ObjectPaths.of(parent2));
                }

                @Override
                protected void fillContext(@NotNull DatabaseRefactoringHandler handler) {
                    if (handler == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    LoaderContext context = handler.getContext();
                    if (this.myTargetElement instanceof BasicMateNamespace && DatabaseSettings.getSettings().trackNamespaces) {
                        ObjectPath path = BasicPaths.of(this.myTargetElement);
                        context.getScopeUpdater().toAdd(path);
                        context.include(path);
                    } else {
                        context.include(parent2);
                    }
                    super.fillContext(handler);
                }

                @Override
                protected void reset() {
                    this.editor.reset(this.myTargetElement);
                }

                @Override
                protected void apply() {
                    this.editor.apply(null, this.myTargetElement);
                    if (this.myTargetElement instanceof BasicModSourceAware) {
                        this.applySourceFromPreview((BasicModSourceAware)this.myTargetElement);
                    }
                }

                @Override
                protected DbObjectEditor getObjectEditor() {
                    return this.editor;
                }

                @Override
                protected ScriptingTaskBuilder createBuilder() {
                    ScriptingSingleModelTaskBuilder builder = new ScriptingSingleModelTaskBuilder((BasicModel)this.myTargetModel, ScriptCategory.CREATE_COMPLETE);
                    builder.getElements().add(this.myTargetElement);
                    builder.setOptions(new CustomScriptingOptions((Map<ScriptingOption<?>, ? extends Object>)ImmutableMap.of(ScriptingOptionStatic.USE_COMPACT_DEFINITION, (Object)true, ScriptingOptionStatic.USER_GRANTS, (Object)true)));
                    return builder;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/actions/ddl/CreateObjectGroup$CreateObject$1", "fillContext"));
                }
            };
            dialog2.initAndShow();
        }

        @Nullable
        static DbElement getSingle(@NotNull AnActionEvent e) {
            if (e == null) {
                CreateObject.$$$reportNull$$$0(5);
            }
            @NotNull DataContext dataContext = e.getDataContext();
            return (DbElement)DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext).single();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variant";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/ddl/CreateObjectGroup$CreateObject";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSupported";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSingle";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Public
    extends CreateObjectGroup {
        @Override
        @NotNull
        protected JBIterable<BasicMetaObject<?>> getCreateTargets(BasicElement element2) {
            JBIterable jBIterable = super.getCreateTargets(element2).filter(p2 -> Public.isPublic(p2));
            if (jBIterable == null) {
                Public.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        public static boolean isPublic(BasicMetaObject<?> p2) {
            return p2.kind == ObjectKind.USER || p2.kind == ObjectKind.ROLE || p2.kind == ObjectKind.LOGIN || p2.kind == ObjectKind.COLLATION || p2.kind == ObjectKind.DATABASE || p2.kind == ObjectKind.SCHEMA || p2.kind == ObjectKind.SEQUENCE || p2.kind == ObjectKind.LANGUAGE || p2.kind == ObjectKind.CONSTANT || p2.kind == ObjectKind.OPERATOR || p2.kind == ObjectKind.VIEW || p2.kind == ObjectKind.MAT_VIEW;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ddl/CreateObjectGroup$Public", "getCreateTargets"));
        }
    }
}

